/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.internal;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.db.internal.DTPCatalogWrapper;
import org.eclipse.jpt.jpa.db.internal.DTPColumnWrapper;
import org.eclipse.jpt.jpa.db.internal.DTPConnectionProfileWrapper;
import org.eclipse.jpt.jpa.db.internal.DTPSchemaContainerWrapper;
import org.eclipse.jpt.jpa.db.internal.DTPSchemaWrapper;
import org.eclipse.jpt.jpa.db.internal.DTPTableWrapper;
import org.eclipse.jpt.jpa.db.internal.driver.DTPDriverAdapter;
import org.eclipse.jpt.jpa.db.internal.driver.DTPDriverAdapterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DTPDatabaseWrapper
extends DTPSchemaContainerWrapper<DTPConnectionProfileWrapper, org.eclipse.datatools.modelbase.sql.schema.Database>
implements Database {
    private final DTPDriverAdapter dtpDriverAdapter = DTPDriverAdapterManager.instance().buildAdapter(this.getVendorName(), this);
    private DTPCatalogWrapper[] catalogs;

    DTPDatabaseWrapper(DTPConnectionProfileWrapper connectionProfile, org.eclipse.datatools.modelbase.sql.schema.Database dtpDatabase) {
        super(connectionProfile, dtpDatabase);
    }

    @Override
    synchronized void catalogObjectChanged() {
        super.catalogObjectChanged();
        this.getConnectionProfile().databaseChanged(this);
    }

    @Override
    public DTPDatabaseWrapper getDatabase() {
        return this;
    }

    @Override
    List<Schema> getDTPSchemas() {
        return this.dtpDriverAdapter.getDTPSchemas();
    }

    @Override
    DTPSchemaWrapper getSchema(Schema dtpSchema) {
        return this.getSchema_(dtpSchema);
    }

    DTPSchemaWrapper getSchemaFromCatalogs(Schema dtpSchema) {
        return this.getCatalog(dtpSchema.getCatalog()).getSchema_(dtpSchema);
    }

    @Override
    DTPTableWrapper getTable(org.eclipse.datatools.modelbase.sql.tables.Table dtpTable) {
        return this.getTable_(dtpTable);
    }

    DTPTableWrapper getTableFromCatalogs(org.eclipse.datatools.modelbase.sql.tables.Table dtpTable) {
        return this.getCatalog(dtpTable.getSchema().getCatalog()).getTable_(dtpTable);
    }

    @Override
    DTPColumnWrapper getColumn(Column dtpColumn) {
        return this.getColumn_(dtpColumn);
    }

    DTPColumnWrapper getColumnFromCatalogs(Column dtpColumn) {
        return this.getCatalog(dtpColumn.getTable().getSchema().getCatalog()).getColumn_(dtpColumn);
    }

    @Override
    public boolean supportsCatalogs() {
        return this.dtpDriverAdapter.supportsCatalogs();
    }

    @Override
    public Iterable<Catalog> getCatalogs() {
        return IterableTools.iterable((Object[])this.getCatalogArray());
    }

    private Iterable<DTPCatalogWrapper> getCatalogWrappers() {
        return IterableTools.iterable((Object[])this.getCatalogArray());
    }

    private synchronized DTPCatalogWrapper[] getCatalogArray() {
        if (this.catalogs == null) {
            this.catalogs = this.buildCatalogArray();
        }
        return this.catalogs;
    }

    private DTPCatalogWrapper[] buildCatalogArray() {
        List<org.eclipse.datatools.modelbase.sql.schema.Catalog> dtpCatalogs = this.getDTPCatalogs();
        Object[] result = new DTPCatalogWrapper[dtpCatalogs.size()];
        int i = result.length;
        while (i-- > 0) {
            result[i] = new DTPCatalogWrapper(this, dtpCatalogs.get(i));
        }
        return (DTPCatalogWrapper[])ArrayTools.sort((Object[])result, (Comparator)DEFAULT_COMPARATOR);
    }

    private List<org.eclipse.datatools.modelbase.sql.schema.Catalog> getDTPCatalogs() {
        return this.dtpDriverAdapter.getDTPCatalogs();
    }

    @Override
    public int getCatalogsSize() {
        return this.getCatalogArray().length;
    }

    DTPCatalogWrapper getCatalog(org.eclipse.datatools.modelbase.sql.schema.Catalog dtpCatalog) {
        DTPCatalogWrapper[] dTPCatalogWrapperArray = this.getCatalogArray();
        int n = dTPCatalogWrapperArray.length;
        int n2 = 0;
        while (n2 < n) {
            DTPCatalogWrapper catalog = dTPCatalogWrapperArray[n2];
            if (catalog.wraps(dtpCatalog)) {
                return catalog;
            }
            ++n2;
        }
        throw new IllegalArgumentException("invalid DTP catalog: " + dtpCatalog);
    }

    @Override
    public Iterable<String> getSortedCatalogNames() {
        return new TransformationIterable(this.getCatalogWrappers(), NAME_TRANSFORMER);
    }

    @Override
    public DTPCatalogWrapper getCatalogNamed(String name) {
        return this.selectDatabaseObjectNamed(this.getCatalogWrappers(), name);
    }

    @Override
    public Iterable<String> getSortedCatalogIdentifiers() {
        return new TransformationIterable(this.getCatalogWrappers(), IDENTIFIER_TRANSFORMER);
    }

    @Override
    public Catalog getCatalogForIdentifier(String identifier) {
        return this.dtpDriverAdapter.selectCatalogForIdentifier(this.getCatalogs(), identifier);
    }

    @Override
    public synchronized DTPCatalogWrapper getDefaultCatalog() {
        return this.getCatalogForNames(this.getDefaultCatalogNames());
    }

    private Iterable<String> getDefaultCatalogNames() {
        return this.dtpDriverAdapter.getDefaultCatalogNames();
    }

    private DTPCatalogWrapper getCatalogForNames(Iterable<String> names) {
        for (String name : names) {
            DTPCatalogWrapper catalog = this.getCatalogNamed(name);
            if (catalog == null) continue;
            return catalog;
        }
        return null;
    }

    @Override
    public synchronized String getDefaultCatalogIdentifier() {
        Iterable<String> names = this.getDefaultCatalogNames();
        DTPCatalogWrapper catalog = this.getCatalogForNames(names);
        if (catalog != null) {
            return catalog.getIdentifier();
        }
        Iterator<String> stream = names.iterator();
        return stream.hasNext() ? this.convertNameToIdentifier((String)IteratorTools.last(stream)) : null;
    }

    @Override
    public String convertNameToIdentifier(String name) {
        return super.convertNameToIdentifier(name);
    }

    @Override
    public org.eclipse.datatools.modelbase.sql.schema.Database getDTPDatabase() {
        return (org.eclipse.datatools.modelbase.sql.schema.Database)this.dtpObject;
    }

    @Override
    public String getVendorName() {
        return ((org.eclipse.datatools.modelbase.sql.schema.Database)this.dtpObject).getVendor();
    }

    @Override
    public String getVersion() {
        return ((org.eclipse.datatools.modelbase.sql.schema.Database)this.dtpObject).getVersion();
    }

    @Override
    DTPDriverAdapter getDTPDriverAdapter() {
        return this.dtpDriverAdapter;
    }

    @Override
    public Table selectTableForIdentifier(Iterable<Table> tables, String identifier) {
        return this.dtpDriverAdapter.selectTableForIdentifier(tables, identifier);
    }

    DatabaseDefinition getDTPDefinition() {
        return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition((org.eclipse.datatools.modelbase.sql.schema.Database)this.dtpObject);
    }

    @Override
    synchronized void startListening() {
        if (this.catalogs != null) {
            this.startCatalogs();
        }
        super.startListening();
    }

    private void startCatalogs() {
        DTPCatalogWrapper[] dTPCatalogWrapperArray = this.catalogs;
        int n = this.catalogs.length;
        int n2 = 0;
        while (n2 < n) {
            DTPCatalogWrapper catalog = dTPCatalogWrapperArray[n2];
            catalog.startListening();
            ++n2;
        }
    }

    @Override
    synchronized void stopListening() {
        if (this.catalogs != null) {
            this.stopCatalogs();
        }
        super.stopListening();
    }

    private void stopCatalogs() {
        DTPCatalogWrapper[] dTPCatalogWrapperArray = this.catalogs;
        int n = this.catalogs.length;
        int n2 = 0;
        while (n2 < n) {
            DTPCatalogWrapper catalog = dTPCatalogWrapperArray[n2];
            catalog.stopListening();
            ++n2;
        }
    }

    @Override
    synchronized void clear() {
        if (this.catalogs != null) {
            this.clearCatalogs();
        }
        super.clear();
    }

    private void clearCatalogs() {
        this.stopCatalogs();
        DTPCatalogWrapper[] dTPCatalogWrapperArray = this.catalogs;
        int n = this.catalogs.length;
        int n2 = 0;
        while (n2 < n) {
            DTPCatalogWrapper catalog = dTPCatalogWrapperArray[n2];
            catalog.clear();
            ++n2;
        }
        this.catalogs = null;
    }
}

