/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.CharArrayTools;
import org.eclipse.jpt.common.utility.internal.CharacterTools;
import org.eclipse.jpt.common.utility.internal.StringTools;

public final class StringBufferTools {
    public static char[] convertToCharArray(StringBuffer sb) {
        int len = sb.length();
        char[] result = new char[len];
        sb.getChars(0, len, result, 0);
        return result;
    }

    public static void center(StringBuffer sb, String string, int length) {
        StringBufferTools.center(sb, string, length, ' ');
    }

    public static void center(StringBuffer sb, char[] string, int length) {
        StringBufferTools.center(sb, string, length, ' ');
    }

    public static void center(StringBuffer sb, String string, int length, char c) {
        if (length == 0) {
            return;
        }
        int stringLength = string.length();
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            int begin = stringLength - length >> 1;
            sb.append(string, begin, begin + length);
        } else {
            int begin = length - stringLength >> 1;
            StringBufferTools.fill(sb, begin, c);
            sb.append(string);
            StringBufferTools.fill(sb, length - (begin + stringLength), c);
        }
    }

    public static void center(StringBuffer sb, char[] string, int length, char c) {
        if (length == 0) {
            return;
        }
        int stringLength = string.length;
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            int begin = stringLength - length >> 1;
            sb.append(string, begin, length);
        } else {
            int begin = length - stringLength >> 1;
            StringBufferTools.fill(sb, begin, c);
            sb.append(string);
            StringBufferTools.fill(sb, length - (begin + stringLength), c);
        }
    }

    public static void pad(StringBuffer sb, String string, int length) {
        StringBufferTools.pad(sb, string, length, ' ');
    }

    public static void pad(StringBuffer sb, char[] string, int length) {
        StringBufferTools.pad(sb, string, length, ' ');
    }

    public static void pad(StringBuffer sb, String string, int length, char c) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringBufferTools.pad_(sb, string, stringLength, length, c);
        }
    }

    public static void pad(StringBuffer sb, char[] string, int length, char c) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringBufferTools.pad_(sb, string, stringLength, length, c);
        }
    }

    public static void fit(StringBuffer sb, String string, int length) {
        StringBufferTools.fit(sb, string, length, ' ');
    }

    public static void fit(StringBuffer sb, char[] string, int length) {
        StringBufferTools.fit(sb, string, length, ' ');
    }

    public static void fit(StringBuffer sb, String string, int length, char c) {
        if (length == 0) {
            return;
        }
        int stringLength = string.length();
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string, 0, length);
        } else {
            StringBufferTools.pad_(sb, string, stringLength, length, c);
        }
    }

    public static void fit(StringBuffer sb, char[] string, int length, char c) {
        if (length == 0) {
            return;
        }
        int stringLength = string.length;
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string, 0, length);
        } else {
            StringBufferTools.pad_(sb, string, stringLength, length, c);
        }
    }

    private static void pad_(StringBuffer sb, String string, int stringLength, int length, char c) {
        sb.append(string);
        StringBufferTools.fill(sb, stringLength, length, c);
    }

    private static void pad_(StringBuffer sb, char[] string, int stringLength, int length, char c) {
        sb.append(string);
        StringBufferTools.fill(sb, stringLength, length, c);
    }

    private static void fill(StringBuffer sb, int stringLength, int length, char c) {
        StringBufferTools.fill(sb, length - stringLength, c);
    }

    private static void fill(StringBuffer sb, int length, char c) {
        sb.append(ArrayTools.fill(new char[length], c));
    }

    public static void zeroPad(StringBuffer sb, String string, int length) {
        StringBufferTools.frontPad(sb, string, length, '0');
    }

    public static void zeroPad(StringBuffer sb, char[] string, int length) {
        StringBufferTools.frontPad(sb, string, length, '0');
    }

    public static void frontPad(StringBuffer sb, String string, int length, char c) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringBufferTools.frontPad_(sb, string, stringLength, length, c);
        }
    }

    public static void frontPad(StringBuffer sb, char[] string, int length, char c) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringBufferTools.frontPad_(sb, string, stringLength, length, c);
        }
    }

    public static void zeroFit(StringBuffer sb, String string, int length) {
        StringBufferTools.frontFit(sb, string, length, '0');
    }

    public static void zeroFit(StringBuffer sb, char[] string, int length) {
        StringBufferTools.frontFit(sb, string, length, '0');
    }

    public static void frontFit(StringBuffer sb, String string, int length, char c) {
        if (length == 0) {
            return;
        }
        int stringLength = string.length();
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string, stringLength - length, stringLength);
        } else {
            StringBufferTools.frontPad_(sb, string, stringLength, length, c);
        }
    }

    public static void frontFit(StringBuffer sb, char[] string, int length, char c) {
        if (length == 0) {
            return;
        }
        int stringLength = string.length;
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string, stringLength - length, length);
        } else {
            StringBufferTools.frontPad_(sb, string, stringLength, length, c);
        }
    }

    private static void frontPad_(StringBuffer sb, String string, int stringLength, int length, char c) {
        StringBufferTools.fill(sb, stringLength, length, c);
        sb.append(string);
    }

    private static void frontPad_(StringBuffer sb, char[] string, int stringLength, int length, char c) {
        StringBufferTools.fill(sb, stringLength, length, c);
        sb.append(string);
    }

    public static void separate(StringBuffer sb, String string, char separator, int segmentSize) {
        if (segmentSize <= 0) {
            throw new IllegalArgumentException("segment size must be positive: " + segmentSize);
        }
        int stringLength = string.length();
        if (stringLength <= segmentSize) {
            sb.append(string);
        } else {
            sb.ensureCapacity(sb.length() + stringLength + stringLength / segmentSize);
            StringBufferTools.separate(sb, string, separator, segmentSize, stringLength);
        }
    }

    private static void separate(StringBuffer sb, String string, char separator, int segmentSize, int stringLength) {
        int segCount = 0;
        int i = 0;
        while (i < stringLength) {
            char c = string.charAt(i);
            if (segCount == segmentSize) {
                sb.append(separator);
                segCount = 0;
            }
            ++segCount;
            sb.append(c);
            ++i;
        }
    }

    public static void separate(StringBuffer sb, char[] string, char separator, int segmentSize) {
        if (segmentSize <= 0) {
            throw new IllegalArgumentException("segment size must be positive: " + segmentSize);
        }
        int stringLength = string.length;
        if (stringLength <= segmentSize) {
            sb.append(string);
        } else {
            sb.ensureCapacity(sb.length() + stringLength + stringLength / segmentSize);
            StringBufferTools.separate(sb, string, separator, segmentSize, stringLength);
        }
    }

    private static void separate(StringBuffer sb, char[] string, char separator, int segmentSize, int stringLength) {
        int segCount = 0;
        int i = 0;
        while (i < stringLength) {
            char c = string[i];
            if (segCount == segmentSize) {
                sb.append(separator);
                segCount = 0;
            }
            ++segCount;
            sb.append(c);
            ++i;
        }
    }

    public static void quote(StringBuffer sb, String string) {
        StringBufferTools.delimit(sb, string, '\"');
    }

    public static void quote(StringBuffer sb, char[] string) {
        StringBufferTools.delimit(sb, string, '\"');
    }

    public static void delimit(StringBuffer sb, String string, char delimiter) {
        int stringLength = string.length();
        sb.ensureCapacity(sb.length() + stringLength + 2);
        StringBufferTools.delimit(sb, string, delimiter, stringLength);
    }

    private static void delimit(StringBuffer sb, String string, char delimiter, int stringLength) {
        sb.append(delimiter);
        int i = 0;
        while (i < stringLength) {
            char c = string.charAt(i);
            if (c == delimiter) {
                sb.append(c);
            }
            sb.append(c);
            ++i;
        }
        sb.append(delimiter);
    }

    public static void delimit(StringBuffer sb, char[] string, char delimiter) {
        int stringLength = string.length;
        sb.ensureCapacity(sb.length() + stringLength + 2);
        StringBufferTools.delimit(sb, string, delimiter, stringLength);
    }

    private static void delimit(StringBuffer sb, char[] string, char delimiter, int stringLength) {
        sb.append(delimiter);
        int i = 0;
        while (i < stringLength) {
            char c = string[i];
            if (c == delimiter) {
                sb.append(c);
            }
            sb.append(c);
            ++i;
        }
        sb.append(delimiter);
    }

    public static void delimit(StringBuffer sb, String string, String delimiter) {
        int delimiterLength = delimiter.length();
        switch (delimiterLength) {
            case 0: {
                sb.append(string);
                break;
            }
            case 1: {
                StringBufferTools.delimit(sb, string, delimiter.charAt(0));
                break;
            }
            default: {
                StringBufferTools.delimit(sb, string, delimiter, delimiterLength);
            }
        }
    }

    private static void delimit(StringBuffer sb, String string, String delimiter, int delimiterLength) {
        sb.append(delimiter, 0, delimiterLength);
        sb.append(string);
        sb.append(delimiter, 0, delimiterLength);
    }

    public static void delimit(StringBuffer sb, char[] string, char[] delimiter) {
        int delimiterLength = delimiter.length;
        switch (delimiterLength) {
            case 0: {
                sb.append(string);
                break;
            }
            case 1: {
                StringBufferTools.delimit(sb, string, delimiter[0]);
                break;
            }
            default: {
                StringBufferTools.delimit(sb, string, delimiter, delimiterLength);
            }
        }
    }

    private static void delimit(StringBuffer sb, char[] string, char[] delimiter, int delimiterLength) {
        sb.append(delimiter, 0, delimiterLength);
        sb.append(string);
        sb.append(delimiter, 0, delimiterLength);
    }

    public static void undelimit(StringBuffer sb, String string) {
        int stringLength = string.length();
        int resultLength = stringLength - 2;
        if (resultLength < 0) {
            throw new IllegalArgumentException("invalid string: \"" + string + '\"');
        }
        if (resultLength == 0) {
            return;
        }
        StringBufferTools.undelimit_(sb, string, stringLength);
    }

    private static void undelimit_(StringBuffer sb, String string, int stringLength) {
        char delimiter;
        char c = delimiter = string.charAt(0);
        char next = string.charAt(1);
        int i = 1;
        int last = stringLength - 1;
        do {
            c = next;
            sb.append(c);
            next = string.charAt(++i);
            if (c != delimiter) continue;
            if (next != delimiter || i == last) {
                return;
            }
            next = string.charAt(++i);
        } while (i != last);
    }

    public static void undelimit(StringBuffer sb, char[] string) {
        int stringLength = string.length;
        int resultLength = stringLength - 2;
        if (resultLength < 0) {
            throw new IllegalArgumentException("invalid string: \"" + new String(string) + '\"');
        }
        if (resultLength == 0) {
            return;
        }
        StringBufferTools.undelimit_(sb, string, stringLength);
    }

    private static void undelimit_(StringBuffer sb, char[] string, int stringLength) {
        char delimiter;
        char c = delimiter = string[0];
        char next = string[1];
        int i = 1;
        int last = stringLength - 1;
        do {
            c = next;
            sb.append(c);
            next = string[++i];
            if (c != delimiter) continue;
            if (next != delimiter || i == last) {
                return;
            }
            next = string[++i];
        } while (i != last);
    }

    public static void undelimit(StringBuffer sb, String string, int count) {
        if (count == 0) {
            sb.append(string);
            return;
        }
        int resultLength = string.length() - 2 * count;
        if (resultLength < 0) {
            throw new IllegalArgumentException("invalid string: \"" + string + '\"');
        }
        if (resultLength == 0) {
            return;
        }
        sb.append(string, count, count + resultLength);
    }

    public static void undelimit(StringBuffer sb, char[] string, int count) {
        if (count == 0) {
            sb.append(string);
            return;
        }
        int resultLength = string.length - 2 * count;
        if (resultLength < 0) {
            throw new IllegalArgumentException("invalid string: \"" + new String(string) + '\"');
        }
        if (resultLength == 0) {
            return;
        }
        sb.append(string, count, resultLength);
    }

    public static void removeFirstOccurrence(StringBuffer sb, String string, char c) {
        int index = string.indexOf(c);
        if (index == -1) {
            sb.append(string);
        } else {
            StringBufferTools.removeCharAtIndex(sb, string, index);
        }
    }

    private static void removeCharAtIndex(StringBuffer sb, String string, int index) {
        int stringLength = string.length();
        if (index == 0) {
            sb.append(string, 1, stringLength);
        } else {
            sb.append(string, 0, index);
            if (index != stringLength - 1) {
                sb.append(string, index + 1, stringLength);
            }
        }
    }

    public static void removeFirstOccurrence(StringBuffer sb, char[] string, char c) {
        int index = ArrayTools.indexOf(string, c);
        if (index == -1) {
            sb.append(string);
        } else {
            StringBufferTools.removeCharAtIndex(sb, string, index);
        }
    }

    private static void removeCharAtIndex(StringBuffer sb, char[] string, int index) {
        int last = string.length - 1;
        if (index == 0) {
            sb.append(string, 1, last);
        } else if (index == last) {
            sb.append(string, 0, last);
        } else {
            sb.append(string, 0, index);
            sb.append(string, index + 1, last - index);
        }
    }

    public static void removeAllOccurrences(StringBuffer sb, String string, char c) {
        int first = string.indexOf(c);
        if (first == -1) {
            sb.append(string);
        } else {
            int stringLength = string.length();
            sb.ensureCapacity(sb.length() + stringLength);
            StringBufferTools.removeAllOccurrences(sb, string, c, first, stringLength);
        }
    }

    private static void removeAllOccurrences(StringBuffer sb, String string, char c, int first, int stringLength) {
        sb.append(string, 0, first);
        int i = first;
        while (i < stringLength) {
            char d = string.charAt(i);
            if (d != c) {
                sb.append(d);
            }
            ++i;
        }
    }

    public static void removeAllOccurrences(StringBuffer sb, char[] string, char c) {
        int first = ArrayTools.indexOf(string, c);
        if (first == -1) {
            sb.append(string);
        } else {
            int stringLength = string.length;
            sb.ensureCapacity(sb.length() + stringLength);
            StringBufferTools.removeAllOccurrences(sb, string, c, first, stringLength);
        }
    }

    private static void removeAllOccurrences(StringBuffer sb, char[] string, char c, int first, int stringLength) {
        sb.append(string, 0, first);
        int i = first;
        while (i < stringLength) {
            char d = string[i];
            if (d != c) {
                sb.append(d);
            }
            ++i;
        }
    }

    public static void removeAllSpaces(StringBuffer sb, String string) {
        StringBufferTools.removeAllOccurrences(sb, string, ' ');
    }

    public static void removeAllSpaces(StringBuffer sb, char[] string) {
        StringBufferTools.removeAllOccurrences(sb, string, ' ');
    }

    public static void removeAllWhitespace(StringBuffer sb, String string) {
        int first = StringTools.indexOfWhitespace(string);
        if (first == -1) {
            sb.append(string);
        } else {
            int stringLength = string.length();
            sb.ensureCapacity(sb.length() + stringLength);
            StringBufferTools.removeAllWhitespace(sb, string, first, stringLength);
        }
    }

    private static void removeAllWhitespace(StringBuffer sb, String string, int first, int stringLength) {
        sb.append(string, 0, first);
        int i = first;
        while (i < stringLength) {
            char c = string.charAt(i);
            if (!Character.isWhitespace(c)) {
                sb.append(c);
            }
            ++i;
        }
    }

    public static void removeAllWhitespace(StringBuffer sb, char[] string) {
        int first = CharArrayTools.indexOfWhitespace(string);
        if (first == -1) {
            sb.append(string);
        } else {
            int stringLength = string.length;
            sb.ensureCapacity(sb.length() + stringLength);
            StringBufferTools.removeAllWhitespace(sb, string, first, stringLength);
        }
    }

    private static void removeAllWhitespace(StringBuffer sb, char[] string, int first, int stringLength) {
        sb.append(string, 0, first);
        int i = first;
        while (i < stringLength) {
            char c = string[i];
            if (!Character.isWhitespace(c)) {
                sb.append(c);
            }
            ++i;
        }
    }

    public static void compressWhitespace(StringBuffer sb, String string) {
        int first = StringTools.indexOfWhitespace(string);
        if (first == -1) {
            sb.append(string);
        } else {
            int stringLength = string.length();
            sb.ensureCapacity(sb.length() + stringLength);
            StringBufferTools.compressWhitespace(sb, string, first, stringLength);
        }
    }

    private static void compressWhitespace(StringBuffer sb, String string, int first, int stringLength) {
        sb.append(string, 0, first);
        int i = first;
        char c = string.charAt(i);
        block0: while (true) {
            sb.append(' ');
            while (++i < stringLength) {
                c = string.charAt(i);
                if (Character.isWhitespace(c)) continue;
                do {
                    sb.append(c);
                    if (++i >= stringLength) break block0;
                } while (!Character.isWhitespace(c = string.charAt(i)));
                continue block0;
            }
            break;
        }
    }

    public static void compressWhitespace(StringBuffer sb, char[] string) {
        int first = CharArrayTools.indexOfWhitespace(string);
        if (first == -1) {
            sb.append(string);
        } else {
            int stringLength = string.length;
            sb.ensureCapacity(sb.length() + stringLength);
            StringBufferTools.compressWhitespace(sb, string, first, stringLength);
        }
    }

    private static void compressWhitespace(StringBuffer sb, char[] string, int first, int stringLength) {
        sb.append(string, 0, first);
        int i = first;
        char c = string[i];
        block0: while (true) {
            sb.append(' ');
            while (++i < stringLength) {
                c = string[i];
                if (Character.isWhitespace(c)) continue;
                do {
                    sb.append(c);
                    if (++i >= stringLength) break block0;
                } while (!Character.isWhitespace(c = string[i]));
                continue block0;
            }
            break;
        }
    }

    public static void capitalize(StringBuffer sb, String string) {
        if (string.length() == 0) {
            return;
        }
        if (Character.isUpperCase(string.charAt(0))) {
            sb.append(string);
        } else {
            StringBufferTools.capitalize_(sb, string);
        }
    }

    private static void capitalize_(StringBuffer sb, String string) {
        sb.append(Character.toUpperCase(string.charAt(0)));
        sb.append(string, 1, string.length());
    }

    public static void capitalize(StringBuffer sb, char[] string) {
        if (string.length == 0) {
            return;
        }
        if (Character.isUpperCase(string[0])) {
            sb.append(string);
        } else {
            StringBufferTools.capitalize_(sb, string);
        }
    }

    private static void capitalize_(StringBuffer sb, char[] string) {
        sb.append(Character.toUpperCase(string[0]));
        sb.append(string, 1, string.length - 1);
    }

    public static void uncapitalize(StringBuffer sb, String string) {
        int stringLength = string.length();
        if (StringTools.needNotBeUncapitalized(string, stringLength)) {
            sb.append(string);
        } else {
            StringBufferTools.uncapitalize(sb, string, stringLength);
        }
    }

    private static void uncapitalize(StringBuffer sb, String string, int stringLength) {
        sb.append(Character.toLowerCase(string.charAt(0)));
        sb.append(string, 1, stringLength);
    }

    public static void uncapitalize(StringBuffer sb, char[] string) {
        int stringLength = string.length;
        if (CharArrayTools.needNotBeUncapitalized(string, stringLength)) {
            sb.append(string);
        } else {
            StringBufferTools.uncapitalize(sb, string, stringLength);
        }
    }

    private static void uncapitalize(StringBuffer sb, char[] string, int stringLength) {
        sb.append(Character.toLowerCase(string[0]));
        sb.append(string, 1, stringLength - 1);
    }

    public static void convertToHexString(StringBuffer sb, byte[] bytes) {
        int bytesLength = bytes.length;
        if (bytesLength != 0) {
            sb.ensureCapacity(sb.length() + (bytesLength << 1));
            StringBufferTools.convertToHexString(sb, bytes, bytesLength);
        }
    }

    private static void convertToHexString(StringBuffer sb, byte[] bytes, int bytesLength) {
        char[] digits = CharacterTools.DIGITS;
        int i = 0;
        while (i < bytesLength) {
            int b = bytes[i] & 0xFF;
            sb.append(digits[b >> 4]);
            sb.append(digits[b & 0xF]);
            ++i;
        }
    }

    public static void convertCamelCaseToAllCaps(StringBuffer sb, String camelCaseString) {
        int stringLength = camelCaseString.length();
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + stringLength / 4);
            StringBufferTools.convertCamelCaseToAllCaps_(sb, camelCaseString, stringLength);
        }
    }

    private static void convertCamelCaseToAllCaps_(StringBuffer sb, String camelCaseString, int stringLength) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString.charAt(0);
        int i = 1;
        while (i <= stringLength) {
            c = next;
            char c2 = next = i == stringLength ? (char)'\u0000' : camelCaseString.charAt(i);
            if (StringTools.camelCaseWordBreak(prev, c, next)) {
                sb.append('_');
            }
            sb.append(Character.toUpperCase(c));
            prev = c;
            ++i;
        }
    }

    public static void convertCamelCaseToAllCaps(StringBuffer sb, char[] camelCaseString) {
        int stringLength = camelCaseString.length;
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + stringLength / 4);
            StringBufferTools.convertCamelCaseToAllCaps_(sb, camelCaseString, stringLength);
        }
    }

    private static void convertCamelCaseToAllCaps_(StringBuffer sb, char[] camelCaseString, int stringLength) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString[0];
        int i = 1;
        while (i <= stringLength) {
            c = next;
            char c2 = next = i == stringLength ? (char)'\u0000' : camelCaseString[i];
            if (StringTools.camelCaseWordBreak(prev, c, next)) {
                sb.append('_');
            }
            sb.append(Character.toUpperCase(c));
            prev = c;
            ++i;
        }
    }

    public static void convertCamelCaseToAllCaps(StringBuffer sb, String camelCaseString, int maxLength) {
        int stringLength;
        if (maxLength != 0 && (stringLength = camelCaseString.length()) != 0) {
            sb.ensureCapacity(sb.length() + maxLength);
            StringBufferTools.convertCamelCaseToAllCaps(sb, camelCaseString, maxLength, stringLength);
        }
    }

    private static void convertCamelCaseToAllCaps(StringBuffer sb, String camelCaseString, int maxLength, int stringLength) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString.charAt(0);
        int i = 1;
        while (i <= stringLength) {
            c = next;
            char c2 = next = i == stringLength ? (char)'\u0000' : camelCaseString.charAt(i);
            if (StringTools.camelCaseWordBreak(prev, c, next)) {
                sb.append('_');
                if (sb.length() == maxLength) {
                    return;
                }
            }
            sb.append(Character.toUpperCase(c));
            if (sb.length() == maxLength) {
                return;
            }
            prev = c;
            ++i;
        }
    }

    public static void convertCamelCaseToAllCaps(StringBuffer sb, char[] camelCaseString, int maxLength) {
        int stringLength;
        if (maxLength != 0 && (stringLength = camelCaseString.length) != 0) {
            sb.ensureCapacity(sb.length() + maxLength);
            StringBufferTools.convertCamelCaseToAllCaps(sb, camelCaseString, maxLength, stringLength);
        }
    }

    private static void convertCamelCaseToAllCaps(StringBuffer sb, char[] camelCaseString, int maxLength, int stringLength) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString[0];
        int i = 1;
        while (i <= stringLength) {
            c = next;
            char c2 = next = i == stringLength ? (char)'\u0000' : camelCaseString[i];
            if (StringTools.camelCaseWordBreak(prev, c, next)) {
                sb.append('_');
                if (sb.length() == maxLength) {
                    return;
                }
            }
            sb.append(Character.toUpperCase(c));
            if (sb.length() == maxLength) {
                return;
            }
            prev = c;
            ++i;
        }
    }

    public static void convertAllCapsToCamelCase(StringBuffer sb, String allCapsString) {
        StringBufferTools.convertAllCapsToCamelCase(sb, allCapsString, true);
    }

    public static void convertAllCapsToCamelCase(StringBuffer sb, char[] allCapsString) {
        StringBufferTools.convertAllCapsToCamelCase(sb, allCapsString, true);
    }

    public static void convertAllCapsToCamelCase(StringBuffer sb, String allCapsString, boolean capitalizeFirstLetter) {
        int stringLength = allCapsString.length();
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength);
            StringBufferTools.convertAllCapsToCamelCase(sb, allCapsString, capitalizeFirstLetter, stringLength);
        }
    }

    private static void convertAllCapsToCamelCase(StringBuffer sb, String allCapsString, boolean capitalizeFirstLetter, int stringLength) {
        char prev = '\u0000';
        char c = '\u0000';
        boolean first = true;
        int i = 0;
        while (i < stringLength) {
            prev = c;
            c = allCapsString.charAt(i);
            if (c != '_') {
                if (first) {
                    first = false;
                    sb.append(capitalizeFirstLetter ? Character.toUpperCase(c) : Character.toLowerCase(c));
                } else {
                    sb.append(prev == '_' ? Character.toUpperCase(c) : Character.toLowerCase(c));
                }
            }
            ++i;
        }
    }

    public static void convertAllCapsToCamelCase(StringBuffer sb, char[] allCapsString, boolean capitalizeFirstLetter) {
        int stringLength = allCapsString.length;
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength);
            StringBufferTools.convertAllCapsToCamelCase(sb, allCapsString, capitalizeFirstLetter, stringLength);
        }
    }

    private static void convertAllCapsToCamelCase(StringBuffer sb, char[] allCapsString, boolean capitalizeFirstLetter, int stringLength) {
        char prev = '\u0000';
        char c = '\u0000';
        boolean first = true;
        int i = 0;
        while (i < stringLength) {
            prev = c;
            c = allCapsString[i];
            if (c != '_') {
                if (first) {
                    first = false;
                    sb.append(capitalizeFirstLetter ? Character.toUpperCase(c) : Character.toLowerCase(c));
                } else {
                    sb.append(prev == '_' ? Character.toUpperCase(c) : Character.toLowerCase(c));
                }
            }
            ++i;
        }
    }

    public static void convertToJavaStringLiteral(StringBuffer sb, String string) {
        int stringLength = string.length();
        if (stringLength == 0) {
            sb.append("\"\"");
        } else {
            sb.ensureCapacity(sb.length() + stringLength + 6);
            StringBufferTools.convertToJavaStringLiteral(sb, string, stringLength);
        }
    }

    private static void convertToJavaStringLiteral(StringBuffer sb, String string, int stringLength) {
        sb.append('\"');
        StringBufferTools.convertToJavaStringLiteralContent(sb, string, stringLength);
        sb.append('\"');
    }

    public static void convertToJavaStringLiteralContent(StringBuffer sb, String string) {
        int stringLength = string.length();
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 6);
            StringBufferTools.convertToJavaStringLiteralContent(sb, string, stringLength);
        }
    }

    private static void convertToJavaStringLiteralContent(StringBuffer sb, String string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            StringBufferTools.convertToJavaStringLiteral(sb, string.charAt(i));
            ++i;
        }
    }

    public static void convertToJavaStringLiteral(StringBuffer sb, char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            sb.append("\"\"");
        } else {
            sb.ensureCapacity(sb.length() + stringLength + 6);
            StringBufferTools.convertToJavaStringLiteral(sb, string, stringLength);
        }
    }

    private static void convertToJavaStringLiteral(StringBuffer sb, char[] string, int stringLength) {
        sb.append('\"');
        StringBufferTools.convertToJavaStringLiteralContent(sb, string, stringLength);
        sb.append('\"');
    }

    public static void convertToJavaStringLiteralContent(StringBuffer sb, char[] string) {
        int stringLength = string.length;
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 6);
            StringBufferTools.convertToJavaStringLiteralContent(sb, string, stringLength);
        }
    }

    private static void convertToJavaStringLiteralContent(StringBuffer sb, char[] string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            StringBufferTools.convertToJavaStringLiteral(sb, string[i]);
            ++i;
        }
    }

    private static void convertToJavaStringLiteral(StringBuffer sb, char c) {
        switch (c) {
            case '\b': {
                sb.append("\\b");
                break;
            }
            case '\t': {
                sb.append("\\t");
                break;
            }
            case '\n': {
                sb.append("\\n");
                break;
            }
            case '\f': {
                sb.append("\\f");
                break;
            }
            case '\r': {
                sb.append("\\r");
                break;
            }
            case '\"': {
                sb.append("\\\"");
                break;
            }
            case '\\': {
                sb.append("\\\\");
                break;
            }
            default: {
                sb.append(c);
            }
        }
    }

    public static void convertToXmlAttributeValue(StringBuffer sb, String string) {
        int stringLength = string.length();
        if (stringLength == 0) {
            sb.append("\"\"");
        } else {
            sb.ensureCapacity(sb.length() + stringLength + 12);
            StringBufferTools.convertToXmlAttributeValue(sb, string, stringLength);
        }
    }

    private static void convertToXmlAttributeValue(StringBuffer sb, String string, int stringLength) {
        int index = string.indexOf(34);
        if (index == -1) {
            StringBufferTools.convertToDoubleQuotedXmlAttributeValue(sb, string, stringLength);
        } else {
            index = string.indexOf(39);
            if (index == -1) {
                StringBufferTools.convertToSingleQuotedXmlAttributeValue(sb, string, stringLength);
            } else {
                StringBufferTools.convertToDoubleQuotedXmlAttributeValue(sb, string, stringLength);
            }
        }
    }

    private static void convertToDoubleQuotedXmlAttributeValue(StringBuffer sb, String string, int stringLength) {
        sb.append('\"');
        StringBufferTools.convertToDoubleQuotedXmlAttributeValueContent(sb, string, stringLength);
        sb.append('\"');
    }

    private static void convertToSingleQuotedXmlAttributeValue(StringBuffer sb, String string, int stringLength) {
        sb.append('\'');
        StringBufferTools.convertToSingleQuotedXmlAttributeValueContent(sb, string, stringLength);
        sb.append('\'');
    }

    public static void convertToDoubleQuotedXmlAttributeValue(StringBuffer sb, String string) {
        StringBufferTools.convertToDoubleQuotedXmlAttributeValue(sb, string, string.length());
    }

    public static void convertToDoubleQuotedXmlAttributeValueContent(StringBuffer sb, String string) {
        int stringLength = string.length();
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 10);
            StringBufferTools.convertToDoubleQuotedXmlAttributeValueContent(sb, string, stringLength);
        }
    }

    private static void convertToDoubleQuotedXmlAttributeValueContent(StringBuffer sb, String string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            StringBufferTools.convertToDoubleQuotedXmlAttributeValueContent(sb, string.charAt(i));
            ++i;
        }
    }

    public static void convertToSingleQuotedXmlAttributeValue(StringBuffer sb, String string) {
        StringBufferTools.convertToSingleQuotedXmlAttributeValue(sb, string, string.length());
    }

    public static void convertToSingleQuotedXmlAttributeValueContent(StringBuffer sb, String string) {
        int stringLength = string.length();
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 10);
            StringBufferTools.convertToSingleQuotedXmlAttributeValueContent(sb, string, stringLength);
        }
    }

    private static void convertToSingleQuotedXmlAttributeValueContent(StringBuffer sb, String string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            StringBufferTools.convertToSingleQuotedXmlAttributeValueContent(sb, string.charAt(i));
            ++i;
        }
    }

    public static void convertToXmlAttributeValue(StringBuffer sb, char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            sb.append("\"\"");
        } else {
            sb.ensureCapacity(sb.length() + stringLength + 12);
            StringBufferTools.convertToXmlAttributeValue(sb, string, stringLength);
        }
    }

    private static void convertToXmlAttributeValue(StringBuffer sb, char[] string, int stringLength) {
        int index = ArrayTools.indexOf(string, '\"');
        if (index == -1) {
            StringBufferTools.convertToDoubleQuotedXmlAttributeValue(sb, string, stringLength);
        } else {
            index = ArrayTools.indexOf(string, '\'');
            if (index == -1) {
                StringBufferTools.convertToSingleQuotedXmlAttributeValue(sb, string, stringLength);
            } else {
                StringBufferTools.convertToDoubleQuotedXmlAttributeValue(sb, string, stringLength);
            }
        }
    }

    private static void convertToDoubleQuotedXmlAttributeValue(StringBuffer sb, char[] string, int stringLength) {
        sb.append('\"');
        StringBufferTools.convertToDoubleQuotedXmlAttributeValueContent(sb, string, stringLength);
        sb.append('\"');
    }

    private static void convertToSingleQuotedXmlAttributeValue(StringBuffer sb, char[] string, int stringLength) {
        sb.append('\'');
        StringBufferTools.convertToSingleQuotedXmlAttributeValueContent(sb, string, stringLength);
        sb.append('\'');
    }

    public static void convertToDoubleQuotedXmlAttributeValue(StringBuffer sb, char[] string) {
        StringBufferTools.convertToDoubleQuotedXmlAttributeValue(sb, string, string.length);
    }

    public static void convertToDoubleQuotedXmlAttributeValueContent(StringBuffer sb, char[] string) {
        int stringLength = string.length;
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 10);
            StringBufferTools.convertToDoubleQuotedXmlAttributeValueContent(sb, string, stringLength);
        }
    }

    private static void convertToDoubleQuotedXmlAttributeValueContent(StringBuffer sb, char[] string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            StringBufferTools.convertToDoubleQuotedXmlAttributeValueContent(sb, string[i]);
            ++i;
        }
    }

    public static void convertToSingleQuotedXmlAttributeValue(StringBuffer sb, char[] string) {
        StringBufferTools.convertToSingleQuotedXmlAttributeValue(sb, string, string.length);
    }

    public static void convertToSingleQuotedXmlAttributeValueContent(StringBuffer sb, char[] string) {
        int stringLength = string.length;
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 10);
            StringBufferTools.convertToSingleQuotedXmlAttributeValueContent(sb, string, stringLength);
        }
    }

    private static void convertToSingleQuotedXmlAttributeValueContent(StringBuffer sb, char[] string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            StringBufferTools.convertToSingleQuotedXmlAttributeValueContent(sb, string[i]);
            ++i;
        }
    }

    private static void convertToDoubleQuotedXmlAttributeValueContent(StringBuffer sb, char c) {
        switch (c) {
            case '\"': {
                sb.append("&quot;");
                break;
            }
            case '&': {
                sb.append("&amp;");
                break;
            }
            case '<': {
                sb.append("&lt;");
                break;
            }
            default: {
                sb.append(c);
            }
        }
    }

    private static void convertToSingleQuotedXmlAttributeValueContent(StringBuffer sb, char c) {
        switch (c) {
            case '\'': {
                sb.append("&apos;");
                break;
            }
            case '&': {
                sb.append("&amp;");
                break;
            }
            case '<': {
                sb.append("&lt;");
                break;
            }
            default: {
                sb.append(c);
            }
        }
    }

    public static void convertToXmlElementText(StringBuffer sb, String string) {
        int stringLength = string.length();
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 8);
            StringBufferTools.convertToXmlElementText(sb, string, stringLength);
        }
    }

    private static void convertToXmlElementText(StringBuffer sb, String string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            StringBufferTools.convertToXmlElementText(sb, string.charAt(i));
            ++i;
        }
    }

    public static void convertToXmlElementText(StringBuffer sb, char[] string) {
        int stringLength = string.length;
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 8);
            StringBufferTools.convertToXmlElementText(sb, string, stringLength);
        }
    }

    private static void convertToXmlElementText(StringBuffer sb, char[] string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            StringBufferTools.convertToXmlElementText(sb, string[i]);
            ++i;
        }
    }

    private static void convertToXmlElementText(StringBuffer sb, char c) {
        switch (c) {
            case '&': {
                sb.append("&amp;");
                break;
            }
            case '<': {
                sb.append("&lt;");
                break;
            }
            default: {
                sb.append(c);
            }
        }
    }

    public static void convertToXmlElementCDATA(StringBuffer sb, String string) {
        int stringLength = string.length();
        if (stringLength == 0) {
            sb.append("<![CDATA[]]>");
        } else {
            sb.ensureCapacity(sb.length() + stringLength + "<![CDATA[]]>".length() + 6);
            StringBufferTools.convertToXmlElementCDATA(sb, string, stringLength);
        }
    }

    private static void convertToXmlElementCDATA(StringBuffer sb, String string, int stringLength) {
        sb.append("<![CDATA[");
        StringBufferTools.convertToXmlElementCDATAContent(sb, string, stringLength);
        sb.append("]]>");
    }

    public static void convertToXmlElementCDATAContent(StringBuffer sb, String string) {
        int stringLength = string.length();
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 6);
            StringBufferTools.convertToXmlElementCDATAContent(sb, string, stringLength);
        }
    }

    private static void convertToXmlElementCDATAContent(StringBuffer sb, String string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            char c = string.charAt(i);
            sb.append(c);
            if (c == ']') {
                if (++i >= stringLength) break;
                c = string.charAt(i);
                sb.append(c);
                if (c == ']') {
                    if (++i >= stringLength) break;
                    c = string.charAt(i);
                    if (c == '>') {
                        sb.append("&gt;");
                    } else {
                        sb.append(c);
                    }
                }
            }
            ++i;
        }
    }

    public static void convertToXmlElementCDATA(StringBuffer sb, char[] string) {
        int stringLength = string.length;
        if (stringLength == 0) {
            sb.append("<![CDATA[]]>");
        } else {
            sb.ensureCapacity(sb.length() + stringLength + "<![CDATA[]]>".length() + 6);
            StringBufferTools.convertToXmlElementCDATA(sb, string, stringLength);
        }
    }

    private static void convertToXmlElementCDATA(StringBuffer sb, char[] string, int stringLength) {
        sb.append("<![CDATA[");
        StringBufferTools.convertToXmlElementCDATAContent(sb, string, stringLength);
        sb.append("]]>");
    }

    public static void convertToXmlElementCDATAContent(StringBuffer sb, char[] string) {
        int stringLength = string.length;
        if (stringLength != 0) {
            sb.ensureCapacity(sb.length() + stringLength + 6);
            StringBufferTools.convertToXmlElementCDATAContent(sb, string, stringLength);
        }
    }

    private static void convertToXmlElementCDATAContent(StringBuffer sb, char[] string, int stringLength) {
        int i = 0;
        while (i < stringLength) {
            char c = string[i];
            sb.append(c);
            if (c == ']') {
                if (++i >= stringLength) break;
                c = string[i];
                sb.append(c);
                if (c == ']') {
                    if (++i >= stringLength) break;
                    c = string[i];
                    if (c == '>') {
                        sb.append("&gt;");
                    } else {
                        sb.append(c);
                    }
                }
            }
            ++i;
        }
    }

    private StringBufferTools() {
        throw new UnsupportedOperationException();
    }
}

