/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.validation;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jst.jsp.core.internal.JSPCorePlugin;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.java.IJSPProblem;
import org.eclipse.jst.jsp.core.internal.java.IJSPTranslation;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslation;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationAdapter;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationExtension;
import org.eclipse.jst.jsp.core.internal.modelhandler.ModelHandlerForJSP;
import org.eclipse.jst.jsp.core.internal.validation.FragmentValidationTools;
import org.eclipse.jst.jsp.core.internal.validation.JSPBatchValidator;
import org.eclipse.jst.jsp.core.internal.validation.JSPValidator;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class JSPJavaValidator
extends JSPValidator {
    private static final boolean DEBUG = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/jspvalidator"));
    private IValidator fMessageOriginator;
    private IPreferencesService fPreferencesService = Platform.getPreferencesService();
    private static final String PREFERENCE_NODE_QUALIFIER = JSPCorePlugin.getDefault().getBundle().getSymbolicName();
    private IScopeContext[] fScopes = null;
    private static final boolean UPDATE_JAVA_TASKS = true;
    private static final String JAVA_TASK_MARKER_TYPE = "org.eclipse.jdt.core.task";
    private static final String[] DEPEND_ONs = new String[]{".classpath", ".project", ".settings/org.eclipse.jdt.core.prefs", ".settings/org.eclipse.jst.jsp.core.prefs", ".settings/org.eclipse.wst.common.project.facet.core.xml", ".settings/org.eclipse.wst.common.component"};
    static /* synthetic */ Class class$0;

    public JSPJavaValidator() {
        this.fMessageOriginator = this;
    }

    public JSPJavaValidator(IValidator validator) {
        this.fMessageOriginator = validator;
    }

    private void adjustIndirectPosition(IMessage m, IJSPTranslation translation) {
        if (!(translation instanceof JSPTranslationExtension)) {
            return;
        }
        IDocument jspDoc = ((JSPTranslationExtension)translation).getJspDocument();
        if (!(jspDoc instanceof IStructuredDocument)) {
            return;
        }
        IStructuredDocument sDoc = (IStructuredDocument)jspDoc;
        IStructuredDocumentRegion[] regions = sDoc.getStructuredDocumentRegions(0, m.getOffset() + m.getLength());
        int i = regions.length - 1;
        while (i >= 0) {
            IStructuredDocumentRegion region = regions[i];
            if (region.getType() == "JSP_DIRECTIVE_NAME" && this.getDirectiveName((ITextRegionCollection)region).equals("include")) {
                ITextRegion fileValueRegion = this.getAttributeValueRegion((ITextRegionCollection)region, "file");
                if (fileValueRegion != null) {
                    m.setOffset(region.getStartOffset(fileValueRegion));
                    m.setLength(fileValueRegion.getTextLength());
                } else {
                    m.setOffset(region.getStartOffset());
                    m.setLength(region.getTextLength());
                }
                m.setLineNo(sDoc.getLineOfOffset(m.getOffset()) + 1);
                break;
            }
            --i;
        }
    }

    private IMessage createMessageFromProblem(IProblem problem, IFile f, IJSPTranslation translation, IStructuredDocument structuredDoc) {
        int sev = -1;
        int sourceStart = -1;
        int sourceEnd = -1;
        if (problem instanceof IJSPProblem) {
            sourceStart = problem.getSourceStart();
            sourceEnd = problem.getSourceEnd();
            switch (((IJSPProblem)problem).getEID()) {
                case -1610612735: {
                    sev = this.getMessageSeverity("validation.translation-tei-class-not-found");
                    break;
                }
                case -1610612734: {
                    sev = this.getMessageSeverity("validation.translation-tei-message");
                    break;
                }
                case -1610612733: {
                    sev = this.getMessageSeverity("validation.translation-tei-class-not-instantiated");
                    break;
                }
                case -1610612732: {
                    sev = this.getMessageSeverity("validation.translation-tei-class-runtime-exception");
                    break;
                }
                case -1610612731: {
                    sev = this.getMessageSeverity("validation.translation-tag-class-not-found");
                    break;
                }
                case -1610612730: {
                    sev = this.getMessageSeverity("validation.translation-usebean-invalid-id");
                    break;
                }
                case -1610612729: {
                    sev = this.getMessageSeverity("validation.translation-usebean-missing-type-info");
                    break;
                }
                case -1610612728: {
                    sev = this.getMessageSeverity("validation.translation-usebean-ambiguous-type-info");
                    break;
                }
                default: {
                    sev = problem.isError() ? 1 : (problem.isWarning() ? 2 : -1);
                    break;
                }
            }
        } else {
            sourceStart = translation.getJspOffset(problem.getSourceStart());
            sourceEnd = translation.getJspOffset(problem.getSourceEnd());
            switch (problem.getID()) {
                case 536870973: {
                    sev = this.getSourceSeverity("validation.java-local-variable-is-never-used", sourceStart, sourceEnd);
                    break;
                }
                case 536871363: {
                    sev = this.getSourceSeverity("validation.java-null-local-variable-reference", sourceStart, sourceEnd);
                    break;
                }
                case 536870974: {
                    sev = this.getSourceSeverity("validation.java-", sourceStart, sourceEnd);
                    break;
                }
                case 536871364: {
                    sev = this.getSourceSeverity("validation.java-potential-null-local-variable-reference", sourceStart, sourceEnd);
                    break;
                }
                case 268435844: {
                    sev = this.getSourceSeverity("validation.java-unused-import", sourceStart, sourceEnd);
                    break;
                }
                case 0x20000060: 
                case 570425421: {
                    sev = -1;
                    break;
                }
                default: {
                    sev = problem.isError() ? 1 : (problem.isWarning() ? 2 : 4);
                    if (sev == -1) {
                        return null;
                    }
                    if (sourceStart != -1) break;
                    int problemID = problem.getID();
                    if ((problemID & 0x20000000) != 0 && (problemID & 0x40000000) != 0 && translation instanceof JSPTranslation) {
                        JSPTranslation jspTranslation = (JSPTranslation)translation;
                        Position[] jspPositions = jspTranslation.getJsp2JavaMap().keySet().toArray(new Position[jspTranslation.getJsp2JavaMap().size()]);
                        int i = 0;
                        while (i < jspPositions.length) {
                            sourceStart = Math.max(sourceStart, jspPositions[i].getOffset());
                            ++i;
                        }
                        JSPValidator.LocalizedMessage m = new JSPValidator.LocalizedMessage((JSPValidator)this, sev, problem.getMessage(), (IResource)f);
                        m.setOffset(sourceStart);
                        m.setLength(1);
                        return m;
                    }
                    return null;
                }
            }
        }
        if (sev == -1) {
            return null;
        }
        boolean isIndirect = translation.isIndirect(problem.getSourceStart());
        if (isIndirect && !FragmentValidationTools.shouldValidateFragment((IResource)f)) {
            return null;
        }
        int lineNo = structuredDoc.getLineOfOffset(sourceStart) + 1;
        JSPValidator.LocalizedMessage m = new JSPValidator.LocalizedMessage((JSPValidator)this, sev, problem.getMessage(), (IResource)f);
        m.setLineNo(lineNo);
        m.setOffset(sourceStart);
        m.setLength(sourceEnd >= sourceStart ? sourceEnd - sourceStart + 1 : 0);
        if (isIndirect) {
            this.adjustIndirectPosition((IMessage)m, translation);
        }
        return m;
    }

    private int getSourceSeverity(String key, int start, int end) {
        return start >= 0 && end >= 0 ? this.getMessageSeverity(key) : -1;
    }

    int getMessageSeverity(String key) {
        int sev = this.fPreferencesService.getInt(PREFERENCE_NODE_QUALIFIER, key, 2, this.fScopes);
        switch (sev) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case -1: {
                return -1;
            }
        }
        return 2;
    }

    private void loadPreferences(IFile file) {
        ProjectScope projectScope;
        this.fScopes = new IScopeContext[]{new InstanceScope(), new DefaultScope()};
        if (file != null && file.isAccessible() && (projectScope = new ProjectScope(file.getProject())).getNode(PREFERENCE_NODE_QUALIFIER).getBoolean("validation.use-project-settings", false)) {
            this.fScopes = new IScopeContext[]{projectScope, new InstanceScope(), new DefaultScope()};
        }
    }

    void performValidation(IFile f, IReporter reporter, IStructuredModel model) {
        int i = 0;
        while (i < DEPEND_ONs.length) {
            this.addDependsOn(f.getProject().getFile(DEPEND_ONs[i]));
            ++i;
        }
        if (model instanceof IDOMModel) {
            IDOMModel domModel = (IDOMModel)model;
            ModelHandlerForJSP.ensureTranslationAdapterFactory((IStructuredModel)domModel);
            IDOMDocument xmlDoc = domModel.getDocument();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.internal.java.IJSPTranslation");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            JSPTranslationAdapter translationAdapter = (JSPTranslationAdapter)xmlDoc.getAdapterFor((Object)clazz);
            JSPTranslationExtension translation = translationAdapter.getJSPTranslation();
            if (!reporter.isCancelled()) {
                int i2;
                boolean updateJavaTasks;
                this.loadPreferences(f);
                boolean bl = updateJavaTasks = !domModel.isDirty() && f != null && f.isAccessible();
                if (updateJavaTasks) {
                    try {
                        IMarker[] foundMarkers = f.findMarkers(JAVA_TASK_MARKER_TYPE, true, 1);
                        i2 = 0;
                        while (i2 < foundMarkers.length) {
                            foundMarkers[i2].delete();
                            ++i2;
                        }
                    }
                    catch (CoreException e) {
                        Logger.logException(e);
                    }
                }
                translation.setProblemCollectingActive(true);
                translation.reconcileCompilationUnit();
                List problems = translation.getProblems();
                i2 = 0;
                while (i2 < problems.size() && !reporter.isCancelled()) {
                    IMessage m;
                    IProblem problem = (IProblem)problems.get(i2);
                    if (problem != null && (m = this.createMessageFromProblem(problem, f, translation, domModel.getStructuredDocument())) != null) {
                        if (problem.getID() == 536871362) {
                            if (updateJavaTasks) {
                                try {
                                    IMarker task = f.createMarker(JAVA_TASK_MARKER_TYPE);
                                    task.setAttribute("lineNumber", (Object)new Integer(m.getLineNumber()));
                                    task.setAttribute("charStart", (Object)new Integer(m.getOffset()));
                                    task.setAttribute("charEnd", (Object)new Integer(m.getOffset() + m.getLength()));
                                    task.setAttribute("message", (Object)m.getText());
                                    task.setAttribute("userEditable", (Object)Boolean.FALSE);
                                    switch (m.getSeverity()) {
                                        case 1: {
                                            task.setAttribute("priority", (Object)new Integer(2));
                                            task.setAttribute("severity", (Object)new Integer(2));
                                            break;
                                        }
                                        case 4: {
                                            task.setAttribute("priority", (Object)new Integer(0));
                                            task.setAttribute("severity", (Object)new Integer(0));
                                            break;
                                        }
                                        default: {
                                            task.setAttribute("priority", (Object)new Integer(1));
                                            task.setAttribute("severity", (Object)new Integer(1));
                                            break;
                                        }
                                    }
                                }
                                catch (CoreException e) {
                                    Logger.logException(e);
                                }
                            }
                        } else {
                            reporter.addMessage(this.fMessageOriginator, m);
                        }
                    }
                    ++i2;
                }
            }
        }
        this.unloadPreferences();
    }

    private void unloadPreferences() {
        this.fScopes = null;
    }

    /*
     * Exception decompiling
     */
    protected void validateFile(IFile f, IReporter reporter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 174->178)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addDependsOn(IFile file) {
        if (this.fMessageOriginator instanceof JSPBatchValidator) {
            ((JSPBatchValidator)this.fMessageOriginator).addDependsOn((IResource)file);
        }
    }
}

