/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.saxparser;

import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.dtd.core.internal.saxparser.Attlist;
import org.eclipse.wst.dtd.core.internal.saxparser.BaseNode;
import org.eclipse.wst.dtd.core.internal.saxparser.CMNode;
import org.eclipse.wst.dtd.core.internal.saxparser.DTD;
import org.eclipse.wst.dtd.core.internal.saxparser.DTDScanner;
import org.eclipse.wst.dtd.core.internal.saxparser.DeclNode;
import org.eclipse.wst.dtd.core.internal.saxparser.ElementDecl;
import org.eclipse.wst.dtd.core.internal.saxparser.EntityDecl;
import org.eclipse.wst.dtd.core.internal.saxparser.EntityPool;
import org.eclipse.wst.dtd.core.internal.saxparser.ErrorMessage;
import org.eclipse.wst.dtd.core.internal.saxparser.TString;
import org.eclipse.wst.xml.core.internal.validation.core.LazyURLInputStream;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class DTDParser
extends DefaultHandler
implements ContentHandler,
DTDHandler,
ErrorHandler,
DeclHandler,
LexicalHandler {
    private String contentString = "";
    protected boolean canonical;
    protected XMLReader reader;
    int entityDepth;
    private String comment = null;
    private ErrorMessage errorMessage = null;
    private List errorMessages = new ArrayList();
    private DeclNode previousDeclNode = null;
    private DeclNode currentDeclNode = null;
    private BaseNode lastBaseNode = null;
    private boolean entityEnd = false;
    private int lineNumber;
    private DTD currentDTD = null;
    private Vector dtdList = new Vector();
    private Stack dtdStack = new Stack();
    private Stack peRefStack = new Stack();
    private Stack parsingPERefStack = new Stack();
    private EntityPool entityPool = new EntityPool();
    private String expandedEntityValue = null;
    private Hashtable elementPool = new Hashtable();
    boolean parsingExternalPEReference = false;
    protected boolean expandEntityReferences = true;
    private Locator locator = null;
    protected String attributeString = "";

    private Locator getLocator() {
        return this.locator;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public DTDParser(boolean canonical) throws UnsupportedEncodingException {
        this(null, canonical);
    }

    protected DTDParser(String encoding, boolean canonical) throws UnsupportedEncodingException {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        this.canonical = canonical;
        try {
            SAXParser sparser = SAXParserFactory.newInstance().newSAXParser();
            this.reader = sparser.getXMLReader();
            this.reader.setProperty("http://xml.org/sax/properties/declaration-handler", this);
            this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.reader.setContentHandler(this);
            this.reader.setDTDHandler(this);
            this.reader.setErrorHandler(this);
            this.reader.setEntityResolver(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void parse(String logicalURI) {
        block5: {
            try {
                String physicalURI = URIResolverPlugin.createResolver().resolvePhysicalLocation("", "", logicalURI);
                boolean isReadable = URIHelper.isReadableURI((String)physicalURI, (boolean)false);
                if (!isReadable) {
                    throw new Exception("DTD parse error. Can not read the specified URI : " + logicalURI);
                }
                String document = "<!DOCTYPE root SYSTEM \"" + logicalURI + "\"><root/>";
                this.entityDepth = 0;
                this.currentDTD = new DTD(logicalURI);
                InputSource inputSource = new InputSource(new StringReader(document));
                inputSource.setSystemId(String.valueOf(logicalURI) + ".xml");
                this.reader.parse(inputSource);
            }
            catch (SAXParseException sAXParseException) {
                if (this.currentDTD != null) {
                    this.currentDTD.setIsExceptionDuringParse(true);
                }
            }
            catch (Exception exception) {
                if (this.currentDTD == null) break block5;
                this.currentDTD.setIsExceptionDuringParse(true);
            }
        }
    }

    public void setExpandEntityReferences(boolean expandEntityReferences) {
        this.expandEntityReferences = true;
    }

    public boolean getExpandEntityReferences() {
        return this.expandEntityReferences;
    }

    public Vector getDTDList() {
        return this.dtdList;
    }

    public Hashtable getElementPool() {
        return this.elementPool;
    }

    public EntityPool getEntityPool() {
        return this.entityPool;
    }

    public List getErrorMessages() {
        return this.errorMessages;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void processingInstruction(String target, String data) {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        this.startDeclaration(11);
        if (this.entityDepth == 1 || this.parsingExternalPEReference) {
            String xs = " ";
            xs = String.valueOf(xs) + name;
            xs = publicId == null ? String.valueOf(xs) + " SYSTEM \"" + systemId + "\"" : String.valueOf(xs) + " PUBLIC \"" + publicId + "\" " + "\"" + systemId + "\"";
            this.contentString = String.valueOf(this.contentString) + xs;
            this.parseCurrentDeclaration();
        }
    }

    public void elementDecl(String name, String model) throws SAXException {
        this.startDeclaration(1);
        if (this.entityDepth == 0 || this.entityDepth == 1 || this.parsingExternalPEReference) {
            this.parseCurrentDeclarationHelper(String.valueOf(name) + " " + model);
        }
    }

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
        this.startDeclaration(2);
        this.attributeString = String.valueOf(this.attributeString) + " " + aName;
        if (type != null) {
            this.attributeString = String.valueOf(this.attributeString) + " " + type;
        }
        if (valueDefault != null) {
            this.attributeString = String.valueOf(this.attributeString) + " " + valueDefault;
        }
        if (value != null) {
            this.attributeString = String.valueOf(this.attributeString) + " '" + value + "'";
        }
        this.attributeString = String.valueOf(eName) + " " + this.attributeString + ">";
        this.parseCurrentDeclarationHelper(this.attributeString);
        this.attributeString = "";
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
        this.startDeclaration(4);
        if (this.entityDepth == 1 || this.parsingExternalPEReference) {
            String xs = " ";
            if (name.startsWith("%")) {
                xs = String.valueOf(xs) + "% ";
                xs = String.valueOf(xs) + name.substring(1);
            } else {
                xs = String.valueOf(xs) + name;
            }
            xs = String.valueOf(xs) + " \"" + value + "\">";
            this.contentString = String.valueOf(this.contentString) + xs;
            this.expandedEntityValue = value;
            this.parseCurrentDeclaration();
        }
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        this.startDeclaration(5);
        if (this.entityDepth == 1 || this.parsingExternalPEReference) {
            String xs = " ";
            if (name.startsWith("%")) {
                xs = String.valueOf(xs) + "% ";
                xs = String.valueOf(xs) + name.substring(1);
            } else {
                xs = String.valueOf(xs) + name;
            }
            if (systemId != null) {
                xs = String.valueOf(xs) + " SYSTEM \"" + systemId + "\">";
            } else if (publicId != null) {
                xs = String.valueOf(xs) + " PUBLIC \"" + publicId + "\">";
            }
            this.contentString = String.valueOf(this.contentString) + xs;
            this.parseCurrentDeclaration();
        }
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.dtdList.removeAllElements();
        this.dtdList.addElement(this.currentDTD);
    }

    public void endDTD() throws SAXException {
        this.startDeclaration(22);
    }

    public void startEntity(String name) throws SAXException {
        if (name.equals("[dtd]")) {
            this.startDeclaration(23);
        } else if (this.currentDeclNode == null) {
            if (name.startsWith("%")) {
                String peName = name.substring(1);
                EntityDecl en = this.entityPool.referPara(peName);
                this.peRefStack.push(name);
                this.parsingPERefStack.push(new Boolean(this.parsingExternalPEReference));
                String systemId = en.getSystemId();
                String publicId = en.getPublicId();
                if (systemId == null) {
                    this.parsingExternalPEReference = false;
                } else {
                    URIResolver idResolver = URIResolverPlugin.createResolver();
                    String uri = idResolver.resolve(this.currentDTD.getName(), publicId, systemId);
                    if (!this.isDTDLoaded(uri)) {
                        this.dtdStack.push(this.currentDTD);
                        DTD newDTD = new DTD(uri);
                        this.dtdList.addElement(newDTD);
                        this.currentDTD = newDTD;
                        this.parsingExternalPEReference = true;
                    } else {
                        this.parsingExternalPEReference = false;
                    }
                }
            }
        } else if (this.entityDepth == 1 || this.parsingExternalPEReference) {
            String xs = (String)this.reader.getProperty("http://xml.org/sax/properties/xml-string");
            this.contentString = String.valueOf(this.contentString) + xs;
        }
        ++this.entityDepth;
    }

    public void endEntity(String name) throws SAXException {
        if (name.equals("[dtd]")) {
            this.startDeclaration(24);
        } else if (!this.peRefStack.empty()) {
            this.parseExternalPEReference(name);
        } else if ((this.entityDepth == 1 || this.parsingExternalPEReference) && !this.contentString.endsWith(String.valueOf(name) + ";")) {
            String xs = (String)this.reader.getProperty("http://xml.org/sax/properties/xml-string");
            this.contentString = String.valueOf(this.contentString) + xs;
        }
        --this.entityDepth;
        this.entityEnd = true;
    }

    protected boolean parseExternalPEReference(String name) {
        if (!this.peRefStack.empty() && ((String)this.peRefStack.peek()).equals(name)) {
            this.peRefStack.pop();
            if (this.parsingExternalPEReference) {
                this.currentDTD = (DTD)this.dtdStack.pop();
                this.addPEReferenceNode(name);
            }
            this.parsingExternalPEReference = (Boolean)this.parsingPERefStack.pop();
            return true;
        }
        return false;
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.startDeclaration(12);
        this.comment = this.comment == null ? new String(ch, start, length) : String.valueOf(this.comment) + "\n" + new String(ch, start, length);
    }

    public void warning(SAXParseException ex) {
        this.setErrorInformation(ex, "warning");
        this.parseCurrentDeclaration();
    }

    public void error(SAXParseException ex) {
        this.setErrorInformation(ex, "error");
        this.parseCurrentDeclaration();
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        this.setErrorInformation(ex, "fatal");
        this.parseCurrentDeclaration();
    }

    private void startDeclaration(int type) {
        if (type == 22 || type == 24 || type == 12 || type == 25) {
            this.previousDeclNode = this.currentDeclNode;
            this.currentDeclNode = null;
        } else {
            this.currentDeclNode = new DeclNode(type);
            this.contentString = "";
            this.expandedEntityValue = null;
        }
    }

    private void parseCurrentDeclaration() {
        this.parseCurrentDeclarationHelper(this.contentString);
        this.contentString = "";
    }

    private void parseCurrentDeclarationHelper(String declarationString) {
        if (this.currentDeclNode == null && this.previousDeclNode != null && this.entityEnd) {
            this.currentDeclNode = this.previousDeclNode;
        }
        if (this.currentDeclNode != null) {
            BaseNode baseNode = null;
            if (declarationString.endsWith(">")) {
                declarationString = declarationString.substring(0, declarationString.length() - 1);
            }
            int type = this.currentDeclNode.getType();
            switch (type) {
                case 1: {
                    String name = TString.word(declarationString, 1);
                    int sIndex = declarationString.indexOf(name) + name.length();
                    String cString = declarationString.substring(sIndex);
                    baseNode = new ElementDecl(name, this.currentDTD.getName());
                    DTDScanner scanner = new DTDScanner(this.currentDTD.getName(), cString);
                    CMNode contentModel = scanner.scanContentModel();
                    if (contentModel == null && this.errorMessage == null) {
                        this.createErrorMessage("Expecting '(' in content model", "error");
                    }
                    ((ElementDecl)baseNode).setContentModelNode(contentModel);
                    this.elementPool.put(name, baseNode);
                    break;
                }
                case 4: 
                case 5: {
                    if (this.parseExternalPEReference(declarationString)) break;
                    DTDScanner scanner = new DTDScanner(this.currentDTD.getName(), declarationString);
                    baseNode = scanner.scanEntityDecl();
                    if (type == 4 && this.expandedEntityValue != null) {
                        ((EntityDecl)baseNode).expandedValue = this.expandedEntityValue;
                    }
                    if (baseNode == null) break;
                    this.entityPool.add((EntityDecl)baseNode);
                    break;
                }
                case 11: {
                    DTDScanner scanner = new DTDScanner(this.currentDTD.getName(), declarationString);
                    baseNode = scanner.scanNotationDecl();
                    break;
                }
                case 2: {
                    String name = TString.word(declarationString, 1);
                    int sIndex = declarationString.indexOf(name) + name.length();
                    String cString = declarationString.substring(sIndex);
                    baseNode = new Attlist(name, this.currentDTD.getName());
                    DTDScanner scanner = new DTDScanner(this.currentDTD.getName(), cString.trim());
                    Vector attrs = scanner.scanAttlistDecl(this.entityPool);
                    String errorString = scanner.getErrorString();
                    if (attrs.size() > 0) {
                        ((Attlist)baseNode).setAttDefs(attrs);
                    }
                    if (errorString == null) break;
                    this.createErrorMessage(errorString, "error");
                    break;
                }
                default: {
                    this.currentDeclNode = null;
                }
            }
            if (baseNode != null) {
                if (this.comment != null) {
                    baseNode.setComment(this.comment);
                    this.comment = null;
                }
                if (this.errorMessage != null) {
                    baseNode.setErrorMessage(this.errorMessage);
                    this.errorMessage = null;
                }
                if (this.currentDeclNode != null) {
                    this.currentDTD.addDecl(baseNode);
                }
                this.lastBaseNode = baseNode;
            }
            this.currentDeclNode = null;
        } else if (this.lastBaseNode != null && this.errorMessage != null && this.lastBaseNode.getErrorMessage() == null) {
            this.lastBaseNode.setErrorMessage(this.errorMessage);
            this.errorMessage = null;
        }
    }

    private void addPEReferenceNode(String name) {
        if (name.startsWith("%")) {
            name = name.substring(1);
        }
        EntityDecl e = new EntityDecl(name, this.currentDTD.getName(), null, true);
        e.setEntityReferenced(true);
        e.setErrorMessage(this.errorMessage);
        this.errorMessage = null;
        this.currentDTD.addDecl(e);
    }

    private boolean isDTDLoaded(String uri) {
        boolean loaded = false;
        if (this.dtdList != null) {
            Enumeration en = this.dtdList.elements();
            while (en.hasMoreElements()) {
                DTD dtd = (DTD)en.nextElement();
                if (!dtd.getName().equals(uri)) continue;
                loaded = true;
                break;
            }
        }
        return loaded;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource result = null;
        URIResolver idResolver = URIResolverPlugin.createResolver();
        String logicalURI = idResolver.resolve(this.currentDTD.getName(), publicId, systemId);
        String physicalURI = idResolver.resolvePhysicalLocation(this.currentDTD.getName(), publicId, logicalURI);
        result = new InputSource(logicalURI);
        if (physicalURI != null && !physicalURI.equals("") && !URIHelper.hasProtocol((String)physicalURI)) {
            physicalURI = "file:///" + physicalURI;
        }
        result.setByteStream((InputStream)new LazyURLInputStream(physicalURI));
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] argv) {
        if (argv.length == 0) {
            DTDParser.printUsage();
            System.exit(1);
        }
        canonical = false;
        expandEntityReferences = false;
        i = 0;
        while (i < argv.length) {
            arg = argv[i];
            if (!arg.startsWith("-")) ** GOTO lbl19
            if (arg.equals("-c")) {
                canonical = true;
            } else if (arg.equals("-x")) {
                expandEntityReferences = true;
            } else {
                if (arg.equals("-h")) {
                    DTDParser.printUsage();
                    System.exit(1);
                }
lbl19:
                // 4 sources

                try {
                    parser = new DTDParser(canonical);
                    parser.setExpandEntityReferences(expandEntityReferences);
                    parser.parse(arg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    private static void printUsage() {
        System.err.println("usage: java sax.DTDParser (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -c       Canonical XML output.");
        System.err.println("  -x       Expand entity references.");
        System.err.println("  -h       This help screen.");
    }

    private void setErrorInformation(SAXParseException ex, String severity) {
        this.errorMessage = new ErrorMessage();
        if (ex.getLineNumber() == -1) {
            this.errorMessage.setErrorLine(this.lineNumber);
        } else {
            this.errorMessage.setErrorLine(ex.getLineNumber());
        }
        this.errorMessage.setErrorMessage(ex.getMessage());
        this.errorMessage.setErrorColumn(ex.getColumnNumber());
        this.errorMessage.setSeverity(severity);
        this.errorMessages.add(this.errorMessage);
    }

    private void createErrorMessage(String message, String severity) {
        this.errorMessage = new ErrorMessage();
        Locator locator = this.getLocator();
        this.errorMessage.setErrorLine(locator.getLineNumber());
        this.errorMessage.setErrorColumn(locator.getColumnNumber());
        this.errorMessage.setErrorMessage(message);
        this.errorMessage.setSeverity(severity);
        this.errorMessages.add(this.errorMessage);
    }
}

