/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.internal.context;

import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jpt.common.core.internal.utility.EmptyTextRange;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jaxb.core.JaxbNode;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbTypeMapping;
import org.eclipse.jpt.jaxb.core.context.TypeKind;
import org.eclipse.jpt.jaxb.core.internal.context.AbstractJaxbContextRoot;
import org.eclipse.jpt.jaxb.core.resource.jaxbprops.JaxbPropertiesResource;
import org.eclipse.jpt.jaxb.eclipselink.core.ELJaxbProject;
import org.eclipse.jpt.jaxb.eclipselink.core.context.ELJaxbContextRoot;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmFile;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmJavaType;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmTypeMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmXmlEnum;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.oxm.OxmFileImpl;
import org.eclipse.jpt.jaxb.eclipselink.core.validation.JptJaxbEclipseLinkCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELJaxbContextRootImpl
extends AbstractJaxbContextRoot
implements ELJaxbContextRoot {
    private SortedSet<OxmFile> oxmFiles;
    private Hashtable<String, OxmTypeMapping> oxmTypeMappingMap;

    public ELJaxbContextRootImpl(JaxbProject jaxbProject) {
        super(jaxbProject);
    }

    public ELJaxbProject getJaxbProject() {
        return (ELJaxbProject)super.getJaxbProject();
    }

    public JaxbClassMapping getClassMapping(String typeName) {
        OxmTypeMapping mapping = this.oxmTypeMappingMap.get(typeName);
        if (mapping != null) {
            return mapping.getTypeKind() == TypeKind.CLASS ? (JaxbClassMapping)mapping : null;
        }
        return super.getClassMapping(typeName);
    }

    protected void initialize() {
        this.initOxmFiles();
        this.oxmTypeMappingMap = new Hashtable();
        super.initialize();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        for (OxmFile oxmFile : this.getOxmFiles()) {
            oxmFile.synchronizeWithResourceModel();
        }
    }

    public void update() {
        this.rebuildOxmTypeMappingMap();
        this.updateOxmFiles();
        super.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildOxmTypeMappingMap() {
        Hashtable<String, OxmTypeMapping> hashtable = this.oxmTypeMappingMap;
        synchronized (hashtable) {
            Hashtable<String, OxmTypeMapping> oldMap = new Hashtable<String, OxmTypeMapping>(this.oxmTypeMappingMap);
            this.oxmTypeMappingMap.clear();
            for (OxmFile oxmFile : this.getOxmFiles()) {
                String typeName;
                for (OxmXmlEnum oxmXmlEnum : oxmFile.getXmlBindings().getXmlEnums()) {
                    typeName = oxmXmlEnum.getTypeName().getFullyQualifiedName();
                    if (StringTools.isBlank((String)typeName) || this.oxmTypeMappingMap.containsKey(typeName)) continue;
                    this.oxmTypeMappingMap.put(typeName, oxmXmlEnum);
                }
                for (OxmJavaType oxmJavaType : oxmFile.getXmlBindings().getJavaTypes()) {
                    typeName = oxmJavaType.getTypeName().getFullyQualifiedName();
                    if (StringTools.isBlank((String)typeName) || this.oxmTypeMappingMap.containsKey(typeName)) continue;
                    this.oxmTypeMappingMap.put(typeName, oxmJavaType);
                }
            }
            if (!oldMap.equals(this.oxmTypeMappingMap)) {
                this.fireStateChanged();
            }
        }
    }

    protected Set<String> calculateInitialPackageNames() {
        Set initialPackageNames = super.calculateInitialPackageNames();
        for (OxmFile oxmFile : this.getOxmFiles()) {
            String packageName = oxmFile.getPackageName();
            if (StringTools.isBlank((String)packageName)) continue;
            initialPackageNames.add(packageName);
        }
        return initialPackageNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<OxmFile> getOxmFiles() {
        SortedSet<OxmFile> sortedSet = this.oxmFiles;
        synchronized (sortedSet) {
            return IterableTools.cloneSnapshot(this.oxmFiles);
        }
    }

    @Override
    public int getOxmFilesSize() {
        return this.oxmFiles.size();
    }

    protected void addOxmFile(OxmFile oxmFile) {
        this.addItemToCollection(oxmFile, this.oxmFiles, "oxmFiles");
    }

    protected void removeOxmFile(OxmFile oxmFile) {
        this.removeItemFromCollection(oxmFile, this.oxmFiles, "oxmFiles");
    }

    @Override
    public OxmFile getOxmFile(String packageName) {
        for (OxmFile oxmFile : this.getOxmFiles()) {
            if (!packageName.equals(oxmFile.getPackageName())) continue;
            return oxmFile;
        }
        return null;
    }

    protected OxmFile buildOxmFile(JptXmlResource oxmResource) {
        return new OxmFileImpl(this, oxmResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initOxmFiles() {
        SortedSet<OxmFile> sortedSet = this.oxmFiles = Collections.synchronizedSortedSet(new TreeSet<OxmFile>(new Comparator<OxmFile>(){

            @Override
            public int compare(OxmFile of1, OxmFile of2) {
                return of1.getResource().getProjectRelativePath().toString().compareTo(of2.getResource().getProjectRelativePath().toString());
            }
        }));
        synchronized (sortedSet) {
            for (JptXmlResource oxmResource : this.getJaxbProject().getOxmResources()) {
                this.oxmFiles.add(this.buildOxmFile(oxmResource));
            }
        }
    }

    protected void updateOxmFiles() {
        HashBag unmatchedOxmResources = CollectionTools.collection(this.getJaxbProject().getOxmResources());
        for (OxmFile oxmFile : this.getOxmFiles()) {
            JptXmlResource oxmResource = oxmFile.getOxmResource();
            if (!unmatchedOxmResources.remove(oxmResource)) {
                this.removeOxmFile(oxmFile);
                continue;
            }
            oxmFile.update();
        }
        for (JptXmlResource oxmResource : unmatchedOxmResources) {
            this.addOxmFile(this.buildOxmFile(oxmResource));
        }
    }

    public JaxbTypeMapping getTypeMapping(String typeName) {
        if (typeName == null) {
            return null;
        }
        OxmTypeMapping oxmTypeMapping = this.getOxmTypeMapping(typeName);
        return oxmTypeMapping != null ? oxmTypeMapping : super.getTypeMapping(typeName);
    }

    @Override
    public OxmTypeMapping getOxmTypeMapping(String typeName) {
        return this.oxmTypeMappingMap.get(typeName);
    }

    public TextRange getValidationTextRange() {
        return EmptyTextRange.instance();
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateJaxbProperties(messages, reporter);
        for (OxmFile oxmFile : this.getOxmFiles()) {
            oxmFile.validate(messages, reporter);
        }
    }

    protected void validateJaxbProperties(List<IMessage> messages, IReporter reporter) {
        String factoryProp = "javax.xml.bind.context.factory";
        String factoryPropValue = "org.eclipse.persistence.jaxb.JAXBContextFactory";
        for (JaxbPackage jp : this.getPackages()) {
            String pn = jp.getName();
            JaxbPropertiesResource jpr = this.getJaxbProject().getJaxbPropertiesResource(pn);
            if (jpr == null || !ObjectTools.equals((Object)jpr.getProperty(factoryProp), (Object)factoryPropValue)) continue;
            return;
        }
        messages.add(this.buildValidationMessage((JaxbNode)this.getJaxbProject(), JptJaxbEclipseLinkCoreValidationMessages.PROJECT_MISSING_ECLIPSELINK_JAXB_CONTEXT_FACTORY));
    }
}

