/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.jaxb.core.JaxbNode;
import org.eclipse.jpt.jaxb.core.context.JaxbAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.jpt.jaxb.eclipselink.core.context.ELXmlPath;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.xpath.java.XPath;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.xpath.java.XPathFactory;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlPathAnnotation;
import org.eclipse.jpt.jaxb.eclipselink.core.validation.JptJaxbEclipseLinkCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELJavaXmlPath
extends AbstractJavaContextNode
implements ELXmlPath {
    protected String value;
    protected Context context;

    public ELJavaXmlPath(JaxbContextNode parent, Context context) {
        super((JaxbNode)parent);
        this.context = context;
        this.initValue();
    }

    protected JaxbPackage getJaxbPackage() {
        return this.getClassMapping().getJaxbPackage();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncValue();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.getAnnotation().setValue(value);
        this.setValue_(value);
    }

    protected void setValue_(String value) {
        String old = this.value;
        this.value = value;
        this.firePropertyChanged("value", old, this.value);
    }

    protected void initValue() {
        this.value = this.getAnnotation().getValue();
    }

    protected void syncValue() {
        this.setValue_(this.getAnnotation().getValue());
    }

    protected XmlPathAnnotation getAnnotation() {
        return this.context.getAnnotation();
    }

    protected JaxbAttributeMapping getAttributeMapping() {
        return this.context.getAttributeMapping();
    }

    protected JaxbClassMapping getClassMapping() {
        return this.getAttributeMapping().getClassMapping();
    }

    public Iterable<String> getCompletionProposals(int pos) {
        if (this.getAnnotation().valueTouches(pos) && this.value != null) {
            XsdTypeDefinition xsdType = this.getClassMapping().getXsdTypeDefinition();
            XPath xpath = XPathFactory.instance().getXpath(this.value);
            return xpath.getCompletionProposals(new XPathContext(), xsdType, pos);
        }
        return EmptyIterable.instance();
    }

    public TextRange getValidationTextRange() {
        return this.getAnnotation().getTextRange();
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (StringTools.isBlank((String)this.value)) {
            messages.add(this.buildValidationMessage((JaxbNode)this, this.getValueTextRange(), JptJaxbEclipseLinkCoreValidationMessages.XML_PATH__NOT_SPECIFIED));
            return;
        }
        if (this.value.startsWith(XPath.DELIM)) {
            messages.add(this.buildValidationMessage((JaxbNode)this, this.getValueValidationTextRange(), JptJaxbEclipseLinkCoreValidationMessages.XPATH__ROOT_NOT_SUPPORTED));
            return;
        }
        XsdTypeDefinition xsdType = this.getClassMapping().getXsdTypeDefinition();
        XPath xpath = XPathFactory.instance().getXpath(this.value);
        xpath.validate(new XPathContext(), xsdType, messages);
    }

    protected TextRange getValueTextRange() {
        return this.getAnnotation().getValueTextRange();
    }

    protected TextRange getValueValidationTextRange() {
        return this.getAnnotation().getValueValidationTextRange();
    }

    public static interface Context {
        public XmlPathAnnotation getAnnotation();

        public JaxbAttributeMapping getAttributeMapping();
    }

    protected class XPathContext
    extends XPath.AbstractContext {
        protected XPathContext() {
        }

        public JaxbNode getContextObject() {
            return ELJavaXmlPath.this;
        }

        public JaxbPackage getJaxbPackage() {
            return ELJavaXmlPath.this.getJaxbPackage();
        }

        public TextRange getTextRange() {
            return ELJavaXmlPath.this.getValueTextRange();
        }
    }
}

