/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.tests.j2ee;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectDescriptionReader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class ProjectUnzipUtil {
    private IPath zipLocation;
    private String[] projectNames;
    private static final String META_PROJECT_NAME = ".project";

    public ProjectUnzipUtil(IPath aZipLocation, String[] aProjectNames) {
        this.zipLocation = aZipLocation;
        this.projectNames = aProjectNames;
    }

    public boolean createProjects() {
        try {
            this.expandZip();
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
            this.buildProjects();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void expandZip() throws CoreException, IOException {
        ZipFile zipFile = null;
        zipFile = new ZipFile(this.zipLocation.toFile());
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File aFile = this.computeLocation(entry.getName()).toFile();
            File parentFile = null;
            if (entry.isDirectory()) {
                aFile.mkdirs();
                continue;
            }
            parentFile = aFile.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            if (!aFile.exists()) {
                aFile.createNewFile();
            }
            ProjectUnzipUtil.copy(zipFile.getInputStream(entry), new FileOutputStream(aFile));
            if (entry.getTime() <= 0L) continue;
            aFile.setLastModified(entry.getTime());
        }
    }

    private IPath computeLocation(String name) {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation().append(name);
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        try {
            int n = in.read(buffer);
            while (n > 0) {
                out.write(buffer, 0, n);
                n = in.read(buffer);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    private void buildProjects() throws IOException, CoreException {
        String[] stringArray = this.projectNames;
        int n = this.projectNames.length;
        int n2 = 0;
        while (n2 < n) {
            String projectName = stringArray[n2];
            ProjectDescriptionReader pd = new ProjectDescriptionReader();
            Path projectPath = new Path("/" + projectName + "/" + META_PROJECT_NAME);
            IPath path = ResourcesPlugin.getWorkspace().getRoot().getLocation().append((IPath)projectPath);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            try {
                ProjectDescription description = pd.read(path);
                project.create((IProjectDescription)description, (IProgressMonitor)new NullProgressMonitor());
                project.open((IProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException e) {
                throw e;
            }
            catch (CoreException e) {
                throw e;
            }
            ++n2;
        }
    }
}

