/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.reconcile.DocumentRegionProcessor;
import org.eclipse.wst.sse.ui.reconcile.ISourceReconcilingListener;

public class TestStructuredTextEditor
extends TestCase {
    private final String PROJECT_NAME = "TestStructuredTextEditor";
    private final String FILE_NAME = "testStructuredTextEditor.xml";
    private static final int MAX_WAIT = 10000;
    private static final int TIME_DELTA = 50;
    private static StructuredTextEditor fEditor;
    private static IFile fFile;
    private static boolean fIsSetup;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        fIsSetup = false;
    }

    public TestStructuredTextEditor() {
        super("TestStructuredTextEditor");
    }

    protected void setUp() throws Exception {
        if (!fIsSetup) {
            this.createProject("TestStructuredTextEditor");
            fFile = this.getOrCreateFile("TestStructuredTextEditor/testStructuredTextEditor.xml");
            fIsSetup = true;
        }
        if (fIsSetup && fEditor == null) {
            FileEditorInput input;
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            IEditorPart part = page.openEditor((IEditorInput)(input = new FileEditorInput(fFile)), "org.eclipse.wst.sse.ui.StructuredTextEditor.test", true);
            if (part instanceof StructuredTextEditor) {
                fEditor = (StructuredTextEditor)part;
            } else {
                TestStructuredTextEditor.assertTrue((String)"Unable to open structured text editor", (boolean)false);
            }
        }
    }

    protected void tearDown() throws Exception {
        if (fEditor != null) {
            fEditor.close(false);
            TestStructuredTextEditor.assertTrue((String)"Unable to close editor", (boolean)true);
            fEditor = null;
        }
    }

    private void createProject(String projName) {
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(projName);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        try {
            project.create(description, (IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected IFile getOrCreateFile(String filePath) {
        IFile blankJspFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
        if (blankJspFile != null && !blankJspFile.exists()) {
            try {
                blankJspFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return blankJspFile;
    }

    public void testDoSaving() {
        fEditor.doRevertToSaved();
        TestStructuredTextEditor.assertTrue((String)"Unable to revert to saved", (boolean)true);
        fEditor.doSave((IProgressMonitor)new NullProgressMonitor());
        TestStructuredTextEditor.assertTrue((String)"Unable to save", (boolean)true);
    }

    public void testEditorContextMenuAboutToShow() {
        MenuManager menu = new MenuManager();
        fEditor.editorContextMenuAboutToShow((IMenuManager)menu);
        TestStructuredTextEditor.assertTrue((String)"Unable to prepare for context menu about to show", (boolean)true);
        menu.dispose();
        menu = null;
    }

    public void testGetAdapter() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = fEditor.getAdapter((Class)clazz);
        TestStructuredTextEditor.assertTrue((String)"Get adapter for show in target failed", (boolean)(adapter instanceof IShowInTargetList));
    }

    public void testGetSetEditorPart() {
        fEditor.setEditorPart(null);
        TestStructuredTextEditor.assertTrue((String)"Unable to set editor part", (boolean)true);
        IEditorPart part = fEditor.getEditorPart();
        TestStructuredTextEditor.assertTrue((String)"Did not get expected editor part", (boolean)(part instanceof StructuredTextEditor));
    }

    public void testInitializeDocumentProvider() {
        fEditor.initializeDocumentProvider(null);
        TestStructuredTextEditor.assertTrue((String)"Unable to initialize document provider", (boolean)true);
    }

    public void testGetOrientation() {
        int or = fEditor.getOrientation();
        TestStructuredTextEditor.assertEquals((int)0x2000000, (int)or);
    }

    public void testGetSelectionProvider() {
        ISelectionProvider provider = fEditor.getSelectionProvider();
        TestStructuredTextEditor.assertNotNull((String)"Editor's selection provider was null", (Object)provider);
    }

    public void testGetTextViewer() {
        StructuredTextViewer viewer = fEditor.getTextViewer();
        TestStructuredTextEditor.assertNotNull((String)"Editor's text viewer was null", (Object)viewer);
    }

    public void testRememberRestoreSelection() {
        fEditor.rememberSelection();
        TestStructuredTextEditor.assertTrue((String)"Unable to remember editor selection", (boolean)true);
        fEditor.restoreSelection();
        TestStructuredTextEditor.assertTrue((String)"Unable to restore editor selection", (boolean)true);
    }

    public void testSafelySanityCheck() {
        fEditor.safelySanityCheckState(fEditor.getEditorInput());
        TestStructuredTextEditor.assertTrue((String)"Unable to safely sanity check editor state", (boolean)true);
    }

    public void testShowBusy() {
        fEditor.showBusy(false);
        TestStructuredTextEditor.assertTrue((String)"Unable to show editor is busy", (boolean)true);
    }

    public void testUpdate() {
        fEditor.update();
        TestStructuredTextEditor.assertTrue((String)"Unable to update editor", (boolean)true);
    }

    public void testSingleNonUIThreadUpdatesToEditorDocument() throws Exception {
        IFile file = this.getOrCreateFile("TestStructuredTextEditor/testBackgroundChanges.xml");
        ITextFileBufferManager textFileBufferManager = FileBuffers.getTextFileBufferManager();
        textFileBufferManager.connect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        ITextFileBuffer textFileBuffer = textFileBufferManager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
        final IDocument document = textFileBuffer.getDocument();
        document.replace(0, 0, "<?xml encoding=\"UTF-8\" version=\"1.0\"?>\n");
        textFileBuffer.commit((IProgressMonitor)new NullProgressMonitor(), true);
        String testText = String.valueOf(document.get()) + "<c/><b/><a/>";
        final int end = document.getLength();
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart openedEditor = IDE.openEditor((IWorkbenchPage)activePage, (IFile)file);
        final boolean[] state = new boolean[1];
        Job changer = new Job("text changer"){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        document.replace(end, 0, "<a/>");
                        document.replace(end, 0, "<b/>");
                        document.replace(end, 0, "<c/>");
                    }
                    catch (Exception e) {
                        Status status = new Status(4, "org.eclipse.wst.sse.ui", e.getMessage());
                        Object var3_4 = null;
                        state[0] = true;
                        return status;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    state[0] = true;
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                    state[0] = true;
                    return Status.OK_STATUS;
                }
            }
        };
        changer.setUser(true);
        changer.setSystem(false);
        changer.schedule();
        while (!state[0]) {
            openedEditor.getSite().getShell().getDisplay().readAndDispatch();
        }
        String finalText = document.get();
        textFileBuffer.commit((IProgressMonitor)new NullProgressMonitor(), true);
        textFileBufferManager.disconnect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        activePage.closeEditor(openedEditor, false);
        TestStructuredTextEditor.assertEquals((String)"Non-UI changes did not apply", (String)testText, (String)finalText);
    }

    public void testManyNonUIThreadsUpdatingEditorDocument() throws Exception {
        long timeout = 900000L;
        long startTime = System.currentTimeMillis();
        IFile file = this.getOrCreateFile("TestStructuredTextEditor/testManyBackgroundChanges.xml");
        ITextFileBufferManager textFileBufferManager = FileBuffers.getTextFileBufferManager();
        textFileBufferManager.connect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        ITextFileBuffer textFileBuffer = textFileBufferManager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
        final IDocument document = textFileBuffer.getDocument();
        document.replace(0, 0, "<?xml encoding=\"UTF-8\" version=\"1.0\"?>\n");
        textFileBuffer.commit((IProgressMonitor)new NullProgressMonitor(), true);
        final int insertionPoint = document.getLength();
        int testLength = insertionPoint + 5200;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        activePage.showView("org.eclipse.ui.views.ProgressView");
        IEditorPart openedEditor = IDE.openEditor((IWorkbenchPage)activePage, (IFile)file);
        final int[] finished = new int[]{50};
        Job[] changers = new Job[50];
        int i = 0;
        while (i < changers.length) {
            changers[i] = new Job("Text Changer " + Integer.toString(i)){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            char[] names = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
                            int j = 0;
                            while (j < names.length) {
                                document.replace(insertionPoint + 4 * j, 0, "<" + names[j] + "/>");
                                ++j;
                            }
                        }
                        catch (Exception e) {
                            Status status = new Status(4, "org.eclipse.wst.sse.ui", e.getMessage());
                            Object var4_6 = null;
                            finished[0] = finished[0] - 1;
                            return status;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        finished[0] = finished[0] - 1;
                        throw throwable;
                    }
                    {
                        Object var4_8 = null;
                    }
                    finished[0] = finished[0] - 1;
                    return Status.OK_STATUS;
                }
            };
            changers[i].setUser(true);
            changers[i].setSystem(false);
            ++i;
        }
        i = 0;
        while (i < changers.length) {
            changers[i].schedule();
            ++i;
        }
        long runtime = 0L;
        while (finished[0] > 0 && (runtime = System.currentTimeMillis()) - startTime < timeout) {
            openedEditor.getSite().getShell().getDisplay().readAndDispatch();
        }
        TestStructuredTextEditor.assertTrue((String)"Test timed out", (runtime - startTime < timeout ? 1 : 0) != 0);
        int finalLength = document.getLength();
        textFileBuffer.commit((IProgressMonitor)new NullProgressMonitor(), true);
        textFileBufferManager.disconnect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        activePage.closeEditor(openedEditor, false);
        TestStructuredTextEditor.assertEquals((String)"Some non-UI changes did not apply", (int)testLength, (int)finalLength);
    }

    /*
     * Exception decompiling
     */
    public void testInitialReconciling() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 216->220)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testModificationReconciling() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 379->383)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testFocusedReconciling() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 384->388)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addReconcilingListener(StructuredTextEditor editor, ISourceReconcilingListener listener) throws Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.texteditor.AbstractTextEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Method mConfig = clazz.getDeclaredMethod("getSourceViewerConfiguration", null);
        mConfig.setAccessible(true);
        Object config = mConfig.invoke((Object)editor, null);
        TestStructuredTextEditor.assertTrue((String)"Did not get a source viewer configuration", (boolean)(config instanceof SourceViewerConfiguration));
        IReconciler reconciler = ((SourceViewerConfiguration)config).getReconciler((ISourceViewer)fEditor.getTextViewer());
        TestStructuredTextEditor.assertTrue((String)"Reconciler is not a DirtyRegionProcessor", (boolean)(reconciler instanceof DocumentRegionProcessor));
        ((DocumentRegionProcessor)reconciler).addReconcilingListener(listener);
    }

    public void waitForReconcile(int[] state) throws Exception {
        int time = 0;
        while ((state[0] == -1 || state[1] == -1) && time < 10000) {
            Thread.sleep(50L);
            time += 50;
        }
    }
}

