/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.tests.viewer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.css.ui.tests.ProjectUtil;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.reconcile.ISourceReconcilingListener;

public class CSSCodeFoldingTest
extends TestCase
implements ISourceReconcilingListener {
    private static final int MAX_WAIT_TIME = 4000;
    private static final int WAIT_TIME = 200;
    private static final String PROJECT_NAME = "CSSCodeFoldingTest";
    private static final String PROJECT_FILES = "/testresources/folding";
    protected static IProject fProject;
    protected static Map fFileToEditorMap;
    private static IDocument fReconciledDoc;
    static /* synthetic */ Class class$0;

    static {
        fFileToEditorMap = new HashMap();
        fReconciledDoc = null;
    }

    public CSSCodeFoldingTest() {
        super("CSS Code Folding Test");
    }

    public CSSCodeFoldingTest(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.css.ui.tests.viewer.CSSCodeFoldingTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite ts = new TestSuite((Class)clazz, "CSS Code Folding Test");
        return new CSSCodeFoldingTestSetup((Test)ts);
    }

    protected void setUp() throws Exception {
        super.setUp();
        fReconciledDoc = null;
    }

    public void testInitFolding() throws Exception {
        IFile file = CSSCodeFoldingTest.getFile("CSSFoldingTest1.css");
        StructuredTextEditor editor = this.getEditor(file);
        ArrayList<Position> expectedPositions = new ArrayList<Position>();
        expectedPositions.add(new Position(401, 120));
        expectedPositions.add(new Position(333, 62));
        expectedPositions.add(new Position(181, 72));
        expectedPositions.add(new Position(258, 69));
        expectedPositions.add(new Position(21, 113));
        this.waitForReconcileThenVerify(editor.getTextViewer(), expectedPositions);
    }

    public void testRemoveNode() throws Exception {
        IFile file = CSSCodeFoldingTest.getFile("CSSFoldingTest1.css");
        StructuredTextEditor editor = this.getEditor(file);
        try {
            StructuredTextViewer viewer = editor.getTextViewer();
            IDocument doc = viewer.getDocument();
            doc.replace(253, 76, "");
            editor.doSave(null);
            ArrayList<Position> expectedPositions = new ArrayList<Position>();
            expectedPositions.add(new Position(325, 120));
            expectedPositions.add(new Position(21, 113));
            expectedPositions.add(new Position(181, 72));
            expectedPositions.add(new Position(257, 62));
            this.waitForReconcileThenVerify(viewer, expectedPositions);
        }
        catch (BadLocationException e) {
            CSSCodeFoldingTest.fail((String)("Test is broken, replace location has become invalid.\n" + e.getMessage()));
        }
    }

    public void testAddNode() throws Exception {
        IFile file = CSSCodeFoldingTest.getFile("CSSFoldingTest2.css");
        StructuredTextEditor editor = this.getEditor(file);
        try {
            StructuredTextViewer viewer = editor.getTextViewer();
            IDocument doc = viewer.getDocument();
            doc.replace(255, 0, "\ntd {\nborder: 1px solid black;\n}\n");
            editor.doSave(null);
            ArrayList<Position> expectedPositions = new ArrayList<Position>();
            expectedPositions.add(new Position(291, 69));
            expectedPositions.add(new Position(256, 31));
            expectedPositions.add(new Position(21, 113));
            expectedPositions.add(new Position(434, 120));
            expectedPositions.add(new Position(181, 72));
            expectedPositions.add(new Position(366, 62));
            this.waitForReconcileThenVerify(viewer, expectedPositions);
        }
        catch (BadLocationException e) {
            CSSCodeFoldingTest.fail((String)("Test is broken, add location has become invalid.\n" + e.getMessage()));
        }
    }

    private static IFile getFile(String name) {
        IFile file = fProject.getFile(name);
        CSSCodeFoldingTest.assertTrue((String)("Test file " + file + " can not be found"), (boolean)file.exists());
        return file;
    }

    private StructuredTextEditor getEditor(IFile file) {
        StructuredTextEditor editor = (StructuredTextEditor)fFileToEditorMap.get(file);
        if (editor == null) {
            try {
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = workbenchWindow.getActivePage();
                IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)"org.eclipse.wst.css.core.csssource.source", (boolean)true);
                if (editorPart instanceof StructuredTextEditor) {
                    editor = (StructuredTextEditor)editorPart;
                    this.standardizeLineEndings(editor);
                } else {
                    CSSCodeFoldingTest.fail((String)("Unable to open structured text editor: " + editorPart.getClass().getName()));
                }
                if (editor != null) {
                    fFileToEditorMap.put(file, editor);
                } else {
                    CSSCodeFoldingTest.fail((String)("Could not open viewer for " + file));
                }
            }
            catch (Exception e) {
                CSSCodeFoldingTest.fail((String)("Could not open editor for " + file + " exception: " + e.getMessage()));
            }
        }
        return editor;
    }

    private void waitForReconcileThenVerify(StructuredTextViewer viewer, List expectedPositions) throws Exception {
        IDocument doc = viewer.getDocument();
        int time = 0;
        while (doc != fReconciledDoc && time <= 4000) {
            Thread.sleep(200L);
            time += 200;
        }
        if (doc == fReconciledDoc) {
            this.verifyAnnotationPositions(viewer, expectedPositions);
        } else {
            Assert.fail((String)("Document " + viewer.getDocument() + " was not reconciled with in " + 4000 + " so gave up waiting and in turn could not validate folding anotations"));
        }
    }

    private void verifyAnnotationPositions(StructuredTextViewer viewer, List expectedPositions) throws Exception {
        ProjectionAnnotationModel projectionModel = viewer.getProjectionAnnotationModel();
        Iterator annotationIter = projectionModel.getAnnotationIterator();
        int attempts = 0;
        while (!annotationIter.hasNext() && attempts < 3) {
            ++attempts;
            annotationIter = projectionModel.getAnnotationIterator();
            Thread.sleep(500L);
        }
        ArrayList<Position> unexpectedPositions = new ArrayList<Position>();
        while (annotationIter.hasNext()) {
            ProjectionAnnotation annotation;
            Position pos;
            boolean found;
            Object obj = annotationIter.next();
            if (!(obj instanceof ProjectionAnnotation) || (found = expectedPositions.remove(pos = projectionModel.getPosition((Annotation)(annotation = (ProjectionAnnotation)obj))))) continue;
            unexpectedPositions.add(pos);
        }
        String error = "";
        if (unexpectedPositions.size() != 0) {
            error = String.valueOf(error) + "There were " + unexpectedPositions.size() + " unexpected positions that were found";
            int i = 0;
            while (i < unexpectedPositions.size()) {
                error = String.valueOf(error) + "\n\t" + unexpectedPositions.get(i);
                ++i;
            }
        }
        if (expectedPositions.size() != 0) {
            error = String.valueOf(error) + "\nThere were " + expectedPositions.size() + " expected positions that were not found";
            int i = 0;
            while (i < expectedPositions.size()) {
                error = String.valueOf(error) + "\n\t" + expectedPositions.get(i);
                ++i;
            }
        }
        if (error.length() != 0) {
            CSSCodeFoldingTest.fail((String)error);
        }
    }

    private void standardizeLineEndings(StructuredTextEditor editor) {
        IDocument doc = editor.getTextViewer().getDocument();
        String contents = doc.get();
        contents = StringUtils.replace((String)contents, (String)"\r\n", (String)"\n");
        contents = StringUtils.replace((String)contents, (String)"\r", (String)"\n");
        doc.set(contents);
    }

    public void aboutToBeReconciled() {
    }

    public void reconciled(IDocument document, IAnnotationModel model, boolean forced, IProgressMonitor progressMonitor) {
        fReconciledDoc = document;
    }

    private static class CSSCodeFoldingTestSetup
    extends TestSetup {
        private static final String WTP_AUTOTEST_NONINTERACTIVE = "wtp.autotest.noninteractive";
        private static String previousWTPAutoTestNonInteractivePropValue = null;

        public CSSCodeFoldingTestSetup(Test test) {
            super(test);
        }

        public void setUp() throws Exception {
            CSSCodeFoldingTestSetup.initializeResources();
            String noninteractive = System.getProperty(WTP_AUTOTEST_NONINTERACTIVE);
            previousWTPAutoTestNonInteractivePropValue = noninteractive != null ? noninteractive : "false";
            System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, "true");
        }

        public void tearDown() throws Exception {
            Iterator iter = fFileToEditorMap.values().iterator();
            while (iter.hasNext()) {
                StructuredTextEditor editor = (StructuredTextEditor)iter.next();
                editor.doSave(null);
                editor.close(false);
            }
            if (previousWTPAutoTestNonInteractivePropValue != null) {
                System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, previousWTPAutoTestNonInteractivePropValue);
            }
            fProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }

        private static void initializeResources() {
            fProject = ProjectUtil.createProject(CSSCodeFoldingTest.PROJECT_NAME, null, null);
            ProjectUtil.copyBundleEntriesIntoWorkspace(CSSCodeFoldingTest.PROJECT_FILES, CSSCodeFoldingTest.PROJECT_NAME);
        }
    }
}

