/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.dependency.tests.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.application.internal.operations.AddComponentToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.RemoveComponentFromEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestDataModelProvider;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.dependency.tests.util.DependencyUtil;
import org.eclipse.jst.j2ee.dependency.tests.util.ProjectUtil;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class DependencyCreationUtil {
    public static void createEARDependency(IProject earProject, IProject childProject) throws ExecutionException {
        DependencyCreationUtil.createEARDependency(earProject, childProject, false);
    }

    public static void createEARDependency(IProject earProject, IProject childProject, boolean inLibDir) throws ExecutionException {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new AddComponentToEnterpriseApplicationDataModelProvider());
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)earProject);
        IVirtualComponent childComp = ComponentCore.createComponent((IProject)childProject);
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)earComp);
        ArrayList<IVirtualComponent> depList = new ArrayList<IVirtualComponent>();
        depList.add(childComp);
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", depList);
        if (inLibDir) {
            dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)"/lib");
        } else {
            dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)"/");
            Map modDeployPathMap = (Map)dm.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH_MAP");
            modDeployPathMap.put(childComp, "/");
        }
        dm.getDefaultOperation().execute(null, null);
        ProjectUtil.waitForClasspathUpdate();
    }

    public static void removeEARDependency(IProject earProject, IProject childProject) throws ExecutionException {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new RemoveComponentFromEnterpriseApplicationDataModelProvider());
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)earProject);
        IVirtualComponent childComp = ComponentCore.createComponent((IProject)childProject);
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)earComp);
        ArrayList<IVirtualComponent> depList = new ArrayList<IVirtualComponent>();
        depList.add(childComp);
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", depList);
        dm.getDefaultOperation().execute(null, null);
        ProjectUtil.waitForClasspathUpdate();
    }

    public static void createModuleDependency(IProject source, IProject target) throws ExecutionException, CoreException, IOException {
        DependencyCreationUtil.createProjectDependency(source, target, false);
    }

    public static void createWebLibDependency(IProject source, IProject target) throws ExecutionException, CoreException, IOException {
        DependencyCreationUtil.createProjectDependency(source, target, true);
    }

    private static void createProjectDependency(IProject source, IProject target, boolean webLibDep) throws ExecutionException, CoreException, IOException {
        IVirtualComponent sourceComp = ComponentCore.createComponent((IProject)source);
        IVirtualComponent targetComp = ComponentCore.createComponent((IProject)target);
        if (webLibDep) {
            IDataModel refdm = DataModelFactory.createDataModel((IDataModelProvider)new CreateReferenceComponentsDataModelProvider());
            List targetCompList = (List)refdm.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
            targetCompList.add(targetComp);
            refdm.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)sourceComp);
            refdm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)targetCompList);
            refdm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)"/WEB-INF/lib");
            refdm.getDefaultOperation().execute(null, null);
        } else {
            IVirtualComponent dependentComp = sourceComp;
            String dependentProjName = source.getName();
            String refactoredProjName = target.getName();
            IVirtualFile vf = dependentComp.getRootFolder().getFile((IPath)new Path("META-INF/MANIFEST.MF"));
            IFile manifestmf = vf.getUnderlyingFile();
            NullProgressMonitor monitor = new NullProgressMonitor();
            IDataModel updateManifestDataModel = DataModelFactory.createDataModel((IDataModelProvider)new UpdateManifestDataModelProvider());
            updateManifestDataModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)dependentProjName);
            updateManifestDataModel.setBooleanProperty("UpdateManifestDataModel.MERGE", false);
            updateManifestDataModel.setProperty("UpdateManifestDataModel.MANIFEST_FILE", (Object)manifestmf);
            ArchiveManifest manifest = DependencyCreationUtil.getArchiveManifest(manifestmf);
            String[] cp = manifest.getClassPathTokenized();
            ArrayList<String> cpList = new ArrayList<String>();
            String newCp = String.valueOf(refactoredProjName) + ".jar";
            int i = 0;
            while (i < cp.length) {
                if (!cp[i].equals(newCp)) {
                    cpList.add(cp[i]);
                }
                ++i;
            }
            cpList.add(newCp);
            updateManifestDataModel.setProperty("UpdateManifestDataModel.CLASSPATH_LIST", cpList);
            updateManifestDataModel.getDefaultOperation().execute((IProgressMonitor)monitor, null);
        }
        ProjectUtil.waitForClasspathUpdate();
        if (webLibDep) {
            DependencyUtil.waitForComponentRefactoringJobs();
        }
    }

    public static ArchiveManifest getArchiveManifest(IFile manifestFile) throws CoreException, IOException {
        ArchiveManifestImpl archiveManifestImpl;
        block7: {
            InputStream in = null;
            try {
                ArchiveManifestImpl mf;
                in = manifestFile.getContents();
                archiveManifestImpl = mf = new ArchiveManifestImpl(new Manifest(in));
                if (in == null) break block7;
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return archiveManifestImpl;
    }
}

