/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.ejb.tests;

import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.dependency.tests.util.ProjectUtil;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.jee.model.ejb.tests.EjbAnnotationReaderTest;
import org.eclipse.jst.jee.model.internal.EJBAnnotationReader;
import org.eclipse.jst.jee.model.internal.common.AbstractAnnotationModelProvider;
import org.eclipse.jst.jee.model.tests.AbstractAnnotationModelTest;
import org.eclipse.jst.jee.model.tests.AbstractTest;
import org.eclipse.jst.jee.model.tests.TestUtils;

public class EJBAnnotationReaderWithClientTest
extends AbstractAnnotationModelTest {
    private static final String ejbProjectName = EJBAnnotationReaderWithClientTest.class.getSimpleName();
    private static final String earProjectName = String.valueOf(ejbProjectName) + "ear";
    private static final String clientName = String.valueOf(ejbProjectName) + "Client";

    public static TestSuite suite() throws Exception {
        TestSuite suite = new TestSuite(EJBAnnotationReaderWithClientTest.class);
        return suite;
    }

    public static void setUpProject() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(ejbProjectName);
        if (!project.exists()) {
            ProjectUtil.createEARProject(String.valueOf(ejbProjectName) + "ear", true);
            project = ProjectUtil.createEJBProject(ejbProjectName, earProjectName, clientName, 30, true);
            IProject clientProject = ResourcesPlugin.getWorkspace().getRoot().getProject(clientName);
            EJBAnnotationReaderWithClientTest.createProjectContent(project);
            EJBAnnotationReaderWithClientTest.createClientProjectContent(clientProject);
        }
    }

    private static void createClientProjectContent(IProject clientProject) throws Exception {
        IJavaProject javaProject = JavaCore.create((IProject)clientProject);
        IFolder comFolder = javaProject.getProject().getFolder("ejbModule/com");
        comFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        comFolder.getFolder("sap").create(true, true, null);
        IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)comFolder);
        root.createPackageFragment("sap", true, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void tearDownAfterClass() throws InterruptedException {
        AbstractTest.deleteProject(EjbAnnotationReaderTest.class.getSimpleName());
    }

    private static void createProjectContent(IProject project) throws Exception {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IFolder comFolder = javaProject.getProject().getFolder("ejbModule/com");
        comFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        comFolder.getFolder("sap").create(true, true, null);
        IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)comFolder);
        root.createPackageFragment("sap", true, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void setUp() throws Exception {
        EJBAnnotationReaderWithClientTest.setUpProject();
        super.setUp();
        this.clientProject = ResourcesPlugin.getWorkspace().getRoot().getProject(clientName);
        this.fixture = new EJBAnnotationReader(this.facetedProject, this.clientProject);
    }

    protected void tearDown() throws Exception {
        ((AbstractAnnotationModelProvider)this.fixture).dispose();
    }

    public void testLocalInterfaceInClient() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testLocalInterfaceInClient.java");
        IFile interfaceFile = this.clientProject.getProject().getFile("ejbModule/com/sap/InterfaceForAddedBean.java");
        this.saveFileAndUpdate(beanFile, "package com.sap;import javax.ejb.Stateless;@Stateless public class testLocalInterfaceInClient implements InterfaceForAddedBean {}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testLocalInterfaceInClient");
        EJBAnnotationReaderWithClientTest.assertNotNull((Object)result);
        EJBAnnotationReaderWithClientTest.assertEquals((String)"InterfaceForAddedBean", (String)((String)result.getBusinessLocals().get(0)));
        this.saveFileAndUpdate(interfaceFile, "package com.sap;public interface InterfaceForAddedBean {} ");
        result = TestUtils.getSessionBean(this.getEJBJar(), "testLocalInterfaceInClient");
        EJBAnnotationReaderWithClientTest.assertNotNull((Object)result);
        EJBAnnotationReaderWithClientTest.assertEquals((String)"com.sap.InterfaceForAddedBean", (String)((String)result.getBusinessLocals().get(0)));
        this.deleteFileAndUpdate(beanFile);
        AbstractTest.deleteFile(interfaceFile);
    }

    public void testLocalToRemoteInterfaceInClient() throws Exception {
        IFile bean1File = this.facetedProject.getProject().getFile("ejbModule/com/sap/testLocalToRemoteInterfaceInClient1.java");
        IFile bean2File = this.facetedProject.getProject().getFile("ejbModule/com/sap/testLocalToRemoteInterfaceInClient2.java");
        IFile interfaceFile = this.clientProject.getProject().getFile("ejbModule/com/sap/InterfaceForAddedBean.java");
        this.saveFileAndUpdate(bean1File, "package com.sap;import javax.ejb.Stateless;@Stateless public class testLocalToRemoteInterfaceInClient1 implements InterfaceForAddedBean {}");
        this.saveFileAndUpdate(bean2File, "package com.sap;import javax.ejb.Stateless;@Stateless public class testLocalToRemoteInterfaceInClient2 implements InterfaceForAddedBean {}");
        SessionBean result1 = TestUtils.getSessionBean(this.getEJBJar(), "testLocalToRemoteInterfaceInClient1");
        EJBAnnotationReaderWithClientTest.assertEquals((String)"InterfaceForAddedBean", (String)((String)result1.getBusinessLocals().get(0)));
        SessionBean result2 = TestUtils.getSessionBean(this.getEJBJar(), "testLocalToRemoteInterfaceInClient2");
        EJBAnnotationReaderWithClientTest.assertEquals((String)"InterfaceForAddedBean", (String)((String)result2.getBusinessLocals().get(0)));
        this.saveFileAndUpdate(interfaceFile, "package com.sap;public interface InterfaceForAddedBean {} ");
        this.saveFileAndUpdate(interfaceFile, "package com.sap;import javax.ejb.Remote@Remote public interface InterfaceForAddedBean {} ");
        result1 = TestUtils.getSessionBean(this.getEJBJar(), "testLocalToRemoteInterfaceInClient1");
        EJBAnnotationReaderWithClientTest.assertEquals((String)"com.sap.InterfaceForAddedBean", (String)((String)result1.getBusinessRemotes().get(0)));
        result2 = TestUtils.getSessionBean(this.getEJBJar(), "testLocalToRemoteInterfaceInClient2");
        EJBAnnotationReaderWithClientTest.assertEquals((String)"com.sap.InterfaceForAddedBean", (String)((String)result2.getBusinessRemotes().get(0)));
        EJBAnnotationReaderWithClientTest.assertTrue((boolean)result1.getBusinessLocals().isEmpty());
        EJBAnnotationReaderWithClientTest.assertTrue((boolean)result2.getBusinessLocals().isEmpty());
        this.deleteFileAndUpdate(bean1File);
        this.deleteFileAndUpdate(bean2File);
        EJBAnnotationReaderWithClientTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testLocalToRemoteInterfaceInClient1"));
        EJBAnnotationReaderWithClientTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testLocalToRemoteInterfaceInClient2"));
        AbstractTest.deleteFile(interfaceFile);
    }
}

