/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.ejb.tests;

import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.javaee.core.Description;
import org.eclipse.jst.javaee.core.ResAuthType;
import org.eclipse.jst.javaee.core.ResSharingScopeType;
import org.eclipse.jst.javaee.core.ResourceRef;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.jee.model.internal.EJBAnnotationReader;
import org.eclipse.jst.jee.model.internal.common.AbstractAnnotationModelProvider;
import org.eclipse.jst.jee.model.tests.AbstractAnnotationModelTest;
import org.eclipse.jst.jee.model.tests.AbstractTest;
import org.eclipse.jst.jee.model.tests.TestUtils;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;

public class ResourceReferenceTest
extends AbstractAnnotationModelTest {
    public static TestSuite suite() throws Exception {
        TestSuite suite = new TestSuite(ResourceReferenceTest.class);
        return suite;
    }

    public static void setUpProject() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(ResourceReferenceTest.class.getSimpleName());
        if (!project.exists()) {
            IFacetedProject facetedProject = AbstractTest.createEjbProject(ResourceReferenceTest.class.getSimpleName());
            ResourceReferenceTest.createProjectContent(facetedProject.getProject());
        }
    }

    private static void createProjectContent(IProject project) throws Exception {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IFolder comFolder = javaProject.getProject().getFolder("ejbModule/com");
        comFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)comFolder);
        root.createPackageFragment("sap", true, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void tearDownAfterClass() throws InterruptedException {
    }

    protected void setUp() throws Exception {
        ResourceReferenceTest.setUpProject();
        super.setUp();
        this.fixture = new EJBAnnotationReader(this.facetedProject, this.clientProject);
    }

    public void tearDown() throws Exception {
        ((AbstractAnnotationModelProvider)this.fixture).dispose();
    }

    public void testResource() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testResource.java");
        this.saveFileAndUpdate(beanFile, "package com.sap;@Stateless @Resource(name =\"withNotDefaults\", mappedName = \"mappedName\", shareable = false, type = java.lang.Comparable.class, authenticationType = AuthenticationType.CONTAINER, description = \"description\")public class testResource implements SessionBeanLocal{}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testResource");
        ResourceReferenceTest.assertNotNull((Object)result);
        ResourceRef ref = TestUtils.findResourceRefByName(result.getResourceRefs(), "withNotDefaults");
        ResourceReferenceTest.assertNotNull((Object)ref);
        ResourceReferenceTest.assertEquals((String)"description", (String)((Description)ref.getDescriptions().get(0)).getValue());
        ResourceReferenceTest.assertEquals((String)"mappedName", (String)ref.getMappedName());
        ResourceReferenceTest.assertEquals((Object)ResSharingScopeType.UNSHAREABLE_LITERAL, (Object)ref.getResSharingScope());
        ResourceReferenceTest.assertEquals((Object)ResAuthType.CONTAINER_LITERAL, (Object)ref.getResAuth());
        this.deleteFileAndUpdate(beanFile);
        ResourceReferenceTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testResource"));
    }

    public void testResourcesDefaults() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testResourcesDefaults.java");
        this.saveFileAndUpdate(beanFile, "package com.sap;@Stateless @Resource(name =\"withDefaults\", mappedName = \"mappedName\",type = java.lang.Comparable.class, description = \"description\")public class testResourcesDefaults implements SessionBeanLocal{}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testResourcesDefaults");
        ResourceReferenceTest.assertNotNull((Object)result);
        ResourceRef ref = TestUtils.findResourceRefByName(result.getResourceRefs(), "withDefaults");
        ResourceReferenceTest.assertNotNull((Object)ref);
        ResourceReferenceTest.assertEquals((String)"description", (String)((Description)ref.getDescriptions().get(0)).getValue());
        ResourceReferenceTest.assertEquals((String)"mappedName", (String)ref.getMappedName());
        ResourceReferenceTest.assertEquals((String)"java.lang.Comparable", (String)ref.getResType());
        ResourceReferenceTest.assertEquals((Object)ResSharingScopeType.SHAREABLE_LITERAL, (Object)ref.getResSharingScope());
        ResourceReferenceTest.assertEquals((Object)ResAuthType.APPLICATION_LITERAL, (Object)ref.getResAuth());
        this.deleteFileAndUpdate(beanFile);
        ResourceReferenceTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testResourcesDefaults"));
    }

    public void testResources() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testResources.java");
        this.saveFileAndUpdate(beanFile, "package com.sap;@Stateless @Resources(value = {@Resource(name = \"withNotDefaults\", mappedName = \"mappedName\", \tshareable = false, type = java.lang.Comparable.class, \tauthenticationType = AuthenticationType.APPLICATION, description = \"description\"),@Resource(name = \"withDefaults\", type = java.lang.Comparable.class), @Resource(name = \"invalidNoType\") })public class testResources implements SessionBeanLocal{}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testResources");
        ResourceReferenceTest.assertNotNull((Object)result);
        ResourceReferenceTest.assertNotNull((Object)TestUtils.findResourceRefByName(result.getResourceRefs(), "withNotDefaults"));
        ResourceReferenceTest.assertNotNull((Object)TestUtils.findResourceRefByName(result.getResourceRefs(), "withDefaults"));
        ResourceReferenceTest.assertEquals((Object)new Integer(2), (Object)new Integer(result.getResourceRefs().size()));
        this.deleteFileAndUpdate(beanFile);
        ResourceReferenceTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testResources"));
    }

    public void testResourceUnresolved() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testResourceUnresolved.java");
        this.saveFileAndUpdate(beanFile, "package com.sap;@Stateless @Resource(name =\"withNotDefaults\",type = ResourceInterface.class)public class testResourceUnresolved implements SessionBeanLocal{}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testResourceUnresolved");
        ResourceReferenceTest.assertNotNull((Object)result);
        ResourceRef ref = TestUtils.findResourceRefByName(result.getResourceRefs(), "withNotDefaults");
        ResourceReferenceTest.assertNotNull((Object)ref);
        ResourceReferenceTest.assertEquals((String)"ResourceInterface", (String)ref.getResType());
        IFile interfaceFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/ResourceInterface.java");
        this.saveFileAndUpdate(interfaceFile, "package com.sap;public interface ResourceInterface {}");
        result = TestUtils.getSessionBean(this.getEJBJar(), "testResourceUnresolved");
        ResourceReferenceTest.assertNotNull((Object)result);
        ref = TestUtils.findResourceRefByName(result.getResourceRefs(), "withNotDefaults");
        ResourceReferenceTest.assertNotNull((Object)ref);
        ResourceReferenceTest.assertEquals((String)"com.sap.ResourceInterface", (String)ref.getResType());
        this.deleteFileAndUpdate(interfaceFile);
        result = TestUtils.getSessionBean(this.getEJBJar(), "testResourceUnresolved");
        ResourceReferenceTest.assertNotNull((Object)result);
        ref = TestUtils.findResourceRefByName(result.getResourceRefs(), "withNotDefaults");
        ResourceReferenceTest.assertNotNull((Object)ref);
        ResourceReferenceTest.assertEquals((String)"ResourceInterface", (String)ref.getResType());
        this.deleteFileAndUpdate(beanFile);
        ResourceReferenceTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testResourceUnresolved"));
    }

    public void testResourceOnField() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testResourceOnField.java");
        this.saveFileAndUpdate(beanFile, "package com.sap;@Stateless public class testResourceOnField implements SessionBeanLocal{@Resource(type = java.lang.Comparable.class) private java.lang.Comparable valid;@Resource(type = java.lang.Comparable.class) private int simpleType;@Resource private java.lang.Comparable validButWithoutType;}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testResourceOnField");
        ResourceReferenceTest.assertNotNull((Object)result);
        ResourceRef ref1 = TestUtils.findResourceRefByName(result.getResourceRefs(), "com.sap.testResourceOnField/valid");
        ResourceReferenceTest.assertNotNull((Object)ref1);
        ResourceReferenceTest.assertEquals((String)"java.lang.Comparable", (String)ref1.getResType());
        ResourceRef ref2 = TestUtils.findResourceRefByName(result.getResourceRefs(), "com.sap.testResourceOnField/validButWithoutType");
        ResourceReferenceTest.assertNotNull((Object)ref2);
        ResourceReferenceTest.assertEquals((String)"java.lang.Comparable", (String)ref2.getResType());
        ResourceReferenceTest.assertEquals((Object)new Integer(2), (Object)new Integer(result.getResourceRefs().size()));
        this.deleteFileAndUpdate(beanFile);
        ResourceReferenceTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testResourceOnField"));
    }

    public void testResourceOnMethod() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testResourceOnMethod.java");
        this.saveFileAndUpdate(beanFile, "package com.sap;@Stateless public class testResourceOnMethod implements SessionBeanLocal{@Resource(type = java.lang.Comparable.class) public void validMethod(Comparable arg0){};@Resource(type = java.lang.Comparable.class) private void simpleType(int arg0) {};@Resource public void validButWithoutType(Comparable arg0){};@Resource public void twoParams(Comparable arg0, Comparable arg1} {};}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testResourceOnMethod");
        ResourceReferenceTest.assertNotNull((Object)result);
        ResourceRef ref1 = TestUtils.findResourceRefByName(result.getResourceRefs(), "com.sap.testResourceOnMethod/validMethod");
        ResourceReferenceTest.assertNotNull((Object)ref1);
        ResourceRef ref2 = TestUtils.findResourceRefByName(result.getResourceRefs(), "com.sap.testResourceOnMethod/validButWithoutType");
        ResourceReferenceTest.assertNotNull((Object)ref2);
        ResourceReferenceTest.assertEquals((Object)new Integer(2), (Object)new Integer(result.getResourceRefs().size()));
        this.deleteFileAndUpdate(beanFile);
        ResourceReferenceTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testResourceOnMethod"));
    }

    public void testResourceOnMethodAndFieldUnresolved() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testResourceOnMethodAndFieldUnresolved.java");
        this.saveFileAndUpdate(beanFile, "package com.sap;@Stateless public class testResourceOnMethodAndFieldUnresolved implements SessionBeanLocal{@Resource(type = ResourceInterface.class) public void validMethod(ResourceInterface arg0){};@Resource private ResourceInterface valid;}");
        SessionBean result = TestUtils.getSessionBean(this.getEJBJar(), "testResourceOnMethodAndFieldUnresolved");
        ResourceReferenceTest.assertNotNull((Object)result);
        ResourceRef ref1 = TestUtils.findResourceRefByName(result.getResourceRefs(), "com.sap.testResourceOnMethodAndFieldUnresolved/validMethod");
        ResourceReferenceTest.assertEquals((String)"ResourceInterface", (String)ref1.getResType());
        ResourceRef ref2 = TestUtils.findResourceRefByName(result.getResourceRefs(), "com.sap.testResourceOnMethodAndFieldUnresolved/valid");
        ResourceReferenceTest.assertEquals((String)"ResourceInterface", (String)ref2.getResType());
        IFile interfaceFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/ResourceInterface.java");
        this.saveFileAndUpdate(interfaceFile, "package com.sap;public interface ResourceInterface {}");
        result = TestUtils.getSessionBean(this.getEJBJar(), "testResourceOnMethodAndFieldUnresolved");
        ResourceReferenceTest.assertNotNull((Object)result);
        ref1 = TestUtils.findResourceRefByName(result.getResourceRefs(), "com.sap.testResourceOnMethodAndFieldUnresolved/validMethod");
        ref2 = TestUtils.findResourceRefByName(result.getResourceRefs(), "com.sap.testResourceOnMethodAndFieldUnresolved/valid");
        ResourceReferenceTest.assertEquals((String)"com.sap.ResourceInterface", (String)ref1.getResType());
        ResourceReferenceTest.assertEquals((String)"com.sap.ResourceInterface", (String)ref1.getResType());
        this.deleteFileAndUpdate(interfaceFile);
        result = TestUtils.getSessionBean(this.getEJBJar(), "testResourceOnMethodAndFieldUnresolved");
        ref1 = TestUtils.findResourceRefByName(result.getResourceRefs(), "com.sap.testResourceOnMethodAndFieldUnresolved/validMethod");
        ref2 = TestUtils.findResourceRefByName(result.getResourceRefs(), "com.sap.testResourceOnMethodAndFieldUnresolved/valid");
        ResourceReferenceTest.assertEquals((String)"ResourceInterface", (String)ref1.getResType());
        ResourceReferenceTest.assertEquals((String)"ResourceInterface", (String)ref2.getResType());
        this.deleteFileAndUpdate(beanFile);
        ResourceReferenceTest.assertNull((Object)TestUtils.getSessionBean(this.getEJBJar(), "testResourceOnMethodAndFieldUnresolved"));
    }
}

