/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.headless.tests.savestrategy;

import java.io.File;
import java.net.URL;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebComponentImportDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.tests.OperationTestCase;
import org.eclipse.wst.common.tests.ProjectUtility;
import org.eclipse.wtp.j2ee.headless.tests.plugin.HeadlessTestsPlugin;

public class ThreadingTest
extends OperationTestCase {
    public final String WEB_TESTS_PATH;

    public ThreadingTest(String name) {
        super(name);
        String relativeImportTestsPath = "TestData" + File.separator + this.getDirectory() + File.separator;
        URL fullImportTestsPath = HeadlessTestsPlugin.getDefault().find((IPath)new Path(relativeImportTestsPath));
        this.WEB_TESTS_PATH = fullImportTestsPath.getPath();
    }

    public static Test suite() {
        return new TestSuite(ThreadingTest.class);
    }

    protected String getDirectory() {
        return "WARImportTests";
    }

    protected List getImportableArchiveFileNames() {
        return ProjectUtility.getWarsInDirectory((Plugin)HeadlessTestsPlugin.getDefault(), (String)this.WEB_TESTS_PATH);
    }

    protected IDataModel getModelInstance() {
        return DataModelFactory.createDataModel((IDataModelProvider)new WebComponentImportDataModelProvider());
    }

    public void testThreading() throws Exception {
        final List projects = this.getImportableArchiveFileNames();
        final IProject[] projectArray = new IProject[projects.size()];
        int iterationCount = 0;
        while (iterationCount < 20) {
            System.out.println("Importing Projects " + iterationCount);
            int i = 0;
            while (i < projects.size()) {
                String jarName = projects.get(i).toString();
                String projectName = jarName.substring(jarName.lastIndexOf(File.separator) + 1, jarName.length() - 4);
                IDataModel dataModel = this.getModelInstance();
                dataModel.setProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", (Object)jarName);
                dataModel.setProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME", (Object)projectName);
                ThreadingTest.runDataModel((IDataModel)dataModel);
                projectArray[i] = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                ++i;
            }
            Thread[] threads = new Thread[10 + 10 * iterationCount];
            class ReadyCounter {
                private boolean kill = false;
                private boolean ready = false;
                private int count = 0;
                private int requiredCount = 0;

                public ReadyCounter(int requiredCount) {
                    this.requiredCount = requiredCount;
                }

                public synchronized void increment() {
                    if (this.ready) {
                        throw new RuntimeException();
                    }
                    ++this.count;
                    if (this.count == this.requiredCount) {
                        this.ready = true;
                    }
                }

                public synchronized void decrement() {
                    --this.count;
                }

                public int getCurrentCount() {
                    return this.count;
                }

                public synchronized boolean isReady() {
                    return this.ready || this.kill;
                }

                public synchronized boolean isZero() {
                    return this.count == 0;
                }

                public boolean isKill() {
                    return this.kill;
                }

                public void kill() {
                    System.out.println("Killing!!!!");
                    this.kill = true;
                }
            }
            final ReadyCounter readyCounter = new ReadyCounter(threads.length);
            int threadCount = 0;
            while (threadCount < threads.length) {
                final int threadNum = threadCount;
                threads[threadCount] = new Thread(new Runnable(){
                    {
                    }

                    private void kill(Exception e) {
                        e.printStackTrace();
                        readyCounter.kill();
                        ThreadingTest.sleep(1);
                    }

                    /*
                     * Exception decompiling
                     */
                    public void run() {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[DOLOOP]], but top level block is 22[UNCONDITIONALDOLOOP]
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }
                });
                ++threadCount;
            }
            System.out.println("Starting Threads " + iterationCount);
            threadCount = 0;
            while (threadCount < threads.length) {
                threads[threadCount].start();
                ++threadCount;
            }
            while (!readyCounter.isReady()) {
                System.out.println("Main Thread Waiting ---------");
                ThreadingTest.sleep(1);
            }
            ThreadingTest.sleep(1);
            System.out.println("Before Deleting Projects " + iterationCount);
            ProjectUtility.deleteAllProjects();
            System.out.println("After Deleting Projects " + iterationCount);
            while (!readyCounter.isZero()) {
                ThreadingTest.sleep(1);
            }
            if (readyCounter.isKill()) {
                ThreadingTest.fail();
            }
            ++iterationCount;
        }
    }

    private static void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

