/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.ear.operations;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import junit.framework.Test;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jst.common.internal.modulecore.ClasspathContainerVirtualComponent;
import org.eclipse.jst.j2ee.application.internal.operations.AddComponentToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.AddReferenceToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.classpath.tests.util.ClasspathDependencyTestUtil;
import org.eclipse.jst.j2ee.internal.project.facet.EARFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.facet.JavaUtilityProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.tests.OperationTestCase;
import org.eclipse.wst.common.tests.SimpleTestSuite;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wtp.j2ee.headless.tests.appclient.operations.AppClientProjectCreationOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.ejb.operations.EJBProjectCreationOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.JEEProjectCreationOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.JavaEEFacetConstants;
import org.eclipse.wtp.j2ee.headless.tests.jca.operations.JCAProjectCreationOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.web.operations.WebProjectCreationOperationTest;

public class EARProjectCreationOperationTest
extends JEEProjectCreationOperationTest {
    private static final String APP_CLIENT_PROJ_12 = "myAppClient_12";
    private static final String APP_CLIENT_PROJ_13 = "myAppClient_13";
    private static final String APP_CLIENT_PROJ_14 = "myAppClient_14";
    private static final String APP_CLIENT_PROJ_5 = "myAppClient_5";
    private static final String APP_CLIENT_PROJ_6 = "myAppClient_6";
    private static final String EJB_PROJ_11 = "myEJB_11";
    private static final String EJB_PROJ_2 = "myEJB_2";
    private static final String EJB_PROJ_21 = "myEJB_21";
    private static final String EJB_PROJ_3 = "myEJB_3";
    private static final String EJB_PROJ_31 = "myEJB_31";
    private static final String WEB_PROJ_22 = "myWeb_22";
    private static final String WEB_PROJ_23 = "myWeb_23";
    private static final String WEB_PROJ_24 = "myWeb_24";
    private static final String WEB_PROJ_25 = "myWeb_25";
    private static final String WEB_PROJ_30 = "myWeb_30";
    private static final String CONNECTOR_PROJ_1 = "myConnector_1";
    private static final String CONNECTOR_PROJ_15 = "myConnector_15";

    public EARProjectCreationOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new SimpleTestSuite(EARProjectCreationOperationTest.class);
    }

    public void testEAR12_Defaults() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("aEAR", null, null, null, JavaEEFacetConstants.EAR_12, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR13_Defaults() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("bEAR", null, null, null, JavaEEFacetConstants.EAR_13, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR14_Defaults() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("cEAR", null, null, null, JavaEEFacetConstants.EAR_14, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR50_Defaults() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("dEAR", null, null, null, JavaEEFacetConstants.EAR_5, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR60_Defaults() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("eeEAR", null, null, null, JavaEEFacetConstants.EAR_6, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR12_ChangedContentDir() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("eEAR", "whosContent", null, null, JavaEEFacetConstants.EAR_12, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR13_ChangedContentDir() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("fEAR", "myContent", null, null, JavaEEFacetConstants.EAR_13, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR14_ChangedContentDir() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("gEAR", "yourContent", null, null, JavaEEFacetConstants.EAR_14, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR50_ChangedContentDir() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("hEAR", "ourContent", null, null, JavaEEFacetConstants.EAR_5, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR60_ChangedContentDir() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("iEAR", "herContent", null, null, JavaEEFacetConstants.EAR_6, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR12_WithDependencies() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("zEAR", null, EARProjectCreationOperationTest.getJ2EEDependencyList_12(), EARProjectCreationOperationTest.getJavaDependencyList_12(), JavaEEFacetConstants.EAR_12, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR13_WithDependencies() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("yEAR", null, EARProjectCreationOperationTest.getJ2EEDependencyList_13(), EARProjectCreationOperationTest.getJavaDependencyList_13(), JavaEEFacetConstants.EAR_13, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR14_WithDependencies() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("xEAR", null, EARProjectCreationOperationTest.getJ2EEDependencyList_14(), EARProjectCreationOperationTest.getJavaDependencyList_14(), JavaEEFacetConstants.EAR_14, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR50_WithDependencies() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("wEAR", null, EARProjectCreationOperationTest.getJ2EEDependencyList_5(), EARProjectCreationOperationTest.getJavaDependencyList_5(), JavaEEFacetConstants.EAR_5, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR60_WithDependencies() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("whyEAR", null, EARProjectCreationOperationTest.getJ2EEDependencyList_6(), EARProjectCreationOperationTest.getJavaDependencyList_6(), JavaEEFacetConstants.EAR_6, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR12_ChangedContentDir_WithDependencies() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("zEAR", "myContent", EARProjectCreationOperationTest.getJ2EEDependencyList_12(), EARProjectCreationOperationTest.getJavaDependencyList_12(), JavaEEFacetConstants.EAR_12, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR13_ChangedContentDir_WithDependencies() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("yEAR", "ourContent", EARProjectCreationOperationTest.getJ2EEDependencyList_13(), EARProjectCreationOperationTest.getJavaDependencyList_13(), JavaEEFacetConstants.EAR_13, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR14_ChangedContentDir_WithDependencies() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("xEAR", "theirContent", EARProjectCreationOperationTest.getJ2EEDependencyList_14(), EARProjectCreationOperationTest.getJavaDependencyList_14(), JavaEEFacetConstants.EAR_14, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR50_ChangedContentDir_WithDependencies() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("wEAR", "yourContent", EARProjectCreationOperationTest.getJ2EEDependencyList_5(), EARProjectCreationOperationTest.getJavaDependencyList_5(), JavaEEFacetConstants.EAR_5, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR60_ChangedContentDir_WithDependencies() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("xyzEAR", "hisContent", EARProjectCreationOperationTest.getJ2EEDependencyList_6(), EARProjectCreationOperationTest.getJavaDependencyList_6(), JavaEEFacetConstants.EAR_6, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR50_Defaults_WithDD() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("myEAR", null, null, null, JavaEEFacetConstants.EAR_5, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR60_Defaults_WithDD() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("mineEAR", null, null, null, JavaEEFacetConstants.EAR_6, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR50_ChangedContentDir_WithDD() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("yourEAR", "ourContent", null, null, JavaEEFacetConstants.EAR_5, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testEAR60_ChangedContentDir_WithDD() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("thatEAR", "thatContent", null, null, JavaEEFacetConstants.EAR_6, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public static IDataModel getEARDataModel(String projName, String contentDir, List dependenciesJ2EE, List dependenciesJava, IProjectFacetVersion version, boolean createDD) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new EARFacetProjectCreationDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap factMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = (IDataModel)factMap.get((Object)"jst.ear");
        facetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)version);
        if (contentDir != null) {
            facetModel.setStringProperty("IEarFacetInstallDataModelProperties.CONTENT_DIR", contentDir);
        }
        if (dependenciesJ2EE != null) {
            facetModel.setProperty("IEarFacetInstallDataModelProperties.J2EE_PROJECTS_LIST", (Object)dependenciesJ2EE);
        }
        if (dependenciesJava != null) {
            facetModel.setProperty("IEarFacetInstallDataModelProperties.JAVA_PROJECT_LIST", (Object)dependenciesJava);
        }
        facetModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", createDD);
        return dm;
    }

    public static List getJ2EEDependencyList_12() throws Exception {
        ArrayList<IProject> dependencies = new ArrayList<IProject>();
        ArrayList<IDataModel> models = new ArrayList<IDataModel>();
        models.add(AppClientProjectCreationOperationTest.getAppClientCreationDataModel(APP_CLIENT_PROJ_12, null, JavaEEFacetConstants.APP_CLIENT_12, true, true));
        models.add(EJBProjectCreationOperationTest.getEJBDataModel(EJB_PROJ_11, null, null, null, JavaEEFacetConstants.EJB_11, true));
        models.add(WebProjectCreationOperationTest.getWebDataModel(WEB_PROJ_22, null, null, null, null, JavaEEFacetConstants.WEB_22, true));
        int i = 0;
        while (i < models.size()) {
            OperationTestCase.runDataModel((IDataModel)((IDataModel)models.get(i)));
            ++i;
        }
        dependencies.addAll(Arrays.asList(JavaEEProjectUtilities.getAllProjects()));
        return dependencies;
    }

    public static List getJavaDependencyList_12() {
        return Collections.emptyList();
    }

    public static List getJ2EEDependencyList_13() throws Exception {
        EARProjectCreationOperationTest.getJ2EEDependencyList_12();
        ArrayList<IProject> dependencies = new ArrayList<IProject>();
        ArrayList<IDataModel> models = new ArrayList<IDataModel>();
        models.add(AppClientProjectCreationOperationTest.getAppClientCreationDataModel(APP_CLIENT_PROJ_13, null, JavaEEFacetConstants.APP_CLIENT_13, true, true));
        models.add(EJBProjectCreationOperationTest.getEJBDataModel(EJB_PROJ_2, null, null, null, JavaEEFacetConstants.EJB_2, true));
        models.add(WebProjectCreationOperationTest.getWebDataModel(WEB_PROJ_23, null, null, null, null, JavaEEFacetConstants.WEB_23, true));
        models.add(JCAProjectCreationOperationTest.getConnectorDataModel(CONNECTOR_PROJ_1, null, null, JavaEEFacetConstants.CONNECTOR_1));
        int i = 0;
        while (i < models.size()) {
            OperationTestCase.runDataModel((IDataModel)((IDataModel)models.get(i)));
            ++i;
        }
        dependencies.addAll(Arrays.asList(JavaEEProjectUtilities.getAllProjects()));
        return dependencies;
    }

    public static List getJavaDependencyList_13() {
        return Collections.emptyList();
    }

    public static List getJ2EEDependencyList_14() throws Exception {
        EARProjectCreationOperationTest.getJ2EEDependencyList_13();
        ArrayList<IProject> dependencies = new ArrayList<IProject>();
        ArrayList<IDataModel> models = new ArrayList<IDataModel>();
        models.add(AppClientProjectCreationOperationTest.getAppClientCreationDataModel(APP_CLIENT_PROJ_14, null, JavaEEFacetConstants.APP_CLIENT_14, true, true));
        models.add(EJBProjectCreationOperationTest.getEJBDataModel(EJB_PROJ_21, null, null, null, JavaEEFacetConstants.EJB_21, true));
        models.add(WebProjectCreationOperationTest.getWebDataModel(WEB_PROJ_24, null, null, null, null, JavaEEFacetConstants.WEB_24, true));
        int i = 0;
        while (i < models.size()) {
            OperationTestCase.runDataModel((IDataModel)((IDataModel)models.get(i)));
            ++i;
        }
        dependencies.addAll(Arrays.asList(JavaEEProjectUtilities.getAllProjects()));
        return dependencies;
    }

    public static List getJavaDependencyList_14() {
        return Collections.emptyList();
    }

    public static List getJ2EEDependencyList_5() throws Exception {
        EARProjectCreationOperationTest.getJ2EEDependencyList_14();
        ArrayList<IProject> dependencies = new ArrayList<IProject>();
        ArrayList<IDataModel> models = new ArrayList<IDataModel>();
        models.add(AppClientProjectCreationOperationTest.getAppClientCreationDataModel(APP_CLIENT_PROJ_5, null, JavaEEFacetConstants.APP_CLIENT_5, true, false));
        models.add(AppClientProjectCreationOperationTest.getAppClientCreationDataModel("myAppClient_5_WithDD", null, JavaEEFacetConstants.APP_CLIENT_5, true, true));
        models.add(EJBProjectCreationOperationTest.getEJBDataModel(EJB_PROJ_3, null, null, null, JavaEEFacetConstants.EJB_3, false));
        models.add(EJBProjectCreationOperationTest.getEJBDataModel("myEJB_3_WithDD", null, null, null, JavaEEFacetConstants.EJB_3, true));
        models.add(WebProjectCreationOperationTest.getWebDataModel(WEB_PROJ_25, null, null, null, null, JavaEEFacetConstants.WEB_25, false));
        models.add(WebProjectCreationOperationTest.getWebDataModel("myWeb_25_WithDD", null, null, null, null, JavaEEFacetConstants.WEB_25, true));
        int i = 0;
        while (i < models.size()) {
            OperationTestCase.runDataModel((IDataModel)((IDataModel)models.get(i)));
            ++i;
        }
        dependencies.addAll(Arrays.asList(JavaEEProjectUtilities.getAllProjects()));
        return dependencies;
    }

    public static List getJavaDependencyList_5() {
        return Collections.emptyList();
    }

    public static List getJ2EEDependencyList_6() throws Exception {
        EARProjectCreationOperationTest.getJ2EEDependencyList_5();
        ArrayList<IProject> dependencies = new ArrayList<IProject>();
        ArrayList<IDataModel> models = new ArrayList<IDataModel>();
        models.add(AppClientProjectCreationOperationTest.getAppClientCreationDataModel(APP_CLIENT_PROJ_6, null, JavaEEFacetConstants.APP_CLIENT_6, true, false));
        models.add(AppClientProjectCreationOperationTest.getAppClientCreationDataModel("myAppClient_6_WithDD", null, JavaEEFacetConstants.APP_CLIENT_6, true, true));
        models.add(EJBProjectCreationOperationTest.getEJBDataModel(EJB_PROJ_31, null, null, null, JavaEEFacetConstants.EJB_31, false));
        models.add(EJBProjectCreationOperationTest.getEJBDataModel("myEJB_31_WithDD", null, null, null, JavaEEFacetConstants.EJB_31, true));
        models.add(WebProjectCreationOperationTest.getWebDataModel(WEB_PROJ_30, null, null, null, null, JavaEEFacetConstants.WEB_30, false));
        models.add(WebProjectCreationOperationTest.getWebDataModel("myWeb_30_WithDD", null, null, null, null, JavaEEFacetConstants.WEB_30, true));
        int i = 0;
        while (i < models.size()) {
            OperationTestCase.runDataModel((IDataModel)((IDataModel)models.get(i)));
            ++i;
        }
        dependencies.addAll(Arrays.asList(JavaEEProjectUtilities.getAllProjects()));
        return dependencies;
    }

    public static List getJavaDependencyList_6() {
        return Collections.emptyList();
    }

    public void testEAR50_WithVariableReference() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("pEAR", "ourContent", null, null, JavaEEFacetConstants.EAR_5, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject("pEAR");
        if (p != null && p.exists()) {
            try {
                IVirtualComponent vc = ComponentCore.createComponent((IProject)p);
                this.addArchiveComponent(vc);
                IModule module = ServerUtil.getModule((IProject)p);
                EARProjectCreationOperationTest.assertNotNull((Object)module);
                ModuleDelegate md = (ModuleDelegate)module.loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
                IModuleResource[] resources = md.members();
                EARProjectCreationOperationTest.assertEquals((int)1, (int)resources.length);
                EARProjectCreationOperationTest.assertEquals((int)1, (int)((IModuleFolder)resources[0]).members().length);
                EARProjectCreationOperationTest.assertTrue((boolean)(((IModuleFolder)resources[0]).members()[0] instanceof IModuleFile));
                IModuleFile junitjar = (IModuleFile)((IModuleFolder)resources[0]).members()[0];
                EARProjectCreationOperationTest.assertEquals((String)"junit.jar", (String)junitjar.getName());
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
        }
    }

    public void testEAR50_NestedUtil_WithVariableReference() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("zEAR", "zContent", null, null, JavaEEFacetConstants.EAR_5, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
        ResourcesPlugin.getWorkspace().getRoot().getProject("zEAR");
        IDataModel dm2 = EARProjectCreationOperationTest.getUtilityProjectCreationDataModel("nestedUtil", "zEAR");
        OperationTestCase.runAndVerify((IDataModel)dm2);
        IProject utilProj = ResourcesPlugin.getWorkspace().getRoot().getProject("nestedUtil");
        IVirtualComponent vc = ComponentCore.createComponent((IProject)utilProj);
        this.addArchiveComponent(vc);
        IModule module = ServerUtil.getModule((IProject)utilProj);
        EARProjectCreationOperationTest.assertNotNull((Object)module);
        ModuleDelegate md = (ModuleDelegate)module.loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
        IModuleResource[] resources = md.members();
        IModuleResource lib = null;
        int i = 0;
        while (i < resources.length) {
            if (resources[i].getName().equals("lib")) {
                lib = resources[i];
                break;
            }
            ++i;
        }
        EARProjectCreationOperationTest.assertNotNull(lib);
        EARProjectCreationOperationTest.assertTrue((boolean)(lib instanceof IModuleFolder));
        IModuleResource[] libs = ((IModuleFolder)lib).members();
        EARProjectCreationOperationTest.assertNotNull((Object)libs);
        EARProjectCreationOperationTest.assertTrue((libs.length == 1 ? 1 : 0) != 0);
        EARProjectCreationOperationTest.assertTrue((boolean)(libs[0] instanceof IModuleFile));
        IModuleFile junitjar = (IModuleFile)libs[0];
        EARProjectCreationOperationTest.assertEquals((String)"junit.jar", (String)junitjar.getName());
    }

    public static IDataModel getUtilityProjectCreationDataModel(String projName, String earName) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new JavaUtilityProjectCreationDataModelProvider());
        dm.setProperty("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME", (Object)projName);
        dm.setProperty("IJavaUtilityProjectCreationDataModelProperties.SOURCE_FOLDER", (Object)"src");
        if (earName != null) {
            dm.setProperty("IJavaUtilityProjectCreationDataModelProperties.EAR_PROJECT_NAME", (Object)earName);
        }
        return dm;
    }

    public void testEAR_HardDeploymentMapping() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("hardEAR", "ourContent", null, null, JavaEEFacetConstants.EAR_5, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject("hardEAR");
        IFolder f = p.getFolder("test");
        f.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        IFile file = f.getFile("silly.txt");
        file.create((InputStream)new ByteArrayInputStream("Silly String".getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)p);
        IVirtualFolder rootFolder = earComp.getRootFolder();
        IVirtualFile vfile = rootFolder.getFile((IPath)new Path("out/notsilly.txt"));
        vfile.createLink((IPath)new Path("test/silly.txt"), 0, (IProgressMonitor)new NullProgressMonitor());
        IModule module = ServerUtil.getModule((IProject)p);
        EARProjectCreationOperationTest.assertNotNull((Object)module);
        ModuleDelegate md = (ModuleDelegate)module.loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
        IModuleResource[] resources = md.members();
        EARProjectCreationOperationTest.assertTrue((resources.length == 1 ? 1 : 0) != 0);
        EARProjectCreationOperationTest.assertTrue((boolean)resources[0].getName().equals("out"));
        IModuleFolder mf = (IModuleFolder)resources[0];
        IModuleResource[] children = mf.members();
        EARProjectCreationOperationTest.assertTrue((children.length == 1 ? 1 : 0) != 0);
        EARProjectCreationOperationTest.assertTrue((boolean)children[0].getName().equals("notsilly.txt"));
    }

    public void testEARWithJarInLibFolder() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("qEAR", "ourContent", null, null, JavaEEFacetConstants.EAR_5, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject("qEAR");
        IFolder folder = p.getFolder("ourContent/lib");
        folder.create(true, true, null);
        IFile file = folder.getFile("test1.jar");
        file.create((InputStream)new FileInputStream(ClasspathDependencyTestUtil.TEST1_JAR_PATH.toFile()), 0, (IProgressMonitor)new NullProgressMonitor());
        IModule module = ServerUtil.getModule((IProject)p);
        ModuleDelegate md = (ModuleDelegate)module.loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
        IModuleResource[] resources = md.members();
        EARProjectCreationOperationTest.assertEquals((int)1, (int)resources.length);
        EARProjectCreationOperationTest.assertEquals((String)"lib", (String)resources[0].getName());
        EARProjectCreationOperationTest.assertTrue((boolean)(resources[0] instanceof IModuleFolder));
        IModuleResource[] children = ((IModuleFolder)resources[0]).members();
        EARProjectCreationOperationTest.assertEquals((int)1, (int)children.length);
        EARProjectCreationOperationTest.assertEquals((String)"test1.jar", (String)children[0].getName());
    }

    public void testEARWithClasspathContainerReference() throws Exception {
        JavaCore.getClasspathContainerInitializer((String)"org.eclipse.jdt.USER_LIBRARY");
        Path path = new Path("JUNIT_HOME/junit.jar");
        IPath resolvedPath = JavaCore.getResolvedVariablePath((IPath)path);
        IClasspathEntry junitEntry = JavaCore.newLibraryEntry((IPath)resolvedPath, null, null);
        JavaModelManager.getUserLibraryManager().setUserLibrary("a999", new IClasspathEntry[]{junitEntry}, false);
        String containerPath = "org.eclipse.jdt.USER_LIBRARY/a999";
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("rEAR", "ourContent", null, null, JavaEEFacetConstants.EAR_5, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
        IProject rootProj = ResourcesPlugin.getWorkspace().getRoot().getProject("rEAR");
        final IVirtualComponent rootComp = ComponentCore.createComponent((IProject)rootProj);
        ClasspathContainerVirtualComponent classpathContainerComp = new ClasspathContainerVirtualComponent(rootProj, rootComp, containerPath);
        final VirtualReference ref = new VirtualReference(rootComp, (IVirtualComponent)classpathContainerComp, new Path("/testFolder").makeAbsolute());
        ref.setDependencyType(1);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                AddReferenceToEnterpriseApplicationDataModelProvider provider = new AddReferenceToEnterpriseApplicationDataModelProvider();
                IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)provider);
                dm.setProperty("IAddReferenceDataModelProperties.SOURCE_COMPONENT", (Object)rootComp);
                dm.setProperty("IAddReferenceDataModelProperties.TARGET_REFERENCE_LIST", Arrays.asList(ref));
                IStatus stat = dm.validateProperty("IAddReferenceDataModelProperties.TARGET_REFERENCE_LIST");
                if (!stat.isOK()) {
                    throw new CoreException(stat);
                }
                try {
                    dm.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    throw new CoreException((IStatus)new Status(4, "blah", "error", (Throwable)e));
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
            EARProjectCreationOperationTest.fail();
        }
        IModule module = ServerUtil.getModule((IProject)rootProj);
        ModuleDelegate delegate = (ModuleDelegate)module.loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
        IModuleResource[] resources = delegate.members();
        EARProjectCreationOperationTest.assertTrue((resources.length == 1 ? 1 : 0) != 0);
        EARProjectCreationOperationTest.assertTrue((boolean)(resources[0] instanceof IModuleFolder));
        EARProjectCreationOperationTest.assertTrue((boolean)resources[0].getName().equals("testFolder"));
        EARProjectCreationOperationTest.assertTrue((((IModuleFolder)resources[0]).members().length == 1 ? 1 : 0) != 0);
        EARProjectCreationOperationTest.assertTrue((boolean)(((IModuleFolder)resources[0]).members()[0] instanceof IModuleFile));
        EARProjectCreationOperationTest.assertTrue((boolean)((IModuleFolder)resources[0]).members()[0].getName().equals("junit.jar"));
    }

    public void addArchiveComponent(IVirtualComponent component) throws CoreException {
        Path path = new Path("JUNIT_HOME/junit.jar");
        JavaCore.getResolvedVariablePath((IPath)path);
        String type = "var/";
        IVirtualComponent archive = ComponentCore.createArchiveComponent((IProject)component.getProject(), (String)(String.valueOf(type) + path.toString()));
        AddComponentToEnterpriseApplicationDataModelProvider provider = new AddComponentToEnterpriseApplicationDataModelProvider();
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)provider);
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)component);
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", Arrays.asList(archive));
        HashMap<IVirtualComponent, String> uriMap = new HashMap<IVirtualComponent, String>();
        uriMap.put(archive, "junit.jar");
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP", uriMap);
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)"/lib");
        IStatus stat = dm.validateProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        if (!stat.isOK()) {
            throw new CoreException(stat);
        }
        try {
            dm.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "test", e.getMessage()));
        }
    }
}

