/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.j2ee.operations;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.wst.common.tests.AssertWarn;
import org.eclipse.wst.common.tests.BaseTestCase;
import org.eclipse.wst.common.tests.ProjectUtility;
import org.eclipse.wtp.j2ee.headless.tests.plugin.HeadlessTestsPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderParserTests
extends BaseTestCase {
    private static final String DATA_DIR = "TestData" + File.separatorChar + "headerParserTestData" + File.separatorChar;

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(HeaderParserTests.class);
        return suite;
    }

    protected String getDataPath(String shortName) throws Exception {
        HeadlessTestsPlugin plugin = HeadlessTestsPlugin.getDefault();
        String pluginRelativeFileName = String.valueOf(DATA_DIR) + File.separatorChar + shortName;
        return ProjectUtility.getFullFileName((Plugin)plugin, (String)pluginRelativeFileName);
    }

    public void testNull() throws Exception {
        JavaEEQuickPeek quickPeek = new JavaEEQuickPeek(null);
        Assert.assertEquals((int)-1, (int)quickPeek.getType());
        Assert.assertEquals((int)-1, (int)quickPeek.getVersion());
        Assert.assertEquals((int)-1, (int)quickPeek.getJavaEEVersion());
    }

    public void testJavaEEFromArchive() throws Exception {
        ArrayList<TestData> data = new ArrayList<TestData>();
        data.add(new TestData("application-client12.jar", 3, 12, 12, ApplicationClient.class));
        data.add(new TestData("application-client13.jar", 3, 13, 13, ApplicationClient.class));
        data.add(new TestData("application-client14.jar", 3, 14, 14, ApplicationClient.class));
        data.add(new TestData("application-client5.jar", 3, 50, 50, org.eclipse.jst.javaee.applicationclient.ApplicationClient.class));
        data.add(new TestData("application12.ear", 1, 12, 12, Application.class));
        data.add(new TestData("application13.ear", 1, 13, 13, Application.class));
        data.add(new TestData("application14.ear", 1, 14, 14, Application.class));
        data.add(new TestData("application5.ear", 1, 50, 50, org.eclipse.jst.javaee.application.Application.class));
        data.add(new TestData("ejb-jar11.jar", 0, 11, 12, org.eclipse.jst.j2ee.ejb.EJBJar.class));
        data.add(new TestData("ejb-jar20.jar", 0, 20, 13, org.eclipse.jst.j2ee.ejb.EJBJar.class));
        data.add(new TestData("ejb-jar21.jar", 0, 21, 14, org.eclipse.jst.j2ee.ejb.EJBJar.class));
        data.add(new TestData("ejb-jar30.jar", 0, 30, 50, EJBJar.class));
        data.add(new TestData("ra10.rar", 2, 10, 13, Connector.class));
        data.add(new TestData("ra15.rar", 2, 15, 14, Connector.class));
        data.add(new TestData("web22.war", 4, 22, 12, org.eclipse.jst.j2ee.webapplication.WebApp.class));
        data.add(new TestData("web23.war", 4, 23, 13, org.eclipse.jst.j2ee.webapplication.WebApp.class));
        data.add(new TestData("web24.war", 4, 24, 14, org.eclipse.jst.j2ee.webapplication.WebApp.class));
        data.add(new TestData("web25.war", 4, 25, 50, WebApp.class));
        IArchive archive = null;
        int i = 0;
        while (i < data.size()) {
            try {
                TestData testData = (TestData)data.get(i);
                String fileLocation = this.getDataPath(testData.fileName);
                Path filePath = new Path(fileLocation);
                archive = JavaEEArchiveUtilities.INSTANCE.openArchive((IPath)filePath);
                JavaEEQuickPeek peek = JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(archive);
                Assert.assertEquals((int)testData.type, (int)peek.getType());
                Assert.assertEquals((int)testData.modVersion, (int)peek.getVersion());
                Assert.assertEquals((int)testData.eeVersion, (int)peek.getJavaEEVersion());
                Object modelObject = archive.getModelObject();
                Class<?> clazz = modelObject.getClass();
                boolean foundInterface = false;
                Class<?>[] classArray = clazz.getInterfaces();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> anInterface = classArray[n2];
                    if (!foundInterface) {
                        foundInterface = anInterface == testData.modelObjectInterface;
                    }
                    ++n2;
                }
                Assert.assertTrue((String)("Returned Model Object: " + modelObject.getClass().getName() + " does not implement " + testData.modelObjectInterface.getName()), (boolean)foundInterface);
            }
            catch (Throwable throwable) {
                if (archive != null) {
                    JavaEEArchiveUtilities.INSTANCE.closeArchive(archive);
                }
                throw throwable;
            }
            if (archive != null) {
                JavaEEArchiveUtilities.INSTANCE.closeArchive(archive);
            }
            ++i;
        }
    }

    public void testJavaEE() throws Exception {
        List data = this.getXMLData();
        InputStream in = null;
        int i = 0;
        while (i < data.size()) {
            try {
                TestData testData = (TestData)data.get(i);
                in = new FileInputStream(new File(this.getDataPath(testData.fileName)));
                JavaEEQuickPeek peek = new JavaEEQuickPeek(in);
                Assert.assertEquals((int)testData.type, (int)peek.getType());
                Assert.assertEquals((int)testData.modVersion, (int)peek.getVersion());
                Assert.assertEquals((int)testData.eeVersion, (int)peek.getJavaEEVersion());
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            ++i;
        }
    }

    private List getXMLData() {
        ArrayList<TestData> data = new ArrayList<TestData>();
        data.add(new TestData("application-client12.xml", 3, 12, 12));
        data.add(new TestData("application-client13.xml", 3, 13, 13));
        data.add(new TestData("application-client14.xml", 3, 14, 14));
        data.add(new TestData("application-client5.xml", 3, 50, 50));
        data.add(new TestData("application12.xml", 1, 12, 12));
        data.add(new TestData("application13.xml", 1, 13, 13));
        data.add(new TestData("application14.xml", 1, 14, 14));
        data.add(new TestData("application5.xml", 1, 50, 50));
        data.add(new TestData("ejb-jar11.xml", 0, 11, 12));
        data.add(new TestData("ejb-jar20.xml", 0, 20, 13));
        data.add(new TestData("ejb-jar21.xml", 0, 21, 14));
        data.add(new TestData("ejb-jar30.xml", 0, 30, 50));
        data.add(new TestData("ra10.xml", 2, 10, 13));
        data.add(new TestData("ra15.xml", 2, 15, 14));
        data.add(new TestData("web22.xml", 4, 22, 12));
        data.add(new TestData("web23.xml", 4, 23, 13));
        data.add(new TestData("web24.xml", 4, 24, 14));
        data.add(new TestData("web25.xml", 4, 25, 50));
        data.add(new TestData("notxml.xml", -1, -1, -1));
        data.add(new TestData("notjavaee.xml", -1, -1, -1));
        data.add(new TestData("application-client0.xml", 3, -1, -1));
        data.add(new TestData("application-client00.xml", 3, -1, -1));
        data.add(new TestData("application-client000.xml", 3, -1, -1));
        data.add(new TestData("application0.xml", 1, -1, -1));
        data.add(new TestData("application00.xml", 1, -1, -1));
        data.add(new TestData("application000.xml", 1, -1, -1));
        data.add(new TestData("ejb-jar0.xml", 0, -1, -1));
        data.add(new TestData("ejb-jar00.xml", 0, -1, -1));
        data.add(new TestData("ejb-jar000.xml", 0, -1, -1));
        data.add(new TestData("ra0.xml", 2, -1, -1));
        data.add(new TestData("ra00.xml", 2, -1, -1));
        data.add(new TestData("ra000.xml", 2, -1, -1));
        data.add(new TestData("web0.xml", 4, -1, -1));
        data.add(new TestData("web00.xml", 4, -1, -1));
        data.add(new TestData("web000.xml", 4, -1, -1));
        return data;
    }

    public void testNormalizeSchemaLocation() throws Exception {
        this.verifyNormalizeSchemaLocation("", "");
        this.verifyNormalizeSchemaLocation("", " ");
        this.verifyNormalizeSchemaLocation("", "  ");
        this.verifyNormalizeSchemaLocation("", "   ");
        this.verifyNormalizeSchemaLocation("", "\n");
        this.verifyNormalizeSchemaLocation("", "\n\n");
        this.verifyNormalizeSchemaLocation("", "\n\n\n");
        this.verifyNormalizeSchemaLocation("", "\n ");
        this.verifyNormalizeSchemaLocation("simple", "simple");
        this.verifyNormalizeSchemaLocation("simple", "simple ");
        this.verifyNormalizeSchemaLocation("simple", "simple  ");
        this.verifyNormalizeSchemaLocation("simple", "simple   ");
        this.verifyNormalizeSchemaLocation("simple", " simple");
        this.verifyNormalizeSchemaLocation("simple", "   simple   ");
        this.verifyNormalizeSchemaLocation("simple", "simple\n");
        this.verifyNormalizeSchemaLocation("simple", "\nsimple\n");
        this.verifyNormalizeSchemaLocation("simple", "simple\r");
        this.verifyNormalizeSchemaLocation("simple", "simple\t");
        this.verifyNormalizeSchemaLocation("simple", "simple\n\n");
        this.verifyNormalizeSchemaLocation("simple", "simple\n\r");
        this.verifyNormalizeSchemaLocation("simple", "simple\n\t");
        this.verifyNormalizeSchemaLocation("simple", "simple \n");
        this.verifyNormalizeSchemaLocation("simple", "simple\r ");
        this.verifyNormalizeSchemaLocation("simple", " \t\tsimple\t");
        this.verifyNormalizeSchemaLocation("simple", "simple\n \n");
        this.verifyNormalizeSchemaLocation("simple", "\r \rsimple \n\r");
        this.verifyNormalizeSchemaLocation("simple", " simple\n\t");
        this.verifyNormalizeSchemaLocation("simple simple", "simple simple");
        this.verifyNormalizeSchemaLocation("simple simple", "simple  simple");
        this.verifyNormalizeSchemaLocation("simple simple", "simple\nsimple");
        this.verifyNormalizeSchemaLocation("simple simple", "simple\rsimple");
        this.verifyNormalizeSchemaLocation("simple simple", "simple\tsimple");
        this.verifyNormalizeSchemaLocation("simple simple", "simple  \nsimple");
        this.verifyNormalizeSchemaLocation("simple simple", "simple\r  simple");
        this.verifyNormalizeSchemaLocation("simple simple", "simple          \t        simple");
        this.verifyNormalizeSchemaLocation("simple simple", "simple simple ");
        this.verifyNormalizeSchemaLocation("simple simple", " simple  simple");
        this.verifyNormalizeSchemaLocation("simple simple", "   simple      simple   ");
        this.verifyNormalizeSchemaLocation("simple simple", "simple\n simple\n");
        this.verifyNormalizeSchemaLocation("simple simple", "simple\r simple\r");
        this.verifyNormalizeSchemaLocation("simple simple", "simple\t simple\t");
        this.verifyNormalizeSchemaLocation("simple simple", "simple\n\nsimple");
        this.verifyNormalizeSchemaLocation("simple simple", "simple\n\rsimple\n\n");
        this.verifyNormalizeSchemaLocation("simple simple", "simple\n\tsimple\n\t");
        this.verifyNormalizeSchemaLocation("simple simple", "simple \nsimple \n");
        this.verifyNormalizeSchemaLocation("simple simple", "simple\r simple\r ");
        this.verifyNormalizeSchemaLocation("simple simple", " \t\tsimple\t \t\tsimple\t");
        this.verifyNormalizeSchemaLocation("simple simple", "simple\n \nsimple\n \n");
        this.verifyNormalizeSchemaLocation("simple simple", "\r \rsimple \n\r\r \rsimple \n\r");
        this.verifyNormalizeSchemaLocation("simple simple", " simple\n\t simple\n\t");
    }

    private String verifyNormalizeSchemaLocation(String normalizedSchemaLocation, String someSchemaLocation) {
        String normalizedString = JavaEEQuickPeek.normalizeSchemaLocation((String)someSchemaLocation);
        if (!normalizedSchemaLocation.equals(normalizedString)) {
            Assert.assertEquals((String)normalizedSchemaLocation, (String)normalizedString);
        }
        return normalizedString;
    }

    public void testEAR50Import_NoDD() throws Exception {
        ArrayList<TestData> nestedArchiveData = new ArrayList<TestData>();
        nestedArchiveData.add(new TestData("application-client12.jar", 3, 12, 12, ApplicationClient.class));
        nestedArchiveData.add(new TestData("application-client13.jar", 3, 13, 13, ApplicationClient.class));
        nestedArchiveData.add(new TestData("application-client14.jar", 3, 14, 14, ApplicationClient.class));
        nestedArchiveData.add(new TestData("AppClient5_NoDD.jar", 3, 50, 50, org.eclipse.jst.javaee.applicationclient.ApplicationClient.class));
        nestedArchiveData.add(new TestData("AppClient5_WithDD.jar", 3, 50, 50, org.eclipse.jst.javaee.applicationclient.ApplicationClient.class));
        nestedArchiveData.add(new TestData("ejb-jar11.jar", 0, 11, 12, org.eclipse.jst.j2ee.ejb.EJBJar.class));
        nestedArchiveData.add(new TestData("ejb-jar20.jar", 0, 20, 13, org.eclipse.jst.j2ee.ejb.EJBJar.class));
        nestedArchiveData.add(new TestData("ejb-jar21.jar", 0, 21, 14, org.eclipse.jst.j2ee.ejb.EJBJar.class));
        nestedArchiveData.add(new TestData("EJB3_NoDD_MessageDriven.jar", 0, 30, 50, EJBJar.class));
        nestedArchiveData.add(new TestData("EJB3_NoDD_Stateful.jar", 0, 30, 50, EJBJar.class));
        nestedArchiveData.add(new TestData("EJB3_NoDD_Stateless.jar", 0, 30, 50, EJBJar.class));
        nestedArchiveData.add(new TestData("EJB3_WithDD.jar", 0, 30, 50, EJBJar.class));
        nestedArchiveData.add(new TestData("ra10.rar", 2, 10, 13, Connector.class));
        nestedArchiveData.add(new TestData("ra15.rar", 2, 15, 14, Connector.class));
        nestedArchiveData.add(new TestData("web22.war", 4, 22, 12, org.eclipse.jst.j2ee.webapplication.WebApp.class));
        nestedArchiveData.add(new TestData("web23.war", 4, 23, 13, org.eclipse.jst.j2ee.webapplication.WebApp.class));
        nestedArchiveData.add(new TestData("web24.war", 4, 24, 14, org.eclipse.jst.j2ee.webapplication.WebApp.class));
        nestedArchiveData.add(new TestData("Web25_NoDD.war", 4, 25, 50, WebApp.class));
        nestedArchiveData.add(new TestData("Web25_WithDD.war", 4, 25, 50, WebApp.class));
        TestData earData = new TestData("EAR5_NoDD.ear", 1, 50, 50, org.eclipse.jst.javaee.application.Application.class, false);
        this.runEAR50Tests(earData, nestedArchiveData);
    }

    public void testEAR50Import_WithDD() throws Exception {
        ArrayList<TestData> nestedArchiveData = new ArrayList<TestData>();
        nestedArchiveData.add(new TestData("application-client12.jar", 3, 12, 12, ApplicationClient.class));
        nestedArchiveData.add(new TestData("application-client13.jar", 3, 13, 13, ApplicationClient.class));
        nestedArchiveData.add(new TestData("application-client14.jar", 3, 14, 14, ApplicationClient.class));
        nestedArchiveData.add(new TestData("AppClient5_NoDD.jar", 3, 50, 50, org.eclipse.jst.javaee.applicationclient.ApplicationClient.class));
        nestedArchiveData.add(new TestData("AppClient5_WithDD.jar", 3, 50, 50, org.eclipse.jst.javaee.applicationclient.ApplicationClient.class));
        nestedArchiveData.add(new TestData("ejb-jar11.jar", 0, 11, 12, org.eclipse.jst.j2ee.ejb.EJBJar.class));
        nestedArchiveData.add(new TestData("ejb-jar20.jar", 0, 20, 13, org.eclipse.jst.j2ee.ejb.EJBJar.class));
        nestedArchiveData.add(new TestData("ejb-jar21.jar", 0, 21, 14, org.eclipse.jst.j2ee.ejb.EJBJar.class));
        nestedArchiveData.add(new TestData("EJB3_NoDD_MessageDriven.jar", 0, 30, 50, EJBJar.class));
        nestedArchiveData.add(new TestData("EJB3_NoDD_Stateful.jar", 0, 30, 50, EJBJar.class));
        nestedArchiveData.add(new TestData("EJB3_NoDD_Stateless.jar", 0, 30, 50, EJBJar.class));
        nestedArchiveData.add(new TestData("EJB3_WithDD.jar", 0, 30, 50, EJBJar.class));
        nestedArchiveData.add(new TestData("ra10.rar", 2, 10, 13, Connector.class));
        nestedArchiveData.add(new TestData("ra15.rar", 2, 15, 14, Connector.class));
        nestedArchiveData.add(new TestData("web22.war", 4, 22, 12, org.eclipse.jst.j2ee.webapplication.WebApp.class));
        nestedArchiveData.add(new TestData("web23.war", 4, 23, 13, org.eclipse.jst.j2ee.webapplication.WebApp.class));
        nestedArchiveData.add(new TestData("web24.war", 4, 24, 14, org.eclipse.jst.j2ee.webapplication.WebApp.class));
        nestedArchiveData.add(new TestData("Web25_NoDD.war", 4, 25, 50, WebApp.class));
        nestedArchiveData.add(new TestData("Web25_WithDD.war", 4, 25, 50, WebApp.class));
        TestData earData = new TestData("EAR5_WithDD.ear", 1, 50, 50, org.eclipse.jst.javaee.application.Application.class, true);
        this.runEAR50Tests(earData, nestedArchiveData);
    }

    private void runEAR50Tests(TestData earData, List<TestData> nestedArchiveData) throws Exception {
        IArchive earArchive = null;
        try {
            String earLocation = this.getDataPath(earData.fileName);
            Path earPath = new Path(earLocation);
            earArchive = JavaEEArchiveUtilities.INSTANCE.openArchive((IPath)earPath);
            earArchive.getArchiveOptions().setOption((Object)"DISCRIMINATE_EJB_ANNOTATIONS", (Object)Boolean.TRUE);
            JavaEEQuickPeek peek = JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(earArchive);
            Assert.assertEquals((String)(String.valueOf(earData.fileName) + " type"), (int)earData.type, (int)peek.getType());
            if (earData.deploymentDescriptor) {
                Assert.assertEquals((String)(String.valueOf(earData.fileName) + " mod version"), (int)earData.modVersion, (int)peek.getVersion());
                Assert.assertEquals((String)(String.valueOf(earData.fileName) + " ee version"), (int)earData.eeVersion, (int)peek.getJavaEEVersion());
            } else {
                Assert.assertTrue((String)(String.valueOf(earData.fileName) + " mod version"), (peek.getVersion() >= earData.modVersion ? 1 : 0) != 0);
                Assert.assertTrue((String)(String.valueOf(earData.fileName) + " ee version"), (peek.getJavaEEVersion() >= earData.eeVersion ? 1 : 0) != 0);
            }
            IArchive innerArchive = null;
            for (TestData testData : nestedArchiveData) {
                IArchiveResource innerArchiveResource = earArchive.getArchiveResource((IPath)new Path(testData.fileName));
                innerArchive = earArchive.getNestedArchive(innerArchiveResource);
                peek = JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(innerArchive);
                AssertWarn.warnEquals((String)(String.valueOf(testData.fileName) + " type"), (int)testData.type, (int)peek.getType());
                AssertWarn.warnEquals((String)(String.valueOf(testData.fileName) + " mod version"), (int)testData.modVersion, (int)peek.getVersion());
                AssertWarn.warnEquals((String)(String.valueOf(testData.fileName) + " ee version"), (int)testData.eeVersion, (int)peek.getJavaEEVersion());
                System.err.println("TODO -- can't getModelObject from inner archive of JEE5 EAR");
                System.err.println("     -- see https://bugs.eclipse.org/bugs/show_bug.cgi?id=199953");
            }
        }
        catch (Throwable throwable) {
            if (earArchive != null) {
                JavaEEArchiveUtilities.INSTANCE.closeArchive(earArchive);
            }
            throw throwable;
        }
        if (earArchive != null) {
            JavaEEArchiveUtilities.INSTANCE.closeArchive(earArchive);
        }
    }

    private class TestData {
        String fileName;
        int type;
        int modVersion;
        int eeVersion;
        boolean deploymentDescriptor;
        Class modelObjectInterface;

        public TestData(String fileName, int type, int modVersion, int eeVersion) {
            this.fileName = fileName;
            this.type = type;
            this.modVersion = modVersion;
            this.eeVersion = eeVersion;
        }

        public TestData(String fileName, int type, int modVersion, int eeVersion, Class modelTypeClass) {
            this(fileName, type, modVersion, eeVersion);
            this.modelObjectInterface = modelTypeClass;
        }

        public TestData(String fileName, int type, int modVersion, int eeVersion, Class modelTypeClass, boolean deploymentDescriptor) {
            this(fileName, type, modVersion, eeVersion, modelTypeClass);
            this.deploymentDescriptor = deploymentDescriptor;
        }
    }
}

