/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.jca.verifiers;

import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.javaee.jca.Connector;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.verifiers.ModuleProjectCreationDataModelVerifier;

public class JCAProjectCreationDataModelVerifier
extends ModuleProjectCreationDataModelVerifier {
    public void verify(IDataModel model) throws Exception {
        super.verify(model);
        this.verifySourceFolder();
    }

    protected void setFacetProjectType() {
        this.facetProjectType = "jst.connector";
    }

    protected IFile getDDFile() {
        return this.component.getRootFolder().getFile("META-INF/ra.xml").getUnderlyingFile();
    }

    protected void verifyDD(Object modelObj) {
        String projectVersion = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)this.project);
        String modelVersion = null;
        if ("1.6".equals(projectVersion)) {
            Connector connector = (Connector)modelObj;
            modelVersion = connector.getVersion();
        } else {
            org.eclipse.jst.j2ee.jca.Connector connector = (org.eclipse.jst.j2ee.jca.Connector)modelObj;
            modelVersion = connector.getVersion();
        }
        if (projectVersion == null || !projectVersion.equals(modelVersion)) {
            System.err.println("TODO -- connector version incorrect.");
            System.err.println("     -- see https://bugs.eclipse.org/bugs/show_bug.cgi?id=197014");
        }
    }

    private void verifySourceFolder() {
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = facetMap.getFacetDataModel("jst.connector");
        String sourceFolder = facetModel.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
        Path sourceFolderPath = new Path(sourceFolder);
        Assert.assertTrue((String)"Source directory should exist", (boolean)this.project.exists((IPath)sourceFolderPath));
    }
}

