/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.webfragment.operations;

import junit.framework.Test;
import org.eclipse.jst.j2ee.web.project.facet.WebFragmentFacetInstallDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.tests.OperationTestCase;
import org.eclipse.wst.common.tests.SimpleTestSuite;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.JavaEEFacetConstants;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.ModuleProjectCreationOperationTest;

public class WebFragmentProjectCreationOperationTest
extends ModuleProjectCreationOperationTest {
    public WebFragmentProjectCreationOperationTest() {
        super("WebProjectCreationOperationTests");
    }

    public WebFragmentProjectCreationOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new SimpleTestSuite(WebFragmentProjectCreationOperationTest.class);
    }

    public void testWeb30_Defaults() throws Exception {
        IDataModel dm = WebFragmentProjectCreationOperationTest.getWebFragmentDataModel("badWeb", null, null, JavaEEFacetConstants.WEBFRAGMENT_30, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testWeb30_ChangedContentDir() throws Exception {
        IDataModel dm = WebFragmentProjectCreationOperationTest.getWebFragmentDataModel("madWeb", "madContent", null, JavaEEFacetConstants.WEBFRAGMENT_30, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testWeb30_ChangedJavaSrcDir() throws Exception {
        IDataModel dm = WebFragmentProjectCreationOperationTest.getWebFragmentDataModel("booWeb", null, "booSrc", JavaEEFacetConstants.WEBFRAGMENT_30, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testWeb30_ChangedContentDir_ChangedJavaSrcDir() throws Exception {
        IDataModel dm = WebFragmentProjectCreationOperationTest.getWebFragmentDataModel("eeWeb", "contentEE", "srcTry", JavaEEFacetConstants.WEBFRAGMENT_30, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testWeb30_Defaults_WithEAR() throws Exception {
        IDataModel dm = WebFragmentProjectCreationOperationTest.getWebFragmentDataModel("badWeb", null, null, JavaEEFacetConstants.WEBFRAGMENT_30, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testWeb30_ChangedContextRoot_WithEAR() throws Exception {
        IDataModel dm = WebFragmentProjectCreationOperationTest.getWebFragmentDataModel("herWeb", null, null, JavaEEFacetConstants.WEBFRAGMENT_30, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testWeb30_ChangedContentDir_WithEAR() throws Exception {
        IDataModel dm = WebFragmentProjectCreationOperationTest.getWebFragmentDataModel("madWeb", "madContent", null, JavaEEFacetConstants.WEBFRAGMENT_30, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testWeb30_ChangedJavaSrcDir_WithEAR() throws Exception {
        IDataModel dm = WebFragmentProjectCreationOperationTest.getWebFragmentDataModel("booWeb", null, "booSrc", JavaEEFacetConstants.WEBFRAGMENT_30, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testWeb30_ChangedContextRoot_ChangedContentDir_WithEAR() throws Exception {
        IDataModel dm = WebFragmentProjectCreationOperationTest.getWebFragmentDataModel("pinkWeb", "pinkContent", null, JavaEEFacetConstants.WEBFRAGMENT_30, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testWeb30_ChangedContextRoot_ChangedJavaSrcDir_WithEAR() throws Exception {
        IDataModel dm = WebFragmentProjectCreationOperationTest.getWebFragmentDataModel("veryfarWeb", null, "verybadSrc", JavaEEFacetConstants.WEBFRAGMENT_30, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testWeb30_ChangedContentDir_ChangedJavaSrcDir_WithEAR() throws Exception {
        IDataModel dm = WebFragmentProjectCreationOperationTest.getWebFragmentDataModel("eeWeb", "contentEE", "srcTry", JavaEEFacetConstants.WEBFRAGMENT_30, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testWeb30_ChangedContextRoot_ChangedContentDir_ChangedJavaSrcDir_WithEAR() throws Exception {
        IDataModel dm = WebFragmentProjectCreationOperationTest.getWebFragmentDataModel("iiWeb", "iiContDir", "srgII", JavaEEFacetConstants.WEBFRAGMENT_30, false);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testWeb30_Defaults_WithDD() throws Exception {
        IDataModel dm = WebFragmentProjectCreationOperationTest.getWebFragmentDataModel("badWeb", null, null, JavaEEFacetConstants.WEBFRAGMENT_30, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testWeb30_ChangedContextRoot_WithDD() throws Exception {
        IDataModel dm = WebFragmentProjectCreationOperationTest.getWebFragmentDataModel("herWeb", null, null, JavaEEFacetConstants.WEBFRAGMENT_30, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testWeb30_ChangedContentDir_WithDD() throws Exception {
        IDataModel dm = WebFragmentProjectCreationOperationTest.getWebFragmentDataModel("madWeb", "madContent", null, JavaEEFacetConstants.WEBFRAGMENT_30, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testWeb30_ChangedContextRoot_ChangedContentDir_WithDD() throws Exception {
        IDataModel dm = WebFragmentProjectCreationOperationTest.getWebFragmentDataModel("pinkWeb", "tryContent", null, JavaEEFacetConstants.WEBFRAGMENT_30, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testWeb30_ChangedContextRoot_ChangedJavaSrcDir_WithDD() throws Exception {
        IDataModel dm = WebFragmentProjectCreationOperationTest.getWebFragmentDataModel("farawayWeb", null, "farSrc", JavaEEFacetConstants.WEBFRAGMENT_30, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testWeb30_ChangedContentDir_ChangedJavaSrcDir_WithDD() throws Exception {
        IDataModel dm = WebFragmentProjectCreationOperationTest.getWebFragmentDataModel("eeWeb", "contentE", "srcTry", JavaEEFacetConstants.WEBFRAGMENT_30, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testWeb30_Defaults_WithEAR_WithDD() throws Exception {
        IDataModel dm = WebFragmentProjectCreationOperationTest.getWebFragmentDataModel("badWeb", null, null, JavaEEFacetConstants.WEBFRAGMENT_30, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testWeb30_ChangedContextRoot_WithEAR_WithDD() throws Exception {
        IDataModel dm = WebFragmentProjectCreationOperationTest.getWebFragmentDataModel("herWeb", null, null, JavaEEFacetConstants.WEBFRAGMENT_30, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testWeb30_ChangedContentDir_WithEAR_WithDD() throws Exception {
        IDataModel dm = WebFragmentProjectCreationOperationTest.getWebFragmentDataModel("madWeb", "madContent", null, JavaEEFacetConstants.WEBFRAGMENT_30, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testWeb30_ChangedJavaSrcDir_WithEAR_WithDD() throws Exception {
        IDataModel dm = WebFragmentProjectCreationOperationTest.getWebFragmentDataModel("booWeb", null, "booSrc", JavaEEFacetConstants.WEBFRAGMENT_30, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testWeb30_ChangedContextRoot_ChangedContentDir_WithEAR_WithDD() throws Exception {
        IDataModel dm = WebFragmentProjectCreationOperationTest.getWebFragmentDataModel("pinkWeb", "pinkContent", null, JavaEEFacetConstants.WEBFRAGMENT_30, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testWeb30_ChangedContextRoot_ChangedJavaSrcDir_WithEAR_WithDD() throws Exception {
        IDataModel dm = WebFragmentProjectCreationOperationTest.getWebFragmentDataModel("veryfarWeb", null, "verybadSrc", JavaEEFacetConstants.WEBFRAGMENT_30, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testWeb30_ChangedContentDir_ChangedJavaSrcDir_WithEAR_WithDD() throws Exception {
        IDataModel dm = WebFragmentProjectCreationOperationTest.getWebFragmentDataModel("eeWeb", "contentEE", "srcTry", JavaEEFacetConstants.WEBFRAGMENT_30, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public void testWeb30_ChangedContextRoot_ChangedContentDir_ChangedJavaSrcDir_WithEAR_WithDD() throws Exception {
        IDataModel dm = WebFragmentProjectCreationOperationTest.getWebFragmentDataModel("iiWeb", "iiContDir", "srgII", JavaEEFacetConstants.WEBFRAGMENT_30, true);
        OperationTestCase.runAndVerify((IDataModel)dm);
    }

    public static IDataModel getWebFragmentDataModel(String projName, String contentDir, String javaSrcDir, IProjectFacetVersion version, boolean createDD) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new WebFragmentFacetInstallDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        dm.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)version);
        if (contentDir != null) {
            dm.setStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", contentDir);
        }
        if (javaSrcDir != null) {
            dm.setStringProperty("IWebFacetInstallDataModelProperties.SOURCE_FOLDER", javaSrcDir);
        }
        dm.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", createDD);
        return dm;
    }
}

