/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tets.ear.verifiers;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.j2ee.internal.archive.ArchiveWrapper;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.tests.AssertWarn;
import org.eclipse.wst.common.tests.DataModelVerifierFactory;
import org.eclipse.wst.common.tests.ProjectUtility;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.verifiers.JEEImportDataModelVerifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EARImportDataModelVerifier
extends JEEImportDataModelVerifier {
    @Override
    public void verify(IDataModel model) throws Exception {
        super.verify(model);
    }

    @Override
    protected int getExportType() {
        return 1;
    }

    @Override
    protected void verifyImportedResources(Collection<IArchiveResource> sourceResources, Collection<IArchiveResource> importedClassesResources, Collection<IArchiveResource> otherResources, Collection<IArchive> nestedArchives, IContainer rootFolder, IFolder importedClassesFolder) throws Exception {
        IPath resourcePath = null;
        IFile resourceFile = null;
        for (IArchiveResource otherResource : otherResources) {
            resourcePath = otherResource.getPath();
            resourceFile = rootFolder.getFile(resourcePath);
            if (resourceFile.getName().equalsIgnoreCase("Manifest.mf")) {
                AssertWarn.warnTrue((String)("The resource " + resourcePath + " should exist in the project " + this.project.getName()), (boolean)resourceFile.exists());
                continue;
            }
            Assert.assertTrue((String)("The resource " + resourcePath + " should exist in the project " + this.project.getName()), (boolean)resourceFile.exists());
        }
        HashMap<IPath, IArchive> nestedArchiveMap = new HashMap<IPath, IArchive>();
        for (IArchive nestedArchive : nestedArchives) {
            resourcePath = nestedArchive.getPath();
            resourceFile = rootFolder.getFile(resourcePath);
            Assert.assertTrue((String)("The nested archive " + resourcePath + " should exist in the project"), (boolean)resourceFile.exists());
            nestedArchiveMap.put(nestedArchive.getPath(), nestedArchive);
        }
        List selectedModelsList = (List)this.model.getProperty("IEnterpriseApplicationImportDataModelProperties.SELECTED_MODELS_LIST");
        DataModelVerifierFactory verifierFactory = DataModelVerifierFactory.getInstance();
        JEEImportDataModelVerifier verifier = null;
        ArchiveWrapper nestedArchiveWrapper = null;
        IArchive nestedArchive = null;
        for (IDataModel selectedModel : selectedModelsList) {
            verifier = (JEEImportDataModelVerifier)verifierFactory.createVerifier(selectedModel);
            nestedArchiveWrapper = (ArchiveWrapper)selectedModel.getProperty("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER");
            nestedArchive = (IArchive)nestedArchiveMap.get(nestedArchiveWrapper.getPath());
            Assert.assertNotNull((String)("There should be a nested archive object for this selected model: " + selectedModel), (Object)nestedArchive);
            verifier.verify(selectedModel, nestedArchive);
        }
        List moduleModelsList = (List)this.model.getProperty("IEnterpriseApplicationImportDataModelProperties.MODULE_MODELS_LIST");
        moduleModelsList.removeAll(selectedModelsList);
        String projectName = null;
        nestedArchive = null;
        for (IDataModel nonExplodedNestedModels : moduleModelsList) {
            projectName = nonExplodedNestedModels.getStringProperty("IProjectCreationPropertiesNew.PROJECT_NAME");
            nestedArchiveWrapper = (ArchiveWrapper)nonExplodedNestedModels.getProperty("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER");
            Assert.assertFalse((String)("The nested archive, " + nestedArchiveWrapper.getPath() + " should not have been exploded into a project."), (boolean)ProjectUtility.getProject((String)projectName).exists());
        }
        List cfr_ignored_0 = (List)this.model.getProperty("IEnterpriseApplicationImportDataModelProperties.UTILITY_LIST");
        List cfr_ignored_1 = (List)this.model.getProperty("IEnterpriseApplicationImportDataModelProperties.EJB_CLIENT_LIST");
        List cfr_ignored_2 = (List)this.model.getProperty("IEnterpriseApplicationImportDataModelProperties.UTILITY_MODELS_LIST");
    }
}

