/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.contentassist.tests;

import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.ITextRegionContextResolver;
import org.eclipse.jst.jsf.core.internal.contentassist.el.ContentAssistParser;
import org.eclipse.jst.jsf.core.internal.contentassist.el.ContentAssistStrategy;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseTestClass
extends TestCase {
    protected final List<ICompletionProposal> getProposals(IFile jspFile, int docOffset, int exprOffset) throws Exception {
        JSFCoreUtilHelper.ContextWrapper wrapper = null;
        try {
            wrapper = JSFCoreUtilHelper.getDocumentContext((IFile)jspFile, (int)docOffset);
            ITextRegionContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTextRegionResolver(wrapper.getContext());
            BaseTestClass.assertEquals((String)"JSP_VBL_CONTENT", (String)resolver.getRegionType());
            String elText = resolver.getRegionText().trim();
            BaseTestClass.assertNotNull((Object)elText);
            ContentAssistStrategy strategy = ContentAssistParser.getPrefix((int)exprOffset, (String)elText);
            BaseTestClass.assertNotNull((Object)strategy);
            List list = strategy.getProposals(wrapper.getContext());
            return list;
        }
        finally {
            if (wrapper != null) {
                wrapper.dispose();
            }
        }
    }

    protected final List<ICompletionProposal> getProposals(IFile jspFile, int docOffset, String elText, int exprOffset) throws Exception {
        JSFCoreUtilHelper.ContextWrapper wrapper = null;
        try {
            wrapper = JSFCoreUtilHelper.getDocumentContext((IFile)jspFile, (int)docOffset);
            ContentAssistStrategy strategy = ContentAssistParser.getPrefix((int)exprOffset, (String)elText);
            BaseTestClass.assertNotNull((Object)strategy);
            List list = strategy.getProposals(wrapper.getContext());
            return list;
        }
        finally {
            if (wrapper != null) {
                wrapper.dispose();
            }
        }
    }

    protected final void applyAndCheck(IFile jspFile, int offset, ICompletionProposal applyMe, String expectedResult) throws Exception {
        JSFCoreUtilHelper.ContextWrapper wrapper = null;
        try {
            wrapper = JSFCoreUtilHelper.getDocumentContext((IFile)jspFile, (int)offset);
            applyMe.apply(JSFCoreUtilHelper.getDocumentContext((IFile)jspFile, (int)offset).getContext().getStructuredDocument());
            ITextRegionContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTextRegionResolver(wrapper.getContext());
            String newELText = resolver.getRegionText();
            BaseTestClass.assertEquals((String)expectedResult, (String)newELText);
        }
        finally {
            if (wrapper != null) {
                wrapper.dispose();
            }
        }
    }

    protected void assertDisplayNamesMatch(Set<String> expected, List<ICompletionProposal> proposals) {
        BaseTestClass.assertEquals((int)expected.size(), (int)proposals.size());
        for (ICompletionProposal proposal : proposals) {
            expected.contains(proposal.getDisplayString());
        }
    }
}

