/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.core.tests;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitor;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitorListener;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitorWorkingCopy;
import org.eclipse.wst.internet.monitor.core.internal.provisional.MonitorCore;

public class MonitorListenerTestCase
extends TestCase {
    private static IMonitor monitor;
    protected static IMonitor addEvent;
    protected static IMonitor changeEvent;
    protected static IMonitor removeEvent;
    protected static int count;
    protected static IMonitorListener listener;

    static {
        listener = new IMonitorListener(){

            public void monitorAdded(IMonitor monitor2) {
                addEvent = monitor2;
                ++count;
            }

            public void monitorChanged(IMonitor monitor2) {
                changeEvent = monitor2;
                ++count;
            }

            public void monitorRemoved(IMonitor monitor2) {
                removeEvent = monitor2;
                ++count;
            }
        };
    }

    protected IMonitor getMonitor() throws CoreException {
        if (monitor == null) {
            IMonitorWorkingCopy wc = MonitorCore.createMonitor();
            monitor = wc.save();
        }
        return monitor;
    }

    public static void addOrderedTests(TestSuite suite) {
        suite.addTest(TestSuite.createTest(MonitorListenerTestCase.class, (String)"addListener"));
        suite.addTest(TestSuite.createTest(MonitorListenerTestCase.class, (String)"addListener2"));
        suite.addTest(TestSuite.createTest(MonitorListenerTestCase.class, (String)"listenerCreateMonitor"));
        suite.addTest(TestSuite.createTest(MonitorListenerTestCase.class, (String)"listenerChangeMonitor"));
        suite.addTest(TestSuite.createTest(MonitorListenerTestCase.class, (String)"listenerDeleteMonitor"));
        suite.addTest(TestSuite.createTest(MonitorListenerTestCase.class, (String)"removeListener"));
        suite.addTest(TestSuite.createTest(MonitorListenerTestCase.class, (String)"removeListener2"));
    }

    public void addListener() throws Exception {
        MonitorCore.addMonitorListener((IMonitorListener)listener);
    }

    public void addListener2() throws Exception {
        MonitorCore.addMonitorListener((IMonitorListener)listener);
    }

    public void listenerCreateMonitor() throws Exception {
        this.getMonitor();
        MonitorListenerTestCase.assertTrue((addEvent == monitor ? 1 : 0) != 0);
        MonitorListenerTestCase.assertTrue((changeEvent == null ? 1 : 0) != 0);
        MonitorListenerTestCase.assertTrue((removeEvent == null ? 1 : 0) != 0);
        MonitorListenerTestCase.assertTrue((count == 1 ? 1 : 0) != 0);
        addEvent = null;
        count = 0;
    }

    public void listenerChangeMonitor() throws Exception {
        IMonitorWorkingCopy wc = this.getMonitor().createWorkingCopy();
        wc.setLocalPort(1);
        monitor = wc.save();
        MonitorListenerTestCase.assertTrue((addEvent == null ? 1 : 0) != 0);
        MonitorListenerTestCase.assertTrue((changeEvent == monitor ? 1 : 0) != 0);
        MonitorListenerTestCase.assertTrue((removeEvent == null ? 1 : 0) != 0);
        MonitorListenerTestCase.assertTrue((count == 1 ? 1 : 0) != 0);
        changeEvent = null;
        count = 0;
    }

    public void listenerDeleteMonitor() throws Exception {
        this.getMonitor().delete();
        MonitorListenerTestCase.assertTrue((addEvent == null ? 1 : 0) != 0);
        MonitorListenerTestCase.assertTrue((changeEvent == null ? 1 : 0) != 0);
        MonitorListenerTestCase.assertTrue((removeEvent == monitor ? 1 : 0) != 0);
        MonitorListenerTestCase.assertTrue((count == 1 ? 1 : 0) != 0);
        removeEvent = null;
        count = 0;
    }

    public void removeListener() throws Exception {
        MonitorCore.removeMonitorListener((IMonitorListener)listener);
    }

    public void removeListener2() throws Exception {
        MonitorCore.removeMonitorListener((IMonitorListener)listener);
    }

    public void testCheckListener() throws Exception {
        IMonitorListener listener2 = new IMonitorListener(){

            public void monitorAdded(IMonitor monitor2) {
            }

            public void monitorChanged(IMonitor monitor2) {
            }

            public void monitorRemoved(IMonitor monitor2) {
            }
        };
        listener2.monitorAdded(null);
        listener2.monitorChanged(null);
        listener2.monitorRemoved(null);
    }
}

