/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.core.tests;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitor;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitorWorkingCopy;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IRequestListener;
import org.eclipse.wst.internet.monitor.core.internal.provisional.MonitorCore;
import org.eclipse.wst.internet.monitor.core.internal.provisional.Request;

public class RequestTestCase
extends TestCase {
    private static final String CONNECT_TIMEOUT = "sun.net.client.defaultConnectTimeout";
    private static final String READ_TIMEOUT = "sun.net.client.defaultReadTimeout";
    private static IMonitor monitor;
    protected static IMonitor monitorEvent;
    protected static Request requestEvent;
    protected static int addCount;
    protected static int changeCount;
    protected static IRequestListener listener;

    static {
        listener = new IRequestListener(){

            public void requestAdded(IMonitor monitor2, Request request2) {
                monitorEvent = monitor2;
                requestEvent = request2;
                ++addCount;
            }

            public void requestChanged(IMonitor monitor2, Request request2) {
                monitorEvent = monitor2;
                requestEvent = request2;
                ++changeCount;
            }
        };
    }

    protected IMonitor getMonitor() throws CoreException {
        if (monitor == null) {
            IMonitorWorkingCopy wc = MonitorCore.createMonitor();
            wc.setLocalPort(22152);
            wc.setRemoteHost("www.eclipse.org");
            wc.setRemotePort(80);
            monitor = wc.save();
        }
        return monitor;
    }

    public static void addOrderedTests(TestSuite suite) {
        suite.addTest(TestSuite.createTest(RequestTestCase.class, (String)"deleteMonitors"));
        suite.addTest(TestSuite.createTest(RequestTestCase.class, (String)"getMonitors"));
        suite.addTest(TestSuite.createTest(RequestTestCase.class, (String)"createMonitor"));
        suite.addTest(TestSuite.createTest(RequestTestCase.class, (String)"addListener"));
        suite.addTest(TestSuite.createTest(RequestTestCase.class, (String)"addListener2"));
        suite.addTest(TestSuite.createTest(RequestTestCase.class, (String)"startMonitor"));
        suite.addTest(TestSuite.createTest(RequestTestCase.class, (String)"pingMonitor"));
        suite.addTest(TestSuite.createTest(RequestTestCase.class, (String)"checkListener"));
        suite.addTest(TestSuite.createTest(RequestTestCase.class, (String)"verifyMonitor"));
        suite.addTest(TestSuite.createTest(RequestTestCase.class, (String)"verifyProtocol"));
        suite.addTest(TestSuite.createTest(RequestTestCase.class, (String)"verifyTime"));
        suite.addTest(TestSuite.createTest(RequestTestCase.class, (String)"verifyLocalPort"));
        suite.addTest(TestSuite.createTest(RequestTestCase.class, (String)"verifyRemoteHost"));
        suite.addTest(TestSuite.createTest(RequestTestCase.class, (String)"verifyRemotePort"));
        suite.addTest(TestSuite.createTest(RequestTestCase.class, (String)"verifyRequest"));
        suite.addTest(TestSuite.createTest(RequestTestCase.class, (String)"verifyResponse"));
        suite.addTest(TestSuite.createTest(RequestTestCase.class, (String)"verifyResponseTime"));
        suite.addTest(TestSuite.createTest(RequestTestCase.class, (String)"checkRequest"));
        suite.addTest(TestSuite.createTest(RequestTestCase.class, (String)"checkRequest2"));
        suite.addTest(TestSuite.createTest(RequestTestCase.class, (String)"addToRequest"));
        suite.addTest(TestSuite.createTest(RequestTestCase.class, (String)"addToResponse"));
        suite.addTest(TestSuite.createTest(RequestTestCase.class, (String)"setProperty"));
        suite.addTest(TestSuite.createTest(RequestTestCase.class, (String)"getAdapter"));
        suite.addTest(TestSuite.createTest(RequestTestCase.class, (String)"stopMonitor"));
        suite.addTest(TestSuite.createTest(RequestTestCase.class, (String)"removeListener"));
    }

    public void deleteMonitors() {
        IMonitor[] monitors = MonitorCore.getMonitors();
        int i = 0;
        while (i < monitors.length) {
            monitors[i].delete();
            ++i;
        }
        monitor = null;
    }

    public void getMonitors() throws Exception {
        RequestTestCase.assertNotNull((Object)MonitorCore.getMonitors());
    }

    public void createMonitor() throws Exception {
        this.getMonitor();
        RequestTestCase.assertTrue((monitor != null ? 1 : 0) != 0);
        RequestTestCase.assertTrue((MonitorCore.getMonitors().length == 1 ? 1 : 0) != 0);
        RequestTestCase.assertTrue((!monitor.isRunning() ? 1 : 0) != 0);
        RequestTestCase.assertTrue((!monitor.isWorkingCopy() ? 1 : 0) != 0);
    }

    public void addListener() throws Exception {
        monitor.addRequestListener(listener);
    }

    public void addListener2() throws Exception {
        monitor.addRequestListener(listener);
    }

    public void startMonitor() throws Exception {
        RequestTestCase.assertTrue((!monitor.isRunning() ? 1 : 0) != 0);
        monitor.start();
        RequestTestCase.assertTrue((boolean)monitor.isRunning());
    }

    public void pingMonitor() throws Exception {
        String connectTimeout = System.getProperty(CONNECT_TIMEOUT);
        String readTimeout = System.getProperty(READ_TIMEOUT);
        System.setProperty(CONNECT_TIMEOUT, "10000");
        System.setProperty(READ_TIMEOUT, "10000");
        URL url = new URL("http://localhost:22152/");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        System.out.println("Response from www.eclipse.org ----------------------------------");
        InputStream in = conn.getInputStream();
        byte[] b = new byte[256];
        int n = in.read(b);
        System.out.println(new String(b));
        while (n >= 0) {
            n = in.read(b);
            System.out.println(new String(b));
        }
        in.close();
        System.out.println("End of response from www.eclipse.org ---------------------------");
        try {
            System.setProperty(CONNECT_TIMEOUT, connectTimeout);
            System.setProperty(READ_TIMEOUT, readTimeout);
        }
        catch (Exception exception) {}
    }

    public void checkListener() throws Exception {
        RequestTestCase.assertEquals((int)1, (int)addCount);
        RequestTestCase.assertEquals((Object)monitorEvent, (Object)monitor);
        RequestTestCase.assertNotNull((Object)requestEvent);
    }

    public void verifyMonitor() throws Exception {
        RequestTestCase.assertEquals((Object)requestEvent.getMonitor(), (Object)monitor);
    }

    public void verifyProtocol() throws Exception {
        RequestTestCase.assertEquals((String)requestEvent.getProtocol(), (String)"HTTP");
    }

    public void verifyTime() throws Exception {
        RequestTestCase.assertTrue((Math.abs(requestEvent.getDate().getTime() - System.currentTimeMillis()) < 60000L ? 1 : 0) != 0);
    }

    public void verifyLocalPort() throws Exception {
        RequestTestCase.assertEquals((int)requestEvent.getLocalPort(), (int)22152);
    }

    public void verifyRemoteHost() throws Exception {
        RequestTestCase.assertEquals((String)requestEvent.getRemoteHost(), (String)"www.eclipse.org");
    }

    public void verifyRemotePort() throws Exception {
        RequestTestCase.assertEquals((int)requestEvent.getRemotePort(), (int)80);
    }

    public void verifyRequest() throws Exception {
        RequestTestCase.assertNotNull((Object)requestEvent.getRequest(3));
    }

    public void verifyResponse() throws Exception {
        RequestTestCase.assertNotNull((Object)requestEvent.getResponse(3));
    }

    public void verifyResponseTime() throws Exception {
        RequestTestCase.assertTrue((requestEvent.getResponseTime() > 0L ? 1 : 0) != 0);
    }

    public void checkRequest() throws Exception {
        RequestTestCase.assertNotNull((Object)requestEvent.getName());
    }

    public void checkRequest2() throws Exception {
        RequestTestCase.assertNull((Object)requestEvent.getProperty("test"));
    }

    public void addToRequest() throws Exception {
        requestEvent.addToRequest(new byte[0]);
    }

    public void addToResponse() throws Exception {
        requestEvent.addToResponse(new byte[0]);
    }

    public void setProperty() throws Exception {
        requestEvent.setProperty("test", null);
    }

    public void getAdapter() throws Exception {
        RequestTestCase.assertNull((Object)requestEvent.getAdapter(String.class));
    }

    public void stopMonitor() throws Exception {
        RequestTestCase.assertTrue((boolean)monitor.isRunning());
        monitor.stop();
        RequestTestCase.assertTrue((!monitor.isRunning() ? 1 : 0) != 0);
    }

    public void removeListener() throws Exception {
        monitor.removeRequestListener(listener);
    }

    public void testCreateRequest() {
        new Request(null, null, 0, null, 0);
    }

    public void testTestProtectedMethods() {
        Request mr = new Request(null, null, 0, null, 0){

            public Object getAdapter(Class c) {
                this.setName("test");
                this.setRequest(null);
                this.setResponse(null);
                this.fireChangedEvent();
                return null;
            }
        };
        mr.getAdapter(null);
    }
}

