/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.core.tests;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.Random;

public class SocketUtil {
    private static final Random rand = new Random(System.currentTimeMillis());

    private SocketUtil() {
    }

    public static int findUnusedPort(int low, int high) {
        if (high < low) {
            return -1;
        }
        int i = 0;
        while (i < 10) {
            int port = SocketUtil.getRandomPort(low, high);
            if (!SocketUtil.isPortInUse(port)) {
                return port;
            }
            ++i;
        }
        return -1;
    }

    private static int getRandomPort(int low, int high) {
        return rand.nextInt(high - low) + low;
    }

    public static boolean isPortInUse(int port, int count) {
        boolean inUse = SocketUtil.isPortInUse(port);
        while (inUse && count > 0) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
            inUse = SocketUtil.isPortInUse(port);
            --count;
        }
        return inUse;
    }

    /*
     * Loose catch block
     */
    public static boolean isPortInUse(int port) {
        block22: {
            ServerSocket s = null;
            try {
                s = new ServerSocket(port, 0);
            }
            catch (SocketException socketException) {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Exception exception) {}
                }
                return true;
            }
            catch (IOException iOException) {
                block20: {
                    if (s == null) break block20;
                    try {
                        s.close();
                    }
                    catch (Exception exception) {}
                }
                return true;
            }
            catch (Exception exception) {
                block21: {
                    if (s == null) break block21;
                    {
                        catch (Throwable throwable) {
                            if (s != null) {
                                try {
                                    s.close();
                                }
                                catch (Exception exception2) {}
                            }
                            throw throwable;
                        }
                    }
                    try {
                        s.close();
                    }
                    catch (Exception exception3) {}
                }
                return true;
            }
            if (s == null) break block22;
            try {
                s.close();
            }
            catch (Exception exception) {}
        }
        return false;
    }
}

