/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.proxy.initParser;

import java.awt.Color;
import org.eclipse.jem.tests.proxy.initParser.AbstractInitParserTestCase;
import org.eclipse.jem.tests.proxy.initParser.NavigationParameters;

public class ArrayConstructorTest
extends AbstractInitParserTestCase {
    public ArrayConstructorTest(String name) {
        super(name);
    }

    public void testEmptyString1D() throws Throwable {
        this.testHelper.testInitString("new String[2]", new String[2]);
    }

    public void testEmptyString2D() throws Throwable {
        this.testHelper.testInitString("new String[2][2]", new String[2][2]);
    }

    public void testEmptyColor1D() throws Throwable {
        this.testHelper.testInitString("new java.awt.Color[3]", new Color[3]);
    }

    public void testEmptyColor2D() throws Throwable {
        this.testHelper.testInitString("new java.awt.Color[3][4]", new Color[3][4]);
    }

    public void testEmptyInt() throws Throwable {
        this.testHelper.testInitString("new int[3]", new int[3]);
    }

    public void testInitializedInts() throws Throwable {
        this.testHelper.testInitString("new int[] {-2,3}", new int[]{-2, 3});
    }

    public void testInitializedIntsTrailingComma() throws Throwable {
        this.testHelper.testInitString("new int[] {-2,3,}", new int[]{-2, 3});
    }

    public void testInitializedDoubleParens() throws Throwable {
        this.testHelper.testInitString("new double[] {(-2), 3.0 }", new double[]{-2.0, 3.0});
    }

    public void testInitializedStringsTwo() throws Throwable {
        this.testHelper.testInitString("new String[] {\"1\",\"2\"}", new String[]{"1", "2"});
    }

    public void testInitializedStringsThree() throws Throwable {
        this.testHelper.testInitString("new String[] {\"Frog\",\"Dog\",\"Cow\"}", new String[]{"Frog", "Dog", "Cow"});
    }

    public void testInitializedColors() throws Throwable {
        this.testHelper.testInitString("new java.awt.Color[] { java.awt.Color.red , new java.awt.Color(0,0,0) }", new Color[]{Color.red, new Color(0, 0, 0)});
    }

    public void testInitalizedInts2D1() throws Throwable {
        this.testHelper.testInitString("new int[][] { { 2 , -3 } , { 4 , 5 } }", new int[][]{{2, -3}, {4, 5}});
    }

    public void testInitalizedInts2D2() throws Throwable {
        this.testHelper.testInitString("new int[][] {{1,2,3},{4,5,6}}", new int[][]{{1, 2, 3}, {4, 5, 6}});
    }

    public void testInitalizedInts2DParensCommas() throws Throwable {
        this.testHelper.testInitString("new int[][] { {2 ,(-3),} , { 4 , 5,}}", new int[][]{{2, -3}, {4, 5}});
    }

    public void testInitalizedInts2DParensCommas2() throws Throwable {
        this.testHelper.testInitString("new int[][] { {2 ,(-3),} , { 4 , 5,},}", new int[][]{{2, -3}, {4, 5}});
    }

    public void testInitalizedDoubles2D() throws Throwable {
        this.testHelper.testInitString("new double[][] { { 2 , 3 } , { 4 , 5 } }", new double[][]{{2.0, 3.0}, {4.0, 5.0}});
    }

    public void testInitalizedDoubles2DMany() throws Throwable {
        this.testHelper.testInitString("new double[][]{{ 5.0, -2.0, 5.0, -1.0, -1.0, 5.0, -2.0, 5.0 }, { 5.0, -2.0, 5.0, -2.0, 5.0, -1.0, 5.0, -2.0, 5.0 }}", new double[][]{{5.0, -2.0, 5.0, -1.0, -1.0, 5.0, -2.0, 5.0}, {5.0, -2.0, 5.0, -2.0, 5.0, -1.0, 5.0, -2.0, 5.0}});
    }

    public void testInt2DParam() throws Throwable {
        this.testHelper.testInitString("new org.eclipse.jem.tests.proxy.initParser.NavigationParameters(new int[][] {{1,2,3},{3,4,5}})", new NavigationParameters(new int[][]{{1, 2, 3}, {3, 4, 5}}));
    }

    public void testInt2DParamCommas() throws Throwable {
        this.testHelper.testInitString("new org.eclipse.jem.tests.proxy.initParser.NavigationParameters(new int[][] {{1,2,3,},{3,4,5,}})", new NavigationParameters(new int[][]{{1, 2, 3}, {3, 4, 5}}));
    }

    public void testInt2DParamCommas2() throws Throwable {
        this.testHelper.testInitString("new org.eclipse.jem.tests.proxy.initParser.NavigationParameters(new int[][] {{1,2,3,},{3,4,5,},})", new NavigationParameters(new int[][]{{1, 2, 3}, {3, 4, 5}}));
    }

    public void testDoubleParam() throws Throwable {
        this.testHelper.testInitString("new org.eclipse.jem.tests.proxy.initParser.NavigationParameters(new double[]{1,2,3})", new NavigationParameters(new double[]{1.0, 2.0, 3.0}));
    }

    public void testDoubleParam2() throws Throwable {
        this.testHelper.testInitString("new org.eclipse.jem.tests.proxy.initParser.NavigationParameters(new double[]{1.0,2,-3.5})", new NavigationParameters(new double[]{1.0, 2.0, -3.5}));
    }

    public void testDoubleParam3() throws Throwable {
        this.testHelper.testInitString("new org.eclipse.jem.tests.proxy.initParser.NavigationParameters(new double[]{-1,2,-0.5})", new NavigationParameters(new double[]{-1.0, 2.0, -0.5}));
    }

    public void testDouble2DParam() throws Throwable {
        this.testHelper.testInitString("new org.eclipse.jem.tests.proxy.initParser.NavigationParameters(new double[][]{{ 5.0, -2.0, 5.0, -1.0, -1.0, 5.0, -2.0, 5.0 }, { 5.0, -2.0, 5.0, -2.0, 5.0, -1.0, 5.0, -2.0, 5.0 }})", new NavigationParameters(new double[][]{{5.0, -2.0, 5.0, -1.0, -1.0, 5.0, -2.0, 5.0}, {5.0, -2.0, 5.0, -2.0, 5.0, -1.0, 5.0, -2.0, 5.0}}));
    }

    public void testDouble2DParamCommas() throws Throwable {
        this.testHelper.testInitString("new org.eclipse.jem.tests.proxy.initParser.NavigationParameters(new double[][]{{ 5.0, -2.0, 5.0, -1.0, -1.0, 5.0, -2.0, 5.0 , }, { 5.0, -2.0, 5.0, -2.0, 5.0, -1.0, 5.0, -2.0, 5.0 , } , })", new NavigationParameters(new double[][]{{5.0, -2.0, 5.0, -1.0, -1.0, 5.0, -2.0, 5.0}, {5.0, -2.0, 5.0, -2.0, 5.0, -1.0, 5.0, -2.0, 5.0}}));
    }
}

