/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.breakpointproviders;

import com.ibm.icu.util.StringTokenizer;
import java.util.HashSet;
import junit.framework.TestCase;
import org.eclipse.jst.jsp.ui.internal.breakpointproviders.ClassPatternRegistry;

public class BreakpointProvidersTest
extends TestCase {
    public void testAdditionalProviders() {
        String pattern = ClassPatternRegistry.getInstance().getClassPattern("org.eclipse.jst.jsp.ui.tests.type");
        BreakpointProvidersTest.assertNotNull((String)"Class pattern for 'type' shouldn't be null", (Object)pattern);
        String[] expected = new String[]{"*foo", "*bar"};
        StringTokenizer tokenizer = new StringTokenizer(pattern, ",");
        HashSet<Object> tokens = new HashSet<Object>(expected.length);
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextElement());
        }
        int i = 0;
        while (i < expected.length) {
            tokens.remove(expected[i]);
            ++i;
        }
        BreakpointProvidersTest.assertTrue((String)"Class patterns are not equal", (boolean)tokens.isEmpty());
    }

    public void testNoAdditionalProviders() {
        String pattern = ClassPatternRegistry.getInstance().getClassPattern("org.eclipse.jst.jsp.ui.tests.notype");
        BreakpointProvidersTest.assertNull((String)"There should be no providers for 'notype'", (Object)pattern);
    }

    public void testMultipleProviders() {
        String pattern = ClassPatternRegistry.getInstance().getClassPattern("org.eclipse.jst.jsp.ui.tests.multitype");
        BreakpointProvidersTest.assertNotNull((String)"Class pattern for 'type' shouldn't be null", (Object)pattern);
        String[] expected = new String[]{"*foo", "*bar", "*baz"};
        StringTokenizer tokenizer = new StringTokenizer(pattern, ",");
        HashSet<Object> tokens = new HashSet<Object>(expected.length);
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextElement());
        }
        int i = 0;
        while (i < expected.length) {
            tokens.remove(expected[i]);
            ++i;
        }
        BreakpointProvidersTest.assertTrue((String)"Class patterns are not equal", (boolean)tokens.isEmpty());
    }
}

