/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.contentassist;

import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jst.jsp.ui.StructuredTextViewerConfigurationJSP;
import org.eclipse.jst.jsp.ui.tests.util.FileUtil;
import org.eclipse.jst.jsp.ui.tests.util.ProjectUnzipUtility;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;

public class TestJSPContentAssistComputers
extends TestCase {
    private static final String PROJECT_NAME = "TestJSPContentAssistComputers";
    private static final String CONTENT_DIR = "WebContent";
    private static IProject fProject;
    private static Map fFileToEditorMap;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        fFileToEditorMap = new HashMap();
    }

    public TestJSPContentAssistComputers() {
        super("Test JSP Content Assist Computers");
    }

    public TestJSPContentAssistComputers(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.jsp.ui.tests.contentassist.TestJSPContentAssistComputers");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite ts = new TestSuite((Class)clazz, "Test JSP Content Assist Computers");
        return new TestJSPContentAssistComputersSetup((Test)ts);
    }

    public void testEmptyDocument() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 14;
        nArray[1] = 7;
        nArray[2] = 6;
        nArray[3] = 1;
        nArray[5] = 14;
        int[] expectedProposalCounts = nArray;
        TestJSPContentAssistComputers.runProposalTest("test0.jsp", 0, 0, expectedProposalCounts);
    }

    public void testAfterXMLDeclarationBeforeHTMLTagProposals() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 18;
        nArray[1] = 10;
        nArray[2] = 8;
        nArray[5] = 18;
        int[] expectedProposalCounts = nArray;
        TestJSPContentAssistComputers.runProposalTest("test1.jsp", 1, 0, expectedProposalCounts);
    }

    public void testAfterXMLDeclarationBeforeEmptyDocProposals() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 19;
        nArray[1] = 10;
        nArray[2] = 8;
        nArray[3] = 1;
        nArray[5] = 19;
        int[] expectedProposalCounts = nArray;
        TestJSPContentAssistComputers.runProposalTest("test2.jsp", 1, 0, expectedProposalCounts);
    }

    public void testAfterJSPTaglibsBeforeDocType() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 18;
        nArray[1] = 10;
        nArray[2] = 8;
        nArray[5] = 18;
        int[] expectedProposalCounts = nArray;
        TestJSPContentAssistComputers.runProposalTest("test1.jsp", 6, 0, expectedProposalCounts);
    }

    public void testBodyTagChildElementProposals() throws Exception {
        int[] expectedProposalCounts = new int[]{95, 10, 8, 64, 13, 95};
        TestJSPContentAssistComputers.runProposalTest("test1.jsp", 14, 0, expectedProposalCounts);
    }

    public void testPTagChildElementProposals() throws Exception {
        int[] expectedProposalCounts = new int[]{72, 10, 8, 41, 13, 72};
        TestJSPContentAssistComputers.runProposalTest("test1.jsp", 16, 0, expectedProposalCounts);
    }

    public void testDIVTagChildElementProposals() throws Exception {
        int[] expectedProposalCounts = new int[]{95, 10, 8, 64, 13, 95};
        TestJSPContentAssistComputers.runProposalTest("test1.jsp", 20, 0, expectedProposalCounts);
    }

    public void testCommentTagChildElementProposals() throws Exception {
        int[] nArray = new int[5];
        nArray[0] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        int[] expectedProposalCounts = nArray;
        TestJSPContentAssistComputers.runProposalTest("test1.jsp", 25, 0, expectedProposalCounts);
    }

    public void testJSPRegionProposals() throws Exception {
        int[] nArray = new int[4];
        nArray[0] = 60;
        nArray[2] = 60;
        nArray[3] = 60;
        int[] expectedProposalCounts = nArray;
        TestJSPContentAssistComputers.runProposalTest("test1.jsp", 28, 0, expectedProposalCounts);
    }

    public void testDIVTagAttributeNameProposals() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 19;
        nArray[1] = 1;
        nArray[3] = 18;
        nArray[5] = 19;
        int[] expectedProposalCounts = nArray;
        TestJSPContentAssistComputers.runProposalTest("test1.jsp", 19, 5, expectedProposalCounts);
    }

    public void testELProposals() throws Exception {
        int[] nArray = new int[4];
        nArray[0] = 12;
        nArray[2] = 12;
        nArray[3] = 12;
        int[] expectedProposalCounts = nArray;
        TestJSPContentAssistComputers.runProposalTest("test1.jsp", 33, 15, expectedProposalCounts);
    }

    public void testELInAttributeProposals() throws Exception {
        int[] nArray = new int[4];
        nArray[0] = 12;
        nArray[2] = 12;
        nArray[3] = 12;
        int[] expectedProposalCounts = nArray;
        TestJSPContentAssistComputers.runProposalTest("test1.jsp", 31, 24, expectedProposalCounts);
    }

    public void testJSPTagAttributeNameProposals() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 6;
        nArray[1] = 4;
        nArray[2] = 2;
        nArray[5] = 6;
        int[] expectedProposalCounts = nArray;
        TestJSPContentAssistComputers.runProposalTest("test1.jsp", 41, 15, expectedProposalCounts);
    }

    public void testHTMLTagAttributeValueProposals() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 15;
        nArray[1] = 2;
        nArray[4] = 13;
        nArray[5] = 15;
        int[] expectedProposalCounts = nArray;
        TestJSPContentAssistComputers.runProposalTest("test3.jsp", 8, 10, expectedProposalCounts);
    }

    public void testJSPTagProposalsAtDocumentRootLevel() throws Exception {
        int[] expectedProposalCounts = new int[]{36, 10, 8, 1, 17, 36};
        TestJSPContentAssistComputers.runProposalTest("test6.jsp", 2, 0, expectedProposalCounts);
    }

    public void testFinishClosingHTMLTagNamePropsoals() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 2;
        nArray[1] = 1;
        nArray[3] = 1;
        nArray[5] = 2;
        int[] expectedProposalCounts = nArray;
        TestJSPContentAssistComputers.runProposalTest("test4.jsp", 11, 9, expectedProposalCounts);
    }

    public void testFinishClosingHTMLTagPropsoals() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 3;
        nArray[1] = 1;
        nArray[3] = 2;
        nArray[5] = 3;
        int[] expectedProposalCounts = nArray;
        TestJSPContentAssistComputers.runProposalTest("test4.jsp", 12, 0, expectedProposalCounts);
    }

    public void testFinishClosingJSPTagNamePropsoals() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[3] = 1;
        nArray[5] = 1;
        int[] expectedProposalCounts = nArray;
        TestJSPContentAssistComputers.runProposalTest("test5.jsp", 11, 9, expectedProposalCounts);
    }

    public void testFinishClosingJSPTagPropsoals() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 5;
        nArray[1] = 4;
        nArray[2] = 2;
        nArray[5] = 5;
        int[] expectedProposalCounts = nArray;
        TestJSPContentAssistComputers.runProposalTest("test5.jsp", 12, 0, expectedProposalCounts);
    }

    private static void runProposalTest(String fileName, int lineNum, int lineRelativeCharOffset, int[] expectedProposalCounts) throws Exception {
        IFile file = TestJSPContentAssistComputers.getFile(fileName);
        StructuredTextEditor editor = TestJSPContentAssistComputers.getEditor(file);
        StructuredTextViewer viewer = editor.getTextViewer();
        int offset = viewer.getDocument().getLineOffset(lineNum) + lineRelativeCharOffset;
        ICompletionProposal[][] pages = TestJSPContentAssistComputers.getProposals(viewer, offset, expectedProposalCounts.length);
        TestJSPContentAssistComputers.verifyProposalCounts(pages, expectedProposalCounts);
    }

    private static ICompletionProposal[][] getProposals(StructuredTextViewer viewer, int offset, int pageCount) throws Exception {
        StructuredTextViewerConfigurationJSP configuration = new StructuredTextViewerConfigurationJSP();
        ContentAssistant contentAssistant = (ContentAssistant)configuration.getContentAssistant((ISourceViewer)viewer);
        viewer.configure((SourceViewerConfiguration)configuration);
        viewer.setSelectedRange(offset, 0);
        String partitionTypeID = viewer.getDocument().getPartition(offset).getType();
        IContentAssistProcessor processor = contentAssistant.getContentAssistProcessor(partitionTypeID);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.text.contentassist.ContentAssistant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Method privateFireSessionBeginEventMethod = clazz.getDeclaredMethod("fireSessionBeginEvent", Boolean.TYPE);
        privateFireSessionBeginEventMethod.setAccessible(true);
        privateFireSessionBeginEventMethod.invoke((Object)contentAssistant, Boolean.TRUE);
        ICompletionProposal[][] pages = new ICompletionProposal[pageCount][];
        int p = 0;
        while (p < pageCount) {
            pages[p] = processor.computeCompletionProposals((ITextViewer)viewer, offset);
            ++p;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jface.text.contentassist.ContentAssistant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Method privateFireSessionEndEventMethod = clazz2.getDeclaredMethod("fireSessionEndEvent", null);
        privateFireSessionEndEventMethod.setAccessible(true);
        privateFireSessionEndEventMethod.invoke((Object)contentAssistant, null);
        return pages;
    }

    private static void verifyProposalCounts(ICompletionProposal[][] pages, int[] expectedProposalCounts) {
        StringBuffer error = new StringBuffer();
        int page = 0;
        while (page < expectedProposalCounts.length) {
            if (expectedProposalCounts[page] > pages[page].length) {
                error.append("\nProposal page " + page + " did not have the expected number of proposals: was " + pages[page].length + " expected " + expectedProposalCounts[page]);
            }
            ++page;
        }
        if (error.length() > 0) {
            Assert.fail((String)error.toString());
        }
    }

    private static IFile getFile(String name) {
        IFile file = fProject.getFile("WebContent/" + name);
        TestJSPContentAssistComputers.assertTrue((String)("Test file " + file + " can not be found"), (boolean)file.exists());
        return file;
    }

    private static StructuredTextEditor getEditor(IFile file) {
        StructuredTextEditor editor = (StructuredTextEditor)fFileToEditorMap.get(file);
        if (editor == null) {
            try {
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = workbenchWindow.getActivePage();
                IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true, (boolean)true);
                if (editorPart instanceof MultiPageEditorPart) {
                    MultiPageEditorPart xmlEditorPart = (MultiPageEditorPart)editorPart;
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = class$2 = Class.forName("org.eclipse.wst.sse.ui.StructuredTextEditor");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    editor = (StructuredTextEditor)xmlEditorPart.getAdapter((Class)clazz);
                } else if (editorPart instanceof StructuredTextEditor) {
                    editor = (StructuredTextEditor)editorPart;
                } else {
                    TestJSPContentAssistComputers.fail((String)("Unable to open structured text editor: " + editorPart.getClass().getName()));
                }
                if (editor != null) {
                    TestJSPContentAssistComputers.standardizeLineEndings(editor);
                    fFileToEditorMap.put(file, editor);
                } else {
                    TestJSPContentAssistComputers.fail((String)("Could not open editor for " + file));
                }
            }
            catch (Exception e) {
                TestJSPContentAssistComputers.fail((String)("Could not open editor for " + file + " exception: " + e.getMessage()));
            }
        }
        return editor;
    }

    private static void standardizeLineEndings(StructuredTextEditor editor) {
        IDocument doc = editor.getTextViewer().getDocument();
        String contents = doc.get();
        contents = StringUtils.replace((String)contents, (String)"\r\n", (String)"\n");
        contents = StringUtils.replace((String)contents, (String)"\r", (String)"\n");
        doc.set(contents);
    }

    private static class TestJSPContentAssistComputersSetup
    extends TestSetup {
        private static final String WTP_AUTOTEST_NONINTERACTIVE = "wtp.autotest.noninteractive";
        private static String previousWTPAutoTestNonInteractivePropValue = null;

        public TestJSPContentAssistComputersSetup(Test test) {
            super(test);
        }

        public void setUp() throws Exception {
            String noninteractive = System.getProperty(WTP_AUTOTEST_NONINTERACTIVE);
            previousWTPAutoTestNonInteractivePropValue = noninteractive != null ? noninteractive : "false";
            System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, "true");
            ProjectUnzipUtility fProjUtil = new ProjectUnzipUtility();
            Location platformLocation = Platform.getInstanceLocation();
            if (platformLocation != null) {
                File zipFile = FileUtil.makeFileFor("projecttestfiles", "TestJSPContentAssistComputers.zip", "projecttestfiles");
                fProjUtil.unzipAndImport(zipFile, platformLocation.getURL().getPath());
                fProjUtil.initJavaProject(TestJSPContentAssistComputers.PROJECT_NAME);
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                fProject = root.getProject(TestJSPContentAssistComputers.PROJECT_NAME);
            }
        }

        public void tearDown() throws Exception {
            Iterator iter = fFileToEditorMap.values().iterator();
            while (iter.hasNext()) {
                StructuredTextEditor editor = (StructuredTextEditor)iter.next();
                editor.getSite().getPage().saveEditor((IEditorPart)editor, false);
                editor.getSite().getPage().closeEditor((IEditorPart)editor, false);
            }
            if (previousWTPAutoTestNonInteractivePropValue != null) {
                System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, previousWTPAutoTestNonInteractivePropValue);
            }
        }
    }
}

