/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.test.internal.registry;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.validation.test.BVTValidationPlugin;
import org.eclipse.jst.validation.test.internal.registry.ITestcaseMetaData;

public final class TestcaseUtility {
    public static IProject findProject(ITestcaseMetaData tmd) {
        if (tmd == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(tmd.getProjectName());
    }

    public static String getInputDir(ITestcaseMetaData tmd) {
        block4: {
            IPluginRegistry registry = Platform.getPluginRegistry();
            IPluginDescriptor descriptor = registry.getPluginDescriptor(tmd.getDeclaringPluginId());
            if (descriptor != null) {
                try {
                    File inputDir;
                    String pluginXmlPath = Platform.asLocalURL((URL)new URL(descriptor.getInstallURL(), "plugin.xml")).getPath();
                    File pluginXml = new File(pluginXmlPath);
                    if (pluginXml.exists() && (inputDir = new File(pluginXml.getParent(), "testInput")).exists() && inputDir.isDirectory()) {
                        return inputDir.getPath();
                    }
                }
                catch (IOException exc) {
                    Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                    if (!logger.isLoggingLevel(Level.SEVERE)) break block4;
                    logger.write(Level.SEVERE, (Exception)exc);
                }
            }
        }
        return System.getProperty("user.dir");
    }

    public static void flush(String logFileName, String buffer, boolean append) {
        block2: {
            try {
                FileWriter writer = new FileWriter(logFileName, append);
                writer.write(buffer);
                writer.close();
            }
            catch (IOException exc) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block2;
                logger.write(Level.SEVERE, (Exception)exc);
            }
        }
    }
}

