/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.test.junit;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.validation.test.internal.registry.OperationTestcase;
import org.eclipse.jst.validation.test.internal.registry.TestcaseUtility;
import org.eclipse.jst.validation.test.internal.util.BVTRunner;
import org.eclipse.jst.validation.test.junit.JUnitBuffer;
import org.eclipse.jst.validation.test.junit.OperationSuite;

public class OperationTest
extends TestCase {
    private OperationSuite _suite = null;
    private OperationTestcase _tmd = null;

    public OperationTest(OperationTestcase tmd, OperationSuite suite) {
        super(tmd.getName());
        this._tmd = tmd;
        this._suite = suite;
    }

    public JUnitBuffer getBuffer() {
        return this._suite.getBuffer();
    }

    public String toString() {
        return this._tmd.getName();
    }

    protected void runTest() throws Throwable {
        try {
            IProject project = TestcaseUtility.findProject(this._tmd);
            if (!(project != null && project.exists() || BVTRunner.singleton().setupTests(this.getBuffer(), this._tmd, false))) {
                OperationTest.fail((String)("Could not import input from directory " + TestcaseUtility.getInputDir(this._tmd)));
            }
            if (!project.isAccessible()) {
                OperationTest.fail((String)("Project " + project.getName() + " is not accessible."));
            }
            this._tmd.run(this.getBuffer(), project);
            if (!this.getBuffer().isSuccessful(this._tmd.getName())) {
                OperationTest.fail((String)(String.valueOf(this._tmd.getName()) + " failed. Read the log for details. " + this.getBuffer().getLogFileName()));
            }
        }
        finally {
            this.getBuffer().delineate(this._tmd.getName());
        }
    }
}

