/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.appconfig;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigManager;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.IJSFAppConfigManager;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.JSFAppConfigManagerFactory;
import org.eclipse.jst.jsf.core.tests.appconfig.TestJSFAppConfigManagerFactory;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;

public class JSFAppConfigManagerFactoryTests
extends TestCase {
    WebProjectTestEnvironment projectTestEnvironment;
    JDTTestEnvironment jdtTestEnv;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.us.oracle.com", (String)"80");
        this.projectTestEnvironment = new WebProjectTestEnvironment("JSFAppConfigManagerFactoryTests_" + this.getName());
        boolean created = this.projectTestEnvironment.createProject(true);
        JSFAppConfigManagerFactoryTests.assertNotNull((Object)this.projectTestEnvironment);
        JSFAppConfigManagerFactoryTests.assertNotNull((Object)this.projectTestEnvironment.getTestProject());
        JSFAppConfigManagerFactoryTests.assertTrue((boolean)this.projectTestEnvironment.getTestProject().isAccessible());
        if (created) {
            JSFFacetedTestEnvironment jsfFacedEnv = new JSFFacetedTestEnvironment(this.projectTestEnvironment);
            jsfFacedEnv.initialize("1.1");
        }
    }

    public void testDefaultJSFAppConfigManagerSetup() {
        IJSFAppConfigManager mgr = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance((IProject)this.projectTestEnvironment.getTestProject());
        JSFAppConfigManagerFactoryTests.assertNotNull((Object)mgr);
        JSFAppConfigManagerFactoryTests.assertEquals((String)"org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigManager", (String)mgr.getClass().getName());
        IJSFAppConfigManager mgr2 = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance((IProject)this.projectTestEnvironment.getTestProject());
        JSFAppConfigManagerFactoryTests.assertNotNull((Object)mgr2);
        JSFAppConfigManagerFactoryTests.assertEquals((Object)mgr, (Object)mgr2);
        JSFAppConfigManager mgr3 = JSFAppConfigManager.getInstance((IProject)this.projectTestEnvironment.getTestProject());
        JSFAppConfigManagerFactoryTests.assertNotNull((Object)mgr3);
        JSFAppConfigManagerFactoryTests.assertEquals((Object)mgr, (Object)mgr3);
        JSFAppConfigManagerFactoryTests.assertNotNull((Object)mgr3.getManagedBeans());
    }

    public void testTestableJSFAppConfigManagerSetup() throws Exception {
        this.projectTestEnvironment.getTestProject().setSessionProperty(JSFAppConfigManagerFactory.TESTABLE_FACTORY_SESSION_KEY, (Object)new TestJSFAppConfigManagerFactory());
        IJSFAppConfigManager mgr = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance((IProject)this.projectTestEnvironment.getTestProject());
        JSFAppConfigManagerFactoryTests.assertNotNull((Object)mgr);
        JSFAppConfigManagerFactoryTests.assertEquals((String)"TestJSFAppConfigManager", (String)mgr.getClass().getSimpleName());
        JSFAppConfigManagerFactoryTests.assertNotNull((Object)mgr.getManagedBeans());
        JSFAppConfigManagerFactoryTests.assertEquals((int)10, (int)mgr.getManagedBeans().size());
        ManagedBeanType bean = (ManagedBeanType)mgr.getManagedBeans().get(0);
        JSFAppConfigManagerFactoryTests.assertTrue((boolean)bean.getManagedBeanName().getTextContent().contains("MyManagedBean"));
        JSFAppConfigManagerFactoryTests.assertTrue((boolean)bean.getManagedBeanClass().getTextContent().contains("com.foo.MyManagedBeanClass"));
        IJSFAppConfigManager mgr2 = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance((IProject)this.projectTestEnvironment.getTestProject());
        JSFAppConfigManagerFactoryTests.assertNotNull((Object)mgr2);
        JSFAppConfigManagerFactoryTests.assertEquals((Object)mgr, (Object)mgr2);
    }
}

