/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.facet;

import junit.framework.TestCase;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.jsf.core.tests.facet.UserLibraryVersionValidatorProxy;

public abstract class LibraryValidatorTest
extends TestCase {
    private String classNameIdentifyingJarToUse;
    private UserLibraryVersionValidatorProxy validator;

    public LibraryValidatorTest(String name) {
        super(name);
    }

    public LibraryValidatorTest(String name, String classNameIdentifyingJarToUse) {
        super(name);
        this.classNameIdentifyingJarToUse = classNameIdentifyingJarToUse;
        this.validator = new UserLibraryVersionValidatorProxy(this.classNameIdentifyingJarToUse);
    }

    public void testVersionStringSuffixMatch() {
        LibraryValidatorTest.assertNotNull((Object)((Object)this.validator));
        IStatus status = this.validator.validateVersionStrings("1.2", "1.1.2");
        LibraryValidatorTest.assertEquals((int)2, (int)status.getSeverity());
    }

    public void testVersionStringPrefixMatch() {
        LibraryValidatorTest.assertNotNull((Object)((Object)this.validator));
        IStatus status = this.validator.validateVersionStrings("1.2", "1.2.11");
        LibraryValidatorTest.assertEquals((int)0, (int)status.getSeverity());
    }

    public void testNullLibraryVersionString() {
        LibraryValidatorTest.assertNotNull((Object)((Object)this.validator));
        IStatus status = this.validator.validateVersionStrings("1.2", null);
        LibraryValidatorTest.assertEquals((int)2, (int)status.getSeverity());
    }

    public void testNullFacetVersionString() {
        LibraryValidatorTest.assertNotNull((Object)((Object)this.validator));
        try {
            this.validator.validateVersionStrings(null, "1.0.1.2.11");
        }
        catch (IllegalArgumentException e) {
            LibraryValidatorTest.assertEquals((String)"Cannot read facet version", (String)e.getLocalizedMessage());
            return;
        }
        LibraryValidatorTest.fail();
    }
}

