/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.resource;

import java.util.ArrayList;
import java.util.Collections;
import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.jst.jsf.common.internal.resource.ILifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.LifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ResourceLifecycleEvent;
import org.eclipse.jst.jsf.core.tests.resource.MyTestListener;
import org.eclipse.jst.jsf.test.util.junit4.DualModeEnvironment;
import org.eclipse.jst.jsf.test.util.junit4.WorkspaceContext;
import org.eclipse.jst.jsf.test.util.junit4.WorkspaceRunner;
import org.eclipse.jst.jsf.test.util.mock.IWorkspaceContext;
import org.eclipse.jst.jsf.test.util.mock.IWorkspaceContextWithEvents;
import org.eclipse.jst.jsf.test.util.mock.MockResourceChangeEventFactory;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=WorkspaceRunner.class)
@Category(value={DualModeEnvironment.class})
public class FastLifecycleListenerTests_Scenario {
    @WorkspaceContext
    private IWorkspaceContextWithEvents _wsContext;
    private MockResourceChangeEventFactory _factory;
    private IProject _project;
    private IFile _file;
    private IFolder _folderInProject;
    private IFolder _folderInFolder;

    @Before
    public void setUp() throws Exception {
        this._project = this._wsContext.createProject("SomeTestProject");
        this._folderInProject = this._project.getFolder("/folder");
        this._folderInFolder = this._project.getFolder("/folder/folderInFolder");
        this._file = this._project.getFile("/folder/myfile.txt");
        this._factory = new MockResourceChangeEventFactory((IWorkspaceContext)this._wsContext);
    }

    @Test
    public void testAddFile() {
        LifecycleListener listener = new LifecycleListener(this._wsContext.getWorkspace());
        MyTestListener tester = new MyTestListener(this._wsContext, listener);
        IResourceChangeEvent event = this._factory.createSimpleFileAdded(this._file);
        tester.fireAndExpectNull(event);
        listener.addResource((IResource)this._file);
        tester.fireAndExpect(event, (IResource)this._file, ResourceLifecycleEvent.EventType.RESOURCE_ADDED, ResourceLifecycleEvent.ReasonType.RESOURCE_ADDED);
        listener.removeResource((IResource)this._file);
        listener.addResource((IResource)this._file.getParent());
        tester.fireAndExpect(event, (IResource)this._file, ResourceLifecycleEvent.EventType.RESOURCE_ADDED, ResourceLifecycleEvent.ReasonType.RESOURCE_ADDED_TO_CONTAINER);
        listener.removeListener((ILifecycleListener)tester);
        tester.fireAndExpectNull(event);
    }

    @Test
    public void testRemoveFile() {
        LifecycleListener listener = new LifecycleListener(this._wsContext.getWorkspace());
        MyTestListener tester = new MyTestListener(this._wsContext, listener);
        IResourceChangeEvent event = this._factory.createSimpleFileRemove(this._file);
        tester.fireAndExpectNull(event);
        listener.addResource((IResource)this._file);
        tester.fireAndExpect(event, (IResource)this._file, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_DELETED);
        listener.removeResource((IResource)this._file);
        listener.addResource((IResource)this._file.getParent());
        tester.fireAndExpect(event, (IResource)this._file, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_DELETED_FROM_CONTAINER);
        listener.removeListener((ILifecycleListener)tester);
        tester.fireAndExpectNull(event);
    }

    @Test
    public void testAddFolderToProject() {
        Assert.assertEquals((Object)this._project, (Object)this._folderInProject.getParent());
        this.verifyAddFolderTo(this._folderInProject);
    }

    @Test
    public void testAddFolderToFolder() {
        this.verifyAddFolderTo(this._folderInFolder);
    }

    public void verifyAddFolderTo(IFolder folder) {
        LifecycleListener listener = new LifecycleListener(this._wsContext.getWorkspace());
        MyTestListener tester = new MyTestListener(this._wsContext, listener);
        IResourceChangeEvent event = this._factory.createSimpleFolderAdded(folder);
        tester.fireAndExpectNull(event);
        listener.addResource((IResource)folder);
        tester.fireAndExpect(event, (IResource)folder, ResourceLifecycleEvent.EventType.RESOURCE_ADDED, ResourceLifecycleEvent.ReasonType.RESOURCE_ADDED);
        listener.removeResource((IResource)folder);
        listener.addResource((IResource)folder.getParent());
        tester.fireAndExpect(event, (IResource)folder, ResourceLifecycleEvent.EventType.RESOURCE_ADDED, ResourceLifecycleEvent.ReasonType.RESOURCE_ADDED_TO_CONTAINER);
        listener.removeListener((ILifecycleListener)tester);
        tester.fireAndExpectNull(event);
    }

    @Test
    public void testRemoveFolderFromProject() {
        this.verifyRemoveFolderFrom(this._folderInProject);
    }

    @Test
    public void testRemoveFolderFromFolder() {
        this.verifyRemoveFolderFrom(this._folderInFolder);
    }

    public void verifyRemoveFolderFrom(IFolder folder) {
        LifecycleListener listener = new LifecycleListener(this._wsContext.getWorkspace());
        MyTestListener tester = new MyTestListener(this._wsContext, listener);
        IResourceChangeEvent event = this._factory.createSimpleFolderDeleted(folder);
        tester.fireAndExpectNull(event);
        listener.addResource((IResource)folder);
        tester.fireAndExpect(event, (IResource)folder, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_DELETED);
        listener.removeResource((IResource)folder);
        listener.addResource((IResource)folder.getParent());
        tester.fireAndExpect(event, (IResource)folder, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_DELETED_FROM_CONTAINER);
        listener.removeListener((ILifecycleListener)tester);
        tester.fireAndExpectNull(event);
    }

    @Test
    public void testRenameFolderInProject() {
        this.verifyRenameFolder(this._folderInProject);
    }

    @Test
    public void testRenameFolderInFolder() {
        this.verifyRenameFolder(this._folderInFolder);
    }

    private void verifyRenameFolder(IFolder folder) {
        LifecycleListener listener = new LifecycleListener(this._wsContext.getWorkspace());
        MyTestListener tester = new MyTestListener(this._wsContext, listener);
        IFolder newFolder = this._project.getFolder(folder.getProjectRelativePath().removeLastSegments(1).append("NewFolderName"));
        IResourceChangeEvent event = this._factory.createSimpleFolderRename(folder, newFolder);
        tester.fireAndExpectNull(event);
        MyTestListener.EventData oldFolderChange = new MyTestListener.EventData((IResource)folder, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_MOVED);
        listener.addResource((IResource)folder);
        tester.fireAndExpect(event, Collections.singletonList(oldFolderChange));
        listener.removeResource((IResource)folder);
        ArrayList<MyTestListener.EventData> eventData = new ArrayList<MyTestListener.EventData>();
        eventData.add(new MyTestListener.EventData((IResource)folder, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_MOVED_CONTAINER));
        eventData.add(new MyTestListener.EventData((IResource)newFolder, ResourceLifecycleEvent.EventType.RESOURCE_ADDED, ResourceLifecycleEvent.ReasonType.RESOURCE_MOVED_CONTAINER));
        listener.addResource((IResource)folder.getParent());
        tester.fireAndExpect(event, eventData);
        listener.removeListener((ILifecycleListener)tester);
        tester.fireAndExpectNull(event);
    }

    @Test
    public void testRenameFile() {
        this.verifyRenameFile(this._file);
    }

    private void verifyRenameFile(IFile file) {
        ArrayList<MyTestListener.EventData> eventData = new ArrayList<MyTestListener.EventData>();
        LifecycleListener listener = new LifecycleListener(this._wsContext.getWorkspace());
        MyTestListener tester = new MyTestListener(this._wsContext, listener);
        IFile newFile = this._project.getFile(file.getProjectRelativePath().removeLastSegments(1).append("NewFileName"));
        IResourceChangeEvent event = this._factory.createSimpleFileRename(file, newFile);
        tester.fireAndExpectNull(event);
        MyTestListener.EventData oldFileChange = new MyTestListener.EventData((IResource)file, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_MOVED);
        listener.addResource((IResource)file);
        eventData.add(oldFileChange);
        tester.fireAndExpect(event, eventData);
        listener.addResource((IResource)newFile);
        eventData.add(new MyTestListener.EventData((IResource)newFile, ResourceLifecycleEvent.EventType.RESOURCE_ADDED, ResourceLifecycleEvent.ReasonType.RESOURCE_MOVED));
        tester.fireAndExpect(event, eventData);
        listener.removeResource((IResource)file);
        listener.removeResource((IResource)newFile);
        eventData.clear();
        eventData.add(new MyTestListener.EventData((IResource)file, ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE, ResourceLifecycleEvent.ReasonType.RESOURCE_MOVED_CONTAINER));
        eventData.add(new MyTestListener.EventData((IResource)newFile, ResourceLifecycleEvent.EventType.RESOURCE_ADDED, ResourceLifecycleEvent.ReasonType.RESOURCE_MOVED_CONTAINER));
        listener.addResource((IResource)file.getParent());
        tester.fireAndExpect(event, eventData);
        listener.removeListener((ILifecycleListener)tester);
        tester.fireAndExpectNull(event);
    }
}

