/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.resource;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.jsf.common.internal.resource.EventResult;
import org.eclipse.jst.jsf.common.internal.resource.ILifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.IResourceLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.LifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ResourceLifecycleEvent;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;
import org.eclipse.jst.jsf.core.tests.resource.MockListener;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestLifecycleListener
extends TestCase {
    private WebProjectTestEnvironment _webProjectTestEnv;
    private IResource _res1;
    private IResource _res2;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        this._webProjectTestEnv = new WebProjectTestEnvironment(String.valueOf(((Object)((Object)this)).getClass().getName()) + "_" + this.getName());
        this._webProjectTestEnv.createProject(false);
        TestLifecycleListener.assertNotNull((Object)this._webProjectTestEnv);
        TestLifecycleListener.assertNotNull((Object)this._webProjectTestEnv.getTestProject());
        TestLifecycleListener.assertTrue((boolean)this._webProjectTestEnv.getTestProject().isAccessible());
        this._res1 = this._webProjectTestEnv.loadResourceInWebRoot(TestsPlugin.getDefault().getBundle(), "/testfiles/jsps/testdata1.jsp.data", "/testdata1.jsp");
        this._res2 = this._webProjectTestEnv.loadResourceInWebRoot(TestsPlugin.getDefault().getBundle(), "/testfiles/jsps/testdata1.jsp.data", "/testdata2.jsp");
    }

    private void testInaccessibleCondition(IResource res, Runnable runnable, ResourceLifecycleEvent.ReasonType reason) {
        TestLifecycleListener.assertTrue((boolean)res.isAccessible());
        LifecycleListener testListener = new LifecycleListener(res, ResourcesPlugin.getWorkspace());
        MockListener mockListener = new MockListener();
        testListener.addListener((ILifecycleListener)mockListener);
        runnable.run();
        mockListener.assertAcceptedResourceInaccessible(res, reason);
        TestLifecycleListener.assertFalse((boolean)res.isAccessible());
        testListener.removeListener((ILifecycleListener)mockListener);
        testListener.dispose();
    }

    private void testInaccessibleConditionMultiple(List<IResource> resources, Runnable runnable, List<ResourceLifecycleEvent.ReasonType> reasons) {
        TestLifecycleListener.assertEquals((int)resources.size(), (int)reasons.size());
        for (IResource res : resources) {
            TestLifecycleListener.assertTrue((boolean)res.isAccessible());
        }
        LifecycleListener testListener = new LifecycleListener(resources, ResourcesPlugin.getWorkspace());
        MockListener mockListener = new MockListener();
        testListener.addListener((ILifecycleListener)mockListener);
        runnable.run();
        int i = 0;
        while (i < resources.size()) {
            IResource res = resources.get(i);
            ResourceLifecycleEvent.ReasonType reason = reasons.get(i);
            mockListener.assertAcceptedResourceInaccessible(res, reason);
            TestLifecycleListener.assertFalse((boolean)res.isAccessible());
            ++i;
        }
        testListener.removeListener((ILifecycleListener)mockListener);
        testListener.dispose();
    }

    public void testProjectClosedForProject() throws Exception {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    TestLifecycleListener.this._webProjectTestEnv.getTestProject().close(null);
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.testInaccessibleCondition((IResource)this._webProjectTestEnv.getTestProject(), runnable, ResourceLifecycleEvent.ReasonType.RESOURCE_PROJECT_CLOSED);
    }

    public void testProjectClosedForContainedResource() throws Exception {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    TestLifecycleListener.this._webProjectTestEnv.getTestProject().close(null);
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.testInaccessibleCondition(this._res1, runnable, ResourceLifecycleEvent.ReasonType.RESOURCE_PROJECT_CLOSED);
    }

    public void testProjectDeletedForProject() throws Exception {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    TestLifecycleListener.this._webProjectTestEnv.getTestProject().delete(true, null);
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.testInaccessibleCondition((IResource)this._webProjectTestEnv.getTestProject(), runnable, ResourceLifecycleEvent.ReasonType.RESOURCE_DELETED);
    }

    public void testProjectDeletedForContainedResource() throws Exception {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    TestLifecycleListener.this._webProjectTestEnv.getTestProject().delete(true, null);
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.testInaccessibleCondition(this._res1, runnable, ResourceLifecycleEvent.ReasonType.RESOURCE_PROJECT_DELETED);
    }

    public void testResourceDeleted() throws Exception {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    TestLifecycleListener.this._res1.delete(true, null);
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.testInaccessibleCondition(this._res1, runnable, ResourceLifecycleEvent.ReasonType.RESOURCE_DELETED);
    }

    public void testMultipleResourcesDeleted() throws Exception {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    TestLifecycleListener.this._res1.delete(true, null);
                    TestLifecycleListener.this._res2.delete(true, null);
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        ArrayList<IResource> resources = new ArrayList<IResource>();
        resources.add(this._res1);
        resources.add(this._res2);
        ArrayList<ResourceLifecycleEvent.ReasonType> reasons = new ArrayList<ResourceLifecycleEvent.ReasonType>();
        reasons.add(ResourceLifecycleEvent.ReasonType.RESOURCE_DELETED);
        reasons.add(ResourceLifecycleEvent.ReasonType.RESOURCE_DELETED);
        this.testInaccessibleConditionMultiple(resources, runnable, reasons);
    }

    public void testMultipleResourcesProjectClosed() throws Exception {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    TestLifecycleListener.this._res1.getProject().close(null);
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        ArrayList<IResource> resources = new ArrayList<IResource>();
        resources.add(this._res1);
        resources.add(this._res2);
        ArrayList<ResourceLifecycleEvent.ReasonType> reasons = new ArrayList<ResourceLifecycleEvent.ReasonType>();
        reasons.add(ResourceLifecycleEvent.ReasonType.RESOURCE_PROJECT_CLOSED);
        reasons.add(ResourceLifecycleEvent.ReasonType.RESOURCE_PROJECT_CLOSED);
        this.testInaccessibleConditionMultiple(resources, runnable, reasons);
    }

    public void testAddResource() throws Exception {
        TestLifecycleListener.assertTrue((boolean)this._res1.isAccessible());
        TestLifecycleListener.assertTrue((boolean)this._res2.isAccessible());
        LifecycleListener testListener = new LifecycleListener(this._res1, ResourcesPlugin.getWorkspace());
        MockListener mockListener = new MockListener();
        testListener.addListener((ILifecycleListener)mockListener);
        testListener.addResource(this._res2);
        this._res1.getProject().close(null);
        mockListener.assertAcceptedResourceInaccessible(this._res1, ResourceLifecycleEvent.ReasonType.RESOURCE_PROJECT_CLOSED);
        mockListener.assertAcceptedResourceInaccessible(this._res2, ResourceLifecycleEvent.ReasonType.RESOURCE_PROJECT_CLOSED);
        TestLifecycleListener.assertFalse((boolean)this._res1.isAccessible());
        TestLifecycleListener.assertFalse((boolean)this._res2.isAccessible());
        testListener.removeListener((ILifecycleListener)mockListener);
        testListener.dispose();
    }

    public void testAddRemoveResource() throws Exception {
        TestLifecycleListener.assertTrue((boolean)this._res1.isAccessible());
        TestLifecycleListener.assertTrue((boolean)this._res2.isAccessible());
        LifecycleListener testListener = new LifecycleListener(this._res1, ResourcesPlugin.getWorkspace());
        MockListener mockListener = new MockListener();
        testListener.addListener((ILifecycleListener)mockListener);
        testListener.addResource(this._res2);
        testListener.removeResource(this._res1);
        this._res1.getProject().close(null);
        mockListener.assertNoAcceptedResourceInaccessible(this._res1, ResourceLifecycleEvent.ReasonType.RESOURCE_PROJECT_CLOSED);
        mockListener.assertAcceptedResourceInaccessible(this._res2, ResourceLifecycleEvent.ReasonType.RESOURCE_PROJECT_CLOSED);
        TestLifecycleListener.assertFalse((boolean)this._res1.isAccessible());
        TestLifecycleListener.assertFalse((boolean)this._res2.isAccessible());
        testListener.removeListener((ILifecycleListener)mockListener);
        testListener.dispose();
    }

    public void testRemoveListenerResource() throws Exception {
        TestLifecycleListener.assertTrue((boolean)this._res1.isAccessible());
        TestLifecycleListener.assertTrue((boolean)this._res2.isAccessible());
        LifecycleListener testListener = new LifecycleListener(this._res1, ResourcesPlugin.getWorkspace());
        testListener.addResource(this._res2);
        MockListener mockListener = new MockListener();
        MockListener mockListener2 = new MockListener();
        testListener.addListener((ILifecycleListener)mockListener);
        testListener.addListener((ILifecycleListener)mockListener2);
        this._res1.delete(true, null);
        mockListener.assertAcceptedResourceInaccessible(this._res1, ResourceLifecycleEvent.ReasonType.RESOURCE_DELETED);
        mockListener2.assertAcceptedResourceInaccessible(this._res1, ResourceLifecycleEvent.ReasonType.RESOURCE_DELETED);
        TestLifecycleListener.assertFalse((boolean)this._res1.isAccessible());
        testListener.removeListener((ILifecycleListener)mockListener2);
        this._res2.delete(true, null);
        mockListener.assertAcceptedResourceInaccessible(this._res2, ResourceLifecycleEvent.ReasonType.RESOURCE_DELETED);
        mockListener2.assertNoAcceptedResourceInaccessible(this._res2, ResourceLifecycleEvent.ReasonType.RESOURCE_DELETED);
        TestLifecycleListener.assertFalse((boolean)this._res2.isAccessible());
        testListener.removeListener((ILifecycleListener)mockListener);
        testListener.dispose();
    }

    public void testResourceChangedEvent() throws Exception {
        TestLifecycleListener.assertTrue((boolean)this._res1.isAccessible());
        TestLifecycleListener.assertTrue((boolean)this._res2.isAccessible());
        LifecycleListener testListener = new LifecycleListener(this._res1, ResourcesPlugin.getWorkspace());
        testListener.addResource(this._res2);
        MockListener mockListener = new MockListener();
        testListener.addListener((ILifecycleListener)mockListener);
        this._res1.touch(null);
        mockListener.assertAcceptedEvent(this._res1, ResourceLifecycleEvent.EventType.RESOURCE_CHANGED, ResourceLifecycleEvent.ReasonType.RESOURCE_CHANGED_CONTENTS);
        testListener.removeListener((ILifecycleListener)mockListener);
        testListener.dispose();
    }

    public void testDisposeAfterEvent() throws Exception {
        LifecycleListener testListener = new LifecycleListener(this._res1, ResourcesPlugin.getWorkspace());
        MockListenerThatDoesDispose mockListener = new MockListenerThatDoesDispose();
        testListener.addListener((ILifecycleListener)mockListener);
        this._res1.delete(true, null);
        TestLifecycleListener.assertTrue((boolean)testListener.isDisposed());
        boolean caughtAssertion = false;
        try {
            testListener.addListener((ILifecycleListener)mockListener);
        }
        catch (IllegalStateException illegalStateException) {
            caughtAssertion = true;
        }
        TestLifecycleListener.assertTrue((boolean)caughtAssertion);
    }

    private class MockListenerThatDoesDispose
    implements IResourceLifecycleListener {
        private MockListenerThatDoesDispose() {
        }

        public EventResult acceptEvent(ResourceLifecycleEvent event) {
            EventResult result = EventResult.getDisposeAfterEventResult();
            return result;
        }
    }
}

