/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.test;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ArchiveTypeDiscriminatorRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.GenericArchiveTypeDiscriminator;
import org.eclipse.jst.j2ee.core.tests.bvt.AutomatedBVT;

public class DiscriminatorTest
extends TestCase {
    public boolean assertBarFile = false;

    public DiscriminatorTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("DiscriminatorTest");
        suite.addTest((Test)new DiscriminatorTest("testDiscriminator"));
        return suite;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDiscriminator() throws Exception {
        this.assertBarFile = true;
        try {
            ArchiveTypeDiscriminatorRegistry.registorDiscriminator((GenericArchiveTypeDiscriminator)new BeverageArchiveDiscriminator());
            Archive archive = CommonarchiveFactory.eINSTANCE.openArchive(String.valueOf(AutomatedBVT.baseDirectory) + File.separator + "my.bar");
            DiscriminatorTest.assertNotNull((String)"The archive was not found!", (Object)archive);
            DiscriminatorTest.assertTrue((String)"The archive extension (.bar) was not recognized as a custom extension!", (boolean)archive.isNestedArchive("my.bar"));
            boolean typeContributedSuccessfully = false;
            EList types = archive.getTypes();
            int i = 0;
            while (i < types.size()) {
                if (types.get(i).equals("com.ibm.beverage.archive")) {
                    typeContributedSuccessfully = true;
                    break;
                }
                ++i;
            }
            DiscriminatorTest.assertTrue((String)"The BEVERAGE_ARCHIVE_TYPE_KEY was not found in the list of types of the archive!", (boolean)typeContributedSuccessfully);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.assertBarFile = false;
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.assertBarFile = false;
            return;
        }
    }

    public class BeverageArchiveDiscriminator
    extends TestCase
    implements GenericArchiveTypeDiscriminator {
        public static final String BEVERAGE_ARCHIVE_TYPE_KEY = "com.ibm.beverage.archive";

        public boolean discriminate(Archive anArchive) {
            boolean result = anArchive.containsFile("META-INF/adult-beverage-imbibement-options.xml");
            if (DiscriminatorTest.this.assertBarFile) {
                BeverageArchiveDiscriminator.assertTrue((String)"The BeverageArchiveDiscriminator did not recogniZe the file! (Ensure it contains a file named META-INF/adult-beverage-imbibement-venues.xml)", (boolean)result);
            }
            return result;
        }

        public String[] getCustomFileExtensions() {
            return new String[]{"bar"};
        }

        public String getTypeKey() {
            return BEVERAGE_ARCHIVE_TYPE_KEY;
        }
    }
}

