/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.tests.providers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.common.snippets.internal.SnippetsPlugin;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteDrawerFactory;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteItem;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteRoot;
import org.eclipse.wst.common.snippets.internal.ui.SnippetsView;
import org.eclipse.wst.common.snippets.ui.TextSnippetProvider;

public class TextProviderTests
extends TestCase {
    private IFile file;

    protected void setUp() throws Exception {
        super.setUp();
        String projectName = String.valueOf(System.currentTimeMillis());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            project.create((IProgressMonitor)new NullProgressMonitor());
        }
        if (!project.isOpen()) {
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        this.file = project.getFile("testTextSnippet.txt");
        if (!this.file.exists()) {
            ByteArrayInputStream sr = new ByteArrayInputStream("test Text Snippet Provider".getBytes());
            this.file.create((InputStream)sr, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void testTextSnippetCreation() throws Exception {
        SnippetPaletteRoot anchor = null;
        SnippetsView view = (SnippetsView)SnippetsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.wst.common.snippets.internal.ui.SnippetsView");
        if (view == null) {
            view = (SnippetsView)SnippetsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.wst.common.snippets.internal.ui.SnippetsView");
        }
        if (view != null) {
            anchor = view.getRoot();
        }
        Shell activeShell = SnippetsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        TextProviderTests.assertNotNull((String)"no active shell", (Object)activeShell);
        PaletteDrawer drawer = (PaletteDrawer)new SnippetPaletteDrawerFactory().createNewEntry(activeShell, (PaletteEntry)anchor);
        drawer.setLabel("testName");
        TextSnippetProvider textSnippetProvider = new TextSnippetProvider();
        IEditorPart openEditor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)this.file);
        TextProviderTests.assertNotNull((String)"no editor opened", (Object)openEditor);
        textSnippetProvider.setEditor(openEditor);
        SnippetPaletteItem createSnippet = textSnippetProvider.createSnippet((PaletteEntry)drawer);
        TextProviderTests.assertNotNull((String)"no SnippetPaletteItem created", (Object)createSnippet);
        ITextEditor editor = (ITextEditor)openEditor;
        editor.selectAndReveal(0, 5);
        TextProviderTests.assertFalse((String)"textSnippetProvider action is enabled with no selection", (boolean)textSnippetProvider.isActionEnabled(null));
        TextProviderTests.assertTrue((String)"textSnippetProvider action is not enabled with text selection", (boolean)textSnippetProvider.isActionEnabled(editor.getSelectionProvider().getSelection()));
        editor.selectAndReveal(0, 0);
        TextProviderTests.assertFalse((String)"textSnippetProvider action is not enabled with text selection", (boolean)textSnippetProvider.isActionEnabled(editor.getSelectionProvider().getSelection()));
    }
}

