/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.tests.updated;

import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.traittypes.traittypes.ListOfValues;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.metadata.tests.MetadataTestsPlugin;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.jst.jsp.core.internal.domdocument.DOMModelForJSP;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public abstract class AbstractBaseMetaDataTestCase
extends TestCase {
    protected static final String projName = "TestCommonMetadataProject";
    protected static final String domain = "TagLibraryDomain";
    protected static final String badDomain = "TagLibDomain";
    protected static final String baseTestUri = "http://org.eclipse.jsf/test";
    protected static final String TYPE_TAG_FILE = "tagFile";
    protected static final String TYPE_TAG = "tag";
    protected static final String TYPE_TAG_ATTRIBUTE = "attribute";
    protected IProject project;
    protected WebProjectTestEnvironment projectTestEnvironment;
    protected IStructuredDocumentContext docContext;
    private boolean debug_info = false;
    private long startTime;
    private String debugTitle;

    public void setUp() throws Exception {
        String path = "/WebContent/TestJSP.jsp";
        int offset = 33;
        super.setUp();
        this.debug_info = false;
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.us.oracle.com", (String)"80");
        JSFTestUtil.setValidationEnabled((boolean)false);
        this.projectTestEnvironment = new WebProjectTestEnvironment(projName);
        this.projectTestEnvironment.createProject(true);
        this.project = this.projectTestEnvironment.getTestProject();
        this.projectTestEnvironment.loadResourceInWebRoot(MetadataTestsPlugin.getDefault().getBundle(), "/testfiles/metadata/TestJSP.jsp", "/TestJSP.jsp");
        this.docContext = this.getDocContext(path, offset);
    }

    private IStructuredDocumentContext getDocContext(String path, int offset) throws Exception {
        IFile jspFile = this.project.getFile((IPath)new Path(path));
        AbstractBaseMetaDataTestCase.assertTrue((boolean)jspFile.exists());
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        model = modelManager.getModelForRead(jspFile);
        AbstractBaseMetaDataTestCase.assertTrue((boolean)(model instanceof DOMModelForJSP));
        return IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)model.getStructuredDocument(), offset);
    }

    protected void showDebugInfo(boolean show) {
        this.debug_info = show;
    }

    protected void dumpMDTree(Entity entity, int indent) {
        if (this.debug_info) {
            this.printLine("Entity: " + entity.getId(), indent);
            ++indent;
            for (Trait t : entity.getTraits()) {
                this.printLine("Trait: " + t.getId() + "[" + this.getValue(t) + "]", indent);
            }
            Iterator it = entity.getChildEntities().iterator();
            while (it.hasNext()) {
                this.dumpMDTree((Entity)it.next(), indent);
            }
        }
    }

    private String getValue(Trait trait) {
        if (trait.getValue() instanceof ListOfValues) {
            List l = TraitValueHelper.getValueAsListOfStrings((Trait)trait);
            StringBuffer buf = new StringBuffer();
            Iterator it = l.iterator();
            while (it.hasNext()) {
                buf.append((String)it.next());
                buf.append(", ");
            }
            if (buf.toString().length() > 0) {
                return buf.toString().substring(0, buf.toString().length() - 2);
            }
            return null;
        }
        return TraitValueHelper.getValueAsString((Trait)trait);
    }

    private void printLine(String line, int indent) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < indent) {
            buf.append("    ");
            ++i;
        }
        buf.append(line);
        System.out.println(buf.toString());
    }

    protected void endTime() {
        if (this.debug_info) {
            long delta = System.nanoTime() - this.startTime;
            this.printLine("Time for " + this.debugTitle + "(ms)= " + String.valueOf(delta / 1000000L), 0);
        }
    }

    protected void startTime(String debugTitle) {
        if (this.debug_info) {
            this.debugTitle = debugTitle;
            this.startTime = System.nanoTime();
            this.printLine("", 0);
        }
    }
}

