/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.tests.updated;

import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.query.IResultSet;
import org.eclipse.jst.jsf.common.metadata.query.MetaDataException;
import org.eclipse.jst.jsf.common.metadata.query.internal.AbstractMetaDataQuery;
import org.eclipse.jst.jsf.common.metadata.query.internal.IPredicateMatcher;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.ITaglibDomainEntityPredicateMatcher;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.ITaglibDomainMetaDataQuery;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.ITaglibDomainPredicateMatcherFactory;
import org.eclipse.jst.jsf.common.metadata.tests.updated.AbstractBaseMetaDataTestCase;
import org.junit.Before;
import org.junit.Test;

public class TaglibMetaDataQueryTests
extends AbstractBaseMetaDataTestCase {
    private ITaglibDomainMetaDataQuery _query;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        IMetaDataDomainContext context = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(this.project);
        this._query = (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(context);
        TaglibMetaDataQueryTests.assertNotNull((Object)this._query);
    }

    @Test
    public void testFindTagLibraryModel() {
        Model model = this._query.findTagLibraryModel("http://org.eclipse.jsf/test");
        TaglibMetaDataQueryTests.assertNotNull((Object)model);
        TaglibMetaDataQueryTests.assertEquals((String)"http://org.eclipse.jsf/test", (String)model.getId());
        Model model2 = this._query.findTagLibraryModel("http://org.eclipse.jsf/test");
        TaglibMetaDataQueryTests.assertNotNull((Object)model2);
        TaglibMetaDataQueryTests.assertSame((Object)model, (Object)model2);
        Model model3 = this._query.findTagLibraryModel("http://org.eclipse.jsf/test2");
        TaglibMetaDataQueryTests.assertNotNull((Object)model3);
        TaglibMetaDataQueryTests.assertNotSame((Object)model, (Object)model3);
    }

    @Test
    public void testFindTagEntity() {
        Model tagLib = this._query.findTagLibraryModel("http://org.eclipse.jsf/test");
        TaglibMetaDataQueryTests.assertNotNull((Object)tagLib);
        Entity tag = this._query.findTagEntity(tagLib, "loaded");
        TaglibMetaDataQueryTests.assertNotNull((Object)tag);
        TaglibMetaDataQueryTests.assertEquals((String)"loaded", (String)tag.getId());
    }

    @Test
    public void testFindTagAttributeEntity() {
        Model tagLib = this._query.findTagLibraryModel("http://org.eclipse.jsf/test");
        TaglibMetaDataQueryTests.assertNotNull((Object)tagLib);
        Entity tag = this._query.findTagEntity(tagLib, "loaded");
        TaglibMetaDataQueryTests.assertNotNull((Object)tag);
        Entity attr = this._query.findTagAttributeEntity(tag, "att2");
        TaglibMetaDataQueryTests.assertNotNull((Object)attr);
        TaglibMetaDataQueryTests.assertEquals((String)"att2", (String)attr.getId());
    }

    @Test
    public void testFindTrait() {
        Model tagLib = this._query.findTagLibraryModel("http://org.eclipse.jsf/test");
        TaglibMetaDataQueryTests.assertNotNull((Object)tagLib);
        Trait trait = this._query.findTrait((Entity)tagLib, "model-trait");
        TaglibMetaDataQueryTests.assertNotNull((Object)trait);
    }

    @Test
    public void testAbstractSuper() {
        TaglibMetaDataQueryTests.assertNotNull((Object)((AbstractMetaDataQuery)this._query).getManager());
        IMetaDataDomainContext context = ((AbstractMetaDataQuery)this._query).getDomainContext();
        TaglibMetaDataQueryTests.assertNotNull((Object)context);
        TaglibMetaDataQueryTests.assertEquals((String)"TagLibraryDomain", (String)context.getDomainId());
        TaglibMetaDataQueryTests.assertNotNull((Object)context.getAdapter(IProject.class));
        TaglibMetaDataQueryTests.assertSame((Object)this.project, (Object)context.getAdapter(IProject.class));
    }

    @Test
    public void testHelperAvailable() {
        TaglibMetaDataQueryTests.assertNotNull((Object)this._query.getQueryHelper());
    }

    @Test
    public void testFindModelWithQuerySpec() {
        ITaglibDomainPredicateMatcherFactory matcherFactory = MetaDataQueryContextFactory.getInstance().getTaglibDomainPredicateMatcherFactory();
        ITaglibDomainEntityPredicateMatcher matcher = matcherFactory.createTagLibraryModelMatcher("http://org.eclipse.jsf/test");
        try {
            IResultSet models = this._query.findEntities(matcher);
            TaglibMetaDataQueryTests.assertNotNull((Object)models);
            TaglibMetaDataQueryTests.assertEquals((int)1, (int)models.getResults().size());
        }
        catch (MetaDataException metaDataException) {
            TaglibMetaDataQueryTests.fail();
        }
    }

    @Test
    public void testFindSingleTagWithQuerySpec() {
        ITaglibDomainPredicateMatcherFactory matcherFactory = MetaDataQueryContextFactory.getInstance().getTaglibDomainPredicateMatcherFactory();
        ITaglibDomainEntityPredicateMatcher matcher = matcherFactory.createTagEntityMatcher("http://org.eclipse.jsf/test", "NLS");
        try {
            IResultSet entities = this._query.findEntities(matcher);
            TaglibMetaDataQueryTests.assertNotNull((Object)entities);
            TaglibMetaDataQueryTests.assertEquals((int)1, (int)entities.getResults().size());
        }
        catch (MetaDataException metaDataException) {
            TaglibMetaDataQueryTests.fail();
        }
    }

    @Test
    public void testFindMultipleTagsWithQuerySpec() {
        IResultSet tagEntities;
        ITaglibDomainPredicateMatcherFactory matcherFactory = MetaDataQueryContextFactory.getInstance().getTaglibDomainPredicateMatcherFactory();
        ITaglibDomainEntityPredicateMatcher matcher = matcherFactory.createTagEntityMatcher("http://org.eclipse.jsf/test", "loaded");
        try {
            tagEntities = this._query.findEntities(matcher);
            TaglibMetaDataQueryTests.assertNotNull((Object)tagEntities);
            TaglibMetaDataQueryTests.assertTrue((tagEntities.getResults().size() == 2 ? 1 : 0) != 0);
        }
        catch (MetaDataException metaDataException) {
            TaglibMetaDataQueryTests.fail();
        }
        matcher = matcherFactory.createTagEntityMatcher("http://org.eclipse.jsf/test", ".*");
        try {
            tagEntities = this._query.findEntities(matcher);
            TaglibMetaDataQueryTests.assertNotNull((Object)tagEntities);
            TaglibMetaDataQueryTests.assertTrue((tagEntities.getResults().size() == 6 ? 1 : 0) != 0);
        }
        catch (MetaDataException metaDataException) {
            TaglibMetaDataQueryTests.fail();
        }
    }

    @Test
    public void testFindSingleTagAttributeWithQuerySpec() {
        ITaglibDomainPredicateMatcherFactory matcherFactory = MetaDataQueryContextFactory.getInstance().getTaglibDomainPredicateMatcherFactory();
        ITaglibDomainEntityPredicateMatcher matcher = matcherFactory.createTagAttributeEntityMatcher("http://org.eclipse.jsf/test", "loaded", "att2");
        try {
            IResultSet tagAttrEntities = this._query.findEntities(matcher);
            TaglibMetaDataQueryTests.assertNotNull((Object)tagAttrEntities);
            TaglibMetaDataQueryTests.assertTrue((tagAttrEntities.getResults().size() == 1 ? 1 : 0) != 0);
        }
        catch (MetaDataException metaDataException) {
            TaglibMetaDataQueryTests.fail();
        }
    }

    @Test
    public void testFindMultipleTagAttrsWithQuerySpec() {
        IResultSet tagAttrEntities;
        ITaglibDomainPredicateMatcherFactory matcherFactory = MetaDataQueryContextFactory.getInstance().getTaglibDomainPredicateMatcherFactory();
        ITaglibDomainEntityPredicateMatcher matcher = matcherFactory.createTagAttributeEntityMatcher("http://org.eclipse.jsf/test", "loaded", ".*");
        try {
            tagAttrEntities = this._query.findEntities(matcher);
            TaglibMetaDataQueryTests.assertNotNull((Object)tagAttrEntities);
            TaglibMetaDataQueryTests.assertEquals((int)5, (int)tagAttrEntities.getResults().size());
        }
        catch (MetaDataException metaDataException) {
            TaglibMetaDataQueryTests.fail();
        }
        matcher = matcherFactory.createTagAttributeEntityMatcher("http://org.eclipse.jsf/test", "NLS", ".*");
        try {
            tagAttrEntities = this._query.findEntities(matcher);
            TaglibMetaDataQueryTests.assertNotNull((Object)tagAttrEntities);
            TaglibMetaDataQueryTests.assertEquals((int)1, (int)tagAttrEntities.getResults().size());
        }
        catch (MetaDataException metaDataException) {
            TaglibMetaDataQueryTests.fail();
        }
        matcher = matcherFactory.createTagAttributeEntityMatcher("http://org.eclipse.jsf/test", ".*", "att*");
        try {
            tagAttrEntities = this._query.findEntities(matcher);
            TaglibMetaDataQueryTests.assertNotNull((Object)tagAttrEntities);
            TaglibMetaDataQueryTests.assertEquals((int)4, (int)tagAttrEntities.getResults().size());
        }
        catch (MetaDataException metaDataException) {
            TaglibMetaDataQueryTests.fail();
        }
    }

    @Test
    public void testFindSingleTagAttrWithMultiQuerySpec() {
        ITaglibDomainPredicateMatcherFactory matcherFactory = MetaDataQueryContextFactory.getInstance().getTaglibDomainPredicateMatcherFactory();
        ITaglibDomainEntityPredicateMatcher matcher = matcherFactory.createTagAttributeEntityMatcher("http://org.eclipse.jsf/test", "loaded", ".*");
        Entity tagAttrEntity = this._query.findEntity(matcher);
        TaglibMetaDataQueryTests.assertNotNull((Object)tagAttrEntity);
    }

    @Test
    public void testFindSingleTraitWithSingleEntityQuerySpec() {
        ITaglibDomainPredicateMatcherFactory matcherFactory = MetaDataQueryContextFactory.getInstance().getTaglibDomainPredicateMatcherFactory();
        ITaglibDomainEntityPredicateMatcher entityMatcher = matcherFactory.createTagAttributeEntityMatcher("http://org.eclipse.jsf/test", "loaded", "att2");
        IPredicateMatcher traitMatcher = matcherFactory.createTraitMatcher("A2");
        try {
            IResultSet traits = this._query.findTraits(entityMatcher, traitMatcher);
            TaglibMetaDataQueryTests.assertNotNull((Object)traits);
            TaglibMetaDataQueryTests.assertEquals((int)1, (int)traits.getResults().size());
        }
        catch (MetaDataException metaDataException) {
            TaglibMetaDataQueryTests.fail();
        }
    }

    @Test
    public void testFindMultipleTraitsWithSingleEntityQuerySpec() {
        ITaglibDomainPredicateMatcherFactory matcherFactory = MetaDataQueryContextFactory.getInstance().getTaglibDomainPredicateMatcherFactory();
        ITaglibDomainEntityPredicateMatcher entityMatcher = matcherFactory.createTagAttributeEntityMatcher("http://org.eclipse.jsf/test", "loaded", "att2");
        IPredicateMatcher traitMatcher = matcherFactory.createTraitMatcher("^[AB]2");
        try {
            IResultSet traits = this._query.findTraits(entityMatcher, traitMatcher);
            TaglibMetaDataQueryTests.assertNotNull((Object)traits);
            TaglibMetaDataQueryTests.assertEquals((int)2, (int)traits.getResults().size());
        }
        catch (MetaDataException metaDataException) {
            TaglibMetaDataQueryTests.fail();
        }
    }

    @Test
    public void testFindMultipleTraitsWithMultipleEntityQuerySpec() {
        IResultSet traits;
        ITaglibDomainPredicateMatcherFactory matcherFactory = MetaDataQueryContextFactory.getInstance().getTaglibDomainPredicateMatcherFactory();
        ITaglibDomainEntityPredicateMatcher entityMatcher = matcherFactory.createTagEntityMatcher("http://org.eclipse.jsf/test", ".*");
        IPredicateMatcher traitMatcher = matcherFactory.createTraitMatcher("^A.*");
        try {
            traits = this._query.findTraits(entityMatcher, traitMatcher);
            TaglibMetaDataQueryTests.assertNotNull((Object)traits);
            TaglibMetaDataQueryTests.assertEquals((int)2, (int)traits.getResults().size());
        }
        catch (MetaDataException metaDataException) {
            TaglibMetaDataQueryTests.fail();
        }
        entityMatcher = matcherFactory.createTagAttributeEntityMatcher("http://org.eclipse.jsf/test", ".*", ".*");
        traitMatcher = matcherFactory.createTraitMatcher("^[aA].*");
        try {
            traits = this._query.findTraits(entityMatcher, traitMatcher);
            TaglibMetaDataQueryTests.assertNotNull((Object)traits);
            TaglibMetaDataQueryTests.assertEquals((int)6, (int)traits.getResults().size());
        }
        catch (MetaDataException metaDataException) {
            TaglibMetaDataQueryTests.fail();
        }
    }

    @Test
    public void testFindSingleTraitFromMultipleEntityQuerySpecWithSearchControl() {
        ITaglibDomainPredicateMatcherFactory matcherFactory = MetaDataQueryContextFactory.getInstance().getTaglibDomainPredicateMatcherFactory();
        ITaglibDomainEntityPredicateMatcher entityMatcher = matcherFactory.createTagEntityMatcher("http://org.eclipse.jsf/test", ".*");
        IPredicateMatcher traitMatcher = matcherFactory.createTraitMatcher("^A.*");
        Trait trait = this._query.findTrait(entityMatcher, traitMatcher);
        TaglibMetaDataQueryTests.assertNotNull((Object)trait);
        entityMatcher = matcherFactory.createTagAttributeEntityMatcher("http://org.eclipse.jsf/test", ".*", ".*");
        traitMatcher = matcherFactory.createTraitMatcher("^[aA].*");
        trait = this._query.findTrait(entityMatcher, traitMatcher);
        TaglibMetaDataQueryTests.assertNotNull((Object)trait);
    }
}

