/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.metadata.tests.pagedesigner;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.query.ITaglibDomainMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.TaglibDomainMetaDataQueryHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.ITaglibDomainMetaDataQuery;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.metadata.tests.util.IJSFRuntimeRequiredV11;
import org.eclipse.jst.jsf.metadata.tests.util.JSPTestCase;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.jst.pagedesigner.editors.palette.IPaletteContext;
import org.eclipse.jst.pagedesigner.editors.palette.IPaletteItemManager;
import org.eclipse.jst.pagedesigner.editors.palette.TagToolPaletteEntry;
import org.eclipse.jst.pagedesigner.editors.palette.impl.PaletteItemManager;
import org.eclipse.jst.pagedesigner.editors.palette.impl.TaglibPaletteDrawer;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLCMDocumentFactory;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;

public class PaletteTests
extends JSPTestCase
implements IJSFRuntimeRequiredV11 {
    private static String HTML_ID = "HTML";
    private static String HTML_URI = "html".toUpperCase();
    private static String HTML_LABEL = "HTML 4.0";
    private static String HTML_DESC = "HTML Tags";
    private static String HTML_BUTTON_ID = "INPUT.BUTTON";
    private static String HTML_BUTTON_LABEL = "Button";
    private static String HTML_BUTTON_DESC = "An INPUT element with TYPE=SUBMIT represents an input option, typically a button, that instructs the user agent to submit the form";
    private static String HTML_BUTTON_SMALL_ICON = "HTML_INPUT_BUTTON.gif";
    private static String HTML_A_ID = "a";
    private static String HTML_A_LABEL = "Link";
    private static String HTML_A_DESC = "This element allows the user to navigate the content of the document";
    private static String HTML_A_SMALL_ICON = "HTML_A.gif";
    private static String JSP_ID = "JSP11";
    private static String JSP_URI = "JSP11";
    private static String JSP_LABEL = "JSP";
    private static String JSP_DESC = "JSP Tags";
    private static String JSP_DIR_INCLUDE_ID = "jsp:directive.include";
    private static String JSP_DIR_INCLUDE_LABEL = "Directive.Include";
    private static String JSP_DIR_INCLUDE_DESC = "Includes a resource of text or code when the JSP page is translated";
    private static String JSP_DIR_INCLUDE_SMALL_ICON = "JSP_DIRECTIVE.INCLUDE.gif";
    private static String JSFHTML_LABEL = "JSF HTML";
    private static String JSFHTML_DESC = "This tag library contains JavaServer Faces component tags for all UIComponent + HTML RenderKit Renderer combinations defined in the JavaServer Faces Specification.";
    private static String JSFHTML_DEFAULT_PREFIX = "h";
    private static String JSFHTML_COMMAND_BTN_ID = "commandButton";
    private static String JSFHTML_COMMAND_BTN_LABEL = "Command Button";
    private static String JSFHTML_COMMAND_BTN_DESC = "Renders an HTML \"input\" element.Decode BehaviorObtain the Map from the \"requestParameterMap\" property of the ExternalContext. If the value in theMap for the value of the \"clientId\" property of the component is null, create a String by concatenating t...";
    private static String JSFHTML_COMMAND_BTN_SMALL_ICON = "JSF_COMMANDBUTTON.gif";
    private static String JSFCORE_LABEL = "JSF Core";
    private static String JSFCORE_DESC = "The core JavaServer Faces custom actions that are independent of any particular RenderKit.";
    private static String JSFCORE_DEFAULT_PREFIX = "f";
    private static String JSFCORE_ACTION_LISTENER_ID = "actionListener";
    private static String JSFCORE_ACTION_LISTENER_LABEL = "actionListener";
    private static String JSFCORE_ACTION_LISTENER__DESC = "Register an ActionListener instance on the UIComponent associated with the closest parent UIComponent custom action.";
    private static String JSFCORE_ACTION_LISTENER_ICON = "JSF_ACTIONLISTENER.gif";
    private static String JSTL_CORE_URI = "http://java.sun.com/jsp/jstl/core";
    private static String JSTLCORE_LABEL = "JSTL core";
    private static String JSTLCORE_DESC = "JSTL 1.1 core library";
    private static String JSTLCORE_DEFAULT_PREFIX = "c";
    private static String JSTLCORE_IF_ID = "if";
    private static String JSTLCORE_IF_LABEL = "if";
    private static String JSTLCORE_IF_DESC = "Simple conditional tag, which evalutes its body if the \tsupplied condition is true and optionally exposes a Boolean \tscripting variable representing the evaluation of this condition";
    private static String JSTLCORE_IF_ICON = "PD_Palette_Default.gif";

    public PaletteTests() {
        super(JSFVersion.V1_1, "/testfiles/web/faces-config_1_1.xml.data");
    }

    public void testLoadJSPModel() {
        Model JSP11Model = TaglibDomainMetaDataQueryHelper.getModel((ITaglibDomainMetaDataModelContext)TaglibDomainMetaDataQueryHelper.createMetaDataModelContext((IProject)this._testEnv.getTestProject(), (String)"JSP11"));
        PaletteTests.assertNotNull((Object)JSP11Model);
        Model jsp11Model = TaglibDomainMetaDataQueryHelper.getModel((ITaglibDomainMetaDataModelContext)TaglibDomainMetaDataQueryHelper.createMetaDataModelContext((IProject)this._testEnv.getTestProject(), (String)"jsp11"));
        IMetaDataDomainContext context = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(this._testEnv.getTestProject());
        ITaglibDomainMetaDataQuery query = (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(context);
        Model JSP11Model_2 = query.getQueryHelper().getModel("JSP11");
        PaletteTests.assertNotNull((Object)JSP11Model_2);
        PaletteTests.assertSame((Object)jsp11Model, (Object)JSP11Model_2);
        Model jsp11Model_2 = query.getQueryHelper().getModel("jsp11");
        PaletteTests.assertNotNull((Object)jsp11Model_2);
        PaletteTests.assertSame((Object)jsp11Model, (Object)jsp11Model_2);
    }

    public void testPalletteDrawers() {
        IFile file = this._testEnv.getTestProject().getFile("xxx.jsp");
        IPaletteContext context = PaletteItemManager.createPaletteContext((IFile)file);
        PaletteItemManager mgr = PaletteItemManager.getInstance((IPaletteContext)context);
        PaletteTests.assertNotNull((Object)mgr);
        CMDocument doc = HTMLCMDocumentFactory.getCMDocument((String)"HTML");
        TaglibPaletteDrawer drawer = mgr.getPaletteHelper().getOrCreateTaglibPaletteDrawer((IPaletteItemManager)mgr, doc, "HTML");
        this.verifyHTMLDrawer(drawer);
        doc = HTMLCMDocumentFactory.getCMDocument((String)"JSP11");
        drawer = mgr.getPaletteHelper().getOrCreateTaglibPaletteDrawer((IPaletteItemManager)mgr, doc, "JSP11");
        this.verifyJSPDrawer(drawer);
        drawer = this.getTaglibPaletteDrawer(mgr, "http://java.sun.com/jsf/html");
        if (drawer != null) {
            this.verifyJSFHTMLDrawer(drawer);
        }
        if ((drawer = this.getTaglibPaletteDrawer(mgr, "http://java.sun.com/jsf/core")) != null) {
            this.verifyJSFCoreDrawer(drawer);
        }
        if ((drawer = this.getTaglibPaletteDrawer(mgr, JSTL_CORE_URI)) != null) {
            this.verifyJSTLCoreDrawer(drawer);
        }
        mgr.release(context);
    }

    private TaglibPaletteDrawer getTaglibPaletteDrawer(PaletteItemManager mgr, String uri) {
        ITaglibRecord[] tldrecs = TaglibIndex.getAvailableTaglibRecords((IPath)this._testEnv.getTestProject().getFullPath());
        int i = 0;
        while (i < tldrecs.length) {
            if (uri.equals(tldrecs[i].getDescriptor().getURI())) {
                return mgr.getPaletteHelper().configPaletteItemsByTLD((IPaletteItemManager)mgr, tldrecs[i]);
            }
            ++i;
        }
        return null;
    }

    private void verifyJSFHTMLDrawer(TaglibPaletteDrawer drawer) {
        PaletteTests.assertNotNull((Object)drawer);
        this.verifyDrawer(drawer, "JSF HTML", "http://java.sun.com/jsf/html", "http://java.sun.com/jsf/html", JSFHTML_DEFAULT_PREFIX, JSFHTML_LABEL, JSFHTML_DESC);
        for (Object o : drawer.getChildren()) {
            this.verifyJSFHTMLTagItem((TagToolPaletteEntry)o);
        }
    }

    private void verifyJSFCoreDrawer(TaglibPaletteDrawer drawer) {
        PaletteTests.assertNotNull((Object)drawer);
        this.verifyDrawer(drawer, "JSF Core", "http://java.sun.com/jsf/core", "http://java.sun.com/jsf/core", JSFCORE_DEFAULT_PREFIX, JSFCORE_LABEL, JSFCORE_DESC);
        for (Object o : drawer.getChildren()) {
            this.verifyJSFCoreTagItem((TagToolPaletteEntry)o);
        }
    }

    private void verifyHTMLDrawer(TaglibPaletteDrawer drawer) {
        PaletteTests.assertNotNull((Object)drawer);
        this.verifyDrawer(drawer, "HTML", HTML_ID, HTML_URI, null, HTML_LABEL, HTML_DESC);
        for (Object o : drawer.getChildren()) {
            this.verifyHTMLTagItem((TagToolPaletteEntry)o);
        }
    }

    private void verifyJSPDrawer(TaglibPaletteDrawer drawer) {
        PaletteTests.assertNotNull((Object)drawer);
        this.verifyDrawer(drawer, "JSP", JSP_ID, JSP_URI, null, JSP_LABEL, JSP_DESC);
        for (Object o : drawer.getChildren()) {
            this.verifyJSPTagItem((TagToolPaletteEntry)o);
        }
    }

    private void verifyHTMLTagItem(TagToolPaletteEntry tagTool) {
        PaletteTests.assertNotNull((Object)tagTool);
        if (tagTool.getId().equals(HTML_BUTTON_ID)) {
            this.verifyTagTool(tagTool, HTML_BUTTON_LABEL, HTML_BUTTON_DESC, HTML_BUTTON_SMALL_ICON);
        } else if (tagTool.getId().equals(HTML_A_ID)) {
            this.verifyTagTool(tagTool, HTML_A_LABEL, HTML_A_DESC, HTML_A_SMALL_ICON);
        }
    }

    private void verifyJSFHTMLTagItem(TagToolPaletteEntry tagTool) {
        PaletteTests.assertNotNull((Object)tagTool);
        if (tagTool.getId().equals(JSFHTML_COMMAND_BTN_ID)) {
            this.verifyTagTool(tagTool, JSFHTML_COMMAND_BTN_LABEL, JSFHTML_COMMAND_BTN_DESC, JSFHTML_COMMAND_BTN_SMALL_ICON);
        }
    }

    private void verifyJSFCoreTagItem(TagToolPaletteEntry tagTool) {
        PaletteTests.assertNotNull((Object)tagTool);
        if (tagTool.getId().equals(JSFCORE_ACTION_LISTENER_ID)) {
            this.verifyTagTool(tagTool, JSFCORE_ACTION_LISTENER_LABEL, JSFCORE_ACTION_LISTENER__DESC, JSFCORE_ACTION_LISTENER_ICON);
        }
    }

    private void verifyJSPTagItem(TagToolPaletteEntry tagTool) {
        PaletteTests.assertNotNull((Object)tagTool);
        if (tagTool.getId().equals(JSP_DIR_INCLUDE_ID)) {
            this.verifyTagTool(tagTool, JSP_DIR_INCLUDE_LABEL, JSP_DIR_INCLUDE_DESC, JSP_DIR_INCLUDE_SMALL_ICON);
        }
    }

    private void verifyJSTLCoreDrawer(TaglibPaletteDrawer drawer) {
        PaletteTests.assertNotNull((Object)drawer);
        this.verifyDrawer(drawer, "JSTL Core", JSTL_CORE_URI, JSTL_CORE_URI, JSTLCORE_DEFAULT_PREFIX, JSTLCORE_LABEL, JSTLCORE_DESC);
        for (Object o : drawer.getChildren()) {
            this.verifyJSTLCoreTagItem((TagToolPaletteEntry)o);
        }
    }

    private void verifyJSTLCoreTagItem(TagToolPaletteEntry tagTool) {
        PaletteTests.assertNotNull((Object)tagTool);
        if (tagTool.getId().equals(JSTLCORE_IF_ID)) {
            this.verifyTagTool(tagTool, JSTLCORE_IF_LABEL, JSTLCORE_IF_DESC, JSTLCORE_IF_ICON);
        }
    }

    private void verifyDrawer(TaglibPaletteDrawer drawer, String drawerID, String id, String uri, String prefix, String label, String desc) {
        PaletteTests.assertEquals((String)(String.valueOf(drawerID) + ": bad id"), (String)id, (String)drawer.getId());
        PaletteTests.assertEquals((String)(String.valueOf(drawerID) + ": bad uri"), (String)uri, (String)drawer.getURI());
        PaletteTests.assertEquals((String)(String.valueOf(drawerID) + ": bad label"), (String)label, (String)drawer.getLabel());
        PaletteTests.assertEquals((String)(String.valueOf(drawerID) + ": bad desc"), (String)desc, (String)drawer.getDescription());
        PaletteTests.assertEquals((String)(String.valueOf(drawerID) + ": bad default prefix"), (String)prefix, (String)drawer.getDefaultPrefix());
    }

    private void verifyTagTool(TagToolPaletteEntry tagTool, String label, String desc, String iconName) {
        PaletteTests.assertEquals((String)(String.valueOf(tagTool.getId()) + ": bad label"), (String)label, (String)tagTool.getLabel());
        PaletteTests.assertEquals((String)(String.valueOf(tagTool.getId()) + ": bad desc"), (String)desc, (String)tagTool.getDescription());
        PaletteTests.assertNotNull((String)(String.valueOf(tagTool.getId()) + ": missing small icon"), (Object)tagTool.getSmallIcon());
        String actualSmallIcon = tagTool.getSmallIcon().toString();
        String frag = actualSmallIcon.substring(actualSmallIcon.length() - iconName.length() - 1);
        PaletteTests.assertTrue((String)(String.valueOf(tagTool.getId()) + ": bad image"), (frag.indexOf(iconName) == 0 ? 1 : 0) != 0);
    }

    public void testNullProjectPalette() {
        IFile file = null;
        IPaletteContext context = PaletteItemManager.createPaletteContext(file);
        PaletteItemManager mgr = PaletteItemManager.getInstance((IPaletteContext)context);
        PaletteTests.assertNotNull((Object)mgr);
        PaletteTests.assertTrue((boolean)mgr.getTagRegistryIdentifier().getContentType().isAssociatedWith("xxx.jsp"));
        PaletteTests.assertTrue((mgr.getAllCategories().size() == 2 ? 1 : 0) != 0);
        PaletteTests.assertNotNull((Object)mgr.getTaglibPalletteDrawer("HTML"));
        PaletteTests.assertNotNull((Object)mgr.getTaglibPalletteDrawer("JSP11"));
    }
}

