/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.metadata.tests.pagedesigner;

import java.util.List;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.ITaglibDomainMetaDataQuery;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.metadata.tests.util.SingleJSPTestCase;
import org.eclipse.jst.jsf.metadataprocessors.MetaDataEnabledProcessingFactory;
import org.eclipse.jst.pagedesigner.editors.properties.IPropertyPageDescriptor;
import org.eclipse.jst.pagedesigner.properties.ITabbedPropertiesConstants;

public class PropertyDescriptorTests
extends SingleJSPTestCase {
    private String uri = "http://org.eclipse.jsf/propertyDescriptorTest";
    private Model _model;
    private int _offset = 423;

    public PropertyDescriptorTests() {
        super("/testfiles/jsps/propertyDescTests.jsp", "/propertyDescTests.jsp", JSFVersion.V1_1, "/testfiles/web/faces-config_1_1.xml.data");
    }

    public void setUp() throws Exception {
        if (this._model == null) {
            super.setUp();
            this.getModel();
        }
    }

    private Model getModel() {
        if (this._model == null) {
            this._model = this.getQuery().findTagLibraryModel(this.uri);
        }
        return this._model;
    }

    private ITaglibDomainMetaDataQuery getQuery() {
        IMetaDataDomainContext context = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(null);
        return (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(context);
    }

    public void testBasics() {
        PropertyDescriptorTests.assertNotNull((Object)this.getModel());
        PropertyDescriptorTests.assertEquals((int)1, (int)this.getModel().getChildEntities().size());
        Entity tag = this.getQuery().findTagEntity(this.getModel(), "Tag");
        PropertyDescriptorTests.assertNotNull((Object)tag);
        PropertyDescriptorTests.assertTrue((tag.getChildEntities().size() == 3 ? 1 : 0) != 0);
        this.testAttr1(tag);
        this.testDefaultAttr(tag);
    }

    private void testAttr1(Entity tag) {
        Entity attr1 = this.getQuery().findTagAttributeEntity(tag, "Attr1");
        PropertyDescriptorTests.assertNotNull((Object)attr1);
        PropertyDescriptorTests.assertTrue((attr1.getTraits().size() > 2 ? 1 : 0) != 0);
        List pds = MetaDataEnabledProcessingFactory.getInstance().getAttributeValueRuntimeTypeFeatureProcessors(IPropertyPageDescriptor.class, this.getStructuredDocumentContext(this._structuredDocument, this._offset), attr1);
        PropertyDescriptorTests.assertNotNull((Object)pds);
        IPropertyPageDescriptor pd = (IPropertyPageDescriptor)pds.get(0);
        PropertyDescriptorTests.assertNotNull((Object)pd);
        PropertyDescriptorTests.assertEquals((String)"CategoryName", (String)pd.getCategory());
        PropertyDescriptorTests.assertEquals((String)"This is a description.", (String)pd.getDescription());
        PropertyDescriptorTests.assertTrue((boolean)pd.isRequired());
        PropertyDescriptorTests.assertEquals((String)"MyAttr1:", (String)pd.getLabel());
    }

    private void testDefaultAttr(Entity tag) {
        Entity attr1 = this.getQuery().findTagAttributeEntity(tag, "DefaultAttr");
        PropertyDescriptorTests.assertNotNull((Object)attr1);
        List pds = MetaDataEnabledProcessingFactory.getInstance().getAttributeValueRuntimeTypeFeatureProcessors(IPropertyPageDescriptor.class, this.getStructuredDocumentContext(this._structuredDocument, this._offset), attr1);
        PropertyDescriptorTests.assertNotNull((Object)pds);
        IPropertyPageDescriptor pd = (IPropertyPageDescriptor)pds.get(0);
        PropertyDescriptorTests.assertNotNull((Object)pd);
        PropertyDescriptorTests.assertEquals((String)ITabbedPropertiesConstants.OTHER_CATEGORY, (String)pd.getCategory());
        PropertyDescriptorTests.assertNull((Object)pd.getDescription());
        PropertyDescriptorTests.assertFalse((boolean)pd.isRequired());
        PropertyDescriptorTests.assertEquals((String)"DefaultAttr:", (String)pd.getLabel());
    }

    public void testLocatePropertyPageDescForBooleanTagAttr() {
        Entity boolAttr = this.getQuery().getQueryHelper().getEntity((Entity)this.getModel(), "Tag/boolAttr");
        PropertyDescriptorTests.assertNotNull((Object)boolAttr);
        List pds = MetaDataEnabledProcessingFactory.getInstance().getAttributeValueRuntimeTypeFeatureProcessors(IPropertyPageDescriptor.class, this.getStructuredDocumentContext(this._structuredDocument, this._offset), boolAttr);
        PropertyDescriptorTests.assertNotNull((Object)pds);
        IPropertyPageDescriptor pd = (IPropertyPageDescriptor)pds.get(0);
        PropertyDescriptorTests.assertNotNull((Object)pd);
    }
}

