/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.cache.internal;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.internet.cache.internal.LicenseRegistryWrapper;

public class LicenseRegistryTest
extends TestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.internet.cache.internal.LicenseRegistryTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAddLicenseToRegistry() {
        String licenseURL = "http://somelicense";
        LicenseRegistryWrapper registry = new LicenseRegistryWrapper();
        registry.addLicense(licenseURL);
        LicenseRegistryTest.assertEquals((String)"The registry does not have 1 license.", (int)1, (int)registry.getLicensesHashtable().size());
        LicenseRegistryTest.assertTrue((String)("The registry does not conain the license " + licenseURL), (boolean)registry.getLicensesHashtable().containsKey(licenseURL));
        LicenseRegistryTest.assertEquals((String)"The registry does not have the correct value for the license.", (Object)LicenseRegistryWrapper.LICENSE_UNSPECIFIED, registry.getLicensesHashtable().get(licenseURL));
    }

    public void testAddLicenseToRegistryTwice() {
        String licenseURL = "http://somelicense";
        LicenseRegistryWrapper registry = new LicenseRegistryWrapper();
        registry.addLicense(licenseURL);
        registry.addLicense(licenseURL);
        LicenseRegistryTest.assertEquals((String)"The registry contains more than one license.", (int)1, (int)registry.getLicensesHashtable().size());
    }

    public void testAgreeToLicense() {
        String licenseURL = "http://somelicense";
        LicenseRegistryWrapper registry = new LicenseRegistryWrapper();
        registry.addLicense(licenseURL);
        registry.agreeLicense(licenseURL);
        LicenseRegistryTest.assertEquals((String)"The registry does not have the correct value for the license.", (Object)LicenseRegistryWrapper.LICENSE_AGREE, registry.getLicensesHashtable().get(licenseURL));
    }

    public void testAgreeToLicenseNotInRegistry() {
        String licenseURL = "http://somelicense";
        LicenseRegistryWrapper registry = new LicenseRegistryWrapper();
        registry.agreeLicense(licenseURL);
        LicenseRegistryTest.assertEquals((String)"The registry registered the license but it should not have.", (int)0, (int)registry.getLicensesHashtable().size());
    }

    public void testDisgreeToLicense() {
        String licenseURL = "http://somelicense";
        LicenseRegistryWrapper registry = new LicenseRegistryWrapper();
        registry.addLicense(licenseURL);
        registry.disagreeLicense(licenseURL);
        LicenseRegistryTest.assertEquals((String)"The registry does not have the correct value for the license.", (Object)LicenseRegistryWrapper.LICENSE_DISAGREE, registry.getLicensesHashtable().get(licenseURL));
    }

    public void testDisagreeToLicenseNotInRegistry() {
        String licenseURL = "http://somelicense";
        LicenseRegistryWrapper registry = new LicenseRegistryWrapper();
        registry.agreeLicense(licenseURL);
        LicenseRegistryTest.assertEquals((String)"The registry registered the license but it should not have.", (int)0, (int)registry.getLicensesHashtable().size());
    }
}

