/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.ui.text;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.wst.wsdl.validation.internal.IValidationMessage;
import org.eclipse.wst.wsdl.validation.internal.IValidationReport;
import org.eclipse.wst.wsdl.validation.internal.ValidationMessageImpl;
import org.eclipse.wst.wsdl.validation.internal.ValidatorRegistry;
import org.eclipse.wst.wsdl.validation.internal.WSDLValidator;
import org.eclipse.wst.wsdl.validation.internal.eclipse.URIResolverWrapper;
import org.eclipse.wst.wsdl.validation.internal.logging.ILogger;
import org.eclipse.wst.wsdl.validation.internal.logging.LoggerFactory;
import org.eclipse.wst.wsdl.validation.internal.logging.StandardLogger;
import org.eclipse.wst.wsdl.validation.internal.resolver.IExtensibleURIResolver;
import org.eclipse.wst.wsdl.validation.internal.ui.text.WSDLValidateTestLogger;
import org.eclipse.wst.wsdl.validation.internal.ui.text.WSDLValidateTextUIMessages;
import org.eclipse.wst.wsdl.validation.internal.ui.text.WSDLValidateWrapper;
import org.eclipse.wst.wsdl.validation.tests.internal.BaseTestCase;

public class WSDLValidateTest
extends BaseTestCase {
    WSDLValidateWrapper validate = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.validate = new WSDLValidateWrapper();
        WSDLValidator wsdlValidator = this.validate.getWSDLValidator();
        URIResolverWrapper resolver = new URIResolverWrapper();
        wsdlValidator.addURIResolver((IExtensibleURIResolver)resolver);
    }

    protected void tearDown() throws Exception {
        this.validate = null;
        super.tearDown();
    }

    public void testValidateFile() {
        String validFile = String.valueOf(this.FILE_PROTOCOL) + this.PLUGIN_ABSOLUTE_PATH + this.SAMPLES_DIR + "Paths/AngleHat^InPath/AngleHatInPathValid.wsdl";
        if (this.PLUGIN_ABSOLUTE_PATH.startsWith("/")) {
            validFile = "file://" + this.PLUGIN_ABSOLUTE_PATH + this.SAMPLES_DIR + "Paths/AngleHat^InPath/AngleHatInPathValid.wsdl";
        }
        String invalidFile = String.valueOf(this.FILE_PROTOCOL) + this.PLUGIN_ABSOLUTE_PATH + this.SAMPLES_DIR + "Paths/AngleHat^InPath/AngleHatInPathInvalid.wsdl";
        if (this.PLUGIN_ABSOLUTE_PATH.startsWith("/")) {
            invalidFile = "file://" + this.PLUGIN_ABSOLUTE_PATH + this.SAMPLES_DIR + "Paths/AngleHat^InPath/AngleHatInPathInvalid.wsdl";
        }
        String nonexistantFile = "nonexistantfile.wsdl";
        IValidationReport report = this.validate.validateFile(validFile);
        WSDLValidateTest.assertFalse((String)"Errors were reported for a valid file.", (boolean)report.hasErrors());
        IValidationReport report2 = this.validate.validateFile(invalidFile);
        WSDLValidateTest.assertTrue((String)"Errors were not reported for an invalid file.", (boolean)report2.hasErrors());
        IValidationReport report3 = this.validate.validateFile(nonexistantFile);
        WSDLValidateTest.assertTrue((String)"Errors were not reported for a nonexistant file.", (boolean)report3.hasErrors());
    }

    public void testValidate() {
        String validFile = String.valueOf(this.FILE_PROTOCOL) + this.PLUGIN_ABSOLUTE_PATH + this.SAMPLES_DIR + "Paths/AngleHat^InPath/AngleHatInPathValid.wsdl";
        if (this.PLUGIN_ABSOLUTE_PATH.startsWith("/")) {
            validFile = "file://" + this.PLUGIN_ABSOLUTE_PATH + this.SAMPLES_DIR + "Paths/AngleHat^InPath/AngleHatInPathValid.wsdl";
        }
        String validFile2 = String.valueOf(this.FILE_PROTOCOL) + this.PLUGIN_ABSOLUTE_PATH + this.SAMPLES_DIR + "Paths/AngleHatInFilename/AngleHat^InFilenameValid.wsdl";
        if (this.PLUGIN_ABSOLUTE_PATH.startsWith("/")) {
            validFile2 = "file://" + this.PLUGIN_ABSOLUTE_PATH + this.SAMPLES_DIR + "Paths/AngleHatInFilename/AngleHat^InFilenameValid.wsdl";
        }
        ILogger currentLogger = LoggerFactory.getInstance().getLogger();
        WSDLValidateTestLogger logger = new WSDLValidateTestLogger();
        LoggerFactory.getInstance().setLogger((ILogger)logger);
        this.validate.getWSDLFiles().add(validFile);
        this.validate.validate();
        WSDLValidateTest.assertEquals((String)"Validating a single valid file failed.", (Object)MessageFormat.format(WSDLValidateTextUIMessages._UI_VALIDATION_SUMMARY, new Integer(1), new Integer(0)), logger.getInfos().get(0));
        this.validate.getWSDLFiles().clear();
        logger.getInfos().clear();
        this.validate.getWSDLFiles().add(validFile);
        this.validate.getWSDLFiles().add(validFile2);
        this.validate.validate();
        WSDLValidateTest.assertEquals((String)"Validating two valid files failed.", (Object)MessageFormat.format(WSDLValidateTextUIMessages._UI_VALIDATION_SUMMARY, new Integer(2), new Integer(0)), logger.getInfos().get(0));
        this.validate.getWSDLFiles().clear();
        logger.getInfos().clear();
        this.validate.setVerbose(true);
        this.validate.getWSDLFiles().add(validFile);
        this.validate.validate();
        WSDLValidateTest.assertEquals((String)"Validating a single valid file failed.", (Object)MessageFormat.format(WSDLValidateTextUIMessages._UI_FILE_VALID, validFile), logger.getVerboses().get(0));
        WSDLValidateTest.assertEquals((String)"Validating a single valid file failed.", (Object)MessageFormat.format(WSDLValidateTextUIMessages._UI_VALIDATION_SUMMARY, new Integer(1), new Integer(0)), logger.getInfos().get(0));
        this.validate.getWSDLFiles().clear();
        this.validate.setVerbose(false);
        logger.getInfos().clear();
        logger.getVerboses().clear();
        LoggerFactory.getInstance().setLogger(currentLogger);
    }

    public void testGetMessages() {
        ValidationMessageImpl errorMessage = new ValidationMessageImpl("MESSAGE", 1, 2, 0, "URI");
        ValidationMessageImpl warningMessage = new ValidationMessageImpl("MESSAGE", 1, 2, 1, "URI");
        IValidationMessage[] errorMessages = new IValidationMessage[]{errorMessage};
        String message = this.validate.getMessages(errorMessages);
        WSDLValidateTest.assertEquals((String)"The error message was not correct.", (String)(String.valueOf(WSDLValidateTextUIMessages._UI_ERROR_MARKER) + " 1:2 MESSAGE"), (String)message);
        IValidationMessage[] warningMessages = new IValidationMessage[]{warningMessage};
        String message2 = this.validate.getMessages(warningMessages);
        WSDLValidateTest.assertEquals((String)"The warning message was not correct.", (String)(String.valueOf(WSDLValidateTextUIMessages._UI_WARNING_MARKER) + " 1:2 MESSAGE"), (String)message2);
        IValidationMessage[] twoMessages = new IValidationMessage[]{errorMessage, warningMessage};
        String message3 = this.validate.getMessages(twoMessages);
        WSDLValidateTest.assertEquals((String)"Two messages was not correct.", (String)(String.valueOf(WSDLValidateTextUIMessages._UI_ERROR_MARKER) + " 1:2 MESSAGE\n" + WSDLValidateTextUIMessages._UI_WARNING_MARKER + " 1:2 MESSAGE"), (String)message3);
    }

    public void testParseArguments() {
        String[] args1 = new String[]{"-wsdl11v", "http://wsdl11validator", "org.eclipse.wst.wsdl.validation.internal.wsdl11.http.HTTPValidator"};
        this.validate.parseArguments(args1);
        WSDLValidateTest.assertTrue((String)"The WSDL 1.1 validator was not registered.", (boolean)org.eclipse.wst.wsdl.validation.internal.wsdl11.ValidatorRegistry.getInstance().hasRegisteredValidator("http://wsdl11validator"));
        String[] args2 = new String[]{"-extv", "http://extvalidator", "validatorclass"};
        this.validate.parseArguments(args2);
        WSDLValidateTest.assertTrue((String)"The WSDL extension validator was not registered.", (boolean)ValidatorRegistry.getInstance().hasRegisteredValidator("http://extvalidator", ValidatorRegistry.EXT_VALIDATOR));
        String[] args3 = new String[]{"-extv", "http://extvalidator2", "-dummyparam"};
        this.validate.parseArguments(args3);
        WSDLValidateTest.assertFalse((String)"The WSDL extension validator was registered without enough information.", (boolean)ValidatorRegistry.getInstance().hasRegisteredValidator("http://extvalidator2", ValidatorRegistry.EXT_VALIDATOR));
        ILogger currentLogger = LoggerFactory.getInstance().getLogger();
        String[] args4 = new String[]{"-logger", "org.eclipse.wst.wsdl.validation.internal.logging.StandardLogger"};
        this.validate.parseArguments(args4);
        WSDLValidateTest.assertTrue((String)"The registered logger is not a StandardLogger", (boolean)(LoggerFactory.getInstance().getLogger() instanceof StandardLogger));
        WSDLValidateTest.assertFalse((String)"The registered logger is the same as originally registered.", (boolean)currentLogger.equals(LoggerFactory.getInstance().getLogger()));
        LoggerFactory.getInstance().setLogger(currentLogger);
        String[] args5 = new String[]{"-DSAMPLENAME=SAMPLEVALUE"};
        this.validate.parseArguments(args5);
        WSDLValidateTest.assertEquals((String)"The parameter was not set correctly.", (Object)"SAMPLEVALUE", (Object)this.validate.getConfiguration().getProperty("SAMPLENAME"));
        String[] args6 = new String[]{"-verbose"};
        this.validate.setVerbose(false);
        this.validate.parseArguments(args6);
        WSDLValidateTest.assertTrue((String)"Verbose is not set to true.", (boolean)this.validate.isVerbose());
        String[] args6a = new String[]{"-v"};
        this.validate.setVerbose(false);
        this.validate.parseArguments(args6a);
        WSDLValidateTest.assertTrue((String)"Verbose is not set to true.", (boolean)this.validate.isVerbose());
        String[] args7 = new String[]{"filename1.wsdl", "folder/filename2.wsdl", "folder\filename3.wsdl"};
        this.validate.parseArguments(args7);
        List wsdlFiles = this.validate.getWSDLFiles();
        WSDLValidateTest.assertEquals((String)"There were not 3 WSDL files listed to validate.", (int)3, (int)wsdlFiles.size());
        WSDLValidateTest.assertTrue((String)"The WSDL file list did not include filename1.wsdl", (boolean)wsdlFiles.contains("filename1.wsdl"));
        WSDLValidateTest.assertTrue((String)"The WSDL file list did not include folder/filename2.wsdl", (boolean)wsdlFiles.contains("folder/filename2.wsdl"));
        WSDLValidateTest.assertTrue((String)"The WSDL file list did not include folder\filename3.wsdl", (boolean)wsdlFiles.contains("folder\filename3.wsdl"));
    }
}

