/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.wsdl11.xsd;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.xerces.dom.DocumentImpl;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.xsd.InlineSchemaGeneratorWrapper;
import org.w3c.dom.Element;

public class InlineSchemaGeneratorTest
extends TestCase {
    private InlineSchemaGeneratorWrapper generator;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.wsdl.validation.internal.wsdl11.xsd.InlineSchemaGeneratorTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void setUp() {
        this.generator = new InlineSchemaGeneratorWrapper();
    }

    public void testCheckSOAPEncodingRequired() {
        InlineSchemaGeneratorTest.assertFalse((String)"The method does not return false when given an empty list.", (boolean)this.generator.checkSOAPEncodingRequired(new ArrayList()));
        ArrayList<String> list = new ArrayList<String>();
        list.add("http://notsoapencodingnamespace");
        InlineSchemaGeneratorTest.assertFalse((String)"The method does not return false when given a list without the SOAP envelope namespace.", (boolean)this.generator.checkSOAPEncodingRequired(list));
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("http://schemas.xmlsoap.org/soap/encoding/");
        InlineSchemaGeneratorTest.assertTrue((String)"The method does not return true when given a list with the SOAP encoding namespace.", (boolean)this.generator.checkSOAPEncodingRequired(list2));
    }

    public void todoCreateXSDStringRecursively() {
    }

    public void todoGetImportNamespaces() {
    }

    public void testGetNSResolver() {
        DocumentImpl doc = new DocumentImpl();
        Element rootElem = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "schema");
        Hashtable resolver = this.generator.getNSResolver(rootElem);
        InlineSchemaGeneratorTest.assertTrue((String)"The resolver is not empty.", (boolean)resolver.isEmpty());
        rootElem.setAttribute("xmlns", "http://www.w3.org/2001/XMLSchema");
        resolver = this.generator.getNSResolver(rootElem);
        InlineSchemaGeneratorTest.assertTrue((String)"The resolver does not contain the empty namespace.", (boolean)resolver.containsKey(""));
        InlineSchemaGeneratorTest.assertEquals((String)"The resolver does not contain the correct value for the empty namespace.", (Object)"http://www.w3.org/2001/XMLSchema", resolver.get(""));
        rootElem.setAttribute("xmlns:other", "http://othernamespace");
        resolver = this.generator.getNSResolver(rootElem);
        InlineSchemaGeneratorTest.assertTrue((String)"The resolver does not contain the other namespace.", (boolean)resolver.containsKey("other"));
        InlineSchemaGeneratorTest.assertEquals((String)"The resolver does not contain the correct value for the other namespace.", (Object)"http://othernamespace", resolver.get("other"));
        InlineSchemaGeneratorTest.assertTrue((String)"The resolver does not contain the empty namespace after adding a second namespace.", (boolean)resolver.containsKey(""));
        InlineSchemaGeneratorTest.assertEquals((String)"The resolver does not contain the correct value for the empty namespace after adding a second namespace.", (Object)"http://www.w3.org/2001/XMLSchema", resolver.get(""));
        rootElem.setAttribute("type:other2", "other2:type");
        resolver = this.generator.getNSResolver(rootElem);
        InlineSchemaGeneratorTest.assertFalse((String)"The resolver contains the other2 namespace.", (boolean)resolver.containsKey("other2"));
    }

    public void testGetPrefixes() {
        DocumentImpl doc = new DocumentImpl();
        Element rootElem = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "schema");
        rootElem.setAttribute("xmlns", "http://www.w3.org/2001/XMLSchema");
        List reqNSs = this.generator.getNamespacePrefixes(rootElem);
        InlineSchemaGeneratorTest.assertEquals((String)"The required namespace list does not contain one empty string.", (int)1, (int)reqNSs.size());
        InlineSchemaGeneratorTest.assertEquals((String)"The required namespace list does not contain one empty string.", (Object)"", reqNSs.get(0));
        Element rootElem2 = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:schema");
        rootElem2.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        List reqNSs2 = this.generator.getNamespacePrefixes(rootElem2);
        InlineSchemaGeneratorTest.assertEquals((String)"The required namespace list does not contain the one string 'xsd'.", (int)1, (int)reqNSs2.size());
        InlineSchemaGeneratorTest.assertEquals((String)"The required namespace list does not contain the one string 'xsd'.", (Object)"xsd", reqNSs2.get(0));
        Element rootElem4 = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:schema");
        rootElem2.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        Element diffNSElem = doc.createElementNS("http://othernamespace", "other:element");
        rootElem4.appendChild(diffNSElem);
        List reqNSs4 = this.generator.getNamespacePrefixes(rootElem4);
        InlineSchemaGeneratorTest.assertTrue((String)"The required namespace list does not contain the prefix 'other' when the namespace is specified for an element.", (boolean)reqNSs4.contains("other"));
        Element rootElem5 = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:schema");
        rootElem5.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        Element otherElem = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:element");
        otherElem.setAttribute("type", "other:type");
        rootElem5.appendChild(otherElem);
        List reqNSs5 = this.generator.getNamespacePrefixes(rootElem5);
        InlineSchemaGeneratorTest.assertTrue((String)"The required namespace list does not contain 'other' when the namespace is specified for a type.", (boolean)reqNSs5.contains("other"));
        Element rootElem6 = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:schema");
        rootElem6.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        Element importElem = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:import");
        importElem.setAttribute("type", "other:type");
        rootElem6.appendChild(importElem);
        List reqNSs6 = this.generator.getNamespacePrefixes(rootElem6);
        InlineSchemaGeneratorTest.assertEquals((String)"The required namespace list does not contain the one string 'xsd' when an import element is used.", (int)1, (int)reqNSs6.size());
        InlineSchemaGeneratorTest.assertEquals((String)"The required namespace list does not contain the one string 'xsd' when an import element is used.", (Object)"xsd", reqNSs6.get(0));
        Element rootElem7 = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:schema");
        rootElem7.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        Element includeElem = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:include");
        includeElem.setAttribute("type", "other:type");
        rootElem7.appendChild(includeElem);
        List reqNSs7 = this.generator.getNamespacePrefixes(rootElem6);
        InlineSchemaGeneratorTest.assertEquals((String)"The required namespace list does not contain the one string 'xsd' when an import element is used.", (int)1, (int)reqNSs7.size());
        InlineSchemaGeneratorTest.assertEquals((String)"The required namespace list does not contain the one string 'xsd' when an import element is used.", (Object)"xsd", reqNSs7.get(0));
        Element rootElem3 = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:schema");
        rootElem3.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        Element wsdlAttElem = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:element");
        wsdlAttElem.setAttributeNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:arrayType", "sometype[]");
        rootElem3.appendChild(wsdlAttElem);
        List reqNSs3 = this.generator.getNamespacePrefixes(rootElem3);
        InlineSchemaGeneratorTest.assertTrue((String)"The required namespace list does not contain 'wsdl' when the namespace is specified for an attribute.", (boolean)reqNSs3.contains("wsdl"));
    }

    public void todoRemoveImports() {
    }

    public void todoRemoveLocalNamespaces() {
    }

    public void todoResolveNamespaces() {
    }

    public void testRestrictImports() {
    }
}

