/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.tests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.OperationType;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.BindingFault;
import org.eclipse.wst.wsdl.BindingInput;
import org.eclipse.wst.wsdl.BindingOperation;
import org.eclipse.wst.wsdl.BindingOutput;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ExtensibleElement;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.UnknownExtensibilityElement;
import org.eclipse.wst.wsdl.WSDLFactory;
import org.eclipse.wst.wsdl.WSDLPackage;
import org.eclipse.wst.wsdl.WSDLPlugin;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.binding.mime.MIMEContent;
import org.eclipse.wst.wsdl.binding.mime.MIMEFactory;
import org.eclipse.wst.wsdl.binding.mime.MIMEMimeXml;
import org.eclipse.wst.wsdl.binding.mime.MIMEMultipartRelated;
import org.eclipse.wst.wsdl.binding.mime.MIMEPackage;
import org.eclipse.wst.wsdl.binding.mime.MIMEPart;
import org.eclipse.wst.wsdl.binding.soap.SOAPBody;
import org.eclipse.wst.wsdl.binding.soap.SOAPFactory;
import org.eclipse.wst.wsdl.binding.soap.SOAPPackage;
import org.eclipse.wst.wsdl.internal.util.WSDLUtil;
import org.eclipse.wst.wsdl.tests.WSDLTestsPlugin;
import org.eclipse.wst.wsdl.tests.util.DefinitionLoader;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BugFixesTest
extends TestCase {
    private String PLUGIN_ABSOLUTE_PATH = WSDLTestsPlugin.getInstallURL();

    public BugFixesTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)BugFixesTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new BugFixesTest("TypeAndElementResolution"){

            protected void runTest() {
                this.testTypeAndElementResolution();
            }
        });
        suite.addTest((Test)new BugFixesTest("MIMEGetTypeName"){

            protected void runTest() {
                this.testReturnsProperQNameForMIMEExtensibilityElements();
            }
        });
        suite.addTest((Test)new BugFixesTest("ImportsElementOrder"){

            protected void runTest() {
                this.testPlacesImportsAfterTheDefinitionElement();
            }
        });
        suite.addTest((Test)new BugFixesTest("ResolveWSDLElement"){

            protected void runTest() {
                this.testResolvesElementInImports();
            }
        });
        suite.addTest((Test)new BugFixesTest("PartsSerialization"){

            protected void runTest() {
                this.testSerializesPartsInSOAPBody();
            }
        });
        suite.addTest((Test)new BugFixesTest("ImportsSerialization"){

            protected void runTest() {
                this.testSerializesImportsBeforeTypes();
            }
        });
        suite.addTest((Test)new BugFixesTest("LocalNamespacePrefixes"){

            protected void runTest() {
                this.testSupportsLocalNamespacePrefixes();
            }
        });
        suite.addTest((Test)new BugFixesTest("OperationExtensionElements"){

            protected void runTest() {
                this.testTolleratesExtensionElementsForOperation();
            }
        });
        suite.addTest((Test)new BugFixesTest("ReconcilesBindingFaults"){

            protected void runTest() {
                this.testReconcilesBindingFaults();
            }
        });
        suite.addTest((Test)new BugFixesTest("DuplicateSAXErrorDiagnostics"){

            protected void runTest() {
                this.testAvoidDuplicateSAXExceptionDiagnostics();
            }
        });
        suite.addTest((Test)new BugFixesTest("BindingOperationReconciliation"){

            protected void runTest() {
                this.testBindingOperationReconciliation();
            }
        });
        suite.addTest((Test)new BugFixesTest("FullElementExtensibility"){

            protected void runTest() {
                this.testFullElementExtensibility();
            }
        });
        suite.addTest((Test)new BugFixesTest("TypesExtensibility"){

            protected void runTest() {
                this.testTypesExtensibility();
            }
        });
        suite.addTest((Test)new BugFixesTest("AllowNullNamespaceURI"){

            protected void runTest() {
                this.testAllowNullNamespaceURI();
            }
        });
        suite.addTest((Test)new BugFixesTest("LoadsNamelessDefinition"){

            protected void runTest() {
                this.testLoadsNamelessDefinition();
            }
        });
        suite.addTest((Test)new BugFixesTest("HandlesDocumentationElements"){

            protected void runTest() {
                this.testHandlesDocumentationElements();
            }
        });
        suite.addTest((Test)new BugFixesTest("SupportsLocalNSForExtensibilityElements"){

            protected void runTest() {
                this.testSupportsLocalNSForExtensibilityElements();
            }
        });
        suite.addTest((Test)new BugFixesTest("InlineTypesFromImportsAreVisible"){

            protected void runTest() {
                this.testInlineTypesFromImportsAreVisible();
            }
        });
        suite.addTest((Test)new BugFixesTest("PropagatesTargetNamespaceChange"){

            protected void runTest() {
                this.testPropagatesTargetNamespaceChange();
            }
        });
        suite.addTest((Test)new BugFixesTest("RemoveBinding"){

            protected void runTest() {
                this.testRemoveBinding();
            }
        });
        suite.addTest((Test)new BugFixesTest("RemoveMessage"){

            protected void runTest() {
                this.testRemoveMessage();
            }
        });
        suite.addTest((Test)new BugFixesTest("RemovePortType"){

            protected void runTest() {
                this.testRemovePortType();
            }
        });
        suite.addTest((Test)new BugFixesTest("RemoveService"){

            protected void runTest() {
                this.testRemoveService();
            }
        });
        suite.addTest((Test)new BugFixesTest("GetWSDLType"){

            protected void runTest() {
                this.testGetWSDLType();
            }
        });
        suite.addTest((Test)new BugFixesTest("InvalidXSDImports"){

            protected void runTest() {
                this.testInvalidXSDImports();
            }
        });
        suite.addTest((Test)new BugFixesTest("ReconcileNonWSDLElements"){

            protected void runTest() {
                this.testReconcileNonWSDLElements();
            }
        });
        suite.addTest((Test)new BugFixesTest("ReconcilesImportsWithNoLocation"){

            protected void runTest() {
                this.testReconcilesImportsWithNoLocation();
            }
        });
        suite.addTest((Test)new BugFixesTest("ReconcilesExtensibleElements"){

            protected void runTest() {
                this.testReconcilesExtensibleElements();
            }
        });
        suite.addTest((Test)new BugFixesTest("ImportsWithNonStandardFileExtension"){

            protected void runTest() {
                this.testImportsWithNonStandardFileExtension();
            }
        });
        suite.addTest((Test)new BugFixesTest("LocalDefaultNamespace"){

            protected void runTest() {
                this.testSupportsLocalDefaultNamespace();
            }
        });
        suite.addTest((Test)new BugFixesTest("MoveOperation"){

            protected void runTest() {
                this.testMoveOperation();
            }
        });
        suite.addTest((Test)new BugFixesTest("SOAPBodyForMIME"){

            protected void runTest() {
                this.testReconcilesSOAPBodyPartsInMIMEBinding();
            }
        });
        return suite;
    }

    public void testTypeAndElementResolution() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/TypeAndElementResolution/Test.wsdl");
            XSDSchema inlineSchema = (XSDSchema)definition.getETypes().getSchemas().get(1);
            XSDImport xsdImport = (XSDImport)inlineSchema.getContents().get(0);
            XSDSchema schema = xsdImport.getResolvedSchema();
            Iterator messagesIterator = definition.getEMessages().iterator();
            while (messagesIterator.hasNext()) {
                Part part;
                Message message = (Message)messagesIterator.next();
                String name = message.getQName().getLocalPart();
                if (name.equals("testRequest")) {
                    part = (Part)message.getEParts().get(0);
                    XSDTypeDefinition myType = part.getTypeDefinition();
                    BugFixesTest.assertEquals((Object)schema, (Object)myType.getContainer());
                    continue;
                }
                if (!name.equals("testResponse")) continue;
                part = (Part)message.getEParts().get(0);
                XSDElementDeclaration myElement = part.getElementDeclaration();
                BugFixesTest.assertEquals((Object)schema, (Object)myElement.getContainer());
            }
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    public void testReturnsProperQNameForMIMEExtensibilityElements() {
        MIMEFactory factory = MIMEPackage.eINSTANCE.getMIMEFactory();
        MIMEContent content = factory.createMIMEContent();
        QName contentElementType = content.getElementType();
        BugFixesTest.assertEquals((String)"http://schemas.xmlsoap.org/wsdl/mime/", (String)contentElementType.getNamespaceURI());
        BugFixesTest.assertEquals((String)"content", (String)contentElementType.getLocalPart());
        MIMEMimeXml mimeXml = factory.createMIMEMimeXml();
        QName mimeXmlElementType = mimeXml.getElementType();
        BugFixesTest.assertEquals((String)"http://schemas.xmlsoap.org/wsdl/mime/", (String)mimeXmlElementType.getNamespaceURI());
        BugFixesTest.assertEquals((String)"mimeXml", (String)mimeXmlElementType.getLocalPart());
        MIMEMultipartRelated multipartRelated = factory.createMIMEMultipartRelated();
        QName multipartRelatedElementType = multipartRelated.getElementType();
        BugFixesTest.assertEquals((String)"http://schemas.xmlsoap.org/wsdl/mime/", (String)multipartRelatedElementType.getNamespaceURI());
        BugFixesTest.assertEquals((String)"multipartRelated", (String)multipartRelatedElementType.getLocalPart());
        MIMEPart part = factory.createMIMEPart();
        QName partElementType = part.getElementType();
        BugFixesTest.assertEquals((String)"http://schemas.xmlsoap.org/wsdl/mime/", (String)partElementType.getNamespaceURI());
        BugFixesTest.assertEquals((String)"part", (String)partElementType.getLocalPart());
    }

    public void testPlacesImportsAfterTheDefinitionElement() {
        WSDLFactory factory = WSDLPackage.eINSTANCE.getWSDLFactory();
        String namespace = "testNamespace";
        Definition definition = factory.createDefinition();
        definition.setQName(new QName(namespace, "testDefinition"));
        definition.updateElement();
        Service service = factory.createService();
        service.setQName(new QName(namespace, "testService"));
        definition.addService((javax.wsdl.Service)service);
        Import wsdlImport = factory.createImport();
        definition.addImport((javax.wsdl.Import)wsdlImport);
        Element definitionElement = definition.getElement();
        Element serviceElement = service.getElement();
        Element importElement = wsdlImport.getElement();
        NodeList definitionElementChildren = definitionElement.getChildNodes();
        Node firstChild = definitionElementChildren.item(0);
        BugFixesTest.assertSame((Object)importElement, (Object)firstChild);
        Node secondChild = definitionElementChildren.item(1);
        BugFixesTest.assertSame((Object)serviceElement, (Object)secondChild);
    }

    public void testResolvesElementInImports() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/WSDLElementResolution/main.wsdl");
            String targetNamespace = "http://www.example.com";
            QName firstLevelMessageQName = new QName(targetNamespace, "testINPUTmessage");
            javax.wsdl.Message firstLevelMessage = definition.getMessage(firstLevelMessageQName);
            BugFixesTest.assertNotNull((Object)firstLevelMessage);
            QName secondLevelMessageQName = new QName(targetNamespace, "testOUTPUTmessage");
            javax.wsdl.Message secondLevelMessage = definition.getMessage(secondLevelMessageQName);
            BugFixesTest.assertNotNull((Object)secondLevelMessage);
            Import firstLevelImport = (Import)definition.getImports(targetNamespace).get(0);
            Definition firstLevelDefinition = firstLevelImport.getEDefinition();
            BugFixesTest.assertEquals((Object)firstLevelDefinition, (Object)((Message)firstLevelMessage).getEnclosingDefinition());
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    public void testSerializesPartsInSOAPBody() {
        WSDLFactory factory = WSDLPackage.eINSTANCE.getWSDLFactory();
        String targetNamespace = "testNamespace";
        Definition definition = factory.createDefinition();
        definition.setTargetNamespace(targetNamespace);
        definition.setQName(new QName(targetNamespace, "testDefinition"));
        definition.addNamespace("tns", targetNamespace);
        definition.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        definition.addNamespace("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
        Message message = factory.createMessage();
        QName messageQName = new QName(targetNamespace, "testMessage");
        message.setQName(messageQName);
        definition.addMessage((javax.wsdl.Message)message);
        Part part1 = factory.createPart();
        String part1Name = "part1";
        part1.setName(part1Name);
        part1.setTypeName(new QName("http://www.w3.org/2001/XMLSchema", "string"));
        message.addPart((javax.wsdl.Part)part1);
        Part part2 = factory.createPart();
        String part2Name = "part2";
        part2.setName(part2Name);
        part2.setTypeName(new QName("http://www.w3.org/2001/XMLSchema", "string"));
        message.addPart((javax.wsdl.Part)part2);
        PortType portType = factory.createPortType();
        QName portQName = new QName(targetNamespace, "testPort");
        portType.setQName(portQName);
        definition.addPortType((javax.wsdl.PortType)portType);
        Operation operation = factory.createOperation();
        String operationName = "testOperation";
        operation.setName(operationName);
        portType.addOperation((javax.wsdl.Operation)operation);
        Input input = factory.createInput();
        input.setMessage((javax.wsdl.Message)message);
        operation.setInput((javax.wsdl.Input)input);
        Binding binding = factory.createBinding();
        QName bindingQName = new QName(targetNamespace, "testBinding");
        binding.setQName(bindingQName);
        binding.setPortType((javax.wsdl.PortType)portType);
        definition.addBinding((javax.wsdl.Binding)binding);
        BindingOperation bindingOperation = factory.createBindingOperation();
        bindingOperation.setOperation((javax.wsdl.Operation)operation);
        binding.addBindingOperation((javax.wsdl.BindingOperation)bindingOperation);
        BindingInput bindingInput = factory.createBindingInput();
        bindingOperation.setBindingInput((javax.wsdl.BindingInput)bindingInput);
        SOAPFactory soapFactory = SOAPPackage.eINSTANCE.getSOAPFactory();
        SOAPBody soapBody = soapFactory.createSOAPBody();
        bindingInput.addExtensibilityElement((ExtensibilityElement)soapBody);
        definition.updateElement();
        Element soapBodyElement = soapBody.getElement();
        Attr partsAttributeNode = soapBodyElement.getAttributeNode("parts");
        BugFixesTest.assertNull((Object)partsAttributeNode);
        ArrayList<Part> parts = new ArrayList<Part>();
        parts.add(part1);
        soapBody.setParts(parts);
        soapBody.updateElement();
        soapBodyElement = soapBody.getElement();
        String partsAttributeValue = soapBodyElement.getAttribute("parts");
        BugFixesTest.assertEquals((String)part1Name, (String)partsAttributeValue);
        parts.add(part2);
        soapBody.setParts(parts);
        soapBody.updateElement();
        soapBodyElement = soapBody.getElement();
        partsAttributeValue = soapBodyElement.getAttribute("parts");
        BugFixesTest.assertEquals((String)(String.valueOf(part1Name) + " " + part2Name), (String)partsAttributeValue);
    }

    public void testSerializesImportsBeforeTypes() {
        WSDLFactory factory = WSDLPackage.eINSTANCE.getWSDLFactory();
        String namespace = "testNamespace";
        Definition definition = factory.createDefinition();
        definition.setQName(new QName(namespace, "testDefinition"));
        definition.updateElement();
        Types types = factory.createTypes();
        definition.setTypes((javax.wsdl.Types)types);
        Import wsdlImport = factory.createImport();
        definition.addImport((javax.wsdl.Import)wsdlImport);
        Element definitionElement = definition.getElement();
        Element typesElement = types.getElement();
        Element importElement = wsdlImport.getElement();
        NodeList definitionElementChildren = definitionElement.getChildNodes();
        Node firstChild = definitionElementChildren.item(0);
        BugFixesTest.assertSame((Object)importElement, (Object)firstChild);
        Node secondChild = definitionElementChildren.item(1);
        BugFixesTest.assertSame((Object)typesElement, (Object)secondChild);
        definition.setElement(null);
        definition.updateElement();
        definitionElement = definition.getElement();
        typesElement = types.getElement();
        importElement = wsdlImport.getElement();
        definitionElementChildren = definitionElement.getChildNodes();
        firstChild = definitionElementChildren.item(0);
        BugFixesTest.assertSame((Object)importElement, (Object)firstChild);
        secondChild = definitionElementChildren.item(1);
        BugFixesTest.assertSame((Object)typesElement, (Object)secondChild);
    }

    public void testRemoveMessage() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/WSDL4JRemove/RemoveViaWSDL4J.wsdl", true);
            String targetNamespace = definition.getTargetNamespace();
            String importedTargetNamespace = "http://www.example.org/ImportMe/";
            int totalMessages = 5;
            definition.updateElement();
            BugFixesTest.assertEquals((String)"Initial messages were not properly loaded (checked via definition.getMessages())", (int)totalMessages, (int)definition.getMessages().size());
            BugFixesTest.assertEquals((String)"Initial messages were not properly loaded (checked via definition.getEMessages())", (int)totalMessages, (int)definition.getEMessages().size());
            Element definitionElement = definition.getElement();
            NodeList messageElements = definitionElement.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "message");
            BugFixesTest.assertEquals((String)"Initial messages were not properly loaded (checked via DOM)", (int)totalMessages, (int)messageElements.getLength());
            QName messageQName = new QName(targetNamespace, "RemoveViaWSDL4JMessageExtra");
            javax.wsdl.Message message = definition.getMessage(messageQName);
            BugFixesTest.assertNotNull((String)"Unable to find RemoveViaWSDL4JMessageExtra", (Object)message);
            javax.wsdl.Message removedMessage = definition.removeMessage(messageQName);
            BugFixesTest.assertEquals((String)"Incorrect message removed", (Object)message, (Object)removedMessage);
            javax.wsdl.Message nonexistMessage = definition.getMessage(messageQName);
            BugFixesTest.assertNull((String)"RemoveViaWSDL4JMessageExtra still exists in model", (Object)nonexistMessage);
            BugFixesTest.assertEquals((String)"Message was not removed (checked via definition.getMessages())", (int)(totalMessages - 1), (int)definition.getMessages().size());
            BugFixesTest.assertEquals((String)"Message was not removed (checked via definition.getEMessages())", (int)(totalMessages - 1), (int)definition.getEMessages().size());
            definitionElement = definition.getElement();
            messageElements = definitionElement.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "message");
            BugFixesTest.assertEquals((String)"Message was not removed (checked via DOM)", (int)(totalMessages - 1), (int)messageElements.getLength());
            messageQName = new QName(importedTargetNamespace, "ImportMeMessageExtra");
            message = definition.getMessage(messageQName);
            BugFixesTest.assertNotNull((String)"Unable to find ImportMeMessageExtra", (Object)message);
            removedMessage = definition.removeMessage(messageQName);
            BugFixesTest.assertNull((String)"ImportMeMessageExtra was incorrectly removed", (Object)removedMessage);
            message = definition.getMessage(messageQName);
            BugFixesTest.assertNotNull((String)"ImportMeMessageExtra no longer exists", (Object)message);
            nonexistMessage = definition.removeMessage(new QName(targetNamespace, "doesntexist"));
            BugFixesTest.assertNull((String)"A non-existing message was removed", (Object)nonexistMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
            BugFixesTest.fail();
        }
    }

    public void testRemoveService() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/WSDL4JRemove/RemoveViaWSDL4J.wsdl", true);
            String targetNamespace = definition.getTargetNamespace();
            String importedTargetNamespace = "http://www.example.org/ImportMe/";
            int totalServices = 2;
            definition.updateElement();
            BugFixesTest.assertEquals((String)"Initial services were not properly loaded (checked via definition.getServices())", (int)totalServices, (int)definition.getServices().size());
            BugFixesTest.assertEquals((String)"Initial services were not properly loaded (checked via definition.getEServices())", (int)totalServices, (int)definition.getEServices().size());
            Element definitionElement = definition.getElement();
            NodeList serviceElements = definitionElement.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "service");
            BugFixesTest.assertEquals((String)"Initial services were not properly loaded (checked via DOM)", (int)totalServices, (int)serviceElements.getLength());
            QName serviceQName = new QName(targetNamespace, "MainServiceExtra");
            javax.wsdl.Service service = definition.getService(serviceQName);
            BugFixesTest.assertNotNull((String)"Unable to find MainServiceExtra", (Object)service);
            javax.wsdl.Service removedService = definition.removeService(serviceQName);
            BugFixesTest.assertEquals((String)"Incorrect service removed", (Object)service, (Object)removedService);
            javax.wsdl.Service nonexistService = definition.getService(serviceQName);
            BugFixesTest.assertNull((String)"MainServiceExtra still exists in model", (Object)nonexistService);
            BugFixesTest.assertEquals((String)"Service was not removed (checked via definition.getServices())", (int)(totalServices - 1), (int)definition.getServices().size());
            BugFixesTest.assertEquals((String)"Service was not removed (checked via definition.getEServices())", (int)(totalServices - 1), (int)definition.getEServices().size());
            definitionElement = definition.getElement();
            serviceElements = definitionElement.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "service");
            BugFixesTest.assertEquals((String)"Service was not removed (checked via DOM)", (int)(totalServices - 1), (int)serviceElements.getLength());
            serviceQName = new QName(importedTargetNamespace, "ImportServiceExtra");
            service = definition.getService(serviceQName);
            BugFixesTest.assertNotNull((String)"Unable to find ImportServiceExtra", (Object)service);
            removedService = definition.removeService(serviceQName);
            BugFixesTest.assertNull((String)"ImportServiceExtra was incorrectly removed", (Object)removedService);
            service = definition.getService(serviceQName);
            BugFixesTest.assertNotNull((String)"ImportServiceExtra no longer exists", (Object)service);
            nonexistService = definition.removeService(new QName(targetNamespace, "doesntexist"));
            BugFixesTest.assertNull((String)"A non-existing service was removed", (Object)nonexistService);
        }
        catch (Exception e) {
            e.printStackTrace();
            BugFixesTest.fail();
        }
    }

    public void testRemoveBinding() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/WSDL4JRemove/RemoveViaWSDL4J.wsdl", true);
            String targetNamespace = definition.getTargetNamespace();
            String importedTargetNamespace = "http://www.example.org/ImportMe/";
            int totalBindings = 2;
            definition.updateElement();
            BugFixesTest.assertEquals((String)"Initial bindings were not properly loaded (checked via definition.getBindings())", (int)totalBindings, (int)definition.getBindings().size());
            BugFixesTest.assertEquals((String)"Initial bindings were not properly loaded (checked via definition.getEBindings())", (int)totalBindings, (int)definition.getEBindings().size());
            Element definitionElement = definition.getElement();
            NodeList bindingElements = definitionElement.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "binding");
            BugFixesTest.assertEquals((String)"Initial bindings were not properly loaded (checked via DOM)", (int)totalBindings, (int)bindingElements.getLength());
            QName bindingQName = new QName(targetNamespace, "MainBindingExtra");
            javax.wsdl.Binding binding = definition.getBinding(bindingQName);
            BugFixesTest.assertNotNull((String)"Unable to find MainBindingExtra", (Object)binding);
            javax.wsdl.Binding removedBinding = definition.removeBinding(bindingQName);
            BugFixesTest.assertEquals((String)"Incorrect binding removed", (Object)binding, (Object)removedBinding);
            javax.wsdl.Binding nonexistBinding = definition.getBinding(bindingQName);
            BugFixesTest.assertNull((String)"MainBindingExtra still exists in model", (Object)nonexistBinding);
            BugFixesTest.assertEquals((String)"Binding was not removed (checked via definition.getBindings())", (int)(totalBindings - 1), (int)definition.getBindings().size());
            BugFixesTest.assertEquals((String)"Binding was not removed (checked via definition.getEBindings())", (int)(totalBindings - 1), (int)definition.getEBindings().size());
            definitionElement = definition.getElement();
            bindingElements = definitionElement.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "binding");
            BugFixesTest.assertEquals((String)"Binding was not removed (checked via DOM)", (int)(totalBindings - 1), (int)bindingElements.getLength());
            bindingQName = new QName(importedTargetNamespace, "ImportBindingExtra");
            binding = definition.getBinding(bindingQName);
            BugFixesTest.assertNotNull((String)"Unable to find ImportBindingExtra", (Object)binding);
            removedBinding = definition.removeBinding(bindingQName);
            BugFixesTest.assertNull((String)"ImportBindingExtra was incorrectly removed", (Object)removedBinding);
            binding = definition.getBinding(bindingQName);
            BugFixesTest.assertNotNull((String)"ImportBindingExtra no longer exists", (Object)binding);
            nonexistBinding = definition.removeBinding(new QName(targetNamespace, "doesntexist"));
            BugFixesTest.assertNull((String)"A non-existing binding was removed", (Object)nonexistBinding);
        }
        catch (Exception e) {
            e.printStackTrace();
            BugFixesTest.fail();
        }
    }

    public void testRemovePortType() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/WSDL4JRemove/RemoveViaWSDL4J.wsdl", true);
            String targetNamespace = definition.getTargetNamespace();
            String importedTargetNamespace = "http://www.example.org/ImportMe/";
            int totalPortTypes = 2;
            definition.updateElement();
            BugFixesTest.assertEquals((String)"Initial port types were not properly loaded (checked via definition.getPortTypes())", (int)totalPortTypes, (int)definition.getPortTypes().size());
            BugFixesTest.assertEquals((String)"Initial port types were not properly loaded (checked via definition.getEPortTypes())", (int)totalPortTypes, (int)definition.getEPortTypes().size());
            Element definitionElement = definition.getElement();
            NodeList portTypeElements = definitionElement.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "portType");
            BugFixesTest.assertEquals((String)"Initial port types were not properly loaded (checked via DOM)", (int)totalPortTypes, (int)portTypeElements.getLength());
            QName portTypeQName = new QName(targetNamespace, "MainPortTypeExtra");
            javax.wsdl.PortType portType = definition.getPortType(portTypeQName);
            BugFixesTest.assertNotNull((String)"Unable to find MainPortTypeExtra", (Object)portType);
            javax.wsdl.PortType removedPortType = definition.removePortType(portTypeQName);
            BugFixesTest.assertEquals((String)"Incorrect portType removed", (Object)portType, (Object)removedPortType);
            javax.wsdl.PortType nonexistPortType = definition.getPortType(portTypeQName);
            BugFixesTest.assertNull((String)"MainPortTypeExtra still exists in model", (Object)nonexistPortType);
            BugFixesTest.assertEquals((String)"PortType was not removed (checked via definition.getPortTypes())", (int)(totalPortTypes - 1), (int)definition.getPortTypes().size());
            BugFixesTest.assertEquals((String)"PortType was not removed (checked via definition.getEPortTypes())", (int)(totalPortTypes - 1), (int)definition.getEPortTypes().size());
            definitionElement = definition.getElement();
            portTypeElements = definitionElement.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "portType");
            BugFixesTest.assertEquals((String)"PortType was not removed (checked via DOM)", (int)(totalPortTypes - 1), (int)portTypeElements.getLength());
            portTypeQName = new QName(importedTargetNamespace, "ImportPortTypeExtra");
            portType = definition.getPortType(portTypeQName);
            BugFixesTest.assertNotNull((String)"Unable to find ImportPortTypeExtra", (Object)portType);
            removedPortType = definition.removePortType(portTypeQName);
            BugFixesTest.assertNull((String)"ImportPortTypeExtra was incorrectly removed", (Object)removedPortType);
            portType = definition.getPortType(portTypeQName);
            BugFixesTest.assertNotNull((String)"ImportPortTypeExtra no longer exists", (Object)portType);
            nonexistPortType = definition.removePortType(new QName(targetNamespace, "doesntexist"));
            BugFixesTest.assertNull((String)"A non-existing portType was removed", (Object)nonexistPortType);
        }
        catch (Exception e) {
            e.printStackTrace();
            BugFixesTest.fail();
        }
    }

    public void testSupportsLocalNamespacePrefixes() {
        Definition definition = null;
        try {
            definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/LocalNamespace/LocalNamespace.wsdl");
        }
        catch (IOException e) {
            BugFixesTest.fail((String)e.getMessage());
        }
        String targetNamespace = "http://tempuri.org/Simple/";
        QName responseMessageQName = new QName(targetNamespace, "myOperationResponse");
        javax.wsdl.Message responseMessage = definition.getMessage(responseMessageQName);
        Part responsePart = (Part)responseMessage.getPart("myOperationResponse");
        XSDElementDeclaration responseElementDeclaration = responsePart.getElementDeclaration();
        BugFixesTest.assertNotNull((Object)responseElementDeclaration);
        BugFixesTest.assertNotNull((Object)responseElementDeclaration.getContainer());
        QName requestMessageQName = new QName(targetNamespace, "myOperationRequest");
        javax.wsdl.Message requestMessage = definition.getMessage(requestMessageQName);
        Part requestPart = (Part)requestMessage.getPart("myOperationRequest");
        XSDElementDeclaration requestElementDeclaration = requestPart.getElementDeclaration();
        BugFixesTest.assertNotNull((Object)requestElementDeclaration);
        requestPart.setElementDeclaration(responseElementDeclaration);
        Element partElement = requestPart.getElement();
        String elementAttributeValue = partElement.getAttribute("element");
        BugFixesTest.assertEquals((String)elementAttributeValue, (String)("parttns:" + responseElementDeclaration.getName()));
    }

    public void testTolleratesExtensionElementsForOperation() {
        Definition definition = null;
        try {
            definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/OperationStyle/OperationStyleTest.wsdl");
        }
        catch (IOException e) {
            BugFixesTest.fail((String)e.getMessage());
        }
        PortType portType = (PortType)definition.getEPortTypes().get(0);
        EList operations = portType.getEOperations();
        Operation operation = (Operation)operations.get(0);
        OperationType operationType = operation.getStyle();
        BugFixesTest.assertEquals((Object)OperationType.REQUEST_RESPONSE, (Object)operationType);
    }

    public void testReconcilesBindingFaults() {
        Definition definition = null;
        try {
            definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/BindingFaultReconciliation/BindingFaultSample.wsdl");
        }
        catch (IOException e) {
            BugFixesTest.fail((String)e.getMessage());
        }
        EList bindings = definition.getEBindings();
        Binding binding = (Binding)bindings.get(0);
        List bindingOperations = binding.getBindingOperations();
        BindingOperation bindingOperation = (BindingOperation)bindingOperations.get(0);
        BindingFault bindingFault = (BindingFault)bindingOperation.getBindingFault("Operation1Fault");
        Fault fault = bindingFault.getEFault();
        BugFixesTest.assertNull((Object)fault);
        EList portTypes = definition.getEPortTypes();
        PortType portType = (PortType)portTypes.get(0);
        EList operations = portType.getEOperations();
        Operation operation = (Operation)operations.get(1);
        javax.wsdl.Fault expectedFault1 = operation.getFault("Operation2Fault1");
        javax.wsdl.Fault expectedFault2 = operation.getFault("Operation2Fault2");
        BindingOperation bindingOperation2 = (BindingOperation)bindingOperations.get(1);
        BindingFault bindingFault1 = (BindingFault)bindingOperation2.getBindingFault("Operation2Fault1");
        Fault actualFault1 = bindingFault1.getEFault();
        BugFixesTest.assertNotNull((Object)actualFault1);
        BugFixesTest.assertEquals((Object)expectedFault1, (Object)actualFault1);
        BindingFault bindingFault2 = (BindingFault)bindingOperation2.getBindingFault("Operation2Fault2");
        Fault actualFault2 = bindingFault2.getEFault();
        BugFixesTest.assertNotNull((Object)actualFault2);
        BugFixesTest.assertEquals((Object)expectedFault2, (Object)actualFault2);
    }

    public void testAvoidDuplicateSAXExceptionDiagnostics() {
        Definition definition = null;
        try {
            definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/DuplicateSAXException/SAXException.wsdl", true, true);
        }
        catch (IOException e) {
            BugFixesTest.fail((String)e.getMessage());
        }
        Resource resource = definition.eResource();
        EList errors = resource.getErrors();
        int expectedSize = 1;
        int actualSize = errors.size();
        BugFixesTest.assertEquals((int)expectedSize, (int)actualSize);
    }

    public void testBindingOperationReconciliation() {
        Definition definition = null;
        try {
            definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/BindingOperationReconciliation/BindingOperationReconciliation.wsdl", true);
        }
        catch (IOException e) {
            BugFixesTest.fail((String)e.getMessage());
        }
        String targetNamespace = "http://www.example.org/BindingOperationReconciliation/";
        QName portTypeQName = new QName(targetNamespace, "BindingOperationReconciliation");
        javax.wsdl.PortType portType = definition.getPortType(portTypeQName);
        String input3Name = "Input3";
        String output3Name = "Output3";
        String operationName = "NewOperation";
        javax.wsdl.Operation operation1 = portType.getOperation(operationName, null, null);
        QName bindingQName = new QName(targetNamespace, "BindingOperationReconciliationSOAP");
        javax.wsdl.Binding binding = definition.getBinding(bindingQName);
        javax.wsdl.BindingOperation bindingOperation1 = binding.getBindingOperation(operationName, null, null);
        javax.wsdl.Operation actualOperation1 = bindingOperation1.getOperation();
        BugFixesTest.assertEquals((Object)operation1, (Object)actualOperation1);
        String input2Name = "Input2";
        String output2Name = "Output2";
        String operation2Name = "NewOperation2";
        javax.wsdl.BindingOperation bindingOperation2 = binding.getBindingOperation(operation2Name, input2Name, output2Name);
        javax.wsdl.Operation actualOperation2 = bindingOperation2.getOperation();
        BugFixesTest.assertEquals(null, (Object)actualOperation2);
        String operation3Name = "NewOperation3";
        javax.wsdl.Operation operation3 = portType.getOperation(operation3Name, input3Name, output3Name);
        javax.wsdl.BindingOperation bindingOperation3 = binding.getBindingOperation(operation3Name, input3Name, output3Name);
        javax.wsdl.Operation actualOperation3 = bindingOperation3.getOperation();
        BugFixesTest.assertEquals((Object)operation3, (Object)actualOperation3);
    }

    public void testFullElementExtensibility() {
        Definition definition = null;
        try {
            definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/FullElementExtensibility/ExtendedWSDL.wsdl", true);
        }
        catch (IOException e) {
            BugFixesTest.fail((String)e.getMessage());
        }
        String extensionsNamespaceURI = "http://www.example.org/Extensions/";
        EList imports = definition.getEImports();
        BugFixesTest.assertFalse((boolean)imports.isEmpty());
        Import theImport = (Import)imports.get(0);
        this.checkExtension((ExtensibleElement)theImport, extensionsNamespaceURI, "import");
        EList messages = definition.getEMessages();
        BugFixesTest.assertFalse((boolean)messages.isEmpty());
        Message message = (Message)messages.get(0);
        this.checkExtension((ExtensibleElement)message, extensionsNamespaceURI, "message");
        Part part = (Part)message.getPart("extendedPart");
        BugFixesTest.assertNotNull((Object)part);
        this.checkExtension((ExtensibleElement)part, extensionsNamespaceURI, "part");
        EList portTypes = definition.getEPortTypes();
        BugFixesTest.assertFalse((boolean)portTypes.isEmpty());
        PortType portType = (PortType)portTypes.get(0);
        this.checkExtension((ExtensibleElement)portType, extensionsNamespaceURI, "portType");
        Operation operation = (Operation)portType.getOperation("extendedOperation", null, null);
        BugFixesTest.assertNotNull((Object)operation);
        this.checkExtension((ExtensibleElement)operation, extensionsNamespaceURI, "operation");
        Input input = operation.getEInput();
        BugFixesTest.assertNotNull((Object)input);
        this.checkExtension((ExtensibleElement)input, extensionsNamespaceURI, "input");
        Output output = operation.getEOutput();
        BugFixesTest.assertNotNull((Object)output);
        this.checkExtension((ExtensibleElement)output, extensionsNamespaceURI, "output");
        Fault fault = (Fault)operation.getFault("extendedFault");
        BugFixesTest.assertNotNull((Object)fault);
        this.checkExtension((ExtensibleElement)fault, extensionsNamespaceURI, "fault");
    }

    private void checkExtension(ExtensibleElement extensibleElement, String extensionsNamespaceURI, String elementName) {
        List extensibilityElements = extensibleElement.getExtensibilityElements();
        BugFixesTest.assertFalse((boolean)extensibilityElements.isEmpty());
        ExtensibilityElement extensibilityElement = (ExtensibilityElement)extensibilityElements.get(0);
        QName elementType = extensibilityElement.getElementType();
        String nsURI = elementType.getNamespaceURI();
        String localPart = elementType.getLocalPart();
        BugFixesTest.assertEquals((String)extensionsNamespaceURI, (String)nsURI);
        BugFixesTest.assertEquals((String)localPart, (String)elementName);
    }

    public void testTypesExtensibility() {
        Definition definition = null;
        try {
            definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/TypesExtensibility/TypesExtensibility.wsdl", true);
        }
        catch (IOException e) {
            BugFixesTest.fail((String)e.getMessage());
        }
        Types types = definition.getETypes();
        List extensibilityElements = types.getExtensibilityElements();
        BugFixesTest.assertEquals((int)3, (int)extensibilityElements.size());
        String otherTypesNamespace = "http://www.example.org/OtherTypes/";
        ExtensibilityElement extensibilityElement = (ExtensibilityElement)extensibilityElements.get(0);
        QName elementType = extensibilityElement.getElementType();
        BugFixesTest.assertEquals((String)otherTypesNamespace, (String)elementType.getNamespaceURI());
        BugFixesTest.assertEquals((String)"typeDef", (String)elementType.getLocalPart());
        List schemas = types.getSchemas();
        BugFixesTest.assertEquals((int)1, (int)schemas.size());
        XSDSchemaExtensibilityElement schemaExtensibilityElement = (XSDSchemaExtensibilityElement)extensibilityElements.get(1);
        XSDSchema schema = schemaExtensibilityElement.getSchema();
        BugFixesTest.assertNotNull((Object)schema);
        XSDElementDeclaration elementDeclaration = schema.resolveElementDeclaration("test");
        BugFixesTest.assertNotNull((Object)elementDeclaration);
        BugFixesTest.assertNotNull((Object)elementDeclaration.getContainer());
        extensibilityElement = (ExtensibilityElement)extensibilityElements.get(2);
        elementType = extensibilityElement.getElementType();
        BugFixesTest.assertEquals((String)otherTypesNamespace, (String)elementType.getNamespaceURI());
        BugFixesTest.assertEquals((String)"typeDef", (String)elementType.getLocalPart());
    }

    public void testAllowNullNamespaceURI() {
        Definition definition = null;
        try {
            definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/NullNamespaceURI/ContactInfoService.wsdl", true);
        }
        catch (IOException e) {
            BugFixesTest.fail((String)e.getMessage());
        }
        String targetNamespace = "http://www.example.org/ContactInfoService";
        QName output1QName = new QName(targetNamespace, "updatePhoneNumberResponseMsg");
        Message output1Message = (Message)definition.getMessage(output1QName);
        BugFixesTest.assertNotNull((Object)output1Message);
        Part part1 = (Part)output1Message.getPart("output1");
        BugFixesTest.assertNotNull((Object)part1);
        QName output2ElementName = part1.getElementName();
        BugFixesTest.assertNotNull((Object)output2ElementName);
        BugFixesTest.assertEquals((String)"", (String)output2ElementName.getNamespaceURI());
        XSDElementDeclaration output2ElementDeclaration = part1.getElementDeclaration();
        BugFixesTest.assertNotNull((Object)output2ElementDeclaration);
        BugFixesTest.assertNotNull((Object)output2ElementDeclaration.getContainer());
        BugFixesTest.assertNull((Object)output2ElementDeclaration.getTargetNamespace());
        QName output2QName = new QName(targetNamespace, "updateAddressResponseMsg");
        Message output2Message = (Message)definition.getMessage(output2QName);
        BugFixesTest.assertNotNull((Object)output2Message);
        Part part2 = (Part)output2Message.getPart("output2");
        BugFixesTest.assertNotNull((Object)part1);
        QName output2TypeName = part2.getTypeName();
        BugFixesTest.assertNotNull((Object)output2TypeName);
        BugFixesTest.assertEquals((String)"", (String)output2TypeName.getNamespaceURI());
        XSDTypeDefinition output2TypeDefinition = part2.getTypeDefinition();
        BugFixesTest.assertNotNull((Object)output2TypeDefinition);
        BugFixesTest.assertNotNull((Object)output2TypeDefinition.getContainer());
        BugFixesTest.assertNull((Object)output2TypeDefinition.getTargetNamespace());
    }

    public void testLoadsNamelessDefinition() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/LoadsNamelessDefinition/MissingName.wsdl");
            BugFixesTest.assertNull((Object)definition.getQName());
            definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/LoadsNamelessDefinition/WithName.wsdl");
            BugFixesTest.assertNotNull((Object)definition);
            QName name = definition.getQName();
            BugFixesTest.assertNotNull((Object)name);
            BugFixesTest.assertEquals((String)"WSDLFile", (String)name.getLocalPart());
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    public void testHandlesDocumentationElements() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/HandlesDocumentationElements/Documented.wsdl");
            WSDLFactory factory = WSDLFactory.eINSTANCE;
            Import anImport = factory.createImport();
            anImport.setNamespaceURI("http://www.test.com");
            definition.addImport((javax.wsdl.Import)anImport);
            Element definitionDocumentationElement = definition.getDocumentationElement();
            BugFixesTest.assertNotNull((Object)definitionDocumentationElement);
            Element expectedImportElement = this.getNextElement(definitionDocumentationElement);
            Element importElement = anImport.getElement();
            BugFixesTest.assertEquals((Object)importElement, (Object)expectedImportElement);
            Message aMessage = (Message)definition.getEMessages().get(0);
            Part newPart = factory.createPart();
            aMessage.addPart((javax.wsdl.Part)newPart);
            Element messageElement = aMessage.getElement();
            Element messageDocumentationElement = aMessage.getDocumentationElement();
            BugFixesTest.assertNotNull((Object)messageDocumentationElement);
            Element firstChildElement = this.getFirstChildElement(messageElement);
            BugFixesTest.assertEquals((Object)messageDocumentationElement, (Object)firstChildElement);
            Element partElement = newPart.getElement();
            Element lastChildElement = this.getLastChildElement(messageElement);
            BugFixesTest.assertEquals((Object)partElement, (Object)lastChildElement);
            PortType portType = (PortType)definition.getEPortTypes().get(0);
            Operation newOperation = factory.createOperation();
            portType.addOperation((javax.wsdl.Operation)newOperation);
            Element portTypeElement = portType.getElement();
            Element portTypeDocumentationElement = portType.getDocumentationElement();
            BugFixesTest.assertNotNull((Object)portTypeDocumentationElement);
            firstChildElement = this.getFirstChildElement(portTypeElement);
            BugFixesTest.assertEquals((Object)portTypeDocumentationElement, (Object)firstChildElement);
            Element newOperationElement = newOperation.getElement();
            lastChildElement = this.getLastChildElement(portTypeElement);
            BugFixesTest.assertEquals((Object)newOperationElement, (Object)lastChildElement);
            Operation operation = (Operation)portType.getEOperations().get(0);
            Output output = factory.createOutput();
            operation.setOutput((javax.wsdl.Output)output);
            Element operationElement = operation.getElement();
            Element operationDocumentationElement = operation.getDocumentationElement();
            BugFixesTest.assertNotNull((Object)operationDocumentationElement);
            firstChildElement = this.getFirstChildElement(operationElement);
            BugFixesTest.assertEquals((Object)operationDocumentationElement, (Object)firstChildElement);
            Element outputElement = output.getElement();
            lastChildElement = this.getLastChildElement(operationElement);
            BugFixesTest.assertEquals((Object)outputElement, (Object)lastChildElement);
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    public void testSupportsLocalNSForExtensibilityElements() {
        try {
            String uri = String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/LocalNamespace/LocalNamespace2.wsdl";
            javax.wsdl.factory.WSDLFactory factory = WSDLPlugin.INSTANCE.createWSDL4JFactory();
            WSDLReader wsdlReader = factory.newWSDLReader();
            javax.wsdl.Definition definition = wsdlReader.readWSDL(uri);
            String targetNamespace = "http://www.example.org/example/";
            QName bindingQName = new QName(targetNamespace, "exampleSOAP");
            javax.wsdl.Binding binding = definition.getBinding(bindingQName);
            BugFixesTest.assertNotNull((Object)binding);
            List extensibilityElements = binding.getExtensibilityElements();
            BugFixesTest.assertEquals((int)1, (int)extensibilityElements.size());
            ExtensibilityElement soapBinding = (ExtensibilityElement)extensibilityElements.get(0);
            BugFixesTest.assertNotNull((Object)soapBinding);
            QName bindingElementType = soapBinding.getElementType();
            BugFixesTest.assertNotNull((Object)bindingElementType);
            String localPart = bindingElementType.getLocalPart();
            BugFixesTest.assertEquals((String)"binding", (String)localPart);
            String namespaceURI = bindingElementType.getNamespaceURI();
            BugFixesTest.assertEquals((String)"http://schemas.xmlsoap.org/wsdl/soap/", (String)namespaceURI);
            BugFixesTest.assertTrue((boolean)(soapBinding instanceof SOAPBinding));
            QName serviceQName = new QName(targetNamespace, "example");
            javax.wsdl.Service service = definition.getService(serviceQName);
            javax.wsdl.Port port = service.getPort("exampleSOAP");
            extensibilityElements = port.getExtensibilityElements();
            BugFixesTest.assertEquals((int)1, (int)extensibilityElements.size());
            ExtensibilityElement soapAddress = (ExtensibilityElement)extensibilityElements.get(0);
            BugFixesTest.assertNotNull((Object)soapAddress);
            QName portElementType = soapAddress.getElementType();
            BugFixesTest.assertNotNull((Object)portElementType);
            localPart = portElementType.getLocalPart();
            BugFixesTest.assertEquals((String)"address", (String)localPart);
            namespaceURI = portElementType.getNamespaceURI();
            BugFixesTest.assertEquals((String)"http://schemas.xmlsoap.org/wsdl/soap/", (String)namespaceURI);
            BugFixesTest.assertTrue((boolean)(soapAddress instanceof SOAPAddress));
        }
        catch (WSDLException e) {
            e.printStackTrace();
            BugFixesTest.fail();
        }
    }

    private Element getNextElement(Element anElement) {
        Node node = anElement.getNextSibling();
        while (node != null && node.getNodeType() != 1) {
            node = node.getNextSibling();
        }
        return (Element)node;
    }

    private Element getFirstChildElement(Element anElement) {
        Node node = anElement.getFirstChild();
        while (node != null && node.getNodeType() != 1) {
            node = node.getNextSibling();
        }
        return (Element)node;
    }

    private Element getLastChildElement(Element anElement) {
        Node node = anElement.getLastChild();
        while (node != null && node.getNodeType() != 1) {
            node = node.getPreviousSibling();
        }
        return (Element)node;
    }

    public void testInlineTypesFromImportsAreVisible() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/InlineTypesFromImportsAreVisible/A.wsdl");
            String targetNamespace = "http://A";
            QName messageQName = new QName(targetNamespace, "message");
            javax.wsdl.Message message = definition.getMessage(messageQName);
            BugFixesTest.assertNotNull((Object)message);
            Part part = (Part)message.getPart("parameters");
            BugFixesTest.assertNotNull((Object)part);
            XSDTypeDefinition typeDefinition = part.getTypeDefinition();
            BugFixesTest.assertNotNull((Object)typeDefinition);
            String namespace = typeDefinition.getTargetNamespace();
            BugFixesTest.assertEquals((String)"http://B", (String)namespace);
            BugFixesTest.assertEquals((String)"BType", (String)typeDefinition.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            BugFixesTest.fail();
        }
    }

    public void testPropagatesTargetNamespaceChange() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/TargetNamespace/TargetNamespace.wsdl", true);
            String oldTargetNamespace = definition.getTargetNamespace();
            QName messageQName = new QName(oldTargetNamespace, "NewOperationRequest");
            javax.wsdl.Message message = definition.getMessage(messageQName);
            BugFixesTest.assertNotNull((Object)message);
            QName portTypeQName = new QName(oldTargetNamespace, "TargetNamespace");
            javax.wsdl.PortType portType = definition.getPortType(portTypeQName);
            BugFixesTest.assertNotNull((Object)portType);
            QName bindingQName = new QName(oldTargetNamespace, "TargetNamespaceSOAP");
            javax.wsdl.Binding binding = definition.getBinding(bindingQName);
            BugFixesTest.assertNotNull((Object)binding);
            QName serviceQName = new QName(oldTargetNamespace, "TargetNamespace");
            javax.wsdl.Service service = definition.getService(serviceQName);
            BugFixesTest.assertNotNull((Object)service);
            String newTargetNamespace = "http://www.example.org/NewTargetNamespace/";
            definition.setTargetNamespace(newTargetNamespace);
            Element definitionElement = definition.getElement();
            Attr targetNamespaceNode = definitionElement.getAttributeNode("targetNamespace");
            BugFixesTest.assertNotNull((Object)targetNamespaceNode);
            BugFixesTest.assertEquals((String)newTargetNamespace, (String)targetNamespaceNode.getValue());
            messageQName = new QName(newTargetNamespace, messageQName.getLocalPart());
            message = definition.getMessage(messageQName);
            BugFixesTest.assertNotNull((Object)message);
            portTypeQName = new QName(newTargetNamespace, portTypeQName.getLocalPart());
            portType = definition.getPortType(portTypeQName);
            BugFixesTest.assertNotNull((Object)portType);
            bindingQName = new QName(newTargetNamespace, bindingQName.getLocalPart());
            binding = definition.getBinding(bindingQName);
            BugFixesTest.assertNotNull((Object)binding);
            serviceQName = new QName(newTargetNamespace, serviceQName.getLocalPart());
            service = definition.getService(serviceQName);
            BugFixesTest.assertNotNull((Object)service);
        }
        catch (Exception e) {
            e.printStackTrace();
            BugFixesTest.fail();
        }
    }

    public void testGetWSDLType() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/GetWSDLType/BadImport.wsdl", true);
            definition.updateElement();
            Element definitionElement = definition.getElement();
            int type = WSDLUtil.getInstance().getWSDLType(definitionElement);
            BugFixesTest.assertEquals((String)"Definition type incorrectly identified", (int)1, (int)type);
            NodeList childNodes = definitionElement.getChildNodes();
            Node n = childNodes.item(0);
            if (n.getNodeType() != 1) {
                n = n.getNextSibling();
            }
            type = WSDLUtil.getInstance().getWSDLType((Element)n);
            BugFixesTest.assertEquals((String)"Import type incorrectly identified", (int)4, (int)type);
            n = n.getNextSibling();
            if (n.getNodeType() != 1) {
                n = n.getNextSibling();
            }
            type = WSDLUtil.getInstance().getWSDLType((Element)n);
            BugFixesTest.assertEquals((String)"xsd:import type incorrectly identified", (int)-1, (int)type);
            n = n.getNextSibling();
            if (n.getNodeType() != 1) {
                n = n.getNextSibling();
            }
            type = WSDLUtil.getInstance().getWSDLType((Element)n);
            BugFixesTest.assertEquals((String)"Types type incorrectly identified", (int)13, (int)type);
            n = n.getNextSibling();
            if (n.getNodeType() != 1) {
                n = n.getNextSibling();
            }
            type = WSDLUtil.getInstance().getWSDLType((Element)n);
            BugFixesTest.assertEquals((String)"Message type incorrectly identified", (int)6, (int)type);
            n = n.getNextSibling();
            n = n.getNextSibling();
            if (n.getNodeType() != 1) {
                n = n.getNextSibling();
            }
            type = WSDLUtil.getInstance().getWSDLType((Element)n);
            BugFixesTest.assertEquals((String)"Message type incorrectly identified", (int)6, (int)type);
            n = n.getNextSibling();
            if (n.getNodeType() != 1) {
                n = n.getNextSibling();
            }
            type = WSDLUtil.getInstance().getWSDLType((Element)n);
            BugFixesTest.assertEquals((String)"Port type type incorrectly identified", (int)11, (int)type);
            n = n.getNextSibling();
            if (n.getNodeType() != 1) {
                n = n.getNextSibling();
            }
            type = WSDLUtil.getInstance().getWSDLType((Element)n);
            BugFixesTest.assertEquals((String)"Binding type incorrectly identified", (int)0, (int)type);
            n = n.getNextSibling();
            if (n.getNodeType() != 1) {
                n = n.getNextSibling();
            }
            type = WSDLUtil.getInstance().getWSDLType((Element)n);
            BugFixesTest.assertEquals((String)"Service type incorrectly identified", (int)12, (int)type);
        }
        catch (Exception e) {
            e.printStackTrace();
            BugFixesTest.fail();
        }
    }

    public void testInvalidXSDImports() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/GetWSDLType/BadImport.wsdl", true);
            Map imports = definition.getImports();
            BugFixesTest.assertEquals((String)"Incorrect number of imports", (int)1, (int)imports.size());
            List extElements = definition.getExtensibilityElements();
            BugFixesTest.assertEquals((String)"Incorrect number of extensibility elements", (int)1, (int)extElements.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            BugFixesTest.fail();
        }
    }

    public void testReconcileNonWSDLElements() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/ReconcileNonWSDLElements/ReconcileNonWSDLElements.wsdl", true);
            Definition newDefinition = WSDLFactory.eINSTANCE.createDefinition();
            BugFixesTest.assertNotNull((String)"The new definition cannot be null", (Object)newDefinition);
            newDefinition.addNamespace("wsdl", "http://example.org");
            newDefinition.updateElement();
            Document newDocument = newDefinition.getDocument();
            BugFixesTest.assertNotNull((String)"The new definition's document cannot be null", (Object)newDocument);
            Types types = (Types)definition.getTypes();
            BugFixesTest.assertNotNull((String)"The definition must have Types", (Object)types);
            Element typesNode = types.getElement();
            BugFixesTest.assertNotNull((String)"The Types element cannot be null", (Object)typesNode);
            Node toImport = newDocument.importNode(typesNode, true);
            newDefinition.getElement().appendChild(toImport);
            BugFixesTest.assertNotNull((String)"The definition must have messages", (Object)definition.getMessages());
            Message messageToAdd = (Message)definition.getMessage(new QName("http://www.example.com/ReconcileNonWSDLElements/", "NewOperationRequest"));
            Element messageNode = messageToAdd.getElement();
            BugFixesTest.assertNotNull((String)"The message to add to the new definition cannot be null", (Object)messageNode);
            Node toImport2 = newDefinition.getDocument().importNode(messageNode, false);
            BugFixesTest.assertTrue((String)"No messages should exist", (newDefinition.getEMessages().size() == 0 ? 1 : 0) != 0);
            newDefinition.getElement().appendChild(toImport2);
            BugFixesTest.assertTrue((String)"A message should have been added", (newDefinition.getEMessages().size() == 1 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            BugFixesTest.fail();
        }
    }

    public void testReconcilesImportsWithNoLocation() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/ReconcilesImportsWithNoLocation/Main.wsdl", true);
            BugFixesTest.assertNotNull((Object)definition);
            String targetNamespace = "http://www.example.org/B/";
            QName serviceQName = new QName(targetNamespace, "B");
            javax.wsdl.Service service = definition.getService(serviceQName);
            BugFixesTest.assertNotNull((Object)service);
        }
        catch (Exception e) {
            e.printStackTrace();
            BugFixesTest.fail();
        }
    }

    public void testReconcilesExtensibleElements() {
        Definition definition = null;
        try {
            definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/ReconcilesExtensibleElements/ExtensibleElementSample.wsdl");
        }
        catch (IOException e) {
            BugFixesTest.fail((String)e.getMessage());
        }
        this.ensureExtensibilityElementRemoved((ExtensibleElement)definition, 1);
        EList imports = definition.getEImports();
        Import myImport = (Import)imports.get(0);
        this.ensureExtensibilityElementRemoved((ExtensibleElement)myImport, 1);
        Types types = definition.getETypes();
        this.ensureExtensibilityElementRemoved((ExtensibleElement)types, 2);
        Service service = (Service)definition.getEServices().get(0);
        this.ensureExtensibilityElementRemoved((ExtensibleElement)service, 1);
        Port port = (Port)service.getEPorts().get(0);
        this.ensureExtensibilityElementRemoved((ExtensibleElement)port, 2);
        Binding binding = port.getEBinding();
        this.ensureExtensibilityElementRemoved((ExtensibleElement)binding, 2);
        List bindingOperations = binding.getBindingOperations();
        BindingOperation bindingOperation = (BindingOperation)bindingOperations.get(0);
        this.ensureExtensibilityElementRemoved((ExtensibleElement)bindingOperation, 2);
        BindingInput bindingInput = bindingOperation.getEBindingInput();
        this.ensureExtensibilityElementRemoved((ExtensibleElement)bindingInput, 2);
        BindingOutput bindingOutput = bindingOperation.getEBindingOutput();
        this.ensureExtensibilityElementRemoved((ExtensibleElement)bindingOutput, 2);
        EList bindingFaults = bindingOperation.getEBindingFaults();
        BindingFault bindingFault = (BindingFault)bindingFaults.get(0);
        this.ensureExtensibilityElementRemoved((ExtensibleElement)bindingFault, 2);
        PortType portType = binding.getEPortType();
        this.ensureExtensibilityElementRemoved((ExtensibleElement)portType, 1);
        EList operations = portType.getEOperations();
        Operation operation = (Operation)operations.get(0);
        this.ensureExtensibilityElementRemoved((ExtensibleElement)operation, 1);
        Output output = operation.getEOutput();
        this.ensureExtensibilityElementRemoved((ExtensibleElement)output, 1);
        Input input = operation.getEInput();
        this.ensureExtensibilityElementRemoved((ExtensibleElement)input, 1);
        EList faults = operation.getEFaults();
        Fault fault = (Fault)faults.get(0);
        this.ensureExtensibilityElementRemoved((ExtensibleElement)fault, 1);
        Message message = input.getEMessage();
        this.ensureExtensibilityElementRemoved((ExtensibleElement)message, 1);
        EList parts = message.getEParts();
        Part part = (Part)parts.get(0);
        this.ensureExtensibilityElementRemoved((ExtensibleElement)part, 1);
    }

    private void ensureExtensibilityElementRemoved(ExtensibleElement extensibleElement, int originalSize) {
        List extensibilityElements = extensibleElement.getExtensibilityElements();
        BugFixesTest.assertEquals((int)originalSize, (int)extensibilityElements.size());
        UnknownExtensibilityElement unknownExtensibilityElement = null;
        Iterator extensibilityElementsIterator = extensibilityElements.iterator();
        while (extensibilityElementsIterator.hasNext()) {
            Object object = extensibilityElementsIterator.next();
            if (!(object instanceof UnknownExtensibilityElement)) continue;
            unknownExtensibilityElement = (UnknownExtensibilityElement)object;
            break;
        }
        if (unknownExtensibilityElement == null) {
            BugFixesTest.fail((String)"Cannot find the UnknownExtensibilityElement.");
        }
        Element element = unknownExtensibilityElement.getElement();
        extensibleElement.getElement().removeChild(element);
        extensibleElement.elementChanged(extensibleElement.getElement());
        BugFixesTest.assertEquals((int)(originalSize - 1), (int)extensibilityElements.size());
    }

    public void testImportsWithNonStandardFileExtension() {
        String WSDL_NS = "http://www.example.org/ImportWithNonStandardWSDLFileExtension/wsdl0/";
        String XSD_NS = "http://www.example.org/NonStandardSchemaFileExtension/xsd0";
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/ImportsWithNonStandardFileExtension/ImportWithNonStandardFileExtension.wsdl", true);
            EList imports = definition.getEImports();
            BugFixesTest.assertEquals((String)"Incorrect number of imports", (int)2, (int)imports.size());
            int i = 0;
            while (i < imports.size()) {
                Import myImport = (Import)imports.get(i);
                BugFixesTest.assertTrue((String)"Incorrect imported namespace", (WSDL_NS.equals(myImport.getNamespaceURI()) || XSD_NS.equals(myImport.getNamespaceURI()) ? 1 : 0) != 0);
                if (WSDL_NS.equals(myImport.getNamespaceURI())) {
                    Definition importedDefinition = myImport.getEDefinition();
                    BugFixesTest.assertNotNull((Object)importedDefinition);
                    Map bindings = importedDefinition.getBindings();
                    BugFixesTest.assertEquals((String)"Incorrect number of binding elements in imported WSDL", (int)1, (int)bindings.size());
                    List schemas = importedDefinition.getETypes().getSchemas();
                    BugFixesTest.assertEquals((int)1, (int)schemas.size());
                    XSDSchema schema = (XSDSchema)schemas.get(0);
                    EList types = schema.getTypeDefinitions();
                    BugFixesTest.assertEquals((String)"Incorrect number of types definitions in the inline schema of the imported WSDL", (int)1, (int)types.size());
                    Object type = types.get(0);
                    BugFixesTest.assertTrue((String)"Not complex type", (boolean)(type instanceof XSDComplexTypeDefinition));
                    XSDComplexTypeDefinition complexTypeDefinition = (XSDComplexTypeDefinition)type;
                    BugFixesTest.assertEquals((String)"Incorrect name for the ComplexType imported from NonStandardSchemaFileExtension.xsd0", (String)"NewType", (String)complexTypeDefinition.getName());
                    String testAttribute = complexTypeDefinition.getElement().getAttribute("testXSD0");
                    BugFixesTest.assertEquals((String)"Incorrect test attribute for the ComplexType imported from NonStandardSchemaFileExtension.xsd0", (String)"passed", (String)testAttribute);
                } else {
                    XSDSchema schema = myImport.getESchema();
                    EList types = schema.getTypeDefinitions();
                    BugFixesTest.assertEquals((String)"Incorrect number of types definitions in imported XSD", (int)1, (int)types.size());
                    Object type = types.get(0);
                    BugFixesTest.assertTrue((String)"Not complex type", (boolean)(type instanceof XSDComplexTypeDefinition));
                    XSDComplexTypeDefinition complexTypeDefinition = (XSDComplexTypeDefinition)type;
                    BugFixesTest.assertEquals((String)"Incorrect name for the ComplexType imported from NonStandardSchemaFileExtension.xsd1", (String)"ImportedTypeViaWSDLImport", (String)complexTypeDefinition.getName());
                    String testAttribute = complexTypeDefinition.getElement().getAttribute("testXSD1");
                    BugFixesTest.assertEquals((String)"Incorrect test attribute for the ComplexType imported from NonStandardSchemaFileExtension.xsd1", (String)"passed", (String)testAttribute);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BugFixesTest.fail();
        }
    }

    public void testSupportsLocalDefaultNamespace() {
        Definition definition = null;
        try {
            definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/LocalNamespace/LocalDefaultNamespace.wsdl");
        }
        catch (IOException e) {
            BugFixesTest.fail((String)e.getMessage());
        }
        String targetNamespace = "http://www.example.org/LocalDefaultNamespace";
        QName responseMessageQName = new QName(targetNamespace, "TestResponseMessage");
        javax.wsdl.Message responseMessage = definition.getMessage(responseMessageQName);
        Part responsePart = (Part)responseMessage.getPart("parameters");
        XSDElementDeclaration responseElementDeclaration = responsePart.getElementDeclaration();
        BugFixesTest.assertNotNull((Object)responseElementDeclaration);
        BugFixesTest.assertNotNull((Object)responseElementDeclaration.getContainer());
        QName requestMessageQName = new QName(targetNamespace, "TestRequestMessage");
        javax.wsdl.Message requestMessage = definition.getMessage(requestMessageQName);
        Part requestPart = (Part)requestMessage.getPart("parameters");
        XSDElementDeclaration requestElementDeclaration = requestPart.getElementDeclaration();
        BugFixesTest.assertNotNull((Object)requestElementDeclaration);
        requestPart.setElementDeclaration(responseElementDeclaration);
        Element partElement = requestPart.getElement();
        String elementAttributeValue = partElement.getAttribute("element");
        BugFixesTest.assertEquals((String)elementAttributeValue, (String)responseElementDeclaration.getName());
    }

    public void testMoveOperation() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/MoveOperationsTest/PortTypeWithTwoOperations.wsdl");
            Assert.assertNotNull((Object)definition);
            PortType portType = (PortType)definition.getEPortTypes().get(0);
            Assert.assertNotNull((Object)portType);
            EList list = portType.getEOperations();
            EObject eObject1 = (EObject)list.get(0);
            EObject eObject2 = (EObject)list.get(1);
            if (eObject1 instanceof Operation && eObject2 instanceof Operation) {
                Operation op1 = (Operation)eObject1;
                Operation op2 = (Operation)eObject2;
                BugFixesTest.assertEquals((String)"operation1", (String)op1.getName());
                BugFixesTest.assertEquals((String)"operation2", (String)op2.getName());
                BugFixesTest.assertNotNull((Object)op1.getInput().getMessage());
                portType.getEOperations().move(1, (Object)op1);
                BugFixesTest.assertEquals((Object)op2, (Object)portType.getEOperations().get(0));
                BugFixesTest.assertNotNull((Object)op1.getInput().getMessage());
            } else {
                Assert.fail((String)"Did not get two operations.");
            }
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    public void testReconcilesSOAPBodyPartsInMIMEBinding() {
        try {
            Definition definition = DefinitionLoader.load(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples/BugFixes/SOAPBodyReconciliationForMIME/SOAPBodyForMIME.wsdl", true);
            this.checkSOAPBodyPartsInMIMEBinding(definition);
            definition.updateElement(true);
            this.checkSOAPBodyPartsInMIMEBinding(definition);
        }
        catch (Exception e) {
            e.printStackTrace();
            BugFixesTest.fail();
        }
    }

    private void checkSOAPBodyPartsInMIMEBinding(Definition definition) {
        Binding binding = (Binding)definition.getEBindings().get(0);
        List bindingOperations = binding.getBindingOperations();
        BindingOperation bindingOperation = (BindingOperation)bindingOperations.get(0);
        javax.wsdl.BindingInput bindingInput = bindingOperation.getBindingInput();
        List extensibilityElements = bindingInput.getExtensibilityElements();
        MIMEMultipartRelated multipartRelated = (MIMEMultipartRelated)extensibilityElements.get(0);
        EList mimeParts = multipartRelated.getEMIMEPart();
        MIMEPart mimePart = (MIMEPart)mimeParts.get(0);
        List mimePartExtensibilityElements = mimePart.getExtensibilityElements();
        SOAPBody soapBody = (SOAPBody)mimePartExtensibilityElements.get(0);
        List parts = soapBody.getParts();
        BugFixesTest.assertEquals((int)1, (int)parts.size());
        Part part = (Part)parts.get(0);
        String expectedPartName = "part1";
        BugFixesTest.assertEquals((String)expectedPartName, (String)part.getName());
        Element element = soapBody.getElement();
        String partsAttributeValue = element.getAttribute("parts");
        BugFixesTest.assertEquals((String)expectedPartName, (String)partsAttributeValue);
    }
}

