/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.tests.format;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.cleanup.CSSCleanupStrategy;
import org.eclipse.wst.css.core.internal.cleanup.CSSCleanupStrategyImpl;
import org.eclipse.wst.css.core.internal.cleanup.CleanupProcessorCSS;
import org.eclipse.wst.css.core.tests.util.StringCompareUtil;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class TestCleanupProcessorCSS
extends TestCase {
    private static final String UTF_8 = "UTF-8";
    private StringCompareUtil fStringCompareUtil;
    private CleanupProcessorCSS fCleanupProcessor;
    private boolean fOldClearBlankLinesPref;
    private int fOldMaxLineWidthPref;
    private String fOldIndentationCharPref;
    private int fOldIndentationSizePref;

    protected void setUp() throws Exception {
        Preferences prefs = CSSCorePlugin.getDefault().getPluginPreferences();
        this.fOldClearBlankLinesPref = prefs.getBoolean("clearAllBlankLines");
        this.fOldMaxLineWidthPref = prefs.getInt("lineWidth");
        this.fOldIndentationCharPref = prefs.getString("indentationChar");
        this.fOldIndentationSizePref = prefs.getInt("indentationSize");
        prefs.setValue("clearAllBlankLines", false);
        prefs.setValue("lineWidth", 72);
        prefs.setValue("indentationChar", "tab");
        prefs.setValue("indentationSize", 1);
        this.fCleanupProcessor = new CleanupProcessorCSS();
        this.fStringCompareUtil = new StringCompareUtil();
    }

    protected void tearDown() throws Exception {
        Preferences prefs = CSSCorePlugin.getDefault().getPluginPreferences();
        prefs.setValue("clearAllBlankLines", this.fOldClearBlankLinesPref);
        prefs.setValue("lineWidth", this.fOldMaxLineWidthPref);
        prefs.setValue("indentationChar", this.fOldIndentationCharPref);
        prefs.setValue("indentationSize", this.fOldIndentationSizePref);
    }

    private IStructuredModel getModelForEdit(String filename) {
        IStructuredModel model = null;
        try {
            IModelManager modelManager = StructuredModelManager.getModelManager();
            InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
            if (inStream == null) {
                throw new FileNotFoundException("Can't file resource stream " + filename);
            }
            String baseFile = ((Object)((Object)this)).getClass().getResource(filename).toString();
            model = modelManager.getModelForEdit(baseFile, inStream, null);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return model;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cleanupAndAssertEquals(String beforePath, String afterPath) throws UnsupportedEncodingException, IOException, CoreException {
        IStructuredModel afterModel;
        block4: {
            IStructuredModel beforeModel = null;
            afterModel = null;
            try {
                beforeModel = this.getModelForEdit(beforePath);
                TestCleanupProcessorCSS.assertNotNull((String)("could not retrieve structured model for : " + beforePath), (Object)beforeModel);
                afterModel = this.getModelForEdit(afterPath);
                TestCleanupProcessorCSS.assertNotNull((String)("could not retrieve structured model for : " + afterPath), (Object)afterModel);
                this.fCleanupProcessor.cleanupModel(beforeModel);
                ByteArrayOutputStream cleanedupBytes = new ByteArrayOutputStream();
                beforeModel.save((OutputStream)cleanedupBytes);
                ByteArrayOutputStream afterBytes = new ByteArrayOutputStream();
                afterModel.save((OutputStream)afterBytes);
                String cleanedupContents = new String(afterBytes.toByteArray(), UTF_8);
                String expectedContents = new String(cleanedupBytes.toByteArray(), UTF_8);
                TestCleanupProcessorCSS.assertTrue((String)"Cleanup document differs from the expected", (boolean)this.fStringCompareUtil.equalsIgnoreLineSeperator(cleanedupContents, expectedContents));
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (beforeModel != null) {
                    beforeModel.releaseFromEdit();
                }
                if (afterModel == null) throw throwable;
                afterModel.releaseFromEdit();
                throw throwable;
            }
            {
                Object var9_11 = null;
                if (beforeModel == null) break block4;
            }
            beforeModel.releaseFromEdit();
        }
        if (afterModel == null) return;
        afterModel.releaseFromEdit();
    }

    public void testBUG166909urlCaseCleanup() throws UnsupportedEncodingException, IOException, CoreException {
        CSSCleanupStrategy currentStrategy = CSSCleanupStrategyImpl.getInstance();
        short oldCaseIdentifier = currentStrategy.getIdentCase();
        short oldCasePropertyName = currentStrategy.getPropNameCase();
        short oldCasePropertyValue = currentStrategy.getPropValueCase();
        short oldCaseSelector = currentStrategy.getSelectorTagCase();
        boolean oldFormatSource = currentStrategy.isFormatSource();
        boolean oldFormatQuote = currentStrategy.isQuoteValues();
        currentStrategy.setIdentCase((short)1);
        currentStrategy.setPropNameCase((short)1);
        currentStrategy.setPropValueCase((short)1);
        currentStrategy.setSelectorTagCase((short)1);
        currentStrategy.setFormatSource(true);
        currentStrategy.setQuoteValues(false);
        this.cleanupAndAssertEquals("testfiles/bug166909-urlcase.css", "testfiles/bug166909-urlcase-cleaned.css");
        currentStrategy.setIdentCase(oldCaseIdentifier);
        currentStrategy.setPropNameCase(oldCasePropertyName);
        currentStrategy.setPropValueCase(oldCasePropertyValue);
        currentStrategy.setSelectorTagCase(oldCaseSelector);
        currentStrategy.setFormatSource(oldFormatSource);
        currentStrategy.setQuoteValues(oldFormatQuote);
    }

    public void testBug218993NoFormatCleanup() throws UnsupportedEncodingException, IOException, CoreException {
        CSSCleanupStrategy currentStrategy = CSSCleanupStrategyImpl.getInstance();
        short oldCaseIdentifier = currentStrategy.getIdentCase();
        short oldCasePropertyName = currentStrategy.getPropNameCase();
        short oldCasePropertyValue = currentStrategy.getPropValueCase();
        short oldCaseSelector = currentStrategy.getSelectorTagCase();
        boolean oldFormatSource = currentStrategy.isFormatSource();
        boolean oldFormatQuote = currentStrategy.isQuoteValues();
        currentStrategy.setIdentCase((short)1);
        currentStrategy.setPropNameCase((short)1);
        currentStrategy.setPropValueCase((short)1);
        currentStrategy.setSelectorTagCase((short)1);
        currentStrategy.setFormatSource(false);
        currentStrategy.setQuoteValues(false);
        this.cleanupAndAssertEquals("testfiles/bug218993-noformat.css", "testfiles/bug218993-noformat-cleaned.css");
        currentStrategy.setIdentCase(oldCaseIdentifier);
        currentStrategy.setPropNameCase(oldCasePropertyName);
        currentStrategy.setPropValueCase(oldCasePropertyValue);
        currentStrategy.setSelectorTagCase(oldCaseSelector);
        currentStrategy.setFormatSource(oldFormatSource);
        currentStrategy.setQuoteValues(oldFormatQuote);
    }
}

