/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.tests.format;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.format.FormatProcessorCSS;
import org.eclipse.wst.css.core.tests.util.StringCompareUtil;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class TestFormatProcessorCSS
extends TestCase {
    private static final String UTF_8 = "UTF-8";
    private StringCompareUtil fStringCompareUtil;
    private FormatProcessorCSS formatProcessor;
    private boolean fOldClearBlankLinesPref;
    private int fOldMaxLineWidthPref;
    private String fOldIndentationCharPref;
    private int fOldIndentationSizePref;

    public TestFormatProcessorCSS(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        Preferences prefs = CSSCorePlugin.getDefault().getPluginPreferences();
        this.fOldClearBlankLinesPref = prefs.getBoolean("clearAllBlankLines");
        this.fOldMaxLineWidthPref = prefs.getInt("lineWidth");
        this.fOldIndentationCharPref = prefs.getString("indentationChar");
        this.fOldIndentationSizePref = prefs.getInt("indentationSize");
        prefs.setValue("clearAllBlankLines", false);
        prefs.setValue("lineWidth", 72);
        prefs.setValue("indentationChar", "tab");
        prefs.setValue("indentationSize", 1);
        this.formatProcessor = new FormatProcessorCSS();
        this.fStringCompareUtil = new StringCompareUtil();
    }

    protected void tearDown() throws Exception {
        Preferences prefs = CSSCorePlugin.getDefault().getPluginPreferences();
        prefs.setValue("clearAllBlankLines", this.fOldClearBlankLinesPref);
        prefs.setValue("lineWidth", this.fOldMaxLineWidthPref);
        prefs.setValue("indentationChar", this.fOldIndentationCharPref);
        prefs.setValue("indentationSize", this.fOldIndentationSizePref);
    }

    private IStructuredModel getModelForEdit(String filename) {
        IStructuredModel model = null;
        try {
            IModelManager modelManager = StructuredModelManager.getModelManager();
            InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
            if (inStream == null) {
                throw new FileNotFoundException("Can't file resource stream " + filename);
            }
            String baseFile = ((Object)((Object)this)).getClass().getResource(filename).toString();
            model = modelManager.getModelForEdit(baseFile, inStream, null);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return model;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void formatAndAssertEquals(String beforePath, String afterPath) throws UnsupportedEncodingException, IOException, CoreException {
        IStructuredModel afterModel;
        block4: {
            IStructuredModel beforeModel = null;
            afterModel = null;
            try {
                beforeModel = this.getModelForEdit(beforePath);
                TestFormatProcessorCSS.assertNotNull((String)("could not retrieve structured model for : " + beforePath), (Object)beforeModel);
                afterModel = this.getModelForEdit(afterPath);
                TestFormatProcessorCSS.assertNotNull((String)("could not retrieve structured model for : " + afterPath), (Object)afterModel);
                ByteArrayOutputStream afterBytes = new ByteArrayOutputStream();
                afterModel.save((OutputStream)afterBytes);
                String expectedContents = new String(afterBytes.toByteArray(), UTF_8);
                this.formatProcessor.formatModel(beforeModel);
                ByteArrayOutputStream formattedBytes = new ByteArrayOutputStream();
                beforeModel.save((OutputStream)formattedBytes);
                String formattedContents = new String(formattedBytes.toByteArray(), UTF_8);
                TestFormatProcessorCSS.assertTrue((String)"Formatted document differs from the expected", (boolean)this.fStringCompareUtil.equalsIgnoreLineSeperator(formattedContents, expectedContents));
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (beforeModel != null) {
                    beforeModel.releaseFromEdit();
                }
                if (afterModel == null) throw throwable;
                afterModel.releaseFromEdit();
                throw throwable;
            }
            {
                Object var9_11 = null;
                if (beforeModel == null) break block4;
            }
            beforeModel.releaseFromEdit();
        }
        if (afterModel == null) return;
        afterModel.releaseFromEdit();
    }

    public void testBUG73990SelectorFormat() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("testfiles/BUG73990_selector_unformatted.css", "testfiles/BUG73990_selector_formatted.css");
    }

    public void testBUG111569extraSemicolonFormat() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("testfiles/bug111569-extrasemicolon.css", "testfiles/bug111569-extrasemicolon-formatted.css");
    }

    public void testBUG146198attributeSpecifierFormat() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("testfiles/bug146198-attributespecifier.css", "testfiles/bug146198-attributespecifier-formatted.css");
    }

    public void testBUG110539multipleClassFormat() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("testfiles/bug110539-multipleclass.css", "testfiles/bug110539-multipleclass-formatted.css");
    }

    public void testBUG248465combinedPseudoClass() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("testfiles/bug248465-combined-pseudo-classes.css", "testfiles/bug248465-combined-pseudo-classes-fmt.css");
    }

    public void testBUG196476selectorPseudoclassesFormat() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("testfiles/bug196476-selector-pseudo-classes.css", "testfiles/bug196476-selector-pseudo-classes-fmt.css");
    }

    public void testBUG163315SlashBeforePrimative1() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("testfiles/bug163315-slash_before_primative_1.css", "testfiles/bug163315-slash_before_primative_1.css");
    }

    public void testbug367579MultiSpaceAddition() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("testfiles/bug367579-MultiSpaceAdittion.css", "testfiles/bug367579-MultiSpaceAdittion.css");
    }

    public void testBUG163315SlashBeforePrimative2() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("testfiles/bug163315-slash_before_primative_2.css", "testfiles/bug163315-slash_before_primative_1.css");
    }

    public void testCollapseWhitespaceBetweenComments() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("testfiles/comments.css", "testfiles/comments-fmt.css");
    }

    public void testInlineComment() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("testfiles/inline-comment.css", "testfiles/inline-comment-fmt.css");
    }

    public void testSpaceBeforeClosingParenthesis_bug390903() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("testfiles/bug390903_SpaceBeforeClosingParenthesis.css", "testfiles/bug390903_SpaceBeforeClosingParenthesis-fmt.css");
    }

    public void testKeepCommentInSameLine_bug390904() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("testfiles/bug390904_KeepCommentInSameLine.css", "testfiles/bug390904_KeepCommentInSameLine-fmt.css");
    }
}

