/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.tests.source;

import junit.framework.TestCase;
import org.eclipse.wst.css.core.internal.document.CSSSelectorListImpl;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelector;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelectorCombinator;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelectorItem;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelectorList;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSimpleSelector;

public class CSSSelectorTest
extends TestCase {
    public void testSelector01() {
        ICSSSelectorList list = this.createSelectorList("H1, H2, H3");
        this.checkSelectorList(list, "H1, H2, H3", 3, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "H1", 1, 1, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "H1", false, 0, 0, 0, 0);
        selector = list.getSelector(1);
        this.checkSelector(selector, "H2", 1, 1, 0);
        item = selector.getItem(0);
        this.checkSimpleSelector(item, "H2", false, 0, 0, 0, 0);
        selector = list.getSelector(2);
        this.checkSelector(selector, "H3", 1, 1, 0);
        item = selector.getItem(0);
        this.checkSimpleSelector(item, "H3", false, 0, 0, 0, 0);
    }

    public void testSelector02() {
        ICSSSelectorList list = this.createSelectorList("H\\\\, H\\1, H3");
        this.checkSelectorList(list, "H\\\\, H\\1, H3", 3, 2);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "H\\\\", 1, 1, 1);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "H\\\\", false, 0, 0, 0, 0);
        selector = list.getSelector(1);
        this.checkSelector(selector, "H\\1", 1, 1, 1);
        item = selector.getItem(0);
        this.checkSimpleSelector(item, "H\\1", false, 0, 0, 0, 0);
        selector = list.getSelector(2);
        this.checkSelector(selector, "H3", 1, 1, 0);
        item = selector.getItem(0);
        this.checkSimpleSelector(item, "H3", false, 0, 0, 0, 0);
    }

    public void testSelector03() {
        ICSSSelectorList list = this.createSelectorList("H1.pastoral");
        this.checkSelectorList(list, "H1.pastoral", 1, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "H1.pastoral", 1, 101, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "H1", false, 0, 1, 0, 0);
        this.checkSimpleSelectorClasses(item, new String[]{"pastoral"});
    }

    public void testSelector04() {
        ICSSSelectorList list = this.createSelectorList("P.pastoral.marine");
        this.checkSelectorList(list, "P.pastoral.marine", 1, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "P.pastoral.marine", 1, 201, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "P", false, 0, 2, 0, 0);
        this.checkSimpleSelectorClasses(item, new String[]{"pastoral", "marine"});
    }

    public void testSelector05() {
        ICSSSelectorList list = this.createSelectorList("*.warning");
        this.checkSelectorList(list, "*.warning", 1, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "*.warning", 1, 100, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "*", true, 0, 1, 0, 0);
        this.checkSimpleSelectorClasses(item, new String[]{"warning"});
    }

    public void testSelector06() {
        ICSSSelectorList list = this.createSelectorList(".warning");
        this.checkSelectorList(list, ".warning", 1, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, ".warning", 1, 100, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "", true, 0, 1, 0, 0);
        this.checkSimpleSelectorClasses(item, new String[]{"warning"});
    }

    public void testSelector07() {
        ICSSSelectorList list = this.createSelectorList("*[lang=fr]");
        this.checkSelectorList(list, "*[lang=fr]", 1, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "*[lang=fr]", 1, 100, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "*", true, 1, 0, 0, 0);
        this.checkSimpleSelectorAttributes(item, new String[]{"lang=fr"});
    }

    public void testSelector08() {
        ICSSSelectorList list = this.createSelectorList("[lang=fr]");
        this.checkSelectorList(list, "[lang=fr]", 1, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "[lang=fr]", 1, 100, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "", true, 1, 0, 0, 0);
        this.checkSimpleSelectorAttributes(item, new String[]{"lang=fr"});
    }

    public void testSelector09() {
        ICSSSelectorList list = this.createSelectorList("*#myid");
        this.checkSelectorList(list, "*#myid", 1, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "*#myid", 1, 10000, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "*", true, 0, 0, 1, 0);
        this.checkSimpleSelectorIDs(item, new String[]{"myid"});
    }

    public void testSelector10() {
        ICSSSelectorList list = this.createSelectorList("#myid");
        this.checkSelectorList(list, "#myid", 1, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "#myid", 1, 10000, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "", true, 0, 0, 1, 0);
        this.checkSimpleSelectorIDs(item, new String[]{"myid"});
    }

    public void testSelector11() {
        ICSSSelectorList list = this.createSelectorList("H1#z98y");
        this.checkSelectorList(list, "H1#z98y", 1, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "H1#z98y", 1, 10001, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "H1", false, 0, 0, 1, 0);
        this.checkSimpleSelectorIDs(item, new String[]{"z98y"});
    }

    public void testSelector12() {
        ICSSSelectorList list = this.createSelectorList("H1 EM");
        this.checkSelectorList(list, "H1 EM", 1, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "H1 EM", 3, 2, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "H1", false, 0, 0, 0, 0);
        item = selector.getItem(1);
        this.checkSelectorCombinator(item, " ", 32);
        item = selector.getItem(2);
        this.checkSimpleSelector(item, "EM", false, 0, 0, 0, 0);
    }

    public void testSelector13() {
        ICSSSelectorList list = this.createSelectorList("DIV * P");
        this.checkSelectorList(list, "DIV * P", 1, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "DIV * P", 5, 2, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "DIV", false, 0, 0, 0, 0);
        item = selector.getItem(1);
        this.checkSelectorCombinator(item, " ", 32);
        item = selector.getItem(2);
        this.checkSimpleSelector(item, "*", true, 0, 0, 0, 0);
        item = selector.getItem(3);
        this.checkSelectorCombinator(item, " ", 32);
        item = selector.getItem(4);
        this.checkSimpleSelector(item, "P", false, 0, 0, 0, 0);
    }

    public void testSelector14() {
        ICSSSelectorList list = this.createSelectorList("DIV P *[href]");
        this.checkSelectorList(list, "DIV P *[href]", 1, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "DIV P *[href]", 5, 102, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "DIV", false, 0, 0, 0, 0);
        item = selector.getItem(1);
        this.checkSelectorCombinator(item, " ", 32);
        item = selector.getItem(2);
        this.checkSimpleSelector(item, "P", false, 0, 0, 0, 0);
        item = selector.getItem(3);
        this.checkSelectorCombinator(item, " ", 32);
        item = selector.getItem(4);
        this.checkSimpleSelector(item, "*", true, 1, 0, 0, 0);
        this.checkSimpleSelectorAttributes(item, new String[]{"href"});
    }

    public void testSelector15() {
        ICSSSelectorList list = this.createSelectorList("BODY > P");
        this.checkSelectorList(list, "BODY > P", 1, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "BODY > P", 3, 2, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "BODY", false, 0, 0, 0, 0);
        item = selector.getItem(1);
        this.checkSelectorCombinator(item, ">", 62);
        item = selector.getItem(2);
        this.checkSimpleSelector(item, "P", false, 0, 0, 0, 0);
    }

    public void testSelector16() {
        ICSSSelectorList list = this.createSelectorList("DIV OL>LI P");
        this.checkSelectorList(list, "DIV OL > LI P", 1, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "DIV OL > LI P", 7, 4, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "DIV", false, 0, 0, 0, 0);
        item = selector.getItem(1);
        this.checkSelectorCombinator(item, " ", 32);
        item = selector.getItem(2);
        this.checkSimpleSelector(item, "OL", false, 0, 0, 0, 0);
        item = selector.getItem(3);
        this.checkSelectorCombinator(item, ">", 62);
        item = selector.getItem(4);
        this.checkSimpleSelector(item, "LI", false, 0, 0, 0, 0);
        item = selector.getItem(5);
        this.checkSelectorCombinator(item, " ", 32);
        item = selector.getItem(6);
        this.checkSimpleSelector(item, "P", false, 0, 0, 0, 0);
    }

    public void testSelector17() {
        ICSSSelectorList list = this.createSelectorList("MATH + P");
        this.checkSelectorList(list, "MATH + P", 1, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "MATH + P", 3, 2, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "MATH", false, 0, 0, 0, 0);
        item = selector.getItem(1);
        this.checkSelectorCombinator(item, "+", 43);
        item = selector.getItem(2);
        this.checkSimpleSelector(item, "P", false, 0, 0, 0, 0);
    }

    public void testSelector18() {
        ICSSSelectorList list = this.createSelectorList("H1.opener + H2");
        this.checkSelectorList(list, "H1.opener + H2", 1, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "H1.opener + H2", 3, 102, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "H1", false, 0, 1, 0, 0);
        this.checkSimpleSelectorClasses(item, new String[]{"opener"});
        item = selector.getItem(1);
        this.checkSelectorCombinator(item, "+", 43);
        item = selector.getItem(2);
        this.checkSimpleSelector(item, "H2", false, 0, 0, 0, 0);
    }

    public void testSelector19() {
        ICSSSelectorList list = this.createSelectorList("EXAMPLE[notation=decimal]");
        this.checkSelectorList(list, "EXAMPLE[notation=decimal]", 1, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "EXAMPLE[notation=decimal]", 1, 101, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "EXAMPLE", false, 1, 0, 0, 0);
        this.checkSimpleSelectorAttributes(item, new String[]{"notation=decimal"});
    }

    public void testSelector20() {
        ICSSSelectorList list = this.createSelectorList("SPAN[hello=\"Cleveland\"][goodbye=\"Columbus\"]");
        this.checkSelectorList(list, "SPAN[hello=\"Cleveland\"][goodbye=\"Columbus\"]", 1, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "SPAN[hello=\"Cleveland\"][goodbye=\"Columbus\"]", 1, 201, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "SPAN", false, 2, 0, 0, 0);
        this.checkSimpleSelectorAttributes(item, new String[]{"hello=\"Cleveland\"", "goodbye=\"Columbus\""});
    }

    public void testSelector21() {
        ICSSSelectorList list = this.createSelectorList("DIV > P:first-child");
        this.checkSelectorList(list, "DIV > P:first-child", 1, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "DIV > P:first-child", 3, 102, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "DIV", false, 0, 0, 0, 0);
        item = selector.getItem(1);
        this.checkSelectorCombinator(item, ">", 62);
        item = selector.getItem(2);
        this.checkSimpleSelector(item, "P", false, 0, 0, 0, 1);
        this.checkSimpleSelectorPseudoNames(item, new String[]{"first-child"});
    }

    public void testSelector22() {
        ICSSSelectorList list = this.createSelectorList("P:first-child EM");
        this.checkSelectorList(list, "P:first-child EM", 1, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "P:first-child EM", 3, 102, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "P", false, 0, 0, 0, 1);
        this.checkSimpleSelectorPseudoNames(item, new String[]{"first-child"});
        item = selector.getItem(1);
        this.checkSelectorCombinator(item, " ", 32);
        item = selector.getItem(2);
        this.checkSimpleSelector(item, "EM", false, 0, 0, 0, 0);
    }

    public void testSelector23() {
        ICSSSelectorList list = this.createSelectorList("* > A:first-child");
        this.checkSelectorList(list, "* > A:first-child", 1, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "* > A:first-child", 3, 101, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "*", true, 0, 0, 0, 0);
        item = selector.getItem(1);
        this.checkSelectorCombinator(item, ">", 62);
        item = selector.getItem(2);
        this.checkSimpleSelector(item, "A", false, 0, 0, 0, 1);
        this.checkSimpleSelectorPseudoNames(item, new String[]{"first-child"});
    }

    public void testSelector24() {
        ICSSSelectorList list = this.createSelectorList("A:link");
        this.checkSelectorList(list, "A:link", 1, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "A:link", 1, 101, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "A", false, 0, 0, 0, 1);
        this.checkSimpleSelectorPseudoNames(item, new String[]{"link"});
    }

    public void testSelector25() {
        ICSSSelectorList list = this.createSelectorList(":link");
        this.checkSelectorList(list, ":link", 1, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, ":link", 1, 100, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "", true, 0, 0, 0, 1);
        this.checkSimpleSelectorPseudoNames(item, new String[]{"link"});
    }

    public void testSelector26() {
        ICSSSelectorList list = this.createSelectorList("A:focus:hover");
        this.checkSelectorList(list, "A:focus:hover", 1, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "A:focus:hover", 1, 201, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "A", false, 0, 0, 0, 2);
        this.checkSimpleSelectorPseudoNames(item, new String[]{"focus", "hover"});
    }

    public void testSelector27() {
        ICSSSelectorList list = this.createSelectorList("HTML:lang(de) > Q");
        this.checkSelectorList(list, "HTML:lang(de) > Q", 1, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "HTML:lang(de) > Q", 3, 102, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "HTML", false, 0, 0, 0, 1);
        this.checkSimpleSelectorPseudoNames(item, new String[]{"lang(de)"});
        item = selector.getItem(1);
        this.checkSelectorCombinator(item, ">", 62);
        item = selector.getItem(2);
        this.checkSimpleSelector(item, "Q", false, 0, 0, 0, 0);
    }

    public void testSelector28() {
        ICSSSelectorList list = this.createSelectorList("P > A:link, A.external:visited");
        this.checkSelectorList(list, "P > A:link, A.external:visited", 2, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "P > A:link", 3, 102, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "P", false, 0, 0, 0, 0);
        item = selector.getItem(1);
        this.checkSelectorCombinator(item, ">", 62);
        item = selector.getItem(2);
        this.checkSimpleSelector(item, "A", false, 0, 0, 0, 1);
        this.checkSimpleSelectorPseudoNames(item, new String[]{"link"});
        selector = list.getSelector(1);
        this.checkSelector(selector, "A.external:visited", 1, 201, 0);
        item = selector.getItem(0);
        this.checkSimpleSelector(item, "A", false, 0, 1, 0, 1);
        this.checkSimpleSelectorClasses(item, new String[]{"external"});
        this.checkSimpleSelectorPseudoNames(item, new String[]{"visited"});
    }

    public void testSelector29() {
        ICSSSelectorList list = this.createSelectorList("P#hoge98 + *:hover > A:link, A.external:visited");
        this.checkSelectorList(list, "P#hoge98 + *:hover > A:link, A.external:visited", 2, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "P#hoge98 + *:hover > A:link", 5, 10202, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "P", false, 0, 0, 1, 0);
        this.checkSimpleSelectorIDs(item, new String[]{"hoge98"});
        item = selector.getItem(1);
        this.checkSelectorCombinator(item, "+", 43);
        item = selector.getItem(2);
        this.checkSimpleSelector(item, "*", true, 0, 0, 0, 1);
        this.checkSimpleSelectorPseudoNames(item, new String[]{"hover"});
        item = selector.getItem(3);
        this.checkSelectorCombinator(item, ">", 62);
        item = selector.getItem(4);
        this.checkSimpleSelector(item, "A", false, 0, 0, 0, 1);
        this.checkSimpleSelectorPseudoNames(item, new String[]{"link"});
        selector = list.getSelector(1);
        this.checkSelector(selector, "A.external:visited", 1, 201, 0);
        item = selector.getItem(0);
        this.checkSimpleSelector(item, "A", false, 0, 1, 0, 1);
        this.checkSimpleSelectorClasses(item, new String[]{"external"});
        this.checkSimpleSelectorPseudoNames(item, new String[]{"visited"});
    }

    public void testSelector30() {
        ICSSSelectorList list = this.createSelectorList("H1.123");
        this.checkSelectorList(list, "H1.123", 1, 1);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "H1.123", 1, 101, 1);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "H1", false, 0, 1, 0, 0);
        this.checkSimpleSelectorClasses(item, new String[]{"123"});
    }

    public void testSelector31() {
        ICSSSelectorList list = this.createSelectorList("P.123.456");
        this.checkSelectorList(list, "P.123.456", 1, 2);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "P.123.456", 1, 201, 2);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "P", false, 0, 2, 0, 0);
        this.checkSimpleSelectorClasses(item, new String[]{"123", "456"});
    }

    public void testSelector32() {
        ICSSSelectorList list = this.createSelectorList("*.123");
        this.checkSelectorList(list, "*.123", 1, 1);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "*.123", 1, 100, 1);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "*", true, 0, 1, 0, 0);
        this.checkSimpleSelectorClasses(item, new String[]{"123"});
    }

    public void testSelector33() {
        ICSSSelectorList list = this.createSelectorList(".123");
        this.checkSelectorList(list, ".123", 1, 1);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, ".123", 1, 100, 1);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "", true, 0, 1, 0, 0);
        this.checkSimpleSelectorClasses(item, new String[]{"123"});
    }

    public void testSelector34() {
        ICSSSelectorList list = this.createSelectorList("H1.1x3");
        this.checkSelectorList(list, "H1.1x3", 1, 1);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "H1.1x3", 1, 101, 1);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "H1", false, 0, 1, 0, 0);
        this.checkSimpleSelectorClasses(item, new String[]{"1x3"});
    }

    public void testSelector35() {
        ICSSSelectorList list = this.createSelectorList("H2.123#46");
        this.checkSelectorList(list, "H2.123#46", 1, 1);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "H2.123#46", 1, 10101, 1);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "H2", false, 0, 1, 1, 0);
        this.checkSimpleSelectorClasses(item, new String[]{"123"});
        this.checkSimpleSelectorIDs(item, new String[]{"46"});
    }

    public void testSelector36() {
        ICSSSelectorList list = this.createSelectorList("H3.1x3#4t2");
        this.checkSelectorList(list, "H3.1x3#4t2", 1, 1);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "H3.1x3#4t2", 1, 10101, 1);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "H3", false, 0, 1, 1, 0);
        this.checkSimpleSelectorClasses(item, new String[]{"1x3"});
        this.checkSimpleSelectorIDs(item, new String[]{"4t2"});
    }

    public void testSelector37() {
        ICSSSelectorList list = this.createSelectorList("*.123");
        this.checkSelectorList(list, "*.123", 1, 1);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "*.123", 1, 100, 1);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "*", true, 0, 1, 0, 0);
        this.checkSimpleSelectorClasses(item, new String[]{"123"});
    }

    public void testSelector38() {
        ICSSSelectorList list = this.createSelectorList(".123");
        this.checkSelectorList(list, ".123", 1, 1);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, ".123", 1, 100, 1);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "", true, 0, 1, 0, 0);
        this.checkSimpleSelectorClasses(item, new String[]{"123"});
    }

    public void testSelector39() {
        ICSSSelectorList list = this.createSelectorList(".123f567");
        this.checkSelectorList(list, ".123f567", 1, 1);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, ".123f567", 1, 100, 1);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "", true, 0, 1, 0, 0);
        this.checkSimpleSelectorClasses(item, new String[]{"123f567"});
    }

    public void testSelector40() {
        ICSSSelectorList list = this.createSelectorList("h1.fix , h2.fix, h3.fix , div#container");
        this.checkSelectorList(list, "h1.fix, h2.fix, h3.fix, div#container", 4, 0);
        ICSSSelector selector = list.getSelector(0);
        this.checkSelector(selector, "h1.fix", 1, 101, 0);
        ICSSSelectorItem item = selector.getItem(0);
        this.checkSimpleSelector(item, "h1", false, 0, 1, 0, 0);
        this.checkSimpleSelectorClasses(item, new String[]{"fix"});
        selector = list.getSelector(1);
        this.checkSelector(selector, "h2.fix", 1, 101, 0);
        item = selector.getItem(0);
        this.checkSimpleSelector(item, "h2", false, 0, 1, 0, 0);
        this.checkSimpleSelectorClasses(item, new String[]{"fix"});
        selector = list.getSelector(2);
        this.checkSelector(selector, "h3.fix", 1, 101, 0);
        item = selector.getItem(0);
        this.checkSimpleSelector(item, "h3", false, 0, 1, 0, 0);
        this.checkSimpleSelectorClasses(item, new String[]{"fix"});
        selector = list.getSelector(3);
        this.checkSelector(selector, "div#container", 1, 10001, 0);
        item = selector.getItem(0);
        this.checkSimpleSelector(item, "div", false, 0, 0, 1, 0);
        this.checkSimpleSelectorIDs(item, new String[]{"container"});
    }

    private void checkSelectorList(ICSSSelectorList list, String formattedSource, int nSelectors, int nErrors) {
        CSSSelectorTest.assertEquals((String)formattedSource, (String)list.getString());
        CSSSelectorTest.assertEquals((int)nSelectors, (int)list.getLength());
        CSSSelectorTest.assertEquals((int)nErrors, (int)list.getErrorCount());
    }

    private void checkSelector(ICSSSelector selector, String formattedSource, int items, int specificity, int nErrors) {
        CSSSelectorTest.assertEquals((String)formattedSource, (String)selector.getString());
        CSSSelectorTest.assertEquals((int)items, (int)selector.getLength());
        CSSSelectorTest.assertEquals((int)specificity, (int)selector.getSpecificity());
        CSSSelectorTest.assertEquals((int)nErrors, (int)selector.getErrorCount());
    }

    private void checkSimpleSelector(ICSSSelectorItem selector, String formattedSource, boolean isUniversal, int nAttributes, int nClasses, int nIds, int nPseudoNames) {
        CSSSelectorTest.assertTrue((boolean)(selector instanceof ICSSSimpleSelector));
        CSSSelectorTest.assertEquals((String)formattedSource, (String)((ICSSSimpleSelector)selector).getName());
        CSSSelectorTest.assertEquals((boolean)isUniversal, (boolean)((ICSSSimpleSelector)selector).isUniversal());
        CSSSelectorTest.assertEquals((int)nAttributes, (int)((ICSSSimpleSelector)selector).getNumOfAttributes());
        CSSSelectorTest.assertEquals((int)nClasses, (int)((ICSSSimpleSelector)selector).getNumOfClasses());
        CSSSelectorTest.assertEquals((int)nIds, (int)((ICSSSimpleSelector)selector).getNumOfIDs());
        CSSSelectorTest.assertEquals((int)nPseudoNames, (int)((ICSSSimpleSelector)selector).getNumOfPseudoNames());
    }

    private void checkSimpleSelectorAttributes(ICSSSelectorItem selector, String[] items) {
        int nItems = ((ICSSSimpleSelector)selector).getNumOfAttributes();
        CSSSelectorTest.assertEquals((int)items.length, (int)nItems);
        int i = 0;
        while (i < nItems) {
            CSSSelectorTest.assertEquals((String)items[i], (String)((ICSSSimpleSelector)selector).getAttribute(i));
            ++i;
        }
    }

    private void checkSimpleSelectorClasses(ICSSSelectorItem selector, String[] items) {
        int nItems = ((ICSSSimpleSelector)selector).getNumOfClasses();
        CSSSelectorTest.assertEquals((int)items.length, (int)nItems);
        int i = 0;
        while (i < nItems) {
            CSSSelectorTest.assertEquals((String)items[i], (String)((ICSSSimpleSelector)selector).getClass(i));
            ++i;
        }
    }

    private void checkSimpleSelectorIDs(ICSSSelectorItem selector, String[] items) {
        int nItems = ((ICSSSimpleSelector)selector).getNumOfIDs();
        CSSSelectorTest.assertEquals((int)items.length, (int)nItems);
        int i = 0;
        while (i < nItems) {
            CSSSelectorTest.assertEquals((String)items[i], (String)((ICSSSimpleSelector)selector).getID(i));
            ++i;
        }
    }

    private void checkSimpleSelectorPseudoNames(ICSSSelectorItem selector, String[] items) {
        int nItems = ((ICSSSimpleSelector)selector).getNumOfPseudoNames();
        CSSSelectorTest.assertEquals((int)items.length, (int)nItems);
        int i = 0;
        while (i < nItems) {
            CSSSelectorTest.assertEquals((String)items[i], (String)((ICSSSimpleSelector)selector).getPseudoName(i));
            ++i;
        }
    }

    private void checkSelectorCombinator(ICSSSelectorItem combinator, String formattedSource, int combinatorType) {
        CSSSelectorTest.assertTrue((boolean)(combinator instanceof ICSSSelectorCombinator));
        CSSSelectorTest.assertEquals((String)formattedSource, (String)((ICSSSelectorCombinator)combinator).getString());
        CSSSelectorTest.assertEquals((int)combinatorType, (int)((ICSSSelectorCombinator)combinator).getCombinatorType());
    }

    private ICSSSelectorList createSelectorList(String str) {
        return new CSSSelectorListImpl(str);
    }
}

