/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.tests.internal;

import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.eclipse.wst.wsi.internal.WSITestToolsProperties;
import org.eclipse.wst.wsi.internal.report.AssertionError;
import org.eclipse.wst.wsi.tests.internal.WSITestsPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CoreConformanceTest
extends TestCase {
    public static final String TEST_CASE_FILE = "testcase.xml";
    public static final String TAD_ID_AP = "AP10";
    public static final String TAD_ID_SSBP = "SSBP10";
    protected String pluginURI = WSITestsPlugin.getInstallURL();
    protected String tadID = "AP10";

    public CoreConformanceTest(String name) {
        super(name);
    }

    protected void setup() {
    }

    protected List getExpectedAssertionFailures(String filename) {
        ArrayList<String> assertionFailures = new ArrayList<String>();
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(filename);
            NodeList list = doc.getElementsByTagName("assertion");
            if (list != null) {
                int i = 0;
                while (i < list.getLength()) {
                    Element element = (Element)list.item(i);
                    String tad = element.getAttribute("tadID");
                    if (tad != null && tad.equals(this.tadID)) {
                        assertionFailures.add(element.getAttribute("id"));
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            assertionFailures = null;
        }
        return assertionFailures;
    }

    protected void analyzeResults(List errors, List expectedErrors) {
        ArrayList<String> actualErrors = new ArrayList<String>();
        if (errors != null && expectedErrors != null) {
            for (AssertionError e : errors) {
                String assertionId = e.getAssertionID();
                actualErrors.add(assertionId);
                if (expectedErrors.contains(assertionId)) continue;
                CoreConformanceTest.fail((String)("Unexpected assertion failure: " + assertionId));
            }
            for (String assertionId : expectedErrors) {
                if (actualErrors.contains(assertionId)) continue;
                CoreConformanceTest.fail((String)("Expected assertion failure: " + assertionId));
            }
            CoreConformanceTest.assertEquals((int)expectedErrors.size(), (int)errors.size());
        }
    }

    protected String getTADURI(String tid) {
        if (tid.equals(TAD_ID_AP)) {
            return WSITestToolsProperties.AP_ASSERTION_FILE;
        }
        return WSITestToolsProperties.SSBP_ASSERTION_FILE;
    }
}

