/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.tests.contenttypeidentifier.contentspecific;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.jst.jsp.core.tests.contenttypeidentifier.contentspecific.NullStream;
import org.eclipse.wst.css.core.internal.provisional.contenttype.ContentTypeIdForCSS;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;

public class TestContentTypeHandlers
extends TestCase {
    private static final boolean DEBUG = false;

    public TestContentTypeHandlers(String name) {
        super(name);
    }

    private static IContentTypeManager getContentTypeRegistry() {
        IContentTypeManager registry = Platform.getContentTypeManager();
        return registry;
    }

    public void testCreation() {
        IContentTypeManager registry = TestContentTypeHandlers.getContentTypeRegistry();
        TestContentTypeHandlers.assertTrue((String)"content type identifer registry must exist", (registry != null ? 1 : 0) != 0);
    }

    public void testXMLExists() {
        String id = ContentTypeIdForXML.ContentTypeID_SSEXML;
        IContentTypeManager registry = TestContentTypeHandlers.getContentTypeRegistry();
        IContentType identifier = registry.getContentType(id);
        TestContentTypeHandlers.assertTrue((String)("content type identifier " + id + " does not have custom XML type "), (identifier != null ? 1 : 0) != 0);
    }

    public void testHTMLExists() {
        String id = ContentTypeIdForHTML.ContentTypeID_HTML;
        IContentTypeManager registry = TestContentTypeHandlers.getContentTypeRegistry();
        IContentType identifier = registry.getContentType(id);
        TestContentTypeHandlers.assertTrue((String)("content type identifier " + id + " does not have HTML type "), (identifier != null ? 1 : 0) != 0);
    }

    public void testJSPExists() {
        String id = ContentTypeIdForJSP.ContentTypeID_JSP;
        IContentTypeManager registry = TestContentTypeHandlers.getContentTypeRegistry();
        IContentType identifier = registry.getContentType(id);
        TestContentTypeHandlers.assertTrue((String)("content type identifier " + id + " does not have JSP type "), (identifier != null ? 1 : 0) != 0);
    }

    public void testCSSExists() {
        String id = ContentTypeIdForCSS.ContentTypeID_CSS;
        IContentTypeManager registry = TestContentTypeHandlers.getContentTypeRegistry();
        IContentType identifier = registry.getContentType(id);
        TestContentTypeHandlers.assertTrue((String)("content type identifier " + id + " does not have CSS type "), (identifier != null ? 1 : 0) != 0);
    }

    public void testDTDExists() {
        String id = "org.eclipse.wst.dtd.core.dtdsource";
        IContentTypeManager registry = TestContentTypeHandlers.getContentTypeRegistry();
        IContentType identifier = registry.getContentType(id);
        TestContentTypeHandlers.assertTrue((String)("content type identifier " + id + " does not have DTD type "), (identifier != null ? 1 : 0) != 0);
    }

    public void testXMLExistsByFileExtension() throws IOException {
        String filename = "test.xml";
        IContentTypeManager registry = TestContentTypeHandlers.getContentTypeRegistry();
        IContentType identifier = registry.getDescriptionFor((InputStream)new NullStream(), filename, IContentDescription.ALL).getContentType();
        TestContentTypeHandlers.assertTrue((String)("content type identifier for " + filename + " does not have XML type "), (identifier != null ? 1 : 0) != 0);
    }

    public void testHTMLExistsByFileExtension() throws IOException {
        String filename = "test.html";
        IContentTypeManager registry = TestContentTypeHandlers.getContentTypeRegistry();
        IContentType identifier = registry.getDescriptionFor((InputStream)new NullStream(), filename, IContentDescription.ALL).getContentType();
        TestContentTypeHandlers.assertTrue((String)("content type identifier for " + filename + " does not have HTML type "), (identifier != null ? 1 : 0) != 0);
    }

    public void testJSPExistsByFileExtension() throws IOException {
        String filename = "test.jsp";
        IContentTypeManager registry = TestContentTypeHandlers.getContentTypeRegistry();
        IContentType identifier = registry.getDescriptionFor((InputStream)new NullStream(), filename, IContentDescription.ALL).getContentType();
        TestContentTypeHandlers.assertTrue((String)("content type identifier for " + filename + " does not have JSP type "), (identifier != null ? 1 : 0) != 0);
    }

    public void testCSSExistsByFileExtension() throws IOException {
        String filename = "test.css";
        IContentTypeManager registry = TestContentTypeHandlers.getContentTypeRegistry();
        IContentType identifier = registry.getDescriptionFor((InputStream)new NullStream(), filename, IContentDescription.ALL).getContentType();
        TestContentTypeHandlers.assertTrue((String)("content type identifier for " + filename + " does not have CSS type "), (identifier != null ? 1 : 0) != 0);
    }

    public void testDTDExistsByFileExtension() throws IOException {
        String filename = "test.dtd";
        IContentTypeManager registry = TestContentTypeHandlers.getContentTypeRegistry();
        IContentType identifier = registry.getDescriptionFor((InputStream)new NullStream(), filename, IContentDescription.ALL).getContentType();
        TestContentTypeHandlers.assertTrue((String)("content type identifier for " + filename + " does not have DTD type "), (identifier != null ? 1 : 0) != 0);
    }

    public void testMultipleDefinitions() throws IOException {
        String id = ContentTypeIdForCSS.ContentTypeID_CSS;
        String filename = "test.css";
        IContentTypeManager registry = TestContentTypeHandlers.getContentTypeRegistry();
        IContentType identifier1 = registry.getContentType(id);
        IContentType identifier2 = registry.getDescriptionFor((InputStream)new NullStream(), filename, IContentDescription.ALL).getContentType();
        TestContentTypeHandlers.assertTrue((String)"mulitple content type identifiers need to be equal (but not same instance) ", (boolean)identifier1.equals(identifier2));
    }
}

