/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.tests.dom;

import junit.framework.TestCase;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.jst.jsp.core.tests.Logger;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestOrphan
extends TestCase {
    private static final String fCategory = "unittests";

    public TestOrphan(String name) {
        super(name);
    }

    private Document getJSPDoc() {
        IDOMModel structuredModel = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForJSP.ContentTypeID_JSP);
        IDOMDocument doc = structuredModel.getDocument();
        return doc;
    }

    private Document getHTMLDoc() {
        IDOMModel structuredModel = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForHTML.ContentTypeID_HTML);
        IDOMDocument doc = structuredModel.getDocument();
        return doc;
    }

    private Element makeElement(Document document) {
        Element element = document.createElement("IMG");
        element.setAttribute("src", "<bean:message />");
        return element;
    }

    public void testNonOrphanInHTMLDoc() {
        Logger.trace(fCategory, "testNonOrphanInHTMLDoc");
        Document doc = this.getHTMLDoc();
        Element element = this.makeElement(doc);
        AttrImpl attr = (AttrImpl)element.getAttributeNode("src");
        String attrValue = attr.getValue();
        Logger.trace(fCategory, "attrValue: " + attrValue);
        doc.appendChild(element);
        boolean isJspValue = attr.hasNestedValue();
        Logger.trace(fCategory, "isJspValue: " + isJspValue);
        TestOrphan.assertFalse((boolean)isJspValue);
    }

    public void testNonOrphanInJSPDoc() {
        Logger.trace(fCategory, "testNonOrphanInJSPDoc");
        Document doc = this.getJSPDoc();
        Element element = this.makeElement(doc);
        AttrImpl attr = (AttrImpl)element.getAttributeNode("src");
        String attrValue = attr.getValue();
        Logger.trace(fCategory, "attrValue: " + attrValue);
        doc.appendChild(element);
        boolean isJspValue = attr.hasNestedValue();
        Logger.trace(fCategory, "isJspValue: " + isJspValue);
        TestOrphan.assertTrue((boolean)isJspValue);
    }

    public void testNonOrphanInBoth() {
        Logger.trace(fCategory, "testNonOrphanInBoth");
        Document jspDoc = this.getJSPDoc();
        Element commonElement = this.makeElement(jspDoc);
        AttrImpl attr = (AttrImpl)commonElement.getAttributeNode("src");
        String attrValue = attr.getValue();
        Logger.trace(fCategory, "attrValue: " + attrValue);
        jspDoc.appendChild(commonElement);
        boolean isJspValue = attr.hasNestedValue();
        Logger.trace(fCategory, "isJspValue: " + isJspValue);
        TestOrphan.assertTrue((boolean)isJspValue);
        Document htmlDoc = this.getHTMLDoc();
        htmlDoc.appendChild(commonElement);
        isJspValue = attr.hasNestedValue();
        Logger.trace(fCategory, "isJspValue: " + isJspValue);
        TestOrphan.assertFalse((boolean)isJspValue);
    }

    public void testNonOrphanInBothReversedOrder() {
        Logger.trace(fCategory, "testNonOrphanInBothReversedOrder");
        Document htmlDoc = this.getHTMLDoc();
        Element commonElement = this.makeElement(htmlDoc);
        AttrImpl attr = (AttrImpl)commonElement.getAttributeNode("src");
        String attrValue = attr.getValue();
        Logger.trace(fCategory, "attrValue: " + attrValue);
        htmlDoc.appendChild(commonElement);
        boolean isJspValue = attr.hasNestedValue();
        Logger.trace(fCategory, "isJspValue: " + isJspValue);
        TestOrphan.assertFalse((boolean)isJspValue);
        Document jspDoc = this.getJSPDoc();
        commonElement = this.makeElement(jspDoc);
        jspDoc.appendChild(commonElement);
        attr = (AttrImpl)commonElement.getAttributeNode("src");
        attrValue = attr.getValue();
        Logger.trace(fCategory, "attrValue: " + attrValue);
        isJspValue = attr.hasNestedValue();
        Logger.trace(fCategory, "isJspValue: " + isJspValue);
        TestOrphan.assertTrue((boolean)isJspValue);
    }

    public void doBothTests() {
        this.testNonOrphanInHTMLDoc();
        this.testNonOrphanInJSPDoc();
        this.testNonOrphanInBoth();
        this.testNonOrphanInBothReversedOrder();
    }
}

