/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.tests.source;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import junit.framework.TestCase;
import org.eclipse.jst.jsp.core.internal.parser.internal.JSPTokenizer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class JSPTokenizerTest
extends TestCase {
    private JSPTokenizer tokenizer = null;

    private void reset(Reader in) {
        this.tokenizer.reset(in);
    }

    private void reset(String filename) {
        InputStreamReader fileReader = null;
        try {
            fileReader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(filename), "utf8");
        }
        catch (IOException e) {
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            JSPTokenizerTest.fail((String)s.toString());
        }
        BufferedReader reader = new BufferedReader(fileReader);
        this.reset(reader);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.tokenizer = new JSPTokenizer();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.tokenizer = null;
    }

    public void test144807_AttrName() {
        String input = "";
        int i = 0;
        while (i < 400) {
            input = String.valueOf(input) + "<a ";
            ++i;
        }
        try {
            this.reset(new StringReader(input));
            JSPTokenizerTest.assertTrue((String)"empty input", (this.tokenizer.getNextToken() != null ? 1 : 0) != 0);
            while (this.tokenizer.getNextToken() != null) {
            }
        }
        catch (IOException e) {
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            JSPTokenizerTest.fail((String)s.toString());
        }
    }

    public void test144807_AttrValue() {
        String input = "<a b=";
        int i = 0;
        while (i < 400) {
            input = String.valueOf(input) + "<a ";
            ++i;
        }
        try {
            this.reset(new StringReader(input));
            JSPTokenizerTest.assertTrue((String)"empty input", (this.tokenizer.getNextToken() != null ? 1 : 0) != 0);
            while (this.tokenizer.getNextToken() != null) {
            }
        }
        catch (IOException e) {
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            JSPTokenizerTest.fail((String)s.toString());
        }
    }

    public void test144807_Equals() {
        String input = "<a b";
        int i = 0;
        while (i < 400) {
            input = String.valueOf(input) + "<a ";
            ++i;
        }
        try {
            this.reset(new StringReader(input));
            JSPTokenizerTest.assertTrue((String)"empty input", (this.tokenizer.getNextToken() != null ? 1 : 0) != 0);
            while (this.tokenizer.getNextToken() != null) {
            }
        }
        catch (IOException e) {
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            JSPTokenizerTest.fail((String)s.toString());
        }
    }

    public void testInsertComment() {
        this.reset("jspcomment01.jsp");
        try {
            JSPTokenizerTest.assertTrue((String)"empty input", (this.tokenizer.getNextToken() != null ? 1 : 0) != 0);
            while (this.tokenizer.getNextToken() != null) {
            }
        }
        catch (IOException e) {
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            JSPTokenizerTest.fail((String)s.toString());
        }
        catch (StackOverflowError e) {
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            JSPTokenizerTest.fail((String)s.toString());
        }
        JSPTokenizerTest.assertTrue((boolean)true);
    }

    public void test26004() {
        String input = "<c:set var=\"foo\" value=\"${foo} bar #\" /> <div id=\"container\" >Test</div>";
        try {
            this.reset(new StringReader(input));
            ITextRegion region = this.tokenizer.getNextToken();
            JSPTokenizerTest.assertTrue((String)"empty input", (region != null ? 1 : 0) != 0);
            while (region != null) {
                if (region.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                    region = this.tokenizer.getNextToken();
                    JSPTokenizerTest.assertNotNull((String)"document consumed by trailing $ or #", (Object)region);
                    continue;
                }
                region = this.tokenizer.getNextToken();
            }
        }
        catch (IOException e) {
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            JSPTokenizerTest.fail((String)s.toString());
        }
    }

    public void test150794() {
        String input = "<a href=\"<jsp:getProperty/>\">";
        try {
            this.reset(new StringReader(input));
            ITextRegion region = this.tokenizer.getNextToken();
            JSPTokenizerTest.assertTrue((String)"empty input", (region != null ? 1 : 0) != 0);
            while (region != null) {
                if (region.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                    region = this.tokenizer.getNextToken();
                    JSPTokenizerTest.assertNotNull((String)"document consumed by embedded JSP tag", (Object)region);
                    continue;
                }
                region = this.tokenizer.getNextToken();
            }
        }
        catch (IOException e) {
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            JSPTokenizerTest.fail((String)s.toString());
        }
    }

    public void test299146() {
        String input = "<root>&#160</root>";
        try {
            this.reset(new StringReader(input));
            ITextRegion region = null;
            int i = 0;
            while (i < 5) {
                region = this.tokenizer.getNextToken();
                ++i;
            }
            JSPTokenizerTest.assertNotNull((String)"This region should exist", region);
            JSPTokenizerTest.assertEquals((String)"The region did not have the expected start location", (int)7, (int)region.getStart());
            JSPTokenizerTest.assertEquals((String)"The region did not have the expected length", (int)4, (int)region.getLength());
        }
        catch (IOException e) {
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            JSPTokenizerTest.fail((String)s.toString());
        }
    }

    public void test343387() {
        String[] regions = new String[]{"XML_TAG_OPEN", "XML_TAG_NAME", "XML_TAG_ATTRIBUTE_NAME", "XML_TAG_ATTRIBUTE_EQUALS", "XML_TAG_ATTRIBUTE_VALUE", "XML_EMPTY_TAG_CLOSE"};
        try {
            this.reset(new StringReader("<h:commandButton value=\"<\"/>"));
            ITextRegion region = null;
            int i = 0;
            while ((region = this.tokenizer.getNextToken()) != null) {
                JSPTokenizerTest.assertEquals((String)("Region [" + i + "] does not match."), (String)regions[i++], (String)region.getType());
            }
            JSPTokenizerTest.assertEquals((String)"Not enough regions found.", (int)regions.length, (int)i);
        }
        catch (IOException e) {
            StringWriter s = new StringWriter();
            e.printStackTrace(new PrintWriter(s));
            JSPTokenizerTest.fail((String)s.toString());
        }
    }
}

