/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.tests.translation;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationAdapter;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationExtension;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslator;
import org.eclipse.jst.jsp.core.tests.ProjectUtil;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class JSPTranslatorPersistenceTest
extends TestCase {
    private static final String PROJECT_NAME = "JSPTranslatorPersistenceTest";
    private static final String PROJECT_FILES = "/testfiles/JSPTranslatorPersistenceTest";
    private static IProject fProject;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public JSPTranslatorPersistenceTest() {
        super("JSPTranslator Externalization Test");
    }

    public JSPTranslatorPersistenceTest(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.tests.translation.JSPTranslatorPersistenceTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite ts = new TestSuite((Class)clazz, "JSPTranslator Externalization Test");
        return new JSPTranslatorExternalizationTestSetup((Test)ts);
    }

    public void testTranslationTextComparison() throws Exception {
        String outFileName = "testTranslationTextComparison.obj";
        JSPTranslator originalTranslator = JSPTranslatorPersistenceTest.writeTranslator("Test1.jsp", outFileName);
        StringBuffer originalTranslation = originalTranslator.getTranslation();
        JSPTranslator externalizedTranslator = (JSPTranslator)JSPTranslatorPersistenceTest.readObject(outFileName);
        StringBuffer externalizedTranslation = externalizedTranslator.getTranslation();
        JSPTranslatorPersistenceTest.assertEquals((String)"The original translation should be the same as the restored externalized translation", (String)originalTranslation.toString(), (String)externalizedTranslation.toString());
    }

    public void testTranslationsDeepEqual() throws Exception {
        String outFileName = "testTranslationTextComparison.obj";
        JSPTranslator originalTranslator = JSPTranslatorPersistenceTest.writeTranslator("Test1.jsp", outFileName);
        JSPTranslator externalizedTranslator = (JSPTranslator)JSPTranslatorPersistenceTest.readObject(outFileName);
        JSPTranslatorPersistenceTest.assertEquals((String)"The original translation should be deeply equal to the restored externalized translation", (Object)originalTranslator, (Object)externalizedTranslator);
    }

    public void testCreateTranslationAdapter() throws Exception {
        String outFileName = "testCreateTranslationAdapter.obj";
        IStructuredModel structModel = JSPTranslatorPersistenceTest.getModelForRead("Test1.jsp");
        IDOMDocument domDoc = ((IDOMModel)structModel).getDocument();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jst.jsp.core.internal.java.IJSPTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INodeAdapter existingAdapter = domDoc.getAdapterFor((Object)clazz);
        JSPTranslatorPersistenceTest.assertNull((String)"There should be no existing adapter for IJSPTranslation", (Object)existingAdapter);
        JSPTranslator originalTranslator = JSPTranslatorPersistenceTest.writeTranslator(structModel, outFileName);
        JSPTranslator externalizedTranslator = (JSPTranslator)JSPTranslatorPersistenceTest.readObject(outFileName);
        JSPTranslationAdapter restoredAdapter = new JSPTranslationAdapter((IDOMModel)structModel, externalizedTranslator);
        domDoc.addAdapter((INodeAdapter)restoredAdapter);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jst.jsp.core.internal.java.IJSPTranslation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        existingAdapter = domDoc.getAdapterFor((Object)clazz2);
        JSPTranslatorPersistenceTest.assertNotNull((String)"There should now be an existing adapter for IJSPTranslation", (Object)existingAdapter);
        JSPTranslatorPersistenceTest.assertTrue((String)("Expected " + existingAdapter + " to be an instance of JSPTranslationAdapter"), (boolean)(existingAdapter instanceof JSPTranslationAdapter));
        JSPTranslationAdapter retrievedAdapter = (JSPTranslationAdapter)existingAdapter;
        JSPTranslationExtension jspTranslationExtension = retrievedAdapter.getJSPTranslation();
        JSPTranslatorPersistenceTest.assertEquals((String)"The original translation should be the same as the restored externalized translation", (String)originalTranslator.getTranslation().toString(), (String)jspTranslationExtension.getJavaText());
    }

    /*
     * Exception decompiling
     */
    private static JSPTranslator writeTranslator(String jspFileName, String externalizedFileName) throws IOException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 46->49)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IStructuredModel getModelForRead(String fileName) throws IOException, CoreException {
        IFile jspFile = fProject.getFile(fileName);
        JSPTranslatorPersistenceTest.assertTrue((boolean)jspFile.exists());
        IStructuredModel model = StructuredModelManager.getModelManager().getModelForRead(jspFile);
        JSPTranslatorPersistenceTest.assertNotNull((Object)model);
        return model;
    }

    private static JSPTranslator writeTranslator(IStructuredModel jspModel, String externalizedFileName) throws IOException, CoreException {
        JSPTranslator translator = new JSPTranslator();
        translator.reset((IDOMNode)jspModel.getIndexedRegion(0), (IProgressMonitor)new NullProgressMonitor());
        translator.translate();
        JSPTranslatorPersistenceTest.writeObject(externalizedFileName, translator);
        return translator;
    }

    private static void writeObject(String fileName, Object obj) throws IOException {
        FileOutputStream fos = new FileOutputStream(fileName);
        ObjectOutputStream out = new ObjectOutputStream(fos);
        out.writeObject(obj);
        out.close();
    }

    private static Object readObject(String fileName) throws IOException, ClassNotFoundException {
        Object obj = null;
        FileInputStream fis = new FileInputStream(fileName);
        ObjectInputStream in = new ObjectInputStream(fis);
        obj = in.readObject();
        in.close();
        return obj;
    }

    private static class JSPTranslatorExternalizationTestSetup
    extends TestSetup {
        private static final String WTP_AUTOTEST_NONINTERACTIVE = "wtp.autotest.noninteractive";
        private static String previousWTPAutoTestNonInteractivePropValue = null;

        public JSPTranslatorExternalizationTestSetup(Test test) {
            super(test);
        }

        public void setUp() throws Exception {
            fProject = ProjectUtil.createProject(JSPTranslatorPersistenceTest.PROJECT_NAME, null, null);
            ProjectUtil.copyBundleEntriesIntoWorkspace(JSPTranslatorPersistenceTest.PROJECT_FILES, JSPTranslatorPersistenceTest.PROJECT_NAME);
            String noninteractive = System.getProperty(WTP_AUTOTEST_NONINTERACTIVE);
            previousWTPAutoTestNonInteractivePropValue = noninteractive != null ? noninteractive : "false";
            System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, "true");
        }

        public void tearDown() throws Exception {
            if (previousWTPAutoTestNonInteractivePropValue != null) {
                System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, previousWTPAutoTestNonInteractivePropValue);
            }
            fProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

