/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.sync;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.sync.AbstractModelSynchronizer;
import org.eclipse.jst.ws.jaxws.testutils.jmock.Mock;
import org.eclipse.jst.ws.jaxws.testutils.jmock.MockObjectTestCase;

public class AbstractModelSynchronizerTest
extends MockObjectTestCase {
    private AbstractModelSynchronizerTester modelSync;
    private JaxWsWorkspaceResource resource;

    public void setUp() {
        Mock javaModelMock = this.mock(IJavaModel.class);
        this.resource = new JaxWsWorkspaceResource((IJavaModel)javaModelMock.proxy());
        this.modelSync = new AbstractModelSynchronizerTester(this.resource, new JaxWsWorkspaceResource.ServiceModelData(this.resource)){};
    }

    public void testProcessCompilationUnitEditEnabledDespiteNPE() throws JavaModelException {
        AbstractModelSynchronizerTest.assertTrue((boolean)this.resource.isSaveEnabled());
        try {
            this.modelSync.processCompilationUnit(null, null);
        }
        catch (NullPointerException nullPointerException) {}
        AbstractModelSynchronizerTest.assertTrue((boolean)this.resource.isSaveEnabled());
    }

    public void testProcessCompilationUnitEditEnabledNormalExecution() throws JavaModelException {
        AbstractModelSynchronizerTest.assertTrue((boolean)this.resource.isSaveEnabled());
        Mock cuMock = this.mock(ICompilationUnit.class);
        cuMock.expects(this.once()).method("findPrimaryType").will(this.returnValue(null));
        this.modelSync.processCompilationUnit(null, (ICompilationUnit)cuMock.proxy());
        AbstractModelSynchronizerTest.assertTrue((boolean)this.resource.isSaveEnabled());
    }

    public class AbstractModelSynchronizerTester
    extends AbstractModelSynchronizer {
        public AbstractModelSynchronizerTester(JaxWsWorkspaceResource resource, JaxWsWorkspaceResource.ServiceModelData serviceData) {
            super(resource, serviceData);
        }

        protected void processCompilationUnit(IWebServiceProject wsProject, ICompilationUnit cu) throws JavaModelException {
            super.processCompilationUnit(wsProject, cu);
        }
    }
}

